PROGRAM Addvol;
{$M 10000, 0,0}
USES
  bioscrt, Dos, laufbalk, strings, Masken, keycode, filecopy, rechnen;

CONST
  Max                     = 60000;
  gelesen       : LongInt = 0;
  geschrieben   : LongInt = 0;
  DiskNr        : Word    = 1;
  ProgName                = 'ADDVOL';
  Quelle        : PathStr = '';
  Ziel          : PathStr = '';


TYPE
  Str20 = String[20];

VAR
  Result        : Word;
  sr, tg        : Searchrec;
  x             : Byte;
  Block         : Array[1..Max] Of Byte;
  gel, ges      : Word;
  f1, f2        : File;
  Reading       : LongInt;
  lese          : LongInt;
  Kennwort      : String[18];
  InfoRec       : RECORD
                    Header : array[1..2] of Char;
                    UserStr: String[18];
                    Nam    : String[12];
                    siz    : LongInt;
                    tim    : LongInt;
                    att    : Byte;
                    onDisk : LongInt;
                    VolNr  : Word;
                    LastVol: Boolean;
                  END;


PROCEDURE ClearWin;
BEGIN Window (1, 3, 80, 15); ClrScr; Window (1, 3, 80, 25); END;


PROCEDURE Taste;
BEGIN
  REPEAT
    UpScanBKeys;
    If t1='N' Then t1:= #27 Else If t1='J' Then t1:=#13;
  UNTIL (t1=#13) or (t1=#27);
  ClearWin;
END;


PROCEDURE Fehlertext (s : String);
BEGIN
  Fusszeile ('Treffen Sie eine Auswahl');
  GotoXY (1, 9);
  OutStr (s);
  GotoXY (1, 9);
END;


PROCEDURE Hilfe;
BEGIN
  Standardkopf (ProgName, CopyRight);
  DosLnLF (
   'Fgt eine mit MULTIVOL.EXE auf Disketten verteilte Datei wieder zusammen.'#13#10#13#10+
   'ADDVOL [Quellaufwerk] [Zielverzeichnis]'#13#10#13#10+
   '[Quellaufwerk]'#13#10+
   'Laufwerk, das die Disketten mit den Dateiteilen aufnimmt.'#13#10);
  DosLnLF (
   '[Zielverzeichnis]'#13#10+
   'Name des Verzeichnisses, in dem die Ziel-Datei angelegt werden soll.'#13#10+
   'Fehlt Ziel, verwendet ADDVOL das gerade geffnete Verzeichnis.');
  Blindstop; Halt;
END;


PROCEDURE OpenZFile;
BEGIN
  Ziel:= Vollpfad (Ziel, InfoRec.Nam);
  FindFirst (Ziel, Normalfile, sr);
  If DOSerror=0 Then
  BEGIN
    Fehlertext (
    'Im Ziel existiert bereits eine gleichnamige Datei. Entweder'#13#10+
    '- Datei mit ENTER berschreiben lassen oder'#13#10+
    '- mit ESC abbrechen');
    Taste;
    If t1=#27 Then UserAbort;
  END Else
  If DOSError>=150 Then ErrorHalt (CopyResultStr (DOSError));

  REPEAT
    Assign  (f2, Ziel);
    Rewrite (f2, 1);
    If InOutRes<>0 Then
    BEGIN
      Tastenabfrage ('Die Zieldatei konnte nicht angelegt werden. Nochmal versuchen? j/n', 'J', 'N');
      If t1=#27 Then UserAbort;
    END;
  UNTIL IOResult=0;
END;


PROCEDURE OpenQFile;
VAR
  gel   : Word;
  sr    : searchrec;
BEGIN
  REPEAT
    FindFirst (VollPfad (Quelle, '*.*'), NormalFile, sr);
    If DOSError>=150 Then ErrorHalt (CopyResultStr (DOSError));
    While DOSError=0 Do
    BEGIN
      Assign    (f1, VollPfad (Quelle, sr.name)); Filemode:=0;
      Reset     (f1, 1);
      BlockRead (f1, InfoRec, SizeOf(InfoRec), gel);
      Result:=IOResult;
      If   (Result=0) and (gel=SizeOf(InfoRec)) and (InfoRec.Header='AO')
      and  (InfoRec.VolNr=DiskNr) and (InfoRec.onDisk= sr.Size-SizeOf(InfoRec))
      and ((Kennwort=InfoRec.UserStr) or (Kennwort='')) Then
      BEGIN
        If Kennwort='' Then Kennwort:= InfoRec.UserStr;
        If InfoRec.VolNr=1 Then OpenZFile;
        inc (DiskNr);
        Exit;
      END;
      XClose (f1);
      FindNext (sr);
    END;

    Fehlertext(
   'Es konnte keine gltige Teildatei gefunden werden. Legen Sie eine andere'#13#10+
   'Diskette ein und drcken Sie ENTER fr Fortfahren oder ESC fr Abbrechen.');
    Taste;
    If t1=#27 Then UserAbort;
  UNTIL 1=2;
END;


PROCEDURE Kopieren;
BEGIN
  Fusszeile ('Fge Dateiteile zusammen...   (Abbrechen mit Esc)');
  GotoOldPos;
  Reading:=0;

  REPEAT
    Blockread  (f1, Block, Max, gel);
    Result:= IOResult; If Result<>0 Then Exit;

    If gel>0 Then
    BEGIN
      BlockWrite (f2, Block, gel, ges);
      Result:= IOResult; If Result<>0 Then Exit;
      inc (gelesen, gel); inc (Geschrieben, ges);
      inc (Reading, gel);
    END Else ges:=0;

    Balken (18, gelesen, InfoRec.siz);
    Balken (15, Reading, InfoRec.onDisk);
    GotoXY (1, 4);
    OutStr ('Kopiert......: '); OutStr (StretchStr(TausPkt(gelesen), 14));     OutLnLF (' Byte');
    OutStr ('Noch offen...: '); OutStr (StretchStr(TausPkt(InfoRec.siz-geschrieben), 14)); OutLnLF (' Byte'#13#10);
    OutStr ('Disketten-Nr.: '); OutStr (StretchStr(LongStr(InfoRec.VolNr),14));

    If (keypressed) and (UpReadKey=#27) Then
    BEGIN XClose (f1); XClose(f2); UserAbort; END;

  UNTIL (gel=0) or (ges<>gel) or (Reading=InfoRec.onDisk);

  XClose (f1);
END;



PROCEDURE DiskWechseln;
BEGIN
  If Result=0 Then
  BEGIN
    If (geschrieben=InfoRec.Siz) and (InfoRec.LastVol) Then Else
    BEGIN
      FehlerText (
      'Legen Sie die nchste Diskette ein und drcken Sie ENTER fr Fortfahren'#13#10+
      'oder ESC fr Abbrechen.'#13#10);
      Taste;
      If t1=#27 Then BEGIN XClose (f2); UserAbort; END;
    END;
  END Else
  BEGIN XClose (f2); ErrorHalt (CopyResultStr (Result)); END;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Quelle, 'Laufwerk, das die Disketten mit den Dateiteilen enthlt:');

  a2:
  EditStr (6, Ziel, 'Verzeichnis, in dem die Zieldatei zusammengesetzt werden soll:');
  If t2=Up Then Goto a1;

  If (ee=0) and (Quelle='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


PROCEDURE Parameter;
VAR
  x     : Byte;
  Param : String;
  PStat : Word;
BEGIN
  If ParamCount = 0 Then
  BEGIN
    Quelle:= 'A:'; Ziel:= FileExpand ('');
    StandardKopf (ProgName, 'Eingabemaske');
    Fusszeile (EingabeHilfe);
    ee:= 1; ShowMaske; ee:= 0; ShowMaske;
  END Else

  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1] = '/' Then
    CASE Param[2] Of
      '?' : Hilfe;
    END Else
    BEGIN
      If Quelle = '' Then Quelle:= Param Else
      If Ziel   = '' Then Ziel  := Param;
    END;
  END;
  
  Standardkopf (ProgName, '');
  Fusszeile ('Fge Dateiteile zusammen...   (Abbrechen mit Esc)');
  GotoOldPos;

  If Quelle<>'' Then Quelle:= Quelle[1]+':\';
  PStat:= PathStatus (Quelle, CheckQuelle);
  If PStat<>0 Then ErrorHalt (PathStatusStr (PStat));
  
  Ziel:= FileExpand (Ziel);
  If DOSError=0 Then PStat:= PathStatus (Ziel, CheckZiel) Else PStat:= DOSError;
  If PStat<>0 Then ErrorHalt (PathStatusStr (PStat));

  If pos (':\', Ziel) <> Length(Ziel)-1 Then
  BEGIN
    FindFirst (Ziel, Normalfile, tg);
    If DOSError=0 Then
    BEGIN
      If tg.attr and directory=0 Then
      ErrorHalt ('Zielverzeichnis kann wegen gleichnamiger Datei nicht erstellt werden');
    END Else
    BEGIN
      If DOSError>=150 Then ErrorHalt (CopyResultStr (DOSError));
      MakeTree (Ziel);
      If IOResult<>0 Then
      ErrorHalt ('Zielverzeichnis konnte nicht erstellt werden');
    END;
  END;
  FileMode:= 0;
END;


BEGIN
  t1:= #0;
  Parameter;
  Unterbalken (18, 'insgesamt kopiert');
  Kennwort:='';

  REPEAT
    ClearWin;
    Unterbalken (15, 'von Diskette kopiert'); GotoXY (1, 1);
    OpenQFile;
    OutStr ('Dateiname....: '); OutLnLF (StretchStr(InfoRec.Nam, 14));
    OutStr ('Dateigre...: '); OutStr  (StretchStr(TausPkt(InfoRec.Siz), 14)); OutStr (' Byte');

    Kopieren;
    DiskWechseln;
  UNTIL (InfoRec.Siz = geschrieben) and (InfoRec.LastVol);

  SetFTime (f2, InfoRec.tim);
  XClose (f2);
  SetFAttr (f2, InfoRec.att or archive);

  ErrorHalt ('Datei erfolgreich zusammengesetzt.');
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
