PROGRAM ArcDir;
{$M 60000, 0, 0}

USES
  DOS, BiosCRT, Strings, Masken, FileCopy, WildCard;

TYPE
  NS    = String [78];
  Ls    = String [22];
  str2  = String [2];
  Bloc  = array  [1..60000] Of Char;

CONST
  ERR=0;                     
  ARJ=1;
  ZIP=2;
  LHA=3;
  RAR=4;

  PArr : array[1..4] Of String[6] = (' [ARJ]', ' [ZIP]', ' [LHA]', ' [RAR]');


VAR
  NStr     : ^NS;
  Size     : ^LongInt;
  PSize    : ^LongInt;
  Time     : ^LongInt;
  Attr     : ^Byte;
  Block    : Bloc;
  f        : File;
  PName    : Byte;
  gel      : Word;
  x, y     : Word;
  n, nx    : Byte;
  FSize,
  FPos     : LongInt;
  Param    : String;
  sr       : Searchrec;
  zPath    : DirStr;
  ArcName  : PathStr;
  Gesamt   : LongInt;
  Files    : LongInt;
  PStat    : Byte;

CONST
  Page     : Boolean = FALSE;
  List     : Boolean = FALSE;
  Short    : Boolean = FALSE;
  SubDir   : Boolean = FALSE;
  NameOnly : Boolean = FALSE;
  WithPath : Boolean = FALSE;
  Line     : Byte    = 1;
  Alle     : LongInt = 0;
  AllFil   : LongInt = 0;
  SeekFile : PathStr = '';
  FName    : PathStr = '';


PROCEDURE Close_Arc;
BEGIN Close (f); If IOResult<>0 Then; END;



PROCEDURE w (s : String);
BEGIN
  DosLnLF (s);
  If Page Then
  BEGIN
    inc (Line);
    If Line>23 Then
    BEGIN
      Line:= 1;
      DosStr (#13#10'Weiter mit ENTER oder Abbrechen mit Esc');
      t1:= ReadbKey;
      DosLnLF (#13#10);
      If t1=#27 Then BEGIN Close_Arc; Halt; END;
    END;
  END;
END;



FUNCTION TausPunkt (x : LongInt) : String;
VAR
  s : String[15];
BEGIN
  s:= TausPkt (x);
  TausPunkt:= FillString (16-Length (s)) + s;
END;



PROCEDURE Fehler;
VAR
  Result : Word;
BEGIN
  Result:= IOResult;
  If Result<>0 Then
  BEGIN
    w (#13#10'Fehler im Archiv: '+ CopyResultStr (Result));
    Halt;
  END;
END;



PROCEDURE Hilfe;
CONST
s1=#13#10+
   'ARCDIR  ' + Copyright + #13#10+
   'DIR-Befehl fr ARJ-, PKZIP-, LHA-, LHARC- und RAR-Archive'#13#10#13#10+
   'ARCDIR [Archiv(e)] [Suchdatei(en)] [/p /s /b /n /d /a /w]'#13#10#13#10+
   '/p  seitenweise Anzeige'#13#10+
   '/s  sucht Archive auch in Unterverzeichnissen';   
s2='/b  zeigt nur Archiv- und Dateinamen'#13#10+
   '/n  zeigt nur Dateinamen'#13#10+
   '/d  zeigt nur Dateinamen mit Unterverzeichnis'#13#10+
   '/a  zeigt nur Archivnamen'#13#10+
   '/w  wartet vor Beginn auf einen Tastendruck'#13#10;
s3='Selbstextraktoren bzw. umbenannte Archive werden erkannt. Gepackte'#13#10+
   'Unterverzeichnisse werden (meist) nicht angezeigt. Wildcards in [Suchdateien]'#13#10+
   'sind mglich.';

BEGIN
  w (s1); w (s2); w (s3); BlindStop;
  Halt;
END;



PROCEDURE Open_Arc;
BEGIN
  Assign (f, ArcName); FileMode:=0; Reset (f, 1);
  Fehler; FSize:=FileSize (f);
END;


(*
PROCEDURE Read_Header1;
VAR
  xx : Word;
BEGIN
  PName:=ERR; xx:= gel-5; x:=0;
  REPEAT
    inc (x);
    If (Block[x]=#30) and (Block[x+1]=#6)  and (Block[x+2]=#1)  and (Block[x+3]=#0)  Then
    PName:=ARJ Else
    If (Block[x]='P') and (Block[x+1]='K') and (Block[x+2]=#3)  and (Block[x+3]=#4)  Then
    PName:=ZIP Else
    If (Block[x]='-') and (Block[x+1]='l') and (Block[x+2]='h') and (Block[x+4]='-') Then
    PName:=LHA Else
    If (Block[x]='R') and (Block[x+1]='a') and (Block[x+2]='r') and (Block[x+3]='!') Then
    PName:=RAR;
  UNTIL (PName<>ERR) or (x=xx);
END;
*)


PROCEDURE Read_Header; assembler;
ASM
  mov PName, ERR; mov cx, gel; sub cx, 5; xor bx, bx; dec bx
  @nochmal:
    inc bx
    mov ax, Word Ptr Block[bx]
    mov dx, Word Ptr Block[bx+2]

    cmp ax, 061Eh;  jne @zip; cmp dx, 0001h; jne @zip
    mov PName, ARJ; jmp @fertig

    @zip:
    cmp ax, 4B50h;  jne @rar; cmp dx, 0403h; jne @rar
    mov PName, ZIP; jmp @fertig

    @rar:
    cmp ax, 6152h;  jne @lha; cmp dx, 2172h; jne @lha
    mov PName, RAR; jmp @fertig

    @lha:
    cmp ax, 6C2Dh;  jne @nix; cmp dl, 'h'  ;  jne @nix
    cmp Byte Ptr Block[bx+4], '-'  ; jne @nix
    mov PName, LHA; jmp @fertig

    @nix:
  loop @nochmal
  @fertig:
END;



FUNCTION Insert_Spaces (s1 : NS) : Ls; assembler;
ASM
  cld
  push ds
  lds si, s1; les di, @Result; lodsb; stosb;
  mov cl, al; xor ch, ch; jcxz @ende
  mov ah, cl; xor bl, bl
  @nochmal:
    inc  bl
    lodsb
    cmp  al, '.'
    jne @weiter
      push cx
      mov  cl, 12
      sub  cl, ah
      add  bl, cl
      mov  al, ' '
      rep  stosb
      pop  cx
    @weiter:
    stosb
  loop @nochmal
  les di, @result; mov al, bl; stosb
  @ende:
  pop ds
END;



PROCEDURE WriteName;
CONST
  ar : array [1..5] Of Byte=(Directory, ReadOnly, SysFile, Hidden, Archive);
  at : String[5]='DRSHA';
VAR
  D  : DateTime;
  x  : Byte;
  as : String[5];
  y  : Byte;
  s  : String;
BEGIN
  If (SeekFile<>'') and (not FileMatch (NStr^, SeekFile)) Then Exit;
  as[0]:=#5;
  For x:= 1 To 5 Do If Attr^ and ar[x] <> 0 Then as[x]:=at[x] Else as[x]:='-';
  UnPackTime (Time^, D);
  y:= WhereY;
  With D Do
  BEGIN
    If List Then
    BEGIN
      If Short Then
      w (LowStr (NStr^)) Else
      w (LowStr (Vollpfad (ArcName, NStr^)));
    END Else
    BEGIN
      If nx=0 Then
      BEGIN
        nx:=1;
        If PName <> ERR  Then
        BEGIN  w (''); DosStr (ArcName); w (PArr[PName]); w (''); END;
      END;
      DosStr (insert_spaces (LowStr(NStr^)));
      DosStr (FillString (12-Length(insert_spaces (NStr^))));
      DosStr (TausPunkt (Size^));
      DosStr (TausPunkt(PSize^));
      DosStr ('     ');
      DosStr (LZ(hour)); DosStr (':'); DosStr (LZ(Min));
      DosStr ('     ');
      DosStr (LZ(day)); DosStr ('.'); DosStr (LZ(Month)); DosStr ('.');
      DosNum (Year);
      DosStr ('    ');
      w (as);
      inc (Gesamt, Size^);
      inc (alle, Size^);
      inc (Files);
      inc (AllFil);
    END;
  END;
END;


PROCEDURE SetFilePointer (Back : Byte);
BEGIN
  FPos:=FilePos(f);
  If (FPos >=Back) and (FSize-FPos>Back) Then Seek (f, FPos-Back);
END;


PROCEDURE List_LHA;
BEGIN
  If gel>30 Then dec (gel, 30);
  For x:= 1 To gel Do
  If  (Block[x]  ='-') and (Block[x+1]='l') and (Block[x+2]='h')
  and (Block[x+4]='-') Then
  BEGIN
    PSize:= @Block[x+5];
    Size := @Block[x+9];
    Time := @Block[x+13];
    NStr := @Block[x+19];
    Attr := @Block[x+18];
    If attr^=1 Then  {---Normal-Archiv}
    BEGIN
      Attr := @Block[x+23+ord(Nstr^[0])];
      If Attr^=0 Then Attr^:= archive Else
      Attr := @Block[x+26+ord(Nstr^[0])];
    END Else Attr := @Block[x+17]; {---Selbstextraktor}
    WriteName;
  END;
  SetFilePointer (30);
END;



PROCEDURE List_ZIP;
BEGIN
  If gel>50 Then dec (gel, 50);
  For x:= 1 To gel Do
  If  (Block[x]  ='P') and (Block[x+1]='K') and (Block[x+2]=#1)
  and (Block[x+3]=#2)  and (Block[x+4]=#20) and (Block[x+5]=#0) Then
  BEGIN
    NStr := @Block[x+45]; NStr^[0]:= Block[x+28];
    Size := @Block[x+24];
    Time := @Block[x+12];
    Attr := @Block[x+38];
    PSize:= @Block[x+20];
    If NStr^[Length(NStr^)]='/' Then dec (NStr^[0]);
    If not WithPath Then
    BEGIN
      While pos ('/', NStr^)<>0 Do delete (NStr^, 1, pos ('/', NStr^));
      While pos ('\', NStr^)<>0 Do delete (NStr^, 1, pos ('\', NStr^));
    END;
    WriteName;
  END;
  SetFilePointer (50);
END;



PROCEDURE List_ARJ;
BEGIN
  If gel>50 Then dec (gel, 50);
  For x:= 1 To gel Do
  If  (Block[x]  =#30) and (Block[x+1]=#6)  and (Block[x+2]= #1)
  and (Block[x+3]=#0)  and (Block[x+4]=#16) and (Block[x+6]<>#2) Then
  BEGIN
    Attr := @Block[x+26];
    Size := @Block[x+16];
    PSize:= @Block[x+12];
    Time := @Block[x+8];
    NStr := @Block[x+29];
    NStr^[0]:= #78;
    NStr^[0]:= chr (pos (#0, NStr^));
    If not WithPath Then
    BEGIN
      While pos ('/', NStr^)<>0 Do delete (NStr^, 1, pos ('/', NStr^));
      While pos ('\', NStr^)<>0 Do delete (NStr^, 1, pos ('\', NStr^));
    END;
    WriteName;
  END;
  SetFilePointer (50);
END;

(*
PROCEDURE List_RAR;
BEGIN
  If gel>20 Then dec (gel, 20);
  For x:= 1 To gel Do
  If (Block[x+1]= #15) and (Block[x+2]= #51) and (Block[x]<'0') Then
  BEGIN
    Size := @Block[x-12];
    PSize:= @Block[x-16];
    Time := @Block[x-3];
    NStr := @Block[x+8]; NStr^[0]:= Block[x+3];
    Attr := @Block[x+5];
    If pos ('\', NStr^)<>0 Then delete (NStr^, 1, pos ('\', NStr^));
    WriteName;
  END;
  SetFilePointer (50);
END;
*)

PROCEDURE List_RAR;
VAR
  p : Byte;
BEGIN
  If gel>20 Then dec (gel, 20);
  For x:= 1 To gel Do
  If (Block[x+2]= #$0F) and (Block[x+3]= #$35) and (Block[x+5]= #0) Then
  BEGIN
    PSize:= @Block[x-15];
    Time := @Block[x-2];
    Attr := @Block[x+6];
    Size := @Block[x-11];
    NStr := @Block[x+9]; NStr^[0]:=Block[x+4];
    If not WithPath Then
    BEGIN
      p:= LastPos ('\', NStr^);
      If p<>0 Then NStr^:= copy (NStr^, p+1, 255);
    END;
    WriteName;
  END;
  SetFilePointer (20);
END;



PROCEDURE ListDir (Pfad : PathStr);
LABEL
  Ende, Ende1;
BEGIN
  FindFirst (VollPfad (Pfad, '*.*'), normalfile, sr);
  If DOSError>=150 Then SimpleHalt (CopyResultStr (DOSError));
  While (DOSError = 0) and (t1<>#27) Do
  BEGIN
    If (sr.attr and directory = 0) and (FileMatch(sr.name, FName)) Then
    BEGIN
      ArcName:= VollPfad (Pfad, sr.name);

      Open_arc;
      n:=0; nx:= 0; Gesamt:= 0; Files:= 0;

      REPEAT
        If Keypressed Then t1:= ReadBKey;
        BlockRead (f, Block, SizeOf (Block), gel); Fehler;
        If gel>5 Then
        BEGIN
          If n=0 Then
          BEGIN
            Read_Header; n:=1;
            If PName=Err Then Goto Ende1;
            If NameOnly Then
            BEGIN
              DosStr (LowStr(ArcName));
              GotoXY (74, WhereY); w (PArr[PName]);
              inc (AllFil);
              inc (alle, sr.size);
              Ende1:
              Close_Arc; Goto Ende;
            END;
          END;
          CASE PName Of
            ARJ : List_ARJ;
            ZIP : List_ZIP;
            LHA : List_LHA;
            RAR : List_RAR;
          END;
        END;
      UNTIL (gel=0) or (t1=#27);

      Close_arc;
      If (not List) and (nx<>0) Then
      BEGIN
        w ('');
        DosStr ('Gesamtgre entpackt: ');
        DosStr (TausPkt (Gesamt));
        w (' Byte');
        DosStr (      'Gefundene Dateien...: ');
        w (TausPkt (Files));
      END;
    END;
    Ende:
    FindNext (sr);
  END;
END;



PROCEDURE Rek (S : PathStr);
VAR
  tx : Searchrec;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), normalfile, tx);
  While (DOSError=0) and (t1<>#27) Do
  BEGIN
    If (tx.attr and Directory <> 0) and (tx.name[1] <> '.') Then
    BEGIN
      ListDir (Vollpfad (S, tx.name));
      Rek (Vollpfad (S, tx.name));
    END;
    Findnext (tx);
  END;
END;


{---------------------------- Hauptprogramm ---------------------------------}

BEGIN
  t1:= #0;
  StretchParam (Param);
  For n:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr(n));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'P' : Page    := TRUE;
      'B' : List    := TRUE;
      'S' : SubDir  := TRUE;
      'D' : BEGIN WithPath:= TRUE; List:= TRUE; Short:= TRUE; END;
      'A' : NameOnly:= TRUE;
      'W' : BEGIN Line:= 25; w ('Starte ARCDIR...'); END;
      'N' : BEGIN List:= TRUE; Short:= TRUE; END;
    END Else
    If FName=''    Then FName   := Param Else
    If SeekFile='' Then SeekFile:= Param;
  END;

  If FName='' Then FName:= VollPfad (FileExPand (''), '*.*') Else
  If pos ('*', FName) = 0 Then
  BEGIN
    If (Length (FName)<=3) and (FName[2]=':') Then
    FName:= VollPfad (FName, '*.*') Else
    BEGIN
      FindFirst (FName, normalfile, sr);
      If DOSError>=150 Then SimpleHalt (CopyResultStr (DOSError));
      If (DOSerror=0) Then
      If (sr.attr and directory <> 0) Then FName:= VollPfad (FName, '*.*');
    END;
  END;

  FName:= FileExPand (FName);
  PStat:= PathStatus (FName, CheckQuelle);
  If PStat<>0 Then SimpleHalt (PathStatusStr (PStat));

  zPath := GetPathName  (FName);
  FName := GetFileNames (FName);

  ListDir (zPath);
  If SubDir Then Rek (zPath);

  If not List Then
  BEGIN
    If AllFil = 0 Then w ('Keine Archive gefunden') Else
    BEGIN
      w ('');
      DosStr ('Gesamtgren (Summe): '); DosStr (TausPkt (Alle)); w (' Byte');
      DosStr ('Dateien insgesamt...: ');      w (TausPkt (AllFil));
    END;
  END;
  BlindStop;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
