UNIT ART_1;


INTERFACE

USES
  Crt, Graph, art_menu;

CONST
  Gravity      = 1;
  MaxSchuss    = 10;
  MaxPulver    = 250;
  MaxWind      = 10;
  StartWinkel  = 40;
  StartLadung  = 25;
  StWi         = '40';
  StLa         = '25';
  Kanonenfarbe = LightGray;

  PgUp = #73; Up = #72; PgDn = #81; Down = #80;
  (* PgUp/PgDn: unter MacOS fn+Pfeiltasten *)

VAR
  GameOver         : Boolean;
  PulverAlle       : array[1..2] Of Boolean;
  x, y, xMax, yMax : Integer;
  st1, st2         : String[5];
  PixelColor       : Word;
  Winkel, UserNum  : Integer;
  OldW1, OldW2     : Integer;
  Ladung, Wind     : Integer;
  StartX, StartY   : Integer;
  Fahnenfuss       : Integer;
  xko, pKo         : array[1..2] Of Word;
  xm, ym, kn, xh   : Integer;
  Beginner         : Byte;
  User             : Array[1..2] Of
                     RECORD
                       winkel, ladung, pulver, schuss, yy : Integer;
                       Punkte : Word;
                     END;


PROCEDURE Grafik_ein;
PROCEDURE MakeScreen;
PROCEDURE Taste (a, b, c, d : Word; st : String);
PROCEDURE Tasten;
PROCEDURE Sonne;
PROCEDURE Wolke;
PROCEDURE Fahne;
PROCEDURE Kugelhaufen;
PROCEDURE Punkte;
PROCEDURE Kanone (Color, Unum : Byte);
PROCEDURE Explosion;



IMPLEMENTATION


PROCEDURE EgaVga; external;  {ist in EGAVGA.OBJ enthalten}
{$L EGAVGA.OBJ }


PROCEDURE Grafik_ein;
VAR
  grDriver, grMode : Integer;
  ErrCode          : Integer;
BEGIN
  if RegisterBGIdriver(@EGAVGA) < 0 then
  BEGIN W0 ('Fehler: '+ GraphErrorMsg(GraphResult)); Halt END;;
  grDriver:= detect;
  InitGraph (grDriver, grMode, '');
  ErrCode:= GraphResult;
  If ErrCode <> grOk then
  BEGIN W0 ('Fehler: '+ GraphErrorMsg (ErrCode)); Halt; END;
  SetBkColor (white);
  xMax:= GetMaxX; yMax:= GetMaxY; xh:= xMax DIV 2;
END;



PROCEDURE MakeScreen;
BEGIN
  SetLineStyle (0, 0, 0);
  SetFillStyle(SolidFill, red);
  Bar (0, 0, xMax, 15);
  SetColor (white);
  OutTextXY (15,  4, 'Artillerie 1.0');
  OutTextXY (xMax-200, 4, 'Neu = Space   Ende = Esc');
  SetViewPort (0, 16, xMax, yMax, ClipOn);
  Beginner:=1;
  User[1].Punkte:= 0; User[2].Punkte:= 0;
END;



PROCEDURE Taste (a, b, c, d : Word; st : String);
BEGIN
  SetColor (15); Line (a, b, a, d); Line (a, b, c, b);
  SetColor (8);  Line (c, b, c, d); Line (a, d, c, d);
  Setcolor (yellow); OutTextXY (a+10, b+8, st);
END;



PROCEDURE Tasten;
VAR
  x1,x2, y1, y2, y3, y4 : Word;
BEGIN
  Taste (xh-45, yMax-63, xh+45, yMax-43, 'Tab-Enter');
  x1:= xMax-83; x2:=xMax-45;
  y1:= yMax-64; y2:=yMax-40; y3:=yMax-44; y4:=yMax-20;

  Taste (4,  y1, 45, y3, 'Q '#24);
  Taste (4,  y2, 45, y4, 'A '#24);
  Taste (49, y1, 89, y3, 'W '#25);
  Taste (49, y2, 89, y4, 'S '#25);

  Taste (x1,  y1, x2,  y3, 'B '#24);
  Taste (x1,  y2, x2,  y4, '  '#24); inc (x1, 42); inc (x2, 42);
  Taste (x1,  y1, x2,  y3, 'B '#25);
  Taste (x1,  y2, x2,  y4, '  '#25);
END;


PROCEDURE Sonne;
VAR
  x : Integer;
BEGIN
  x:= Random (xMax-40); If x<40 Then x:=40;
  SetFillStyle(SolidFill, yellow);
  SetColor (yellow);
  Fillellipse (x, 40, 20, 20);
END;


PROCEDURE Wolke;
VAR
  x, y       : Integer;
  z, a, b, c : Byte;
BEGIN
  x:= Random (xMax-100); If x<140 Then x:=140;
  a:= Random (15)+1; b:= Random (15)+8; c:= Random (5);
  SetFillStyle (solidFill, lightblue);
  SetColor (lightblue);
  y:=40;
  For z:= 1 To b Do
  BEGIN
    Fillellipse (x+(z*12), y, 10, 10);
    If z= b DIV 2 Then BEGIN y:=45+c; x:=x-(z*a); END;
  END;
END;



PROCEDURE Fahne;
VAR
  i, x2 : Word;
BEGIN
  Wind:= Random (MaxWind) - MaxWind DIV 2;
  If Wind >= 0 Then x2:=xh Else x2:= xh-10;
  For i:= 1 To abs (Wind) Do
  BEGIN
    SetFillStyle (SolidFill, lightred);
    Bar (x2, Fahnenfuss-30, x2+5, Fahnenfuss-25);
    SetFillStyle (SolidFill, lightgray);
    Bar (x2+5, Fahnenfuss-30, x2+10, Fahnenfuss-25); 
    If Wind>0 Then inc (x2, 10) Else dec (x2, 10);
  END;
  Setcolor (brown);
  Line (xh, Fahnenfuss, xh, Fahnenfuss-30);
END;


PROCEDURE Kugelhaufen;
VAR
  xx, yy   : Integer;
  i, color : Byte;
BEGIN
  yy:= User[UserNum].yy-4;
  If UserNum=1 Then xx:= 5 Else xx:= xMax-23;
  For i:= 1 To MaxSchuss Do
  BEGIN
    If i > User[UserNum].Schuss Then color:=White Else Color:=DarkGray;
    SetFillStyle (SolidFill, color);
    SetColor (color);
    Fillellipse (xx, yy, 2, 2);
    inc (xx, 6);
    CASE i Of
      4 : BEGIN dec (yy, 6); dec (xx, 21); END;
      7 : BEGIN dec (yy, 6); dec (xx, 15); END;
      9 : BEGIN dec (yy, 6); dec (xx,  9); END;
    END;
  END;
END;



PROCEDURE Kanone (Color, UNum : Byte);
VAR
  NWinkel : Real;
  x, y, x2, y2,  xx : Integer;
BEGIN
  SetLineStyle (0, 0, ThickWidth);
  If UNum=2 Then xx:= xMax-30 Else xx:=30;
  NWinkel:= User[Unum].Winkel/180 * Pi;
  X := round (30*cos (NWinkel));
  Y := round (30*sin (NWinkel));
  SetColor (Brown);
  If UNum=1 Then
  BEGIN
    Line (xx, User[UNum].yy-2, xx+20, User[UNum].yy-2);
    Ellipse (xx, User[UNum].yy-2,  0,User[UNum].Winkel, 15, 15);
    setcolor (color);
    Line (xx, User[UNum].yy-2, xx+x,  User[UNum].yy-2-y);
  END Else
  BEGIN
    Line (xx, User[UNum].yy-2, xx-20, User[UNum].yy-2);
    Ellipse (xx, User[UNum].yy-2, 180-User[UNum].Winkel, 180, 15, 15);
    setcolor (color);
    Line (xx, User[UNum].yy-2, xx-x,  User[UNum].yy-2-y);
  END;
  SetLineStyle (0, 0, 0);
END;


PROCEDURE Punkte;
VAR
  x : Byte; st : String[5];
BEGIN
  SetColor (lightGray); st:=''; For x:= 1 To 5 Do st:=st+#219;
  OutTextXY (xh-46, yMax-30, st);
  OutTextXY (xh+8,  yMax-30, st);
  Setcolor (Red);
  OutTextXY (xh-3,  yMax-30, ':');
  Str (User[1].Punkte:5, st);
  OutTextXY (xh-46, yMax-30, st);
  Str (User[2].Punkte, st);
  OutTextXY (xh+8,  yMax-30, st);
END;


PROCEDURE Stern (x, y : Word);
BEGIN
  MoveTo (x-20, y);    LineTo (x-20, y);    LineTo (x-5,  y-10);
  LineTo (x-20, y-20); LineTo (x-2,  y-15); LineTo (x,    y-34);
  MoveTo (x+20, y-5);  LineTo (x+5,  y-10); LineTo (x+20, y-20);
  LineTo (x+2,  y-15); LineTo (x,    y-34); MoveTo (x-20, y);
  LineTo (x-5,  y-5);  LineTo (x-20, y+10); LineTo (x-2,  y);
  LineTo (x,    y+15); LineTo (x+5,  y);    LineTo (x+15, y+10);
  LineTo (x+7,  y-5);  LineTo (x+20, y-5);
END;


PROCEDURE Explosion;
VAR
  i : Byte;
  k : Integer;
BEGIN
  SetLineStyle (0,0,3);
  For i:= 1 To 10 Do
  BEGIN
    If SoundOn Then BEGIN Sound(5000); Delay (1); Nosound; END;
    SetColor (yellow);   Delay (20); Stern (x, y);
    SetColor (LightRed); Delay (20); Stern (x, y);
  END;
    SetColor (White);    Delay (20); Stern (x, y);

  SetLineStyle (0,0,0);

  MoveTo (x, y-20); k:=x;
  SetColor (DarkGray);
  For i:= 1 To 60 Do
  BEGIN
    inc (i);
    If k <= x Then inc (k, 3) Else dec (k, 3);
    LineTo (k, (y-20)-i);
    Delay (80);
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
