
jmp BEGIN 

DB                  1    ; VersionsNummer des Treibers 
DB                  6    ; Treiber-Nummer zur berprfung d. Unascii
DB                  1,0  ; interne Nummer (vom Programmierer frei whlbar) 
DB                  09h  ; Nummer eines der umgeleiteten Interrupts 
DB                  0h   ; Zahl der Start-Parameter

Flag            DB  0
VideoAddr       DW  $B000 
Busy            DB  0    ; Tabelle schon angezeigt ? 0=nein, 1=ja
IfMouse         DB  0    ; Maus eingeschaltet ?
 
.Ifopt deu
LineBuffer      DB  '       Leer-Taste:Einfgen   ENTER:Fertig  '
>                   ' Esc:Abbruch   Zeichen: ' 
.endopt

.Ifopt eng
LineBuffer      DB  '       Space-bar :insert     ENTER:Ready   '
>                   ' Esc:Abort     Chars  : ' 
.endopt

; hier keine Variablen einfgen !
 
CharBuffer      DB  '                    '

MaxBufLen       EQU 12                 ; Maximal zu speichernde Zeichen
HalfBufSize     EQU 400                ; Hintergrundpuffer...
GBufSize        EQU (HalfBufSize*2)
Pos1            EQU 71
Endx            EQU 79
Left            EQU 75
Right           EQU 77
Up              EQU 72
Down            EQU 80
 

.INSERT Strings.StrWord
 
;------------------------- Die ASCII-Tabelle ------------------------------

PROC CheckMouse:
  push ax, bx, es, si
  xor  ax, ax
  mov  es, ax
  mov  si, (33h shl 2)  ; Maus-Vektor = Int-Nr * 4
  es:
  lodsw
  mov  bx, ax
  es:
  lodsw
  or   ax, bx
  or   al, ah           ; NIL ?
  cs:
  mov  IfMouse, al
  #MouseOff
  pop  si, es, bx, ax
  ret
ENDP


PROC MouseOff:
  cs:
  cmp  Byte IfMouse, 0
  je   @raus
  push ax
  mov  ax, 2
  int  33h
  pop  ax
  @raus:
  RET
ENDP
;Mauszeiger unsichtbar

 
PROC MouseOn:
  cs:
  cmp  Byte IfMouse, 0
  je   @raus
  push ax
  mov  ax, 1
  int  33h
  pop  ax
  @raus:
  RET
ENDP
;Mauszeiger sichtbar


PROC MouseGet                   ; Rckgabe: dx=Pos, bl=Knopfzustand
  push ax
  cs:
  mov  al, IfMouse
  or   al, al
  jz   @raus

  push bx, cx, dx
  mov  ax, 3
  int  33h
  or   bl, bl
  jz   @NoMaus
  pop  ax    ; Dummy, um DX vom Stack zu bekommen
  push bx
  shr  cx, 1 / shr  cx, 1 / shr  cx, 1
  shr  dx, 1 / shr  dx, 1 / shr  dx, 1 / mov ax, dx
  mov  bx, 80
  mul  bx
  add  ax, cx
  mov  dx, ax
  pop  bx

  pop  cx
  or   bl, bl     ; setze ZeroFlag, wenn Maus nicht bettigt
  pop  bx

  @raus:
  pop  ax
  RET

  @NoMaus:
  pop  dx, cx, bx, ax
  RET
ENDP
;ermittelt die Mauskoordinaten und den Zustand der Maustasten

PROC MouseWait
  cs:
  cmp  Byte IfMouse, 0
  je   @raus
  push ax, bx, cx, dx
  @nochmal:
  mov  ax, 3
  int  33h
  or   bx, bx               ;kn = 0 ?
  jnz  @nochmal
  pop  dx, cx, bx, ax
  @raus:
  RET
ENDP

PROC GetEvent:
  #MouseOn
  @MouseKey:
    mov ah, 1
    int 16h       ; keypressed ?
    jnz @HoleTaste
    #MouseGet
    jz @MouseKey
    #MouseWait
    mov ah, 32
    or  dh, dh    ; DX >= 256 ?
    jz  @Zeichen
    cmp dx, 374   ; > Esc ?
    ja  @MouseKey ; nochmal
    cmp dx, 349   ; < Enter ?
    jb  @MouseKey
    cmp dx, 360
    ja  @esc
    mov ah, 13 / jmp short @zeichen
    @esc:
    cmp dx, 364
    jb  @MouseKey
    mov ah, 27
    @Zeichen:
    mov al, ah
    jmp short @MausAn
  @HoleTaste:
  xor ah, ah
  int 16h
  @MausAn:
  #MouseOff
  RET
ENDP

 
PROC ASCIIWindow:
  #CheckMouse
  push bx, cx, dx, es, si, di
  cld                      ; kopiere Bildschirm in Hintergrundspeicher
  cs:

  mov  ds, VideoAddr
  xor  si, si
  push cs /pop es
  lea  di, &BackGround
  mov  cx, HalfBufSize
  rep  movsw               

  lea  di, CharBuffer      ; Zeichenpuffer lschen
  mov  cx, MaxBufLen
  mov  al, 32
  rep  stosb
 
  push ds /pop es          ; ASCII-Fenster 
  push cs /pop ds           
  xor  di, di
  mov  ax, 7020h           ; Leerzeichen grau
  mov  cx, HalfBufSize
  rep  stosw               ; ClrScr
  xor  dx, dx
  xor  bx, bx

@neueRunde:
  xor  di, di  
  xor  al, al
  mov  cx, 256
  @nchstes:
    mov ah, 112
    cmp al, dl
    jne @nichtndern
      xor ah, ah
      lea si, Linebuffer
      mov Byte Ptr [si+3], 32
      inc si
      #strword (ax, si)
      mov ah, 30
    @nichtndern:
    stosw
    inc al
  loop @nchstes           ; schreibe alle Zeichen

@GetKey:
  lea si, Linebuffer
  mov di, 640
  mov ah, 30
  mov cx, 80
  @schreibePuffer:
    lodsb
    stosw
  loop @schreibePuffer
  lea  si, CharBuffer
 
  #GetEvent

         cmp  al, 27    / jne @@y / xor bx, bx           / jmp short @@ende
  @@y: / cmp  al, 8     / jne @@x / or  bx, bx           / jz  @GetKey
                          dec bx  / mov Byte [si+bx], 32 / jmp @GetKey
  @@x: / or   al, al    / jnz @@6

         cmp  ah, Pos1  / jne @@1 / xor dx, dx / jmp @neueRunde
  @@1: / cmp  ah, Endx  / jne @@2 / mov dx, 255/ jmp @neueRunde
  @@2: / cmp  ah, Left  / jne @@3 /  or dx, dx / jz  @getKey / dec dx /jmp @neueRunde
  @@3: / cmp  ah, Right / jne @@4 / cmp dx, 255/ jae @getKey / inc dx /jmp @neueRunde
  @@4: / cmp  ah, Down  / jne @@5 / add dx, 80 / cmp dx, 255 / jbe @neueRunde1
                                                 sub dx, 80  / jmp @neueRunde
  @@5: / cmp  ah, Up    / jne @@6 / sub dx, 80 / jns @neueRunde1
                                                 add dx, 80  / jmp @neueRunde
 
  @@6: / cmp  al, 32    / jne @@7           ; Leerzeichen ?

  cmp bx, MaxBufLen     / jae @getkey1
  mov [si+bx], dl
  inc bx 
  @Getkey1:
  jmp @GetKey

  @@7: /  cmp al, 13  / je @@ende

@Neuerunde1:
jmp @neueRunde


@@ende:

  lea  si, &Background       ; es und ds noch okay
  xor  di, di                ; Hintergrund wieder herstellen
  mov  cx, HalfBufSize
  rep  movsw               

  or   bx, bx / jz @@raus    ; sind Zeichen zum Schreiben vorhanden ?

  lea  si, Charbuffer
  @WriteKeys:                ; In Tastaturpuffer schreiben
    lodsb
    mov  ah, 5
    mov  cl, al / xor ch, ch
    int  16h
    dec  bx
  jnz @WriteKeys

  @@raus:
  #MouseOn
  pop di, si, es, dx, cx, bx
  RET 
ENDP
 
;-------------------------  Interrupt-Prozedur ----------------------------

Keyboard:                       ; die neue INT-Prozedur
  pushf                                     
  DB 9Ah                        ; Call Far Ptr = alte Tastaturroutine
  OBJECT Old09:
    Ofs DW '6.'                ; hier setzt der Loader die alte Adresse
    Seg DW '24'                ; der alten Tastatur-Routine ein.
  OBJECT END 
  push ds, ax 

  cs:
  mov  al, Flag
  shr  al, 1                    ; Flag wird vom Unloader gesetzt 
  jc   @Unload                  ; 1 = entladen
  jne  @Ganzraus                ; 2 = Nur alte Routine ausfhren
 
  mov  ax, 0040h
  mov  ds, ax                   ; Segment der BIOS-Variablen-Tabelle in DS
  mov  al, [0017h]              ; Tastatur-Status-Byte 
  and  al, 00000011b
  cmp  al, 00000011b            ; Shift links UND rechts ?
  jne  @Ganzraus   

  cs:
  mov  al, Busy
  or   al, al
  jnz  @Ganzraus

  mov  al, 1
  cs:
  mov  Busy, al
  call ASCIIWindow
  xor  al, al
  cs:
  mov  Busy, al
 
  jmp  short @Ganzraus
                     
@Unload:  
  push dx, es
  cs:
  lds  dx, Old09           ; Alte Adressen laden 
  mov  ax, 2509h           ; SetIntVec 09h
  int  21h                 ; Alte Tastaturroutine wieder einsetzen

  push cs / pop es
  mov  ah, 49h             ; Speicher von ASCII.COM wieder freigeben
  int  21h                 ; ES=CS=Segment des freizugebenden Blocks 
  pop  es, dx

@GanzRaus: 
  pop  ax, ds
IRET                                     


&BackGround DW 0

;------------------------------- Loader ------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt 
  lea dx, &Progname
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
 
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3509h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  int  09h              ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree
  -GetVideoAddr

  lea  dx, &Load
  #output                    ; Gebe Text aus                  

  mov  ax, 3509h       ; GetIntVec 09h
  int  21h                                
  mov  Old09.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old09.Seg, es  
  mov  ax, 2509h       ; SetIntVec 09h
  lea  dx, Keyboard    ; = mov dx, Offset Keyboard / DS bereits Segment-Addr.
  int  21h
 
  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  add  dx, GBufSize    ; zum Hintergrund speichern
  int  27h             ; Rest des Programmes resident machen

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
 
.ifopt deu
  &ProgName  DB  'ASCII  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'residente ASCII-Tabelle zum Einfgen von Grafikzeichen in Texte'
  >               13,10,13,10
  >              'Laden  : ASCII',13,10
  >              'Steuern: ASCII [/x|/s|/r]',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren$' 
.endopt
 

.ifOpt eng
  &Progname  DB  'ASCII  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Resident ASCII-Table to insert graphic characters into opened files'
  >               13,10,13,10
  >              'Install: ASCII',13,10
  >              'Control: ASCII [/x|/s|/r]',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
