PROGRAM attrib;
{$M 60000, 0, 0}

USES
  DOS, sperre, Strings, Bioscrt, Masken, filecopy, WildCard;

VAR
  sr        : Searchrec;
  f         : File;
  TmpObjekt : String;
  LosT      : Boolean;

CONST
  Objekt    : String   = '';
  SuchPfad  : String   = '';
  Result    : Word     = 0;
  Rekurs    : Boolean  = False;
  LosTaste  : Boolean  = False;
  Anzeigen  : Boolean  = TRUE;
  IsDir     : Boolean  = False;
  FileNum   : LongInt  = 0;
  LowCase   : Boolean  = FALSE;
  Files     : Byte     = 0;
  SAttr     : Byte     = 0;
  LAttr     : Byte     = 0;
  ZAttr     : Byte     = 0;
  NAttr     : Byte     = 0;
  Attr      : String[6]= 'ASHRID';
  xAttr     : array[1..6] of Byte = (Archive, SysFile, Hidden, ReadOnly, VolumeID, Directory);


PROCEDURE Maske (VAR Attri : Byte);
VAR
  p : Byte;
BEGIN
  p:= pos (TmpObjekt[2], Attr);
  If p<>0 Then Attri:= Attri or xAttr[p];
END;


PROCEDURE TastenAbfrage;
BEGIN
  REPEAT
    UpScanBKeys;
  UNTIL (t1='J') or (t1='N') or (t1= 'A') or (t1=#13) or (t1=#27);
END;


PROCEDURE ExProc;
BEGIN
  If (t1=#27) or (Result<>0) Then
  BEGIN
    If t1=#27 Then
    BEGIN Result:=253; DosLnLF ('Abbruch durch Anwender'); END Else
    DosLnLF ('Ausfhrungsfehler: '+CopyResultStr (Result));
    Halt (Result);
  END;
END;


PROCEDURE Hilfetext;
BEGIN
  DosLnLF (#13#10+
    'ATTRIB  '+ Copyright +#13#10+
    'ndert Dateiattribute oder zeigt sie an'#13#10#13#10+
    'ATTRIB [Datei- oder Verzeichnisname/n] [Parameter]'#13#10#13#10+
    '+   setzt  ein Attribut'#13#10+
    '-   lscht ein Attribut'#13#10+
    '&   bercksichtigt nur Dateien mit dem angegebenen Attribut');
  DosLnLF (
    '#   ignoriert Dateien mit dem angegebenen Attribut'#13#10#13#10+
    'A   Archiv'#13#10+
    'R   Schreibgeschtzt'#13#10+
    'H   Versteckt'#13#10+
    'S   Systemattribut'#13#10+
    'D   Verzeichnis    (nur als Filter mit # oder & verwendbar)'#13#10+
    'I   Datentrger-ID ( " " )'#13#10);
   DosLnLF (
    '/p  fragt bei jeder Datei, ob ihr Attribut gendert werden soll bzw.'#13#10+
    '    ermglicht seitenweises Anzeigen der Dateiliste'#13#10+
    '/l  Anzeige in Kleinschreibung'#13#10+
    '/s  verarbeitet auch Dateien in Unterverzeichnissen'#13#10#13#10+
    'Beispiel: ATTRIB *.BAK+*.TMP -r -h #d /s');

  BlindStop; Halt;
END;


FUNCTION AttrMatch (Att : Byte) : Boolean;
BEGIN
  AttrMatch:=  (Att and ZAttr = ZAttr)
          and  (Att and NAttr = 0)
          and ((Att and 15 <> 15) or (Att and VolumeID = 0));
              { Att and 15 <> 15 wegen LFN von Windows 9x }
END;


PROCEDURE Attribute (Quelle : PathStr; Att : Byte);
VAR
  NewAttr, x : Byte;
BEGIN
  inc (Files);

  If Anzeigen Then
  BEGIN
    inc (FileNum);
    For x:= 1 To 6 Do
    If att and xattr[x]=0 Then DosStr ('-') Else DosStr (Attr[x]);
    DosStr ('   ');
    If LowCase Then DosLnLF (LowStr(Quelle)) Else DosLnLF (Quelle);
    If (LosTaste) and (Files > 22) Then
    BEGIN
      Files:= 0;
      DosStr (#13#10'Weiter mit Enter oder Beenden mit Esc');
      TastenAbfrage; DosLnLF ('');
      ExProc;
    END;
    Exit;
  END;

  NewAttr:= (Att or SAttr) and not LAttr;
  NewAttr:= NewAttr - (NewAttr and Directory);

  If (Att     and (Archive or ReadOnly or Hidden or Sysfile))
  =  (NewAttr and (Archive or ReadOnly or Hidden or Sysfile)) Then
  BEGIN inc (FileNum); Exit; END;

  If Lostaste Then
  BEGIN
    DosLnLF ('');
    If LowCase Then DosLnLF (LowStr(Quelle)) Else DosLnLF (Quelle);
    DosStr ('   Attribute ndern?   <j>a   <n>ein   <a>lle   <Esc>Abbruch');
    GotoXY (3, WhereY);
    TastenAbfrage;
    DosLnLF ('');
    ExProc;
    If t1='N' Then Exit Else
    If t1='A' Then LosTaste:= FALSE;
  END;

  Assign   (f, Quelle);
  SetFAttr (f, NewAttr); Result:= DOSError;
  inc (FileNum);

  If Result<>0 Then BEGIN DosLnLF (Quelle); ExProc; END;
END;



PROCEDURE Rekursiv (Dir : PathStr);
VAR
  sr : SearchRec;
BEGIN
  FindFirst (VollPfad (Dir, '*.*'), anyfile, sr);
  If DOSError>=150 Then BEGIN Result:= DOSError; ExProc; END;
  While DOSError=0 Do
  BEGIN
    If  (sr.name[1]<>'.')
    and (AttrMatch (sr.attr))
    and (FileMatch (sr.name, Objekt)) Then
    Attribute (Vollpfad(Dir, sr.name), sr.attr);
    FindNext (sr);
    If Keypressed Then UpscanBkeys; ExProc;
  END;

  If not Rekurs Then Exit;

  FindFirst (VollPfad (Dir, '*.*'), anyfile, sr);
  If DOSError>=150 Then BEGIN Result:= DOSError; ExProc; END;
  While DOSError=0 Do
  BEGIN
    If (sr.attr and directory <> 0) and (sr.name[1]<>'.') Then
    Rekursiv (VollPfad(Dir, sr.name));
    FindNext (sr);
    If Keypressed Then UpscanBkeys; ExProc;
  END;
END;


PROCEDURE StretchObjekt;
CONST
  Signs : String = '/-+&#';
VAR
  x, y  : Byte;
LABEL
  Los, Ende;
BEGIN
  For x:= 1 To Length (Signs) Do If Objekt[1]=Signs[x] Then Goto Los;
  Goto Ende;
Los:
  For y:= 2 To Length (Objekt) Do
  For x:= 1 To Length (Signs)  Do
  If Objekt[y]=Signs[x] Then
  BEGIN
    TmpObjekt:= copy (Objekt, 1, y-1);
    Delete (Objekt, 1, y-1);
    Exit;
  END;
Ende:
  TmpObjekt:= Objekt; Objekt:= '';
END;


PROCEDURE CheckPfad (Pfad : PathStr; Modus : TCheckObjekt);
VAR
  PStat : Word;
BEGIN
  Pfad:= FileExpand (Pfad);
  If DOSError=0 Then PStat:= PathStatus (Pfad, Modus) Else PStat:= DOSError;
  If PStat<>0 Then
  BEGIN DosStr (PathStatusStr (PStat)); BlindStop; DosLnLF (''); Halt; END;
END;


PROCEDURE Parameter;
VAR
  x : Byte;
BEGIN
  StretchParam (Objekt);
  For x:= 1 To ParamCount Do
  BEGIN
    Objekt:= UpStr (ParamStr (x));
    REPEAT
      StretchObjekt;
      CASE TmpObjekt[1] Of
        '/' : CASE TmpObjekt[2] Of
                'S' : Rekurs:= TRUE;
                'P' : Lostaste:= TRUE;
                'L' : BEGIN LowCase:= TRUE; Attr:= LowStr(Attr); END;
                '?' : BEGIN Hilfetext; Halt (255); END;
              END;
        '-' : Maske (LAttr);
        '+' : Maske (SAttr);
        '&' : Maske (ZAttr);
        '#' : Maske (NAttr);
        Else  If SuchPfad='' Then SuchPfad:= TmpObjekt;
      END;
    UNTIL Objekt='';
  END;

  Anzeigen:= (Sattr+LAttr=0);

  LosT:= LosTaste;
END;


{----------------------------- HauptProgramm ------------------------------}

BEGIN
  Parameter; t1:= #0;

  If SuchPfad='' Then Suchpfad:= '*';
  CheckPfad (SuchPfad, CheckQuelle);

  SuchPfad:= FileExpand (SuchPfad);
  If SuchPfad[Length(Suchpfad)]='\' Then SuchPfad:= VollPfad (SuchPfad, '*');

  If not IsWildCard (SuchPfad) Then
  BEGIN
    FindFirst (SuchPfad, Normalfile, sr);
    IsDir:= (DOSError = 0) and (sr.attr and directory <> 0);
    If IsDir and AttrMatch (sr.attr) Then Attribute (SuchPfad, sr.attr);
    If (Rekurs) and (IsDir) Then SuchPfad:= VollPfad (SuchPfad, '*');
  END;

  Objekt  := GetFileNames (SuchPfad);
  SuchPfad:= DelLastSlash (GetPathName (SuchPfad));

  If not Anzeigen Then CheckPfad (SuchPfad, CheckZiel);

  If Rekurs or (not IsDir) Then Rekursiv (Suchpfad);

  If LosT Then DosLnLF ('');

  If FileNum=0 Then
  BEGIN
    If LosT Then
    DosLnLF ('Kein Objekt verarbeitet') Else
    DosLnLF ('Kein Objekt gefunden');
    Result:=254;
  END Else
  If not Anzeigen Then
  BEGIN
    DosNum (FileNum);
    DosLnLF (' Dateien/Verzeichnisse verarbeitet');
  END;

  Blindstop; Halt (Result);
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
