PROGRAM Browser;
{$M 35000, 4096, 80000}  { Stackhhe wegen (ehem. Rekursion in FileExpand
                           und Textpuffern in bro_cmd }

USES
  Monitor, BiosCrt, Dev_IO, DOS, Brow_var, bro_tool, Mouse, Strings,
  Konvert, keycode, Bro_edit, brow_cmd, bro_list, time,
  clipbord, Bro_Heap, FileMan, Brow_win, IO_Tools, Brow_url, Fil_IO,
  DeviceIO;

VAR
  Tag       : String;
  TagAn,
  TagEn     : Byte;
  tmpLink   : Byte;
  Dev       : Device;
  ActURL    : TURLRec;
  NewURL    : TURLRec;
  x, z      : Word;

LABEL
  ReadNew, Ende, Check, Check1, Tasten, AnkerSeek, IsMouse, Speichern,
  ScanDir, Tabul;


PROCEDURE PutStrInBuf (ein : String);
VAR x : Byte;
BEGIN
  For x:= 1 To Length (ein) Do PutInBuf (ein[x]);
END;


FUNCTION TagPos (ein : String) : Boolean;
BEGIN
  TagPos:= (pos (ein+' ', Tag)=1) or (pos (ein+'>', Tag)=1);
END;


FUNCTION HeadPos (ein : String) : Boolean;
VAR
  c : Char;
BEGIN
  HeadPos:= FALSE;
  For c:= '1' To '7' Do
  If (pos (ein+c+' ', Tag)=1) or (pos (ein+c+'>', Tag)=1) Then
  BEGIN HeadPos:= TRUE; Exit; END;
END;


FUNCTION SinglePos (ein : String) : Boolean;  (* z.B. fr noshade, checked u..*)
BEGIN
  SinglePos:= (pos ('"'+ein+' ', Tag)<>0) or (pos ('"'+ein+'>', Tag)<>0) or
              (pos (' '+ein+' ', Tag)<>0) or (pos (' '+ein+'>', Tag)<>0);
END;


FUNCTION TagElement (ein : String) : String;
VAR
  p   : Byte;
  tmp : String;
BEGIN
  p:= pos (' '+ein+'=', Tag);
  If p=0 Then p:= pos ('"'+ein+'=',  Tag);

  If p=0 Then TagElement:= '' Else
  BEGIN
    TagAn:= p+Length(ein)+2;
    tmp:= copy (Tag, p, 255); p:= pos ('=', tmp);
    If p=0 Then TagElement:= '' Else
    BEGIN
      tmp:= Trim(copy (Tmp, p+1, 255));
      If tmp[1]='"' Then
      BEGIN
        inc (TagAn);
        delete (tmp, 1, 1); p:= pos ('"', tmp);
      END Else
      BEGIN
        p:= pos (' ', tmp); If p=0 Then p:= pos ('>', tmp);
        If p=0 Then p:= Length(tmp);
      END;
      If p=0 Then p:= 1; Tmp[0]:= chr (p-1);
      TagEn:= Length(tmp)+1;
      TagElement:= tmp;
    END;
  END;
END;



PROCEDURE ReadFile (Name : String);
CONST
  StackSize = 1000;
VAR
  x, c1     : Byte;
  c         : Char;
  tmp       : String;
  tmp1      : String;
  i, j      : Word;
  ColStack  : Array[1..StackSize] Of Byte;
  ColPtr    : Word;
  TeleTyper : Boolean;
  UlType    : Char; (*Vorzeichen einer Liste*)
  LastChar  : Char;
  tdEnd     : Boolean; { um festzustellen, ob Tabellenzelle mit </TD> endete oder nicht }
  trEnd     : Boolean; { um festzustellen, ob Tabellenzeile mit </TR>/</TH> endete oder nicht }
  tEnd      : Boolean; { endete Tabelle mit </TABLE> ? }
  IsAnker   : Boolean;
  IsHead    : Boolean;
  IsFrame   : Boolean;
  IsTextArea: Boolean;
  AreaText  : String;
  Kon       : Char;
  OrigTag   : String;

LABEL
  Nochmal, Ende, Over, Over1, Klammer, NextTry;


FUNCTION HtmlCode : String;
VAR
  x          : Byte;
  tmp1, tmp2 : String;
BEGIN
  tmp2:= '';
  For x:=1 To Length(Tmp) Do
  If Tmp[x]='&' Then
  BEGIN
    tmp1:= '';
    While (Length(Tmp1)<255) and (Tmp[x]<>';') and (x<Length(tmp)) Do
    BEGIN CharAdd (Tmp1, tmp[x]); inc (x); END;
    tmp2:= tmp2+HTML2Text (Tmp1+';');
  END Else CharAdd (Tmp2, tmp[x]);
  HTMLCode:= tmp2;
END;


PROCEDURE NewColor (Element : String; Color : Byte);
VAR
  s : String;
  c : Byte;
BEGIN
  If Konfig.ColMode<>'A' Then Exit;
  s:= TagElement (Element);
  If (ColPtr<StackSize) Then
  BEGIN 
    If s<>'' Then c:= ColNum (s) Else
    BEGIN
      If Color=2 Then c:= nWhite Else
      If Color=0 Then
      c:= ColStack[ColPtr] shr 4 Else c:= ColStack[ColPtr] and $0F;
    END;
    If c<>255 Then
    BEGIN
      If (Color<>1) and (ScrMode=MonoMon) and (c>=8) Then c:=7;
      If Color=2 Then
      BEGIN Color:=0; BackCol:= c; END;
      If Color=0 Then TextBack (c) Else
      BEGIN
        If (c=TextAttr shr 4) or ((TextAttr shr 4>=14) and ((c>=14) or (c=10) or (c=11)))
        Then dec (c, 8);
        TextColor(c);
      END;
      inc (ColPtr); ColStack[ColPtr]:= TextAttr;
      PutStrInBuf (#0#1); PutInBuf (chr(TextAttr));
    END Else If Color=2 Then BackCol:= nWhite;
  END;
END;


PROCEDURE OldColor (Color : Byte);
BEGIN
  If Konfig.ColMode<>'A' Then Exit;
  If ColPtr>1 Then  (* vorher: If ColPtr <> 0 Then *)
  BEGIN
    dec (ColPtr);
    If Color=0 Then TextBack (ColStack[ColPtr] shr 4) Else
    TextColor (ColStack[ColPtr] and $0F);
  END; (*Else TextAttr:= 112;*)
  (*If ColPtr>0 Then*) BEGIN PutStrInBuf (#0#1); PutInBuf (chr(TextAttr)); END;
END;


FUNCTION KonChar (c : Char) : Char;
BEGIN
  CASE Kon Of
    '1' : KonChar:= WinToDOS   (c);
    '2' : KonChar:= MacToASCII (c);
    '3' : KonChar:= '#';
  END;
END;


FUNCTION PopChar : Char;
VAR
  c : Char;
BEGIN
  ReadChar (Dev, c);
  If (c>#127) and (Kon<>'0') Then
  PopChar:= KonChar(c) Else PopChar:= c;
END;


BEGIN
  Kon:= IniKon;

  Teletyper:= MIMEType<>'text/html';

  Counter:= 0; c:= #0; ColPtr:= 0; IsTextArea:= FALSE; AreaText:='';
  Refresh.sec:= 65535; { = kein Refresh }

  If (Konfig.ColMode='A') or (Konfig.ColMode='C') Then
  BEGIN TextAttr:= nWhite shl 4; BackCol:= nWhite; END Else
  BEGIN TextAttr:= 7; BackCol:= black; END;

  Title:= 'Ohne Titel'; ULType:= #0; IsFrame:= FALSE;
  Link:= lightBlue; VLink:= magenta;
  LastLink:= 0; onLoad:= FALSE; tdEnd:= TRUE; trEnd:= TRUE; tEnd:= TRUE;
  IsAnker:= FALSE; IsHead:= False;

  FillBuf (#32);

  While (not EndOfFile(Dev)) and (Counter<MaxChars) Do
  BEGIN
    Nochmal:
    LastChar:= c;
    c:= PopChar;

    If (c=#10) and (LastChar<>#13) Then c:= #13;
    If (c=TAB) or (c=#8) Then c:= #32 Else
    If  c=#10 Then
    BEGIN If not EndOfFile(Dev) Then Goto Nochmal Else Goto Ende; END Else
    If (c=#13) and (not Teletyper) Then
    If  LastChar<>'>' Then c:= #32 Else If not EndOfFile(Dev) Then Goto Nochmal;
   
    If c='&' Then
    BEGIN
      tmp:= c;
      While (not EndOfFile(Dev)) and (Length(Tmp)<15)
        and (c<>';') and (c<>' ') and (c<>'<') Do
      BEGIN
        c:= PopChar;
        If c<>'<' Then CharAdd (Tmp, c);
      END;
      If IsHead Then PutStrInBuf (UpStr(HTML2Text (Tmp))) Else
      PutStrInBuf (HTML2Text (Tmp));
      If c='<' Then Goto Klammer;
    END Else

    If c='<' Then
    BEGIN
      Klammer:
      
      tmp:= c;
      While (not EndOfFile(Dev)) (*and (Length(Tmp)<255) s. 5 Zeilen tiefer *)
        and (c<>'>') Do
      BEGIN
        c:= PopChar;
        If (c= #13) or ((c=#10) and (LastChar<>#13)) Then c:= ' ';

        If (c<>#10) and (Length(Tmp)<255) Then CharAdd (Tmp, c);

        If (c='-') and (tmp='<!--') Then
        BEGIN
          While not EndOfFile(Dev) Do
          BEGIN
            c:= PopChar;
            NextTry:
            If (c='-') and (NextChar(Dev)='-') Then
            BEGIN
              c:= PopChar;
              If NextChar(Dev)='>' Then BEGIN c:= PopChar; Goto Nochmal; END
              Else If not EndOfFile(Dev) Then Goto NextTry;
            END;
          END;
          If EndOfFile(Dev) Then Goto Ende;
        END Else
        If (c='?') and (tmp='<?') Then
        BEGIN
          While not EndOfFile(Dev) Do
          BEGIN
            c:= PopChar;
            If (c='?') and (NextChar(Dev)='>') Then
            BEGIN
              c:= PopChar;
              Goto Nochmal;
            END;
          END;
          If EndOfFile(Dev) Then Goto Ende;
        END;
      END;

      While pos (' =', tmp) <>0 Do delete (tmp, pos (' =', tmp), 1);
      While pos ('= ', tmp) <>0 Do delete (tmp, pos ('= ', tmp)+1, 1);

      If pos ('&', tmp)<>0 Then tmp:= HTMLCode;
      OrigTag:= Trim(Tmp);
      Tag:= UpStr (OrigTag);

      If TagPos ('<A') Then
      BEGIN
        tmp:= TagElement ('HREF');  { hier noch wegen Gro/Kleinschreibung optimieren }
        If tmp='' Then  (*Anker?*)
        BEGIN
          IsAnker:= TRUE;
          tmp:= TagElement ('NAME');
          If tmp<>'' Then PutStrInBuf (#0#5+tmp+#255);
        END Else
        If LastLink<MaxLinks Then
        BEGIN
          IsAnker:= FALSE;
          inc (LastLink);
          If tmp[1]='#' Then
          LinkBuf[LastLink].Link:= BuildLink (FileName, tmp) else
          BEGIN
            tmp:= Trim(copy(OrigTag, TagAn, TagEn-1));
            LinkBuf[LastLink].Link:= BuildLink (FileName, tmp);
          END;
          PutStrInBuf (#0#4+chr(LastLink));
        END;
      END Else

      If TagPos  ('</A') Then
      BEGIN
        If not IsAnker Then PutStrInBuf (#0#6+chr(TextAttr));
      END Else

      If TagPos ('<BODY')  Then
      BEGIN
        If not IsFrame Then Counter:= 0;
        NewColor ('BGCOLOR', 2);
        NewColor ('TEXT', 1);
        tmp:= TagElement ('LINK');  If tmp<>'' Then
        BEGIN
          c1:= ColNum (tmp); If c1<>255 Then Link := c1;
          If (Link=BackCol) or ((BackCol>=14) and ((Link>=14) or (Link=10) or (Link=11)))
          Then dec (Link, 8);
        END;
        tmp:= TagElement ('VLINK'); If tmp<>'' Then
        BEGIN
          c1:= ColNum (tmp); If c1<>255 Then VLink:= c1;
          If (VLink=BackCol) or ((BackCol>=14) and ((VLink>=14) or (VLink=10) or (VLink=11)))
          Then dec (VLink, 8);
        END;
        If Link=VLink Then If link>0 Then dec (Link) else inc (VLink);
        tmp:= TagElement ('LOAD'); If tmp<>'' Then
        BEGIN LoadBef:= tmp; onLoad:= TRUE; END;
      END Else
      If TagPos ('</BODY') Then Goto Ende Else
      If TagPos ('<TITLE') Then
      BEGIN
        Title:= '';
        While (not EndOfFile(Dev)) and (Length(Title)<255) and (NextChar(Dev)<>'<') Do
        BEGIN
          c:= PopChar;
          If (c=TAB) or (c=#8) Then c:= ' ';
          If c='&' Then
          BEGIN
            tmp:= c;
            While (not EndOfFile(Dev)) and (Length(Tmp)<255) and (c<>';') Do
            BEGIN
              c:= PopChar;
              CharAdd (Tmp, c);
            END;
            Title:= Title+HTML2Text (Tmp);
          END Else If (c<>#13) and (c<>#10) Then CharAdd (Title, c);
        END;
      END Else
      If (TagPos('<TT'))  or (TagPos ('<PRE'))  or (TagPos('<CODE'))  Then TeleTyper:= TRUE  Else
      If (TagPos('</TT')) or (TagPos ('</PRE')) or (TagPos('</CODE')) Then TeleTyper:= FALSE Else
      If (TagPos('<BR') or TagPos ('<DIV')) and ((NextChar(Dev)<>#13) or (not Teletyper)) Then PutInBuf(#13) Else
      If (TagPos ('<P') or TagPos('</P')) and ((NextChar(Dev)<>#13) or (not Teletyper)) Then PutStrInBuf(#13#13) Else
      If TagPos ('<FONT')     Then BEGIN NewColor ('BGCOLOR', 0); NewColor ('COLOR', 1); END Else
      If TagPos ('</FONT')    Then BEGIN OldColor (1); OldColor (0); END Else

      If (TagPos ('<TABLE'))  Then
      BEGIN PutInBuf (#13); If tEnd Then NewColor ('BGCOLOR', 0); tEnd:= FALSE; END Else
      If (TagPos ('<TR'))  or (TagPos ('<TH')) Then
      BEGIN If TrEnd Then NewColor ('BGCOLOR', 0); trEnd:= FALSE; END Else
      If (TagPos ('<TD'))     Then
      BEGIN If TdEnd Then NewColor ('BGCOLOR', 0); If not TDEnd Then PutInBuf(#32) Else TdEnd:= FALSE; END Else
      If (TagPos ('</TABLE')) Then
      BEGIN If not TEnd Then OldColor (0); TEnd:= TRUE; END Else
      If (TagPos ('</TD'))    Then
      BEGIN If not TdEnd Then OldColor (0); PutInBuf(#32); TdEnd:= TRUE; END Else
      If (TagPos ('</TR'))    or (TagPos ('</TH')) Then
      BEGIN PutInBuf (#13); If not trEnd Then OldColor (0); TrEnd:= TRUE; END Else

      If (TagPos  ('<UL')) or (TagPos  ('<OL')) Then
      BEGIN
        tmp:= TagElement ('TYPE');
        If tmp='CIRCLE' Then UlType:= #9   Else
        If tmp='SQUARE' Then ULType:= #254 Else
        If tmp='DISC'   Then UlType:= #4   Else UlType:=#254;
      END Else
      If (TagPos  ('</UL')) or (TagPos  ('</OL')) Then
      BEGIN UlType:= #0; PutInBuf (#13); END Else        { als Flag }

      If TagPos  ('<LI') Then
      BEGIN
        If ULType=#0 Then ULType:= #254;
        PutStrInBuf (#13+UlType+#32);
      END Else

      If TagPos  ('<HR') Then
      BEGIN
        tmp:= TagElement ('COLOR');
        If (tmp<>'') and (Konfig.ColMode='A') Then
        BEGIN
          c1:= ColNum (tmp);
          If (c1=BackCol) or ((BackCol>=14) and ((c1>=14) or (c1=10) or (c1=11)))
          Then dec (c1, 8);
        END Else If Konfig.ColMode='B' Then c1:=7 Else c1:= 255;
        If SinglePos ('NOSHADE') Then
        PutStrInBuf (#13#0#2+chr(c1)+#13) Else
        PutStrInBuf (#13#0#3+chr(c1)+#13);
      END Else

      If TagPos  ('<INPUT') Then
      BEGIN
        If LastLink<MaxLinks Then
        BEGIN
          tmp1:= Trim (tmp);   (* Fr Name und Value *)
          tmp:= TagElement ('TYPE');
          If tmp='RADIO' Then
          BEGIN
            inc (LastLink);
            If Singlepos ('CHECKED') Then
            LinkBuf[LastLink].Link:=#0#1#1#0 Else    { Letzte Null=FllByte }
            LinkBuf[LastLink].Link:=#0#1#0#0;
            PutStrInBuf (#0#7+chr(LastLink));
          END Else
          If tmp='CHECKBOX' Then
          BEGIN
            inc (LastLink);
            If SinglePos ('CHECKED') Then
            LinkBuf[LastLink].Link:=#0#2#1#0 Else
            LinkBuf[LastLink].Link:=#0#2#0#0;
            PutStrInBuf (#0#8+chr(LastLink));
          END Else
          If (tmp='TEXT') or (tmp='') Then
          BEGIN
            inc (LastLink);
            LinkBuf[LastLink].Link:=
            #0#3+chr(NewVal(TagElement('SIZE')))+chr(NewVal(TagElement('MAXLENGTH')));
            PutStrInBuf (#0#9+chr(LastLink));
          END Else
          If tmp='FILE' Then
          BEGIN
            inc (LastLink);
            LinkBuf[LastLink].Link:= 
            #0#4+chr(NewVal(TagElement('SIZE')))+chr(NewVal(TagElement('MAXLENGTH')));
            PutStrInBuf (#0#10+chr(LastLink));
          END Else
          If tmp='PASSWORD' Then
          BEGIN
            inc (LastLink);
            LinkBuf[LastLink].Link:=
            #0#5+chr(NewVal(TagElement('SIZE')))+chr(NewVal(TagElement('MAXLENGTH')));
            PutStrInBuf (#0#11+chr(LastLink));
          END Else
          If (tmp='BUTTON') or (Tmp='SUBMIT') or (Tmp='RESET') Then
          BEGIN
            inc (LastLink);
            LinkBuf[LastLink].Link:=#0#6#0#0+LowStr(TagElement ('CLICK'))+#255;
            PutStrInBuf (#0#12+chr(LastLink));
            Goto Over;
          END Else Goto Over1; { falls type = HIDDEN o.. }

          tmp:= TagElement('NAME');
          If tmp<>'' Then tmp:=Trim(copy(tmp1, TagAn, TagEn-1));
          LinkBuf[LastLink].Link:=LinkBuf[LastLink].Link+tmp+#255; {EndeMarke Name}
          Over:

          tmp:= TagElement('VALUE');
          If tmp<>'' Then tmp:=copy(tmp1, TagAn, TagEn-1);
          LinkBuf[LastLink].Link:=LinkBuf[LastLink].Link+tmp+#254; {EndeMarke Name}
          Over1:
        END;
      END Else
      If TagPos  ('<IMG') Then
      BEGIN
        tmp1:= Trim (tmp);   (* Fr Name und Value *)
        tmp:= TagElement ('ALT');
        If tmp='' Then tmp:= 'i' Else tmp:=copy(tmp1, TagAn, TagEn-1);
        PutStrInBuf ('['+tmp+']');
      END Else
      If HeadPos ('<H') Then
      BEGIN
        IsHead:= TRUE;
      END Else
      If HeadPos ('</H') Then
      BEGIN
        IsHead:= False;
        PutStrInBuf (#13#13);
      END Else
      (* #13 mu frei bleiben, da es sonst als Zeilenvorschub gesehen werden knnte *)
      If TagPos ('<NOPRINT')  Then PutStrInBuf (#0#14#2) Else
      If TagPos ('</NOPRINT') Then PutStrInBuf (#0#14#1) Else
      If TagPos  ('<FRAME') Then
      BEGIN
        If LastLink<MaxLinks Then
        BEGIN
          IsAnker:= FALSE;
          inc (LastLink);
          tmp:=TagElement ('SRC');
          tmp:= Trim(copy(OrigTag, TagAn, TagEn-1));
          LinkBuf[LastLink].Link:= BuildLink (FileName, tmp);
          If not IsFrame Then PutStrInBuf (#13'Frameset:'#13);
          PutStrInBuf (#0#4+chr(LastLink)+LowStr(LinkBuf[LastLink].Link)+#0#6+chr(TextAttr)+#13);
          IsFrame:= TRUE;
        END;
      END Else
      If TagPos ('<TEXTAREA') Then
      BEGIN
        If LastLink<MaxLinks Then
        BEGIN
          inc (LastLink);
          LinkBuf[LastLink].Link:=
          #0#3+chr(NewVal(TagElement('COLS')))+chr(EditMaxLen);
          PutStrInBuf (#0#9+chr(LastLink));
          tmp1:= trim(tmp);
          tmp:= TagElement('NAME');
          If tmp<>'' Then tmp:=Trim(copy(tmp1, TagAn, TagEn-1));
          LinkBuf[LastLink].Link:=LinkBuf[LastLink].Link+tmp+#255; {EndeMarke Name}
          isTextArea:= TRUE;

          LinkBuf[LastLink].Link:=LinkBuf[LastLink].Link+#254;
          { EndeMarke vorsichtshalber setzen }
        END;
      END Else
      If TagPos ('</TEXTAREA') Then
      BEGIN
        If LinkBuf[LastLink].Link[Length(LinkBuf[LastLink].Link)]=#254 Then
        dec (LinkBuf[LastLink].Link[0]);
        { EndeMarke wieder lschen }
        LinkBuf[LastLink].Link:=LinkBuf[LastLink].Link+copy(AreaText, 1, EditMaxLen)+#254; {EndeMarke Name}
        AreaText:='';
        IsTextArea:= FALSE;
      END Else
      If TagPos ('<META') Then
      BEGIN
        tmp:=  TagElement ('CONTENT');
        tmp1:= TagElement ('HTTP-EQUIV');
        If tmp1 = 'CONTENT-TYPE' Then
        BEGIN
          If (pos ('CHARSET', tmp) <> 0) and (IniKon<>'3') Then
          BEGIN
            If ((pos ('WINDOWS-1252', tmp) <>0)
            or  (pos ('ISO-8859-1',   tmp) <>0)) Then kon:= '1' Else
            If  (pos ('MACROMAN',     tmp) <>0)  Then kon:= '2' Else
            If  (pos ('US-ASCII',     tmp) <>0)  Then kon:= '0';
            If (Kon<>IniKon) and (kon<>'0') Then
            For x:= 1 To Length(Title) Do
            If Title[x]>#127 Then Title[x]:= KonChar (Title[x]);
          END;
        END Else
        If tmp1 = 'REFRESH' Then
        BEGIN
          tmp1:= trim(nthField (tmp, ';', 1));
          tmp := trim(nthField (tmp, ';', 2));
          If (pos ('URL', tmp)=1) and (pos ('=', tmp)<>0) Then
          With Refresh Do
          BEGIN
            url:= BuildLink(FileName, trim(nthField (tmp, '=', 2)));
            sec:= IntVal (tmp1);
            act:= Seconds;
          END;
        END;
      END;
    END Else
    BEGIN
      If isTextArea Then
      BEGIN if Length(AreaText)<EditMaxLen Then CharAdd(AreaText, c); END Else
      BEGIN
        If  (c=' ') and (not Teletyper)
        and ((Counter>0) and ((TxtBuf(Counter-1)=' ') or (TxtBuf(Counter-1)=#13))) Then Else
        BEGIN If IsHead Then c:= UpChar(c); PutInBuf (c); END;
      END;
      If (Counter and 1023=1023) and (DataSize(Dev)>0) Then
      FortschrittsBalken (24, 25, DataPos (Dev), DataSize (Dev));
    END;
  END;
  Ende:
  CloseDev (Dev); InOutRes:= 0;

  x:= 0;
  For i:= 1 To Counter Do
  BEGIN
    inc (x);
    If  TxtBuf(i)=#13 Then
    BEGIN
      If (i+1<Counter) and (TxtBuf(i+1)=#13) and (TxtBuf(i+2)=#13) and (x<77) Then SetBuf(i, ' ') Else
      x:= 0;
    END Else
    If  TxtBuf(i)=#0  Then
    BEGIN
      dec (x, 1);
      If TxtBuf(i+1)=#5 Then {Anker-Namen berspringen}
      BEGIN inc (i); While (TxtBuf(i)<>#255) and (i<Counter) Do inc (i); END Else
      inc (i, 2);
    END;
    If  x>77 Then
    BEGIN
      j:= i;
      While ((x>0) and (j>0) and (TxtBuf(j)<>' ')) or (x>77) Do
      BEGIN dec (j); dec (x); END;
      If x>0 Then 
      BEGIN SetBuf(j, #13); i:= j; x:= 0; END Else SetBuf(i, #13);
    END;
  END;

  If (Konfig.ColMode='A') or (Konfig.ColMode='C') Then
  BEGIN TextAttr:= nWhite shl 4; END Else
  BEGIN TextAttr:= 7;    END;
  TextBack (BackCol);

END;



PROCEDURE ShowText;
VAR
  x, y, z  : Byte;
  i        : Word;
  HRFlag   : Char;
  LCol     : Byte;
  Check    : String[3];
  ValFlag  : Boolean;
  PassWord : Boolean;
  ActLink  : Byte;

LABEL
  Ende;
BEGIN
  i:= FirstChar;
  While (i>0) and ((TxtBuf(i)<>#0) or (TxtBuf(i+1)<>#1)) Do dec (i);
  If (TxtBuf(i)=#0) and (TxtBuf(i+1)=#1) Then TextAttr:= ord(TxtBuf(i+2));
  HRFlag:= #0; ActLink:= 1; FLink:= 0; LLink:= 0;

  i:= FirstChar;
  For y:= 3 To 24 Do For x:= 2 To 79 Do
  BEGIN
    If i<Counter Then
    BEGIN
      While (TxtBuf(i)=#0) and (i<Counter) Do
      CASE TxtBuf(i+1) Of
        #1    : BEGIN
                  TextAttr:= ord(TxtBuf(i+2)); inc (i, 3);
                END;
        #2,#3 : BEGIN
                  z:=ord (TxtBuf(i+2)); If z=255 Then z:= 0;
                  HRFlag:= TxtBuf(i+1);
                  If HRFlag=#3 Then HRFlag:= '' Else HRFlag:='';
                  For x:= 2 To 78 Do CharXY (x, y, HRFlag, z, TextAttr shr 4);
                  inc (i, 3); inc (x);
                END;
        #4    : BEGIN
                  LCol:= Link;
                  ActLink:= ord(TxtBuf(i+2));
                  If FLink = 0 Then FLink:= ActLink;
                  With LinkBuf[ActLink] Do
                  BEGIN x1:= x; y1:= y; END;
                  If InBesuchtListe (LinkBuf[ActLink].Link) Then LCol:= VLink;
                  TextColor (LCol); inc (i, 3);
                END;
        #5    : BEGIN inc (i); While (TxtBuf(i)<>#255) and (i<Counter) Do inc (i); inc (i); END;
        #6    : With LinkBuf[ActLink] Do
                BEGIN
                  x2 := x-1; y2 := y;
                  TextAttr:= ord(TxtBuf(i+2));
                  inc (i, 3);
                END;
        #7,#8 : BEGIN
                  ActLink:= ord(TxtBuf(i+2));
                  If FLink = 0 Then FLink:= ActLink;
                  If TxtBuf(i+1)=#7 Then Check:= '(+)' Else Check:= '[x]';
                  If LinkBuf[ActLink].Link[3]=#0 Then Check[2]:= ' ';
                  WriteXY (x, y, Check, TextAttr and $0F, TextAttr shr 4);
                  With LinkBuf[ActLink] Do
                  BEGIN x1:= x; x2:= x+2; y1:= y; y2:= y; END;
                  inc (i, 3); inc (x, 3);
                END;
  #9, #10, #11: BEGIN
                  Password:= (TxtBuf(i+1)=#11);
                  ActLink:= ord(TxtBuf(i+2));
                  If FLink = 0 Then FLink:= ActLink;
                  With LinkBuf[ActLink] Do
                  BEGIN
                    x1:= x;
                    x2:= x+ord(LinkBuf[ActLink].Link[3])-1;
                    If x2>78 Then
                    BEGIN dec (LinkBuf[ActLink].Link[3], x2-78); x2:= 78; END;
                    y1:= y; y2:= y;
                    z := pos (#255, LinkBuf[ActLink].Link); 
                    ValFlag:= FALSE;
                    For x:= x To x2 Do
                    BEGIN
                      inc (z);
                      If LinkBuf[ActLink].Link[z]=#254 Then ValFlag:= TRUE;
                      If ValFlag Then CharXY (x, y, ' ', 0, 7) Else
                      If Password Then
                      CharXY (x, y, '*', 0, 7) Else
                      CharXY (x, y, LinkBuf[ActLink].Link[z], 0, 7);
                    END;
                    If TxtBuf(i+1)=#10 Then BEGIN CharXY (x, y, #25, 14, 0); END;
                  END;
                  inc (x);
                  inc (i, 3);
                END;
        #12   : BEGIN
                  ActLink:= ord(TxtBuf(i+2));
                  If FLink = 0 Then FLink:= ActLink;
                  With LinkBuf[ActLink] Do
                  BEGIN
                    x1:= x;
                    z := pos (#255, LinkBuf[ActLink].Link); 
                    x2:= x+ord(Pos (#254, LinkBuf[ActLink].Link)-z-2);
                    y1:= y; y2:= y;
                    ValFlag:= FALSE;
                    For x:= x1 To x2 Do
                    BEGIN
                      inc (z);
                      If Konfig.ColMode<>'B' Then
                      CharXY (x, y, LinkBuf[ActLink].Link[z], 14, 1) Else
                      CharXY (x, y, LinkBuf[ActLink].Link[z],  0, 7);
                    END;
                  END;
                  inc (x);
                  inc (i, 3);
                END;
        Else inc (i, 3); { auch bei <NOPRINT> = #14 }
      END;

      If TxtBuf(i)=#13 Then
      BEGIN
        If y<24 Then
        BEGIN
          For x:= x To 79 Do CharXY (x, y, ' ', 0, TextAttr shr 4);
          If HRFlag<>#0 Then BEGIN CharXY (79, y, HRFlag, z, TextAttr shr 4); HRFlag:= #0; END;
          inc (i);
        END
        Else Goto Ende;
      END Else

      BEGIN
        If (FirstChar=0) and (x=2) and (y=3) and (TxtBuf(i)=' ') Then dec (x) Else
        CharXY (x, y, TxtBuf(i), TextAttr and $0F, TextAttr shr 4);
        inc (i);
      END;

    END Else
    BEGIN
      Ende:
      CharXY (x, y, ' ', 0, TextAttr shr 4);
      If HRFlag<>#0 Then BEGIN CharXY (79, y, HRFlag, z, TextAttr shr 4); HRFlag:= #0; END;
    END;
  END;
  LLink:= ActLink;
END;


PROCEDURE IncLine;
BEGIN
  While (FirstChar<Counter) and ((TxtBuf(FirstChar)<>#13)
  or   ((TxtBuf(FirstChar-2) =#0 )))  do inc (FirstChar);
  If TxtBuf(FirstChar)=#13 Then inc (FirstChar);
END;


PROCEDURE DecLine;
BEGIN
  If  (TxtBuf(FirstChar-1)=#13) and (FirstChar>0) Then dec (FirstChar);
  While (FirstChar>0) and ((TxtBuf(FirstChar-1)<>#13)
  or   ((FirstChar>3) and  (TxtBuf(FirstChar-3) =#0 ))) Do dec (FirstChar);
END;


PROCEDURE SaveFileAs;
VAR
  SaveName : String;
  f        : Device;
  c        : Char;
  OutBuf   : Array[1..2048] of Char;

BEGIN
  SaveName:= DateiManager ('Datei speichern unter...');
  If SaveName= '' Then BEGIN CloseDev(Dev); Exit; END;

  AssignFile (f, SaveName);
  OpenDev    (f, DevOutput);
  SetFileBuf (f, OutBuf, SizeOf (OutBuf));
  If IOResult<>0 Then
  BEGIN
    ErrorMsg ('Erzeugen der Zieldatei fehlgeschlagen'); CloseDev (Dev);
    Exit;
  END;

  GotoXY (1, 25); { Blindencursor, fr Sehende momentan unsichtbar }
  Fusszeile ('Datei wird gespeichert');

  While (not EndOfFile (Dev)) and (InOutRes=0) Do
  BEGIN
    ReadChar  (Dev, c);
    WriteChar (f, c);
    If (DataPos(Dev) and 1023=1023) and (DataSize(Dev)>0) Then
    FortschrittsBalken (24, 25, DataPos(Dev), DataSize (Dev));
  END;

  If IOResult<>0 Then
  ErrorMsg ('Speichern der Datei fehlgeschlagen');

  CloseDev (f);
  CloseDev (Dev);
END;


{---------------------------- Browser ---------------------------------}

BEGIN
  GetBufMem;
  GetBesuchtListeMem;

  ReadKonfig;

  GetDir (0, OldPath);

  FileName:= ParamStr (1);
  If FileName='' Then
  BEGIN
    FileName:= BuildPath (ProgPath, 'INDEX.HTM');
    If FileExist (FileName)=Fil Then
    FileName:= DOSToUNIXPath (FileName) Else
    FileName:= DOSToUNIXPath (OldPath);  { abschaltbar fr leere Seite machen ?? }
  END Else
  If FileName='/?' Then
  FileName:= DOSToUNIXPath (BuildPath (ProgPath, 'HILFE.HTM')) Else
  BEGIN
    If OldPath[Length(OldPath)]<>'\' Then CharAdd (OldPath, '\');
    FileName:= BuildLink (OldPath, FileName);
  END;
  MouseInit; VGAColorOn;
  InitScreen;
  IsHistLink:= FALSE;
  Home:= FileName;
  FirstChar:= 0;
  Href:= FileName;

ReadNew:
  TabPos:= 0; FPos:= 0; t1:=#0; t2:=#0;
  Refresh.sec:= 65535; { = kein Refresh }

  Fusszeile ('Dokument wird geladen');

  SplitURL (FileName, ActURL);
  Anker:= ActURL.Anker;

  AssignDev (Dev, FileName);
  If ServerError=302 Then
  BEGIN
    CharAdd(ActURL.Path, '/');
    FileName:= AddURL (ActURL);
    AssignDev (Dev, FileName);
  END;
  OpenDev (Dev, DevInput);

  If pos ('text/', MIMEType) = 1 Then
  BEGIN
    Counter:= 0;
    ReadFile (FileName);
    PutInBesuchtListe (Href); PutInHist (Href);
    (* HRef:= FileName;    { Das mu noch geklrt werden } *)
  END Else
  BEGIN
    SaveFileAs;
  END;

  If (ServerError<>0) and (Konfig.Beep) Then
  BEGIN Sound (440); xDelay (140); NoSound; END;

  InitTitle;

AnkerSeek:
  If HPos>Counter Then HPos:=Counter;
  FirstChar:= HPos; 
  If Anker<>'' Then SeekAnker;

  If onLoad Then BEGIN onLoad:= False; HRef:= LoadBef; Goto Check; END;

  REPEAT
    ShowText;

    If TabPos<FLink Then TabPos:= FLink Else
    If TabPos>LLink Then TabPos:= LLink;
    If (TabPos=0) or (FLink=0) or ((KeyStatus and 67<>0) and (t2<>SHIFT_TAB))
    Then GotoXY (1, 3) Else
    BEGIN
      If TextInput (TabPos) Then
      BEGIN
        StringEditor (TabPos);
        If FileManFlag Then Goto Ende;
        If kn=0 Then Goto Tasten Else Goto IsMouse;
      END Else
      GotoXY (LinkBuf[TabPos].x1, LinkBuf[TabPos].y1);
    END;

    GetKey;

    If Refresh.sec=0 Then
    BEGIN HRef:= Refresh.url; Goto Check1; END;

    If kn<>0 Then
    BEGIN
      IsMouse:
      If MouseIn (2, 3, 79, 24) Then
      BEGIN
        If FLink<>0 Then
        For x:= FLink To LLink Do
        If MouseInLink (x) Then
        BEGIN
          MouseWait;
          HRef:= LinkBuf[x].Link;

          Check1:
          If HRef='' Then Goto Ende;

          SplitURL (Href, NewURL);
          If (NewURL.Anker<>'') and (URLsEqual (NewURL, ActURL)) Then
          BEGIN
            { wird nicht ausgefhrt, wenn der Anker zwar in der selben }
            { Datei liegt, aber die Query-Strings sich unterscheiden }
            Anker:= NewURL.Anker;
            { PutInHist (Href); erzwingt momentan ein Neuladen der Datei }
            PutInBesuchtListe (Href);
            Goto AnkerSeek;
          END;

          If HRef[1]<>#0 Then
          BEGIN
            Check:
            If HRef='' Then Goto Ende;
            If Length (GetProtocol(Href)) <> 0 Then
            BEGIN
              If (KeyStatus and (LShift or RShift) = 0) Then
              BEGIN
                FileName:= HRef;
                Goto ReadNew;
              END Else
              BEGIN
                Speichern:
                PutInBesuchtListe (Href);
                AssignDev (Dev, Href);
                If ServerError=302 Then
                BEGIN
                  SplitURL (HRef, NewURL);
                  CharAdd(NewURL.Path, '/');
                  HRef:= AddURL (NewURL);
                  AssignDev (Dev, HRef);
                END;
                OpenDev (Dev, DevInput);
                SaveFileAs;
                Goto Ende;
              END;
            END Else
            BEGIN
              PutInBesuchtListe (Href);
              CommandLine (HRef);
              If HRef<>'' Then Goto Check1 Else Goto Ende;
            END;
          END Else
          BEGIN
            TabPos:= x;
            CASE HRef[2] Of
            #1 : BEGIN
                   For z:= 1 To LastLink Do
                   If (LinkBuf[z].Link[1]=#0) and (LinkBuf[z].Link[2]=#1) and
                   (UpStr(copy (LinkBuf[z].Link, 5, pos (#255, LinkBuf[z].Link)-5))=
                    UpStr(copy (HRef, 5, pos (#255, HRef)-5))) Then LinkBuf[z].Link[3]:=#0;
                   LinkBuf[x].Link[3]:= #1;
                 END;
            #2 : BEGIN
                   If HRef[3]=#1 Then LinkBuf[x].Link[3]:=#0 Else LinkBuf[x].Link[3]:= #1;
                 END;
      #3,#4,#5 : BEGIN StringEditor (x); Goto Tasten; END;
            #6 : BEGIN
                   HRef:= UpStr(copy(LinkBuf[x].Link, 5, pos (#255, LinkBuf[x].Link)-5));
                   Goto Check;
                 END;
            END;
            Goto Ende;
          END;
        END;
      END Else
      If MouseIn ( 1,  2,  3,  2) Then BEGIN MouseWait; t2:= CTRL_Left END Else
      If MouseIn ( 5,  2,  7,  2) Then BEGIN MouseWait; t2:= CTRL_Rght END Else
      If MouseIn ( 9,  2, 11,  2) Then BEGIN MouseWait; t2:= CTRL_Pos1 END Else
      If MouseIn (13,  2, 15,  2) Then BEGIN MouseWait; t2:= ALTI      END Else
      If MouseIn (17,  2, 19,  2) Then BEGIN MouseWait; t2:= ALTO      END Else
      If MouseIn (21,  2, 23,  2) Then BEGIN MouseWait; t2:= ALTS      END Else
      If MouseIn (25,  2, 27,  2) Then BEGIN MouseWait; t2:= ALTB      END Else
      If MouseIn (29,  2, 31,  2) Then BEGIN MouseWait; t2:= ALTP      END Else
      If MouseIn (33,  2, 35,  2) Then BEGIN MouseWait; t2:= ALTV      END Else
      If MouseIn (37,  2, 39,  2) Then BEGIN MouseWait; t1:= #27       END Else
      If MouseIn (75,  2, 77,  2) Then BEGIN MouseWait; t2:= F1        END Else
      If MouseIn (79,  2, 80,  2) Then BEGIN If kn=1 Then xDelay (70); t2:= Up;   END Else
      If MouseIn (79, 25, 80, 25) Then BEGIN If kn=1 Then xDelay (70); t2:= Down; END Else
      If MouseIn (1,   1, 80,  1) Then BEGIN MouseWait; t2:= ALTT      END Else
    END;

    Tasten:
    If t1=#0 Then
    CASE t2 Of
      (*F2   : BEGIN
               For x:= 1 To ListEnd Do WriteXY (1, x, '#'+Besuchtliste[x], 0, 7);
               WaitKey;
             END;*)
      F1   : BEGIN
               FileName:= DOSToUnixPath(BuildPath (ProgPath, HelpFile));
               Goto ReadNew;
             END;
      F4   : BEGIN
               IsClip:= TRUE;
               PrintFile (BuildPath (TempPath, ClipFile));
               IsClip:= FALSE;
             END;
      Up   : DecLine;
      Down : IncLine;
      PgUp : For x:= 3 To 23 Do DecLine;
      PgDn : For x:= 3 To 23 Do IncLine;
      Pos1 : FirstChar:= 0;

      Endx : BEGIN FirstChar:= Counter; For x:= 3 To 23 Do DecLine; END;

      Ctrl_Pos1 : If (Home<>'') and (Home<>FileName) Then
                  BEGIN
                    HistPtr:= 1; HRef:=Home; 
                    HPos:= HistBuf[HistPtr].HPos;
                    IsHistLink:=TRUE;
                    Goto Check;
                  END Else HPos:= 0;
      Ctrl_Rght : If HistPtr<HistEnd Then
                  BEGIN
                    HistoryForward(1);
                    Goto Check;
                  END Else HPos:= 0;
      Ctrl_Left : If HistPtr>1 Then BEGIN HistoryBack(1); Goto Check; END;
      Shift_TAB,
      CTRL_PgUp : BEGIN
                    If TabPos>FLink Then dec (TabPos) Else
                    If (TabPos=FLink) and (FLink>0) Then
                    BEGIN
                      If TabPos=1 Then
                      BEGIN
                        While (FirstChar<Counter) and (LLink<LastLink) Do
                        BEGIN IncLine; ShowText; END;
                        TabPos:= LLink;
                      END Else
                      If LastLink>1 Then
                      BEGIN
                        TmpLink:= FLink;
                        While (FirstChar>0) and ((FLink=TmpLink) or (FLink=0)) Do
                        BEGIN DecLine; ShowText; END;
                        dec (TabPos);
                      END;
                    END;
                  END;
      ALTI : BEGIN
               FileName:= DOSToUNIXPath (BuildPath (ProgPath, IndexFile));
               Goto ReadNew;
             END;
      ALTS : BEGIN
               FileName:= DOSToUNIXPath (BuildPath (ProgPath, SearchFile));
               Goto ReadNew;
             END;
      ALTO : BEGIN
               HRef:= DateiManager ('Dokument ffnen');
               If HRef<>'' Then
               BEGIN
                 HRef:= DOSToUNIXPath (Href);
                 If Href<>FileName Then
                 BEGIN FileName:= HRef; Goto Check; END;
               END;
             END;
      ALTT : BEGIN HeadFlag:= not HeadFlag; WriteHead; END;
      ALTB : AppendBookMark;
      ALTP : PrintFile('');
      ALTV : BEGIN HRef:= FileName; Goto Speichern; END;  (* aktuelle Datei speichern *)
      AltX : t1:= #27;
      CTRL_PgDn : Goto Tabul;
    END Else
    CASE t1 Of
      TAB  : BEGIN
               Tabul:
               If TabPos<LLink Then inc (TabPos) Else
               If TabPos<LastLink Then
               BEGIN
                 tmpLink:= LLink;
                 While (FirstChar<Counter) and (tmpLink=LLink) Do
                 BEGIN IncLine; ShowText; END;
                 inc (TabPos);
               END Else
               If LastLink>1 Then
               BEGIN
                 While (FirstChar>0) and (FLink<>1) Do
                 BEGIN DecLine; ShowText; END;
                 TabPos:= 1;
               END;
             END;
      #13  : BEGIN HRef:= LinkBuf[TabPos].Link; x:= TabPos; Goto Check1; END;
      #27  : ;
      Else   If TextInput (TabPos) Then BEGIN StringEditor (TabPos); Goto Tasten; END;
 
    END;
    Ende:
  UNTIL (t1=#27);

  VGAColorOff; Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
END.

{ Achtung: Compiler-Direktive "browser" setzen !! }


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
