UNIT Brow_cmd;

INTERFACE
USES
  bro_tool, strings, BiosCrt, brow_var, mouse, dos, monitor, Bro_list,
  Bro_Heap, Bro_Java, IO_Tools, Brow_Url, DeviceIO, Fil_IO, Dev_IO,
  Brow_win;


PROCEDURE CommandLine (ein : String);
PROCEDURE AppendBookMark;
PROCEDURE PrintFile (Ziel : PathStr);
PROCEDURE ReadKonfig;

CONST
  FPos   : LongInt = 0;
  IsClip : Boolean = FALSE;


IMPLEMENTATION
VAR
  AppResult : Word;


FUNCTION GetValue (x : Byte) : String;
VAR
  p1, p2 : Byte;
BEGIN
  p1:= pos (#255, LinkBuf[x].Link);
  p2:= pos (#254, LinkBuf[x].Link);
  If (p1<>0) and (p2<>0) and (p2>p1+1) Then
  GetValue:=copy (LinkBuf[x].Link, p1+1, p2-p1-1) Else
  GetValue:= '';
END;


FUNCTION FormString (TrennChar : Char) : String;
VAR
  x, p1, p2 : Byte;
  tmp       : String;
BEGIN
  tmp:='';
  For x:= 1 To LastLink Do
  If (LinkBuf[x].Link[1]=#0) and (LinkBuf[x].Link[2]<=#5) Then
  BEGIN
    If ((LinkBuf[x].Link[2]=#1) or (LinkBuf[x].Link[2]=#2)) Then
    BEGIN
      If (LinkBuf[x].Link[3]=#1) Then { Kontrollfeld aktiviert }
      tmp:= tmp+TrennChar+GetValue(x) Else
      If TrennChar<>' ' Then tmp:= tmp+TrennChar;
    END Else
    If TextInput(x) Then tmp:= tmp+Trennchar+GetValue(x);
  END;
  FormString:= copy (tmp, 2, 255);
END;


PROCEDURE Clear;
VAR
  x : Byte;
BEGIN
  For x:= 1 To LastLink Do
  BEGIN
    If (LinkBuf[x].Link[1]=#0) and (LinkBuf[x].Link[2]<=#5) Then
    BEGIN
      If TextInput(x) Then
      BEGIN
        LinkBuf[x].Link[0]:= chr(pos (#255, LinkBuf[x].Link));
        LinkBuf[x].Link:= LinkBuf[x].Link + #254;
      END Else
      If (LinkBuf[x].Link[2]=#1) or (LinkBuf[x].Link[2]=#2) Then
      LinkBuf[x].Link[3]:=#0;
    END;
  END;
END;


PROCEDURE Load (Name : String; Line : LongInt);
VAR
  nBuf      : Array[1..10240] Of Byte;
  f         : Device;
  tmp, tmp1 : String;
  Num       : LongInt;
  x, p      : Byte;
  count, cf : Byte;
LABEL
  Ende, Ende1;
BEGIN
  Fusszeile ('Lade Datensatz...');
  If FPos<=0 Then FPos:= 1;

  AssignDev  (f, Name);
  If ServerError<>0 Then Exit;
  SetFileBuf (f, nBuf, SizeOf(nBuf));
  OpenDev    (f, DevInput);
  If IOResult<>0 Then Exit;

  For Num:= 1 To Line Do
  BEGIN
    ReadLine (f, tmp);
    If IOResult<>0 Then BEGIN ErrorMsg ('Lesefehler in Datei'); Goto Ende END;
    If EndofFile (f) Then BEGIN FPos:= Num; Goto Ende1 END;
  END;
  Ende1:

  Count:= 0;
  cf:= CountFields (tmp, ';');
  For x:= 1 To LastLink Do
  BEGIN
    If (LinkBuf[x].Link[1]=#0) and (LinkBuf[x].Link[2]<=#5) Then
    BEGIN
      inc (Count);
      If Count>cf Then Goto Ende;
      tmp1:= nthField (tmp, ';', Count);
      If TextInput(x) Then
      BEGIN
        LinkBuf[x].Link[0]:= chr(pos (#255, LinkBuf[x].Link));
        LinkBuf[x].Link:= LinkBuf[x].Link + tmp1 + #254;
        LinkBuf[x].Link[Length(LinkBuf[x].Link)]:= #254; (*falls tmp1 zu lang war*)
      END Else
      If (LinkBuf[x].Link[2]=#1) or (LinkBuf[x].Link[2]=#2) Then
      BEGIN
        If UpStr(GetValue (x))= UpStr (tmp1) Then
        LinkBuf[x].Link[3]:=#1 Else LinkBuf[x].Link[3]:=#0;
        (*=checked*)
      END;
    END;
  END;
Ende:
  CloseDev (f); InOutRes:= 0;
END;


PROCEDURE AppendStr (Name, Line : String);
VAR
  f : Device;
BEGIN
  AssignDev (f, Name);
  If ServerError<>0 Then
  BEGIN
    AssignFile (f, ASCIIZtoPascal (f.Name));
    OpenDev   (f, DevOutput);
  END Else
  BEGIN
    SetFileAttr (f, 32);
    OpenDev (f, DevAppend);
  END;
  WriteLine (f, Line);
  CloseDev (f);
  AppResult:= IOResult;
  If AppResult<>0 Then ErrorMsg ('Fehler beim Schreiben in Datei');
END;


PROCEDURE AppendBookMark;
VAR
  f : Device;
BEGIN
  AssignDev (f, BuildPath (ProgPath, BookMarkFile));
  If ServerError<>0 Then
  AppendStr (BuildPath (ProgPath, BookMarkFile),
  '<TITLE>Lesezeichen/Favoriten</TITLE><BODY><BR>'#13#10'<FONT COLOR="teal">'+
  'Lesezeichen/Favoriten</FONT>'#13#10'<HR noshade color="silver">'#13#10);
  AppendStr (BuildPath (ProgPath, BookMarkFile),
  '<A HREF="'+LowStr(FileName)+'">'+Title+'</A><BR>')
END;


PROCEDURE AppendForm (Name : String);
BEGIN
  AppendStr (Name, FormString (';'));
  If AppResult=0 Then BEGIN FPos:= MaxLongInt; Load (Name, FPos); END;
END;


PROCEDURE Del_Ins (Name : String; Modus : Byte);
VAR
  f1, f2     : Device;
  buf1, buf2 : Array[1..10240] Of Byte;
  tmp        : String;
  p          : LongInt;
  Result     : Word;

BEGIN
  AssignDev (f1, Name);

  CASE Modus Of
    0 : BEGIN
          If ServerError<>0 Then
          BEGIN ErrorMsg ('Datenbank nicht gefunden'); Exit; END;
          Fusszeile ('Lsche Datensatz...');
        END;
    1 : BEGIN
          Fusszeile ('Speichere Datensatz...');
          If ServerError<>0 Then
          BEGIN
            AppendForm (Name);
            Exit;
          END;
        END;
  END;

  If FPos<=0 Then FPos:= 1;

  tmp:= ChangeFileExt (ASCIIZtoPascal (f1.Name), 'TMP');
  RenameFile (f1, tmp);

  If IOResult<>0 Then
  BEGIN
    AssignFile (f2, tmp); SetFileAttr (f2, 32); EraseFile (f2);
    RenameFile (f1, tmp);
  END;

  OpenDev   (f1, DevInput);
  If IOResult<>0 Then
  BEGIN ErrorMsg ('Datenbankzugriff fehlgeschlagen'); Exit; END;

  AssignDev (f2, Name);
  If ServerError<>0 Then AssignFile (f2, ASCIIZtoPascal(f2.Name));
  OpenDev   (f2, DevOutput);
  If IOResult<>0 Then
  BEGIN ErrorMsg ('Datenbankzugriff fehlgeschlagen'); CloseDev (f1); Exit; END;

  p:= 0; Result:=0;
  SetFileBuf (f1, Buf1, SizeOf(Buf1));
  SetFileBuf (f2, Buf2, SizeOf(Buf2));
  While (not EndofFile (f1)) and (Result=0) Do
  BEGIN
    inc (p);
    ReadLine (f1, tmp);
    If p=FPos Then
    BEGIN
      If Modus=1 Then WriteLine (f2, FormString(';'));
    END Else
    WriteLine (f2, tmp);
    Result:= IOResult;
  END;
  CloseDev (f1);
  CloseDev (f2); Result:= IOResult;
  If Result=0 Then EraseFile (f1);
  Load (Name, FPos);
END;    


PROCEDURE Execute (Befehl : String);
VAR
  OldDir : PathStr;
BEGIN
  GetDir (0, OldDir);
  ChDir (ActDir);
  InOutRes:= 0;
  SwapVectors;
  Exec (GetEnv('COMSPEC'), '/C '+Befehl);
  SwapVectors;
  ChDir (OldDir);
  InOutRes:= 0;
END;


PROCEDURE ExecMsg (Txt : String);
BEGIN
  CharXY  (1,  25, ' ',  0, 7);
  WriteXY (79, 25, '  ', 0, 7);
  Massege (Txt);
END;


FUNCTION nVal (ein : String) : LongInt;
VAR
  c : Integer;
  l : LongInt;
BEGIN
  ein:= UpStr(ein);
  If ein='NEXT' Then BEGIN inc (FPos); nVal:= FPos; END Else
  If ein='PREV' Then BEGIN If FPos>1 Then dec (FPos); nVal:= FPos; END Else
  If ein='LAST' Then BEGIN FPos:= MaxLongInt; nVal:= FPos; END Else
  If ein='FIRST'Then BEGIN FPos:= 1; nVal:= FPos; END Else
  BEGIN
    Val (ein, l, c); If c<>0 Then l:= 0 Else FPos:= l;
    nVal:= l;
  END;
END;


PROCEDURE CommandLine (ein : String);
VAR
  x       : Byte;
  tmp     : String;
  OldAttr : Byte;
  InitFlag: Boolean;
  Num     : LongInt;
  Command : String;
  OrigCmd : String;


PROCEDURE DeInit;
BEGIN
  If InitFlag Then Exit;
  InitFlag:= TRUE;
  OldAttr:= TextAttr;
  Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
  VGAColorOff;
  OutStr ('Befehl wird ausgefhrt...'#13#10);
END;


PROCEDURE ReInit;
BEGIN
  If not InitFlag Then Exit;
  TextAttr:= OldAttr;
  VGAColorOn;
  InitScreen;
  InitTitle;
END;


BEGIN
  HRef:= ''; InitFlag:= FALSE;
 
  If UpStr (copy (ein, 1, 11))='JAVASCRIPT:' Then
  BEGIN
    (*MsgBox ('JavaScript wird nicht untersttzt');
    Exit;*)
    PrintMe:= FALSE;
    ExecJavaScriptLine (copy(ein, 12, 255));
    If PrintMe Then PrintFile ('');
  END
  Else
  For x:= 1 To CountFields (ein, ';') Do
  BEGIN
    tmp:= trim (nthField (ein, ';', x));
    Command:= UpStr(nthField (tmp, ':', 1));
    OrigCmd:= tmp;
    tmp:= trim (copy (tmp, Length (Command)+2, 255));

    If Command = 'START' Then
    BEGIN
      DeInit; Execute (tmp);
    END Else
    If Command = 'EXEC' Then
    BEGIN
      DeInit;
      If pos (' ', tmp)<>0 Then { z.B. falls Programmausgabe umgeleitet werden soll }
      BEGIN
        Insert (' '+FormString (' '), tmp, pos (' ', tmp));
        Execute (tmp);
      END Else
      Execute (tmp+' '+FormString (' '));
    END Else
    If Command = 'HELP' Then
    BEGIN
      PutInBesuchtListe (OrigCmd);
      If not IsHistLink Then PutInHist (FileName) Else
      If HistPtr<HistEnd Then inc (HistPtr); IsHistLink:=FALSE;
      If Konfig.OrigHelp<>'' Then
      BEGIN
        DeInit;
        Execute (Konfig.OrigHelp+' '+tmp);
      END Else
      BEGIN
        HRef:= DOStoUNIXPath(BuildPath (ProgPath, 'HILFE\OLDDOS\'+tmp+'.HTM'));
      END;
    END Else
    If Command = 'WAIT' Then ExecMsg ('Weiter mit beliebiger Taste') Else
    If Command = 'HREF' Then
    BEGIN
      PutInbesuchtliste (OrigCmd);
      HRef:= BuildLink (FileName, tmp);
    END Else
    If Command = 'BACK' Then BEGIN If HistPtr>1 Then HistoryBack(1) END Else
    If Command = 'READ' Then
    BEGIN
      If pos (',', tmp) > 1 Then
      Num:= nVal(Trim(nthField(tmp, ',', 2))) else Num:= 1;
      Load (BuildLink(FileName, Trim(nthField(tmp, ',', 1))), Num);
    END Else
    If Command = 'APPEND' Then AppendForm (BuildLink(FileName, tmp))    Else
    If Command = 'ERASE'  Then del_ins    (BuildLink(FileName, tmp), 0) Else
    If Command = 'WRITE'  Then del_ins    (BuildLink(FileName, tmp), 1) Else
    If Command = 'PRINT'  Then PrintFile  (BuildLink(FileName, tmp))    Else
    If Command = 'INIT'   Then BEGIN ReadKonfig; DeInit; END            Else
    If Command = 'CLEAR'  Then Clear                                    Else
    BEGIN HRef:=''; Exit; END;
  END;
  ReInit;
END;



PROCEDURE PrintFile (Ziel : PathStr);
VAR
  Check    : String[3];
  x, x1,
  x2, y, z : Word;
  Password : Boolean;
  ValFlag  : Boolean;
  ActLink  : Byte;
  NoPrint  : Boolean;
  f        : Device;


PROCEDURE PushChr (ch : Char);
BEGIN
  If not NoPrint Then WriteChar (f, ch);
END;


BEGIN
  NoPrint:= FALSE;
  If Ziel=''  Then Ziel:= Konfig.Printer;
  If Ziel<>'' Then
  BEGIN
    AssignDev (f, Ziel);
    If ServerError<>0 Then AssignFile (f, ASCIIZtoPascal (f.Name));
    OpenDev   (f, DevOutput);
    If IOResult<>0 Then
    BEGIN ErrorMsg ('Fehler beim Schreiben nach Gert/Datei '+Ziel); Exit; END;
    x:= 0;
    While x<=Counter Do
    BEGIN
      If TxtBuf(x)=#0 Then
      BEGIN
        CASE TxtBuf(x+1) Of
          #5 : BEGIN
                 inc (x, 2);
                 While (TxtBuf(x)<>#255) and (x<Counter) Do inc (x); inc (x);
               END;
       #2,#3 : BEGIN
                 inc (x, 3);
                 For y:= 1 To 75 Do PushChr ('-');
               END;
       #7,#8 : BEGIN
                 If TxtBuf(x+1)=#7 Then Check:= '(+)' Else Check:= '[x]';
                 If LinkBuf[ord(TxtBuf(x+2))].Link[3]=#0 Then Check[2]:= ' ';
                 For y:= 1 To Length (Check) Do PushChr (Check[y]);
                 inc (x, 3);
               END;
  #9,#10,#11 : BEGIN
                 Password:= (TxtBuf(x+1)=#11);
                 ActLink := ord(TxtBuf(x+2));
                 x2:= ord(LinkBuf[ActLink].Link[3])-1;
                 If x2>75 Then x2:= 75;
                 z := pos (#255, LinkBuf[ActLink].Link);
                 ValFlag:= FALSE;
                 For x1:= 1 To x2 Do
                 BEGIN
                   inc (z);
                   If LinkBuf[ActLink].Link[z]=#254 Then ValFlag:= TRUE;
                   If ValFlag  Then PushChr (' ') Else
                   If Password Then PushChr ('*') Else
                   PushChr (LinkBuf[ActLink].Link[z]);
                 END;
                 inc (x, 3);
               END;
         #14 : BEGIN If not IsClip Then NoPrint:= Boolean (ord (TxtBuf(x+2))-1); inc (x, 3); END;
         Else  inc (x, 3);
        END;
      END Else
      BEGIN
        PushChr (TxtBuf(x));
        If TxtBuf(x)=#13 Then PushChr (#10);
        inc (x);
      END;
    END;
    If not IsClip Then WriteChar (f, #12);
    CloseDev (f);
  END Else
  ErrorMsg ('Ausgabegert/Datei nicht angegeben.');
END;


PROCEDURE ReadKonfig;
VAR
  f     : Device;
  s, s1 : String;
  x     : Byte;
BEGIN
  AssignDev (f, BuildPath (ProgPath, IniName));
  If ServerError<>0 then Exit;
  OpenDev   (f, DevInput);
  If IOResult<>0 Then Exit;
  ReadLine  (f, s);
  CloseDev  (f);
  If IOResult<>0 Then Exit;

  With Konfig Do
  For x:= 1 To CountFields (s, ';') Do
  BEGIN
    s1:= nthField (s, ';', x);
    CASE x Of
      1     : OrigHelp:= s1;
      2..4  : If s1 <>'' Then ColMode:=upchar(s1[1]);
      5     : IsLCD   := s1<>'';
      6     : Beep    := s1<>'';
      7     : Printer := s1;
      8..11 : If s1 <>'' Then IniKon:= s1[1];
    END;
  END;
END;

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
