UNIT Brow_URL;

INTERFACE
USES
  Strings, DOS, BiosCrt;
TYPE
  TURLRec = RECORD
              Protocol : String[10];
              Domain   : String;
              Path     : String;
              Anker    : String;
              Query    : String;
            END;

FUNCTION  BuildLink     (ActFile, RelPath  : String)  : String;
FUNCTION  GetProtocol   (Path    : String) : String;

PROCEDURE SplitURL      (InPath  : String; VAR URLRec : TURLRec);
FUNCTION  AddURL        (URLRec  : TUrlRec) : String;
FUNCTION  URLsEqual  (URL1, URL2 : TURLRec) : Boolean;
FUNCTION  FilesEqual (URL1, URL2 : TURLRec) : Boolean;

FUNCTION  DOSToUnixPath (DOSPath : String) : String;

PROCEDURE FindLFNFile   (VAR Path : String; VAR sr : SearchRec);

IMPLEMENTATION


FUNCTION VollURL (Pfad, Datei: String) : String; assembler;
ASM
  push ds; cld; les di, @Result; mov dh, '/'
  lds si, Pfad;
  lodsb; stosb; mov dl, al; xor ah, ah; mov cx, ax; jcxz @1
  rep movsB;
  dec si; lodsB; cmp al, dh; je @1
  mov al, dh; stosb; inc dl;
@1:
  lds si, Datei;
  lodsW; mov bx, ax; xor ah, ah; mov cx, ax; jcxz @2
  cmp bh, dh; jne @3; dec cx; dec bl; jmp @4;
@3:
  dec si
@4:
  rep movsb;
  add dl, bl; mov al, dl; les di, @Result; stosb;
@2:
  pop ds
END;
{ Verbindet Pfad- und Dateinamen zu einem vollstndigen Pfadnamen }


FUNCTION GetProtocol (Path : String) : String;
VAR
  p : Byte;
BEGIN
  p:= pos ('://', Path);
  If p<>0 Then inc (p, 2);
  GetProtocol:= copy (Path, 1, p);
END;


FUNCTION GetDomain (Path : String) : String;
VAR
  p : Byte;
BEGIN
  p:= 1;
  While (p<Length(Path)) and (Path[p]='/')  Do inc (p);
  While (p<Length(Path)) and (Path[p]<>'/') Do inc (p);
  Path:= copy (Path, 1, p);
  If Path[Length(Path)]='/' Then dec (Path[0]);
  GetDomain:= Path;
END;


FUNCTION DelPunkte (Path : String) : String;
VAR
  x, c   : Byte;
  s, ret : String;
BEGIN
  ret:='';
  c:= CountFields (Path, '/');
  For x:= 1 To c Do
  BEGIN
    s:= nthField (Path, '/', x);
    If (s<>'.') and (s<>'') Then
    If Length(ret)=0 Then ret:= s Else ret:= ret+'/'+s;
  END;
  DelPunkte:= ret;
END;
{ lscht auch fhrende und anhngende Slashes }


FUNCTION DelDoppelpunkte (Path : String) : String;
VAR
  p : Byte;
  s : String;
BEGIN
  p:= pos ('..', Path);
  While p>1 Do
  BEGIN
    s:= copy (Path, 1, p-2);
    Delete (Path, 1, p+2);
    p:= LastPos ('/', s); If p<>0 Then dec (p);
    s:= copy (s, 1, p);
    Path:= VollURL (s, Path);
    p:= pos ('..', Path);
  END;
  DelDoppelpunkte:= Path;
END;
{ Entrelativiert ... Wenn fhrende .. brigbleiben, dann Pfadfehler }


PROCEDURE TurnSlashes (VAR s : String);
VAR
  x : Byte;
BEGIN
  For x:= 1 To Length(s) Do If s[x]='\' Then s[x]:='/';
END;


FUNCTION DOSToUnixPath (DOSPath : String) : String;
VAR
  p, c : Byte;
BEGIN
  TurnSlashes (DOSPath);
  c:= Length (GetProtocol(DOSPath));
  If c=0 Then
  BEGIN
    p:= pos (':', DOSPath);
    If p<>0 Then DOSPath[p]:='|';
    If pos ('/', DOSPath)=1 Then
    DosToUnixPath:='file://' + DOSPath Else
    DosToUnixPath:='file:///'+ DOSPath;
  END
  Else
  BEGIN
    p:= pos (':', copy (DOSPath, c, 255));
    If p<>0 Then DOSPath[p+c-1]:= '|';
    DosToUnixPath:=DOSPath;
  END;
END;


FUNCTION GetDirName (Path : String) : String;
VAR
  p : Byte;
BEGIN
  p:= pos ('?', Path);
  If p<>0 Then Delete (Path, p, 255);
  While (Length(Path)>0) and (Path[Length(Path)]<>'/') do dec (Path[0]);
  GetDirName:= Path;
END;
{ Achtung: Der Browser mu darauf achten, da ein anhngendes Backslash
  vorhanden ist, wenn die aktuelle Datei ein Ordner ist }


FUNCTION IsAbsPath (Path : String) : Boolean;
VAR
  p : Byte;
BEGIN
  p:= pos ('?', Path);
  If p<>0 Then Delete (Path, p, 255);
  p:= pos (':', Path);
  If p=0 Then p:= pos ('|', Path);
  IsAbsPath:= (p<>0);
END;


FUNCTION AbsPath (ActPath, RelPath : String) : String;
VAR
  x, c, p   : Byte;
  isRoot    : Boolean;
  isAnker   : Boolean;
  Protocol  : String[10];
  Root      : String;
  Query     : String;
  LastSlash : String[1];

BEGIN
  p:= pos ('?', RelPath);
  If p<>0 Then
  BEGIN
    Query:= copy (RelPath, p, 255);
    Delete (RelPath, p, 255);
  END Else Query:= '';

  TurnSlashes (RelPath);

  ActPath:= DOSToUNIXPath (ActPath);
  isAnker:= pos ('#', RelPath) = 1;
  If not IsAnker Then ActPath:= (GetDirName(ActPath));

  isRoot:= pos ('/', RelPath)=1;

  If (RelPath[Length(RelPath)]='/')
  or (LastPos('..', RelPath)+1=Length(RelPath))
  or (LastPos('/.', RelPath)+1=Length(RelPath))
  Then LastSlash:= '/' Else LastSlash:= '';

  RelPath:= DelPunkte (RelPath);

  Protocol:= GetProtocol (ActPath);
  Delete (ActPath, 1, Length(Protocol));

  Root:= GetDomain (ActPath);
  Delete (ActPath, 1, Length(Root));

  If not isRoot Then
  BEGIN
    If not isAnker Then
    RelPath:= VollURL (ActPath, RelPath) Else
    RelPath:= ActPath+RelPath;
  END;
  RelPath:= DelDoppelpunkte (RelPath);

  If pos ('..', RelPath)<>0 Then AbsPath:= '' Else
  BEGIN
    ActPath:= Protocol+VollURL (Root, RelPath)+LastSlash;
    If LastPos ('//', ActPath)+1 = Length (ActPath) Then dec(ActPath[0]);
    AbsPath:= ActPath+Query;
  END;
END;


FUNCTION BuildLink (ActFile, RelPath : String) : String;
VAR
  URL : TURLRec;
  p   : Byte;
BEGIN
  p:= pos ('?', ActFile);
  If p<>0 Then Delete (ActFile, p, 255);
  p:= pos ('#', ActFile);
  If p<>0 Then Delete (ActFile, p, 255);

  If IsAbsPath (RelPath) Then
  BEGIN
    If pos (':', RelPath)<=3 Then
    RelPath:= DOSToUNIXPath (RelPath) (* zur Info: Else BuildLink:= RelPath; *)
  END Else
  RelPath:= AbsPath (ActFile, RelPath);

  If (RelPath[Length(RelPath)]<>'/') and (Length(GetProtocol(RelPath))<>0) Then
  BEGIN
    SplitURL (RelPath, URL);
    With URL Do If Path='' Then Path:='/';
    BuildLink:= AddURL (URL);
  END Else
  BuildLink:= RelPath;
END;


PROCEDURE SplitURL (InPath : String; VAR URLRec : TURLRec);
VAR
  p : Byte;
BEGIN
  With URLRec Do
  BEGIN
    Protocol:= LowStr(GetProtocol (InPath));
    Delete (InPath, 1, Length (Protocol));
    Domain:= GetDomain (InPath);
    Delete (InPath, 1, Length (Domain));

    p:= pos ('?', InPath);
    If p<>0 Then
    BEGIN
      Query:= copy (InPath, p, 255);
      Delete (InPath, p, 255);
    END Else Query:= '';

    p:= pos ('#', InPath);
    If p<>0 Then
    BEGIN
      Anker:= copy (InPath, p, 255);
      Delete (InPath, p, 255);
    END Else Anker:= '';

    Path:= InPath;
  END;
END;


FUNCTION AddURL (URLRec : TUrlRec) : String;
BEGIN
  With URLRec Do
  AddURL:= Protocol+Domain+Path+Anker+Query;
END;


FUNCTION URLsEqual (URL1, URL2 : TURLRec) : Boolean;
BEGIN
  URL1.Anker:= '';
  URL2.Anker:= '';
  URLsEqual := AddURL (URL1) = AddURL (URL2);
END;


FUNCTION FilesEqual (URL1, URL2 : TURLRec) : Boolean;
BEGIN
  URL1.Query:= '';
  URL2.Query:= '';
  FilesEqual:= URLsEqual (URL1, URL2);
END;


FUNCTION ShortPath (Path : String) : String;
VAR
  x, p,
  i, c    : Byte;
  s, Tok  : String;
  Ext     : String[4]; { braucht nicht lnger, da ab 4. Zeichen sowieso weg }
  ToLong  : Boolean;
BEGIN
  s:= nthField (Path, '\', 1);
  For x:= 2 To CountFields (Path, '\') Do
  BEGIN
    Tok:= nthField (Path, '\', x);

    c:= CountFields (Tok, '.');
    If c>=2 Then
    BEGIN
      ToLong:= c>2;
      If ToLong Then For i:= 3 To c Do Delete (Tok, pos ('.', Tok), 1);
      Ext:= nthField (Tok, '.', 2);
      Tok:= nthField (Tok, '.', 1);
      If Length (Ext) > 3 Then BEGIN ToLong:= TRUE; Ext[0]:= #3; END;
      If Length (Tok) > 8 Then BEGIN ToLong:= TRUE; Tok[0]:= #6; END;
      If ToLong Then
      BEGIN
        If Length (Tok) > 6 Then Tok[0]:= #6;
        Tok:= Tok+'~*';
      END;
      Tok:= Tok+'.'+Ext;
    END Else
    If Length(Tok)>8 Then
    BEGIN
      Tok[0]:= #6;
      Tok:= Tok+'~*'; { * als Platzhalter fr die Zahlen * }
    END;
    s:= s+'\'+Tok;
  END;
  ShortPath:= s;
END;


FUNCTION DOSPath (Path : String) : String;
VAR
  x      : Byte;
  s, Tok : String;
BEGIN
  s:= nthField (Path, '\', 1);
  For x:= 2 To CountFields (Path, '\') Do
  BEGIN
    Tok:= nthField (Path, '\', x);
    If pos ('.', Tok)<>0 Then
    Tok:= nthField (Tok, '.', 1)+'.'+copy (nthField (Tok, '.', 2), 1, 3);
    s:= s+'\'+Tok;
  END;
  DOSPath:= s;
END;


PROCEDURE FindLFNFile (VAR Path : String; VAR sr : SearchRec);
CONST
  NormalFile = AnyFile and not (VolumeID or Hidden);
VAR
  x, p  : Byte;
  s, s1 : String;
BEGIN
  If (Path[Length(Path)]='\') and (Length(Path)>3) Then dec (Path[0]);

  s:= DOSPath (Path);
  FindFirst (s, NormalFile, sr);
  If DOSError=0 Then BEGIN Path:= s; Exit; END;

  Path:= ShortPath (Path);
  If pos ('*', Path) = 0 Then FindFirst (Path, NormalFile, sr) Else
  BEGIN
    s:= nthField (Path, '\', 1);
    For x:= 2 To CountFields (Path, '\') Do
    BEGIN
      s:= s+'\'+nthField (Path, '\', x);
      p:= pos ('*', s);
      If p<>0 Then s[p]:= '1';
      FindFirst (s, NormalFile, sr);
      If (DOSError<>0) and (p=0) Then Exit;
      While (DOSError<>0) and (s[p]<='9') Do
      BEGIN
        FindFirst (s, NormalFile, sr);
        If DOSError<>0 Then inc (s[p]);
      END;
    END;
    Path:= s;
  END;
END;

{ da nicht rekursiv, nicht ganz so gut wie die alte Methode,
  vielleicht nochmal vorknpfen }

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
