UNIT brow_var;

INTERFACE

USES
  Monitor, BiosCrt, Mouse, dos, strings;

CONST
  HelpFile     = 'HILFE.HTM';
  IndexFile    = 'INDEX.HTM';
  SearchFile   = 'SUCHEN.HTM';
  IniName      = 'BROWSER.INI';
  BookMarkFile = 'BOOKMARK.HTM';

  MaxLinks     = 255;        { mehr als 255 sind z.Z. nicht mglich }
  IniKon       : Char = '0';
  EditMaxLen   = 128;

VAR
  FileName  : String;     { Name der Aktuellen Datei }
  Anker     : PathStr;    { Name des anzusteuernden Ankers }

  nDarkGray, nWhite, nLightgray, nBlack : Byte;

  Title     : String;
  LinkBuf   : Array[1..MaxLinks] Of RECORD
                                      Link           : String[EditMaxLen];
                                      x1, x2, y1, y2 : Byte;
                                    END;

  FirstChar : Word;  { Nr. des ersten auf dem Bildschirm auszugebenden Zeichens }

  BackCol   : Byte;  { Standardfarbe aus BODY-Tag (fr Rnder) }
  Link      : Byte;  { Standardfarben aus BODY-Tag }
  VLink     : Byte;
  LastLink  : Byte;
  TabPos    : Byte;  { Nummer des Links, auf dem der Cursor steht }

  FLink     : Byte;  { erster und letzter auf dem Monitor angezeigter }
  LLink     : Byte;  { Link }

  ProgPath  : PathStr;
  ActDir    : PathStr;
  OldPath   : PathStr;
  HRef      : String;  { aktueller Link, nicht PathStr nehmen ! }

  LoadBef   : String;  { enthlt den "Load"-Befehl }

  Refresh   : RECORD
                sec : Word;
                url : String;
                act : LongInt;   { Fr den CountDown }
              END;

CONST
  OnLoad    : Boolean = FALSE;     { gibt an, ob in <BODY> ein "Load" existiert}
  HeadFlag  : Boolean = FALSE;

  MaxHist   = 100; { nicht mehr als 255, da HistPtr und HistEnd : Byte }

VAR
  Home       : String;
  IsHistLink : Boolean; { gibt an, ob ein Link aus der Histliste aufgerufen wurde }
  HistBuf    : Array[1..MaxHist]  Of RECORD
                                       HLink : String[128];
                                       HPos  : Word;
                                     END;

  Konfig    : RECORD
                OrigHelp : PathStr;
                ColMode  : Char;
                IsLCD    : Boolean;
                Beep     : Boolean;
                Printer  : PathStr;
              END;

CONST
  HPos      : Word = 0;
  HistPtr   : Byte = 0;
  HistEnd   : Byte = 0;

IMPLEMENTATION
{$IFDEF SHARE1}
USES
  Bro_sper;
{$ENDIF}
USES
  Brow_URL;

BEGIN
  ProgPath:= ParamStr(0);
  While (Length(ProgPath)>0) and (ProgPath[Length(ProgPath)]<>'\') Do dec (ProgPath[0]);

  With Konfig Do
  BEGIN
    OrigHelp := 'HELP';
    ColMode  := 'A';
    IsLCD    := FALSE;
    Beep     := FALSE;
    Printer  := 'LPT1';
  END;

  If ScrMode=MonoMon Then
  BEGIN
    nDarkGray := Black;
    nLightGray:= Black;
    nWhite    := lightgray;
    nBlack    := white;
  END Else
  BEGIN
    nDarkGray := darkgray;
    nLightGray:= LightGray;
    nWhite    := white;
    nBlack    := Black;
  END;

  BackCol:= nWhite; Title:= ''; TextAttr:= 7;
  For Link:= 1 To MaxHist Do HistBuf[Link].HPos:= 65535;
     {^- Aufpassen}
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
