UNIT Bro_heap;

INTERFACE

CONST
  MaxChars : LongInt = 0;
  Counter  : LongInt = 0;   { enthlt momentane Zahl der Zeichen im Puffer }

PROCEDURE GetBufMem;
PROCEDURE FreeBufMem;
PROCEDURE PutInBuf (c : Char);
FUNCTION  TxtBuf   (Index : LongInt) : Char;
PROCEDURE SetBuf   (Index : LongInt; c : Char);
PROCEDURE FillBuf  (c : Char);


IMPLEMENTATION
CONST
  BufSize    = 65534;

TYPE
  TTextBuff  = Array[0..BufSize] Of Char;

CONST
  TextBuff   : ^TTextBuff = NIL;


PROCEDURE GetBufMem;
VAR
  x : LongInt;
BEGIN
  If TextBuff=NIL Then
  BEGIN
    x:= MaxAvail;
    If x>BufSize Then x:= BufSize;
    MaxChars:= x;
    GetMem (TextBuff, MaxChars);
  END;
END;


PROCEDURE FreeBufMem;
BEGIN
  If TextBuff<>NIL Then
  BEGIN
    FreeMem (TextBuff, MaxChars);
    TextBuff:= NIL;
  END;
END;


FUNCTION TxtBuf (Index : LongInt) : Char;
BEGIN
  TxtBuf:= TextBuff^[Index];
END;


PROCEDURE PutInBuf (c : Char);
BEGIN
  If Counter<=MaxChars Then
  BEGIN
    TextBuff^[Counter]:= c;
    inc (Counter);
  END;
END;


PROCEDURE SetBuf (Index : LongInt; c : Char);
BEGIN
  TextBuff^[Index]:= c;
END;


PROCEDURE FillBuf (c : Char);
BEGIN
  FillChar (TextBuff^, MaxChars, c);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
