UNIT Bro_Java;

INTERFACE
USES
  Strings, Bro_List, Brow_Var, Brow_win, BiosCrt;

VAR
  PrintMe : Boolean;


PROCEDURE ExecJavaScriptLine (Line : String);


IMPLEMENTATION

VAR
  JSLine : String;
  Break  : Boolean;
  Befehl : String;
  Params : String;
  Objekt : String;
  Error  : Boolean;


FUNCTION TilePos : Byte;
VAR
  p1, p2, p3 : Byte;
BEGIN
  p1:= pos ('(', JSLine);
  p2:= pos (' ', JSLine);

  If (p1= 0) and (p2=0) Then TilePos:= Length(JSLine) Else
  If (p2>p1) Then
  BEGIN If p1=0 Then TilePos:= p2-1 Else TilePos:= p1-1; END
  Else
  If (p1>p2) Then
  BEGIN If p2=0 Then TilePos:= p1-1 Else TilePos:= p2-1; END
END;


PROCEDURE ParseParams;
BEGIN
  If (Params[1]='''') and (Params[Length(Params)]='''') Then
  BEGIN
    dec (Params[0]);
    Delete (Params, 1, 1);
  END;
END;


PROCEDURE RunHistory;
VAR
  t : Integer;
BEGIN
  If Befehl='BACK'    Then BEGIN If HistPtr>1       Then HistoryBack(1)    END Else
  If Befehl='FORWARD' Then BEGIN If HistPtr<HistEnd Then HistoryForward(1) END Else
  If Befehl='GO'      Then
  BEGIN
    t:= IntVal (Params);
    If t>0 Then HistoryForward(t) Else
    If t<0 Then HistoryBack(abs(t));
  END Else
  Error:= TRUE;
END;


PROCEDURE ExecJSLine;
VAR
  p : Byte;
BEGIN
  Error:= FALSE;

  If JSLine[Length(JSLine)]=';' Then dec(JSLine[0]);
  p:= TilePos;
  Befehl:= UpStr(trim(copy (JSLine, 1, p)));
  Params:= trim (copy(JSLine, p+1, 255));

  If Length(Params)>0 Then
  BEGIN
    If (Params[1]='(') and (Params[Length(Params)]=')') Then
    BEGIN
      dec (Params[0]);
      Delete (Params, 1, 1);
    END;
    Params:= trim(Params);
    ParseParams;
  END;

  If pos ('WINDOW.',   Befehl)=1 Then Delete (Befehl, 1, 7) Else
  If pos ('SELF.'  ,   Befehl)=1 Then Delete (Befehl, 1, 5);
  If pos ('DOCUMENT.', Befehl)=1 Then Delete (Befehl, 1, 9);

  If Befehl='ALERT'  Then MsgBox (Params) Else
  If Befehl='RETURN' Then Break  := TRUE  Else
  If Befehl='PRINT'  Then PrintMe:= TRUE  Else
  BEGIN
    p:= pos ('.', Befehl);
    If p<>0 Then
    BEGIN
      Objekt:= nthField (Befehl, '.', 1);
      delete (Befehl, 1, p);
      If Objekt='HISTORY' Then RunHistory Else
      Error:= TRUE;
    END Else Error:= TRUE;
  END;
  If Error Then MsgBox ('JavaScript-Fehler: '+JSLine);
END;


PROCEDURE ExecJavaScriptLine (Line : String);
VAR
  x       : Byte;
  InQuots : Boolean;
BEGIN
  JSLine:= '';
  InQuots:= FALSE;
  Break:= FALSE;

  For x:= 1 To Length(Line) Do
  BEGIN
    CharAdd (JSLine, Line[x]);
    If Line[x]='''' Then InQuots:= not InQuots Else
    If ((not InQuots) and (Line[x]=';')) or (x>=Length(Line)) Then
    BEGIN
      ExecJSLine;
      If Break Then Exit;
      JSLine:= '';
    END;
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
