UNIT bro_list;

INTERFACE

USES
  Brow_var, Strings;


PROCEDURE PutInHist         (Name  : String);
PROCEDURE HistoryBack       (Count : Word);
PROCEDURE HistoryForward    (Count : Word);

PROCEDURE GetBesuchtlisteMem;
FUNCTION  InBesuchtListe    (ein : String) : Boolean;
PROCEDURE PutInBesuchtListe (ein : String);


IMPLEMENTATION

CONST
  Max     = 100;
  ListEnd : Byte = 0;
  ListPos : Byte = 0;

TYPE
  LinkStr       = String[128]; { SizeOf(LinkStr) mu gleichlang mit Link sein }
  TBesuchtListe = Array[1..Max] Of LinkStr;

CONST
  BesuchtListe  : ^TBesuchtListe = NIL;


PROCEDURE GetBesuchtlisteMem;
BEGIN
  If BesuchtListe=NIL Then
  GetMem (BesuchtListe, SizeOf (TBesuchtListe));
END;


PROCEDURE FreeBesuchtlisteMem;
BEGIN
  If BesuchtListe<>NIL Then
  BEGIN
    FreeMem (BesuchtListe, SizeOf (TBesuchtListe));
    Besuchtliste:= NIL;
  END;
END;


PROCEDURE PutInHist (Name : String);
BEGIN
  If not IsHistLink Then
  BEGIN
    HistBuf[HistPtr].HPos := FirstChar;
    If HistPtr<MaxHist Then inc (HistPtr) Else
    Move (HistBuf[2], HistBuf[1], SizeOf (HistBuf)-SizeOf (HistBuf[1]));
    HistEnd:= HistPtr;
    HistBuf[HistPtr].HLink:= Name;
    HistBuf[HistPtr].HPos := 0;
    HPos:= 0;
  END;
  IsHistLink:= FALSE;
END;


PROCEDURE HistoryForward (Count : Word);
BEGIN
  For Count:= Count DownTo 1 Do
  If HistPtr<HistEnd Then
  BEGIN
    inc (HistPtr);
    HRef:=HistBuf[HistPtr].HLink;
    HPos:=HistBuf[HistPtr].HPos;
    IsHistLink:=TRUE;
  END Else BEGIN HPos:= 0; END;
END;


PROCEDURE HistoryBack (Count : Word);
BEGIN
  For Count:= Count DownTo 1 Do
  If HistPtr>1 Then
  BEGIN
    dec (HistPtr);
    HRef:=HistBuf[HistPtr].HLink;
    HPos:=HistBuf[HistPtr].HPos;
    IsHistLink:=TRUE;
  END Else BEGIN HPos:= 0; END;
END;


FUNCTION InBesuchtListe (ein : String) : Boolean;
VAR
  x, p : Byte;
BEGIN
  ein:= LowStr(ein);
  InBesuchtListe:= TRUE;
  For x:= 1 To ListEnd Do
  BEGIN
    If ein=BesuchtListe^[x] Then Exit;
    p:= pos ('#', BesuchtListe^[x]);
    If  (p<>0) and (p>pos ('\', ein))
    and (ein=copy (BesuchtListe^[x], 1, p-1)) Then Exit;
  END;
  InBesuchtListe:= FALSE;
END;
{ Prft, ob die Datei "ein" schon in der Besucht-Liste enthalten ist, ob
  sie also schon einmal besucht wurde }



PROCEDURE PutInBesuchtListe (ein : String);
BEGIN
  If not InBesuchtListe (ein) Then
  BEGIN
    If ListEnd<Max Then inc (ListEnd);
    If ListPos<ListEnd Then inc (ListPos) Else ListPos:= 1; 
    BesuchtListe^[ListPos]:= LowStr(ein);
  END;
END;
{ Fgt eine Datei zur Besuchtliste hinzu, wenn sie noch nicht
  darin enthalten ist. Die Besuchtliste ist ein Ringpuffer. }



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
