UNIT Bro_tool;

INTERFACE
USES
  BiosCrt, Strings, Mouse, Monitor, Brow_Var, Time, DOS, Bro_Heap, KeyCode;

PROCEDURE TextBack (Color : Byte);
FUNCTION  CenterText (ein : String) : String;
PROCEDURE GetKey;
PROCEDURE GetKey1;
PROCEDURE Fortschrittsbalken (x, y : Byte; ActWert, EndWert : LongInt);
PROCEDURE Fusszeile    (Txt  : String);
FUNCTION  ColNum       (ein  : String) : Byte;
PROCEDURE InitScreen;
PROCEDURE WriteHead;
PROCEDURE InitTitle;
FUNCTION  FileExist    (Name : String) : Byte;
PROCEDURE Massege      (Txt  : String);
PROCEDURE ErrorMsg     (Txt  : String);
FUNCTION  NewVal       (ein  : String) : Byte;
PROCEDURE SeekAnker;
FUNCTION  MouseInLink  (x : Byte) : Boolean;
FUNCTION  TextInPut    (x : Word) : Boolean;


CONST
  NormStatus = 'F1 Hilfe';

  Fil = 1; { Objekt ist eine Datei }
  Dir = 2; { Objekt ist ein Verzeichnis }


IMPLEMENTATION
VAR
  TextFound : Boolean;

PROCEDURE TextBack (Color : Byte); assembler;
ASM
  mov ah, Color
  {$IFOPT G+}
    shl ah, 4
  {$ELSE}
    mov cl, 4
    shl ah, cl
  {$ENDIF}
  mov al, TextAttr
  and al, 00001111B   {BlinkBit bleibt stehen}
  add al, ah
  mov TextAttr, al 
END;


FUNCTION CenterText (ein : String) : String;
BEGIN
  Delete (ein, 78, 255);
  Insert (FillString (39-Length(ein) shr 1), ein, 1);
  CenterText:= ein+FillString (79-Length(ein));
END;


PROCEDURE Fortschrittsbalken (x, y : Byte; ActWert, EndWert : LongInt);
VAR
  pp      : Byte;
  BalkLen : LongInt;
CONST
  MaxLen = 20;
BEGIN
  BalkLen:= ActWert*MaxLen DIV EndWert;
  If BalkLen>MaxLen Then BalkLen:= MaxLen;
  For pp:= 1 To MaxLen Do
  If pp>BalkLen Then
  CharXY (x+pp, y, #254, nWhite, nLightGray) Else
  CharXY (x+pp, y, #254, nBlack, nLightGray);
END;


PROCEDURE Fusszeile (Txt : String);
VAR
  v, h : Byte;
BEGIN
  If Konfig.IsLCD Then
  BEGIN v:=lightgray; h:= black;      END Else
  BEGIN v:=nBlack;    h:= nLightgray; END;
  If Length (Txt)>77 Then Txt[0]:= #77;
  WriteXY (2, 25, Txt+FillString(77-Length(Txt)), v, h);
END;


PROCEDURE CheckMousePos (a, b, c, d : Byte; Txt : String; Modus : Byte);
BEGIN
  If (not TextFound) and (MouseIn (a, b, c, d)) Then
  BEGIN
    CASE Modus Of
      1 : If HistPtr>1       Then Txt:= Txt+': '+LowStr (HistBuf[HistPtr-1].HLink);
      2 : If HistPtr<HistEnd Then Txt:= Txt+': '+LowStr (HistBuf[HistPtr+1].HLink);
      3 : If Length(Home)<>0 Then Txt:= Txt+': '+LowStr (Home);
    END;
    Fusszeile (Txt);
    TextFound:= TRUE;
  END;
END;


PROCEDURE GetKey;
VAR
  tmp : String;
  x   : Byte;
BEGIN
  t1:= #0; t2:=#0; kn:= 0;
  MouseOn;
  REPEAT

    With Refresh Do
    If (sec<>65535) and (sec>0) and (Seconds<>act) then
    BEGIN
      dec (sec);
      act:= Seconds;
    END;

    MouseGet;
    If (kn=0) and (MouseExist) Then
    BEGIN
      TextFound:= False;
      CheckMousePos (  1, 1, 80, 1, 'Umschalten: Titel <--> Dateiname', 0);
      CheckMousePos (  1, 2,  3, 2, 'Zurck', 1);
      CheckMousePos (  5, 2,  7, 2, 'Vor', 2);
      CheckMousePos (  9, 2, 11, 2, 'Home', 3);
      CheckMousePos ( 13, 2, 15, 2, 'Zum Hilfe-Index', 0);
      CheckMousePos ( 17, 2, 19, 2, 'Datei ffnen', 0);
      CheckMousePos ( 21, 2, 23, 2, 'Datei suchen', 0);
      CheckMousePos ( 25, 2, 27, 2, 'Dokument zu Lesezeichen hinzufgen', 0);
      CheckMousePos ( 29, 2, 31, 2, 'Dokument drucken', 0);
      CheckMousePos ( 33, 2, 35, 2, 'Dokument speichern unter...', 0);
      CheckMousePos ( 37, 2, 39, 2, 'Browser beenden', 0);
      CheckMousePos ( 75, 2, 77, 2, 'Hilfe zum Browser', 0);
      If not TextFound Then
      BEGIN
        If (MouseIn (2, 3, 79, 24)) and (FLink<>0) Then
        BEGIN
          For x:= FLink To LLink Do
          If (MouseInLink (x)) and (not TextFound) Then
          BEGIN
            TextFound:= TRUE;
            If LinkBuf[x].Link[1]=#0 Then
            Fusszeile (copy (LinkBuf[x].Link, 5, pos (#255, LinkBuf[x].Link)-5)) Else
            Fusszeile (LowStr(LinkBuf[x].Link));
          END;
        END;
        If not TextFound Then Fusszeile(NormStatus);
      END;
    END;
  UNTIL (kn<>0) or (KeyPressed) or (Refresh.sec=0);
  MouseOff;
  If KeyPressed Then ScanKeys;
END;


PROCEDURE GetKey1;
BEGIN
  t1:= #0; t2:=#0; kn:= 0;
  MouseOn;
  REPEAT
    MouseGet;
  UNTIL (kn<>0) or (KeyPressed);
  MouseOff;
  If KeyPressed Then Scankeys;
END;


CONST
  Colors = 18;

  Cols = 'BLACK;MAROON;GREEN;OLIVE;NAVY;PURPLE;TEAL;GRAY;SILVER;RED;'+
         'LIME;YELLOW;BLUE;FUCHSIA;AQUA;WHITE;CYAN;BROWN';

  ColNums : Array[1..Colors] Of Byte =
  (black, red, green, cyan, blue, magenta, cyan, darkgray, lightgray,
   lightred, lightgreen, yellow, blue, lightmagenta, lightblue, white,
   lightcyan, brown);


FUNCTION ColNum (ein : String) : Byte;
VAR
  c       : Integer;
  l       : LongInt;
  xx      : Array[0..3] of Byte absolute l;
  r, g, b : Byte;
  col     : Byte;

BEGIN
  If ein[1]='#' Then
  BEGIN
    ein[1]:='$';
    Val (ein, l, c); If c <> 0 Then BEGIN ColNum:= nWhite; Exit; END;
    CASE xx[2] Of
       0..63  : r:= 0;
      64..191 : r:= 4;
     191..255 : r:= 12;
    END;
    CASE xx[1] Of
       0..63  : g:= 0;
      64..191 : g:= 2;
     191..255 : g:= 10;
    END;
    CASE xx[0] Of
       0..63  : b:= 0;
      64..191 : b:= 1;
     191..255 : b:= 9;
    END;
    col:= r or g or b;
    If (r+g+b=0) and (xx[2]>31) and (xx[1]>31) and (xx[0]>31) Then col:= col or 8;
    ColNum:= Col;
  END Else
  BEGIN
    For r:= 1 To Colors Do
    If ein=nthField (Cols, ';', r) Then
    BEGIN ColNum:= ColNums[r]; Exit; END;
    ColNum:= 255;                                    (*Error*)
  END;
END;



PROCEDURE InitScreen;
VAR
  OldAttr : Byte;
  v, h    : Byte;
BEGIN
  OldAttr:= TextAttr;
  Window (1, 1, 80, 25);
  GotoXY (1,  1); TextBack (ndarkgray);  ClrEol;
  If Konfig.IsLCD Then BEGIN v:=lightgray; h:= black; END Else BEGIN v:=nBlack; h:= nLightgray; END;
  GotoXY (1,  2); TextBack (h); ClrEol;
  WriteXY (2, 2, #27'  '#26'  '#127'  i  o  s  b  p  v  x ', v, h);
  WriteXY (74, 2, ' ? ', v, h);
  CharXY (80, 2, #24, yellow, h);
  GotoXY (1, 25); ClrEol;
  CharXY (80, 25, #25, yellow, h);
  TextAttr:= OldAttr;
END;


PROCEDURE WriteHead;
BEGIN
  If not HeadFlag Then
  WriteXY (2, 1, CenterText(Title), yellow, nDarkGray) Else
  WriteXY (2, 1, CenterText(LowStr(FileName)), yellow, nDarkGray);
END;


PROCEDURE InitTitle;
BEGIN
  Window (1, 3, 80, 24);
  TextBack (BackCol); ClrScr;
  WriteHead;
  Window (1, 1, 80, 25);
END;


FUNCTION FileExist (Name : String) : Byte;
VAR
  sr : SearchRec;
BEGIN
  If (Length(Name)<=3) and (pos (':', Name)=2) Then
  BEGIN
    If Length(Name)=2    Then Name:= Fexpand (Name) Else
    If pos ('\', Name)=3 Then BEGIN FileExist:=Dir; Exit; END;
  END;
  FindFirst (Name, anyfile, sr);
  If DOSError<>0 Then FileExist:= 0 Else
  If sr.attr and directory = 0 Then Fileexist:= Fil Else Fileexist:= Dir;
END;


PROCEDURE Massege (Txt : String);
VAR
  OldX, OldY : Byte; 
BEGIN
  OldX:= WhereX; OldY:= WhereY;
  GotoXY (1, 25);
  Fusszeile (Txt);
  GetKey1;
  MouseWait;
  GotoXY (OldX, OldY);
  t1:= #0; t2:= #0;
END;


PROCEDURE ErrorMsg (Txt : String);
BEGIN
  If Konfig.Beep Then BEGIN Sound (440); xDelay (140); NoSound; END;
  Massege (Txt+'. Weiter mit Taste.');
END;


FUNCTION NewVal (ein : String) : Byte;
VAR
  l : LongInt;
  c : Integer;
BEGIN
  Val (ein, l, c);
  If (c<>0) or (l>77) or (l<=0) Then l:= 77;
  NewVal:= Byte (l);
END;


PROCEDURE SeekAnker;
VAR
  x, y : Word;
  tmp  : PathStr;
BEGIN
  For x:= 0 To Counter Do
  If (TxtBuf(x)=#0) and (TxtBuf(x+1)=#5) Then
  BEGIN
    tmp:= '#'; y:= x+2;
    While (TxtBuf(y)<>#255) and (Length(Tmp)<SizeOf (PathStr)-1) Do
    BEGIN CharAdd (tmp, TxtBuf(y)); inc (y); END;
    If LowStr (tmp) = LowStr(Anker) Then
    BEGIN
      While (x>0) and (TxtBuf(x-1)<>#13) Do dec (x);
      FirstChar:= x; Anker:= ''; Exit;
    END;
  END;
  Anker:= '';
END;


FUNCTION MouseInLink (x : Byte) : Boolean;
BEGIN
  MouseInLink:= FALSE; If x=0 Then Exit;
  If LinkBuf[x].y1=LinkBuf[x].y2 Then
  BEGIN
    If MouseIn (LinkBuf[x].x1, LinkBuf[x].y1, LinkBuf[x].x2, LinkBuf[x].y1) Then
    MouseInLink:= TRUE;
  END Else
  If (MouseIn (LinkBuf[x].x1,    LinkBuf[x].y1, 78, LinkBuf[x].y1))
  or (MouseIn (2, LinkBuf[x].y2, LinkBuf[x].x2,     LinkBuf[x].y2))
  Then MouseInLink:= TRUE;
END;


FUNCTION TextInPut (x : Word) : Boolean;
BEGIN
  TextInPut:= (LinkBuf[x].Link[1] =#0)
         and  (LinkBuf[x].Link[2]>=#3)
         and  (LinkBuf[x].Link[2]<=#5);
END;


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
