UNIT Buf_IO;

INTERFACE
USES
  Strings, DeviceIO;

PROCEDURE AssignBuf (VAR f : Device; Path : String);

IMPLEMENTATION

TYPE
  VirtualFile = RECORD
                  VBufSize : Word;
                  VBufEnd  : Word; { = FileSize }
                  VBufPos  : Word; { = FilePos  }
                  VBuffer  : Array[0..1023] Of Char;
                END;

VAR
  VFile : VirtualFile;


FUNCTION ReadFile (VAR f : Device) : Integer; far;
BEGIN
  With f, VFile Do
  BEGIN
    ReadFile:= 0;
    While (BufEnd<BufSize) and (VBufPos<VBufEnd) Do
    BEGIN
      BufPtr^[BufEnd]:= VBuffer[VBufPos];
      inc (BufEnd);
      inc (VBufPos);
    END;
  END;
END;


FUNCTION WriteFile (VAR f : Device) : Integer; far;
VAR
  x : Word;
LABEL
  Ende;
BEGIN
  With f, VFile Do
  BEGIN
    WriteFile:= 0;
    For x:= 1 To BufPos Do
    BEGIN
      If VBufEnd<VBufSize Then
      BEGIN
        VBuffer[VBufEnd]:= BufPtr^[x-1];
        inc (VBufEnd);
      END Else
      BEGIN
        WriteFile:= 5;  { Access denied = Datentrger voll }
        Goto Ende;
      END;
    END;
    Ende:
    FileEnd:= VBufEnd;
  END;
END;


FUNCTION FlushInput (VAR f : Device) : Integer; far;
BEGIN
 { Dummy, wird eigentlich berhaupt nicht gebraucht, sollte aber
   erstmal drin bleiben, z.B. fr sptere Erweiterungen o.. }
  FlushInput:= 0;
END;


FUNCTION OpenFile (VAR f : Device) : Integer; far;
BEGIN
  With f, VFile Do
  BEGIN
    VBufPos  := 0;
    VBufSize := SizeOf (VBuffer);
    CASE Mode Of
      DevInput  : BEGIN
                    FileEnd   := VBufEnd;
                    InOutFunc := @ReadFile;
                    FlushFunc := @FlushInput;
                    OpenFile  := 0;
                  END;
      DevOutput : BEGIN
                    FileEnd   := 0;
                    VBufEnd   := 0;
                    InOutFunc := @WriteFile;
                    FlushFunc := @WriteFile;
                    OpenFile  := 0;
                  END;
      Else        OpenFile:= 5;
    END;
  END;
END;


FUNCTION CloseFile (VAR f : Device) : Integer; far;
BEGIN
  CloseFile:= 0;
END;


PROCEDURE AssignBuf (VAR f : Device; Path : String);
BEGIN
  With f Do
  BEGIN
    Mode      := DevClosed;
    BufSize   := SizeOf(Buffer);
    BufPtr    := @Buffer;
    OpenFunc  := @OpenFile;
    CloseFunc := @CloseFile;
    PascalToASCIIZ (Path, Name, SizeOf (Name));
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
