UNIT DeviceIO;

INTERFACE
USES BiosCRT, Strings;

TYPE
  DevBuf = Array [0..127] Of Char;
  Device = RECORD
             Handle    : Word;
             BufSize   : Word;
             BufPtr    : ^DevBuf;
             BufEnd    : Word;
             BufPos    : Word;
             Mode      : Word;
             OpenFunc  : Pointer;
             InOutFunc : Pointer;
             FlushFunc : Pointer;
             CloseFunc : Pointer;
             FilePtr   : LongInt;  { = FilePos  (f) }
             FileEnd   : LongInt;  { = FileSize (f) }
             UserData  : Array [1..10] Of Byte;
             Name      : Array [0..79] Of Char;
             Buffer    : DevBuf;
           END;


PROCEDURE OpenDev     (VAR f : Device; OpenMode : Word);
PROCEDURE ReadChar    (VAR f : Device; VAR c : Char);
PROCEDURE ReadLine    (VAR f : Device; VAR s : String);
FUNCTION  NextChar    (VAR f : Device)   : Char;
PROCEDURE WriteChar   (VAR f : Device; c : Char);
PROCEDURE WriteString (VAR f : Device; s : String);
PROCEDURE WriteLine   (VAR f : Device; s : String);
PROCEDURE CloseDev    (VAR f : Device);

PROCEDURE SetFileBuf  (VAR f : Device; VAR Buf; Size : Word);

FUNCTION  EndOfFile   (VAR f : Device) : Boolean;
FUNCTION  DataSize    (VAR f : Device) : LongInt;
FUNCTION  DataPos     (VAR f : Device) : LongInt;

CONST
  DevClosed  = $D7B0;     { Werte entsprechen fmClosed usw. }
  DevInput   = $D7B1;
  DevOutput  = $D7B2;
  DevInOut   = $D7B3;     { Momentan nicht verwendet }
  DevAppend  = $D7B4;

  BinFile    = 0;
  TextFile   = 1;
  DataMode   : Byte = BinFile;

  DevMode    : Byte = 0;  { ffnen nur zum Lesen (Pascal-FileMode: 2) }


IMPLEMENTATION

TYPE
  VirtualFunc = FUNCTION (VAR f : Device) : Integer;



PROCEDURE OpenDev (VAR f : Device; OpenMode : Word);
BEGIN
  With f Do
  BEGIN
    BufPos   := 0;
    BufEnd   := 0;
    FilePtr  := 0;
    Mode     := OpenMode;
    InOutRes := VirtualFunc (OpenFunc) (f);
  END;
END;


PROCEDURE ReadChar (VAR f : Device; VAR c : Char);
BEGIN
  With f Do
  If (InOutRes=0) and (Mode=DevInput) Then
  BEGIN
    If BufPos>=BufEnd Then
    BEGIN
      BufPos   := 0;
      BufEnd   := 0;
      InOutRes := VirtualFunc (InOutFunc) (f);
      inc (FilePtr, BufEnd);
    END;
    c:= BufPtr^[BufPos];
    inc (BufPos);
  END;
END;


PROCEDURE ReadLine (VAR f : Device; VAR s : String);
VAR
  x : Byte;
  c : Char;
LABEL
  Ende;
BEGIN
  s:= '';
  x:= 0;
  While (not EndOfFile (f)) and (x<255) Do
  BEGIN
    ReadChar (f, c);
    If (c<>#13) and (c<>#10) Then
    BEGIN
      inc (x);
      s[x]:= c;
    END Else
    BEGIN
      c:= NextChar (f);
      If (c=#13) or (c=#10) Then ReadChar (f, c);
      Goto Ende;
    END;
  END;
Ende:
      { Hier noch Code einfgen, der bis zum nchsten Zeilenumbruch liest,
        wenn x=255 ist }
  s[0]:= chr(x);
END;


FUNCTION NextChar (VAR f : Device) : Char;
VAR
  Dummy : Integer;
BEGIN
  With f Do
  If (InOutRes=0) and (Mode=DevInput) Then
  BEGIN
    If BufPos>=BufEnd Then
    BEGIN
      BufPos := 0;
      BufEnd := 0;
      Dummy  := VirtualFunc (InOutFunc) (f); { weil EndOfFile sonst bei der Suche nach #26 einen IOResult erzeugt }
      inc (FilePtr, BufEnd);
    END;
    NextChar:= BufPtr^[BufPos];
  END;
END;


PROCEDURE WriteChar (VAR f : Device; c : Char);
BEGIN
  With f Do
  If (InOutRes=0) and (Mode=DevOutput) Then
  BEGIN
    If BufPos>=BufSize Then
    BEGIN
      InOutRes := VirtualFunc (InOutFunc) (f);
      BufPos   := 0;
    END;
    BufPtr^[BufPos]:= c;
    inc (BufPos);
  END;
END;


PROCEDURE WriteString (VAR f : Device; s : String);
VAR
  x : Byte;
BEGIN
  For x:= 1 To Length(s) Do WriteChar (f, s[x]);
END;


PROCEDURE WriteLine (VAR f : Device; s : String);
BEGIN
  WriteString (f, s);
  WriteString (f, #13#10);
END;


PROCEDURE CloseDev (VAR f : Device);
BEGIN
  With f Do
  BEGIN
    If (Mode > DevClosed) and (Mode <= DevInOut) Then
    BEGIN
      If (BufPos<>0) and ((Mode = DevOutput) or (Mode = DevInOut)) Then
      InOutRes:= VirtualFunc (FlushFunc) (f);
      InOutRes:= VirtualFunc (CloseFunc) (f);
    END;
    Mode:= DevClosed;
  END;
END;


PROCEDURE SetFileBuf (VAR f : Device; VAR Buf; Size : Word);
BEGIN
  With f Do
  BEGIN
    BufSize:= Size;
    BufPtr := @Buf;
  END;
END;


FUNCTION EndOfFile (VAR f : Device) : Boolean;
BEGIN
  With f Do
  BEGIN
    If FileEnd = -1 Then  { hier nochmal generell ber den Sinn von #26 nachdenken }
    EndOfFile:= NextChar (f) = #26 Else
    EndOfFile:= (FilePtr+BufPos >= FileEnd+BufEnd);
  END;
END;


FUNCTION DataSize   (VAR f : Device) : LongInt;
BEGIN
  DataSize:= f.FileEnd;
END;


FUNCTION DataPos   (VAR f : Device) : LongInt;
BEGIN
  DataPos:= f.FilePtr+f.BufPos;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
