UNIT Dev_IO;

INTERFACE

USES
  DOS, Strings, DeviceIO, Dir_IO, Buf_IO, Fil_IO, IO_Tools,
  Brow_URL, Brow_win, Brow_var;


PROCEDURE AssignDev (VAR f : Device; FName : String);

VAR
  MIMEType : String;

IMPLEMENTATION
VAR
  Buffer   : Array[1..2048] of Char;    { knnte grer }

CONST
  PathCash : String = '';    { Fr NameServer }
  MIMECash : String = '';    { Fr MIMEType-Suche }

  MIMETypHTML ='text/html htm php sht dht';
  MIMETypPlain='text/plain txt asc pas asm ini bat pas asm';
  (* falls keine NSERVER.INI verfgbar ist *)

  Dir = 1;
  Fil = 2;


FUNCTION  NameServer (Protocol, Domain : String) : String; forward;
PROCEDURE SendErrorFile (Name, OrigName : String); forward;
FUNCTION  GetMIMEType (Name : String) : String; forward;


FUNCTION ObjektTyp (Name : String) : Byte;
BEGIN
  If (Name[Length(Name)]='/')
  or (Name[Length(Name)]='\') Then ObjektTyp:= Dir Else ObjektTyp:= Fil;
END;


PROCEDURE AssignDev (VAR f : Device; FName : String);
VAR
  sr       :  SearchRec;
  URL      :  TURLRec;
  p        :  Byte;
  Objekt   :  Byte;
  OrigName :  String;

LABEL
  Error, Ende;
BEGIN
  ServerError:= 0; { mu vorn bleiben }

  OrigName:= FName;
  SplitURL (FName, URL);
  With URL Do
  BEGIN
    Objekt:= ObjektTyp (Path);
    For p:= 1 To Length (Path) Do If Path[p]='/' Then Path[p]:= '\';
    If (Protocol='http://') or (Protocol='ftp://') Then
    BEGIN
      FName:= NameServer (Protocol, Domain);
      If ServerError<>0 Then Goto Error;
      FName:= BuildPath (FName, Path);
    END Else
    If Protocol = 'file://' Then
    BEGIN
      If pos ('/', Domain) = 1 Then Delete (Domain, 1, 1);
      p:= pos ('|', Domain);
      If p<>0 Then Domain[p]:= ':';
      FName:= BuildPath (Domain, '\'+Path);
    END;
  END;

  FName:= DelLastSlash (FName);
  (* Hinw.: vom Wurzelverzeichnis wird das letzte \ nicht abgeschnitten -
     das zweite "if" ist also eigentlich berflssig *)

  If (Length(FName)=3) and (pos (':', FName)=2) and (pos('\', FName)=3) Then
  BEGIN
    sr.attr:= directory;
    DOSError:= 0; { Noch Laufwerksverfgbarkeit prfen }
  END
  Else
  If (Length(FName)=2) and (pos (':', FName)=2) Then
  BEGIN
    FName:= FName+'\'; { Backslash wieder anhngen }
    sr.attr:= directory;
    DOSError:= 0; { Noch Laufwerksverfgbarkeit prfen }
  END
  Else
  FindLFNFile (FName, sr);

  If DOSError=0 Then
  BEGIN
    ActDir:= FName;  { ---------  wegen Execute (brow_cmd) }
    If sr.attr and directory=0 Then
    ActDir:= GetPathName (ActDir);
    ActDir:= DelLastSlash(ActDir);

    If sr.attr and directory=0 Then
    BEGIN
      If Objekt = Dir Then BEGIN ServerError:= 404; Goto Error; END;
      AssignFile (f, FName);
      If sr.size=0 Then BEGIN ServerError:= 204; Goto Error; END;
      MIMEType:= GetMIMEType (sr.name);
    END Else
    BEGIN
      If Objekt = Fil Then BEGIN ServerError:= 302; Goto Ende; END;
      FindIndexFile (FName, sr);
      If DOSError=0 Then
      AssignFile (f, BuildPath (FName, sr.name)) Else
      AssignDir  (f, FName, OrigName);
      MIMEType:= 'text/html';
    END;
  END Else
  BEGIN
    ServerError:= 404;
    Error:
    SendErrorFile (FName, OrigName);
    AssignBuf (f, FName);
    MIMEType:= 'text/html';
  END;
  Ende:
  SetFileBuf (f, Buffer, SizeOf(Buffer));
END;

{ ------------------------------ Name-Server --------------------------- }


FUNCTION GetRealPath (Domain, Line : String) : String;
BEGIN
  If LowStr(trim(nthField (Line, '=', 1))) = Domain Then
  GetRealPath := trim(nthField (Line, '=', 2)) Else
  GetRealPath := '';
END;


FUNCTION NameServer (Protocol, Domain : String) : String;
VAR
  f       : Device;
  s, Path : String;

BEGIN
  Domain:= LowStr (Domain);
  If pos ('www.', Domain) = 1 Then delete (Domain, 1, 4);
  Domain:= LowStr(Protocol)+Domain;

  Path:= GetRealPath (Domain, PathCash);

  If Length(Path)=0 Then
  BEGIN
    If (SeekIniDivision (f, 'LocalDomains')) Then
    BEGIN
      s:= '';
      While (IOResult=0) and (not EndOfFile(f)) and (Length(Path)=0) and (s[1]<>'[') Do
      BEGIN
        ReadIniLn (f, s);
        If s[1]<>'[' Then Path:= GetRealPath (Domain, s);
      END;
      CloseDev (f); InOutRes:= 0;
    END;

    If Length(Path)=0 Then
    BEGIN
      ServerError:= 404;
      NameServer:= Domain;
      Exit;
    END Else PathCash:= s;
  END;

  NameServer:= Path;
END;


{ ----------------------- MIME-Typ der Datei ermitteln -------------------- }


FUNCTION SeekMIMEType (Ext, Line : String) : String;
VAR
  x : Byte;
BEGIN
  Ext:= LowStr (Ext);
  For x:= 2 To CountFields (Line, ' ') Do
  If LowStr (nthField(Line, ' ', x)) = Ext Then
  BEGIN
    SeekMIMEType:=LowStr(nthField(Line, ' ', 1));
    Exit;
  END;
  SeekMIMEType:= '';
END;


FUNCTION GetMIMEType (Name : String) : String;
VAR
  f       : Device;
  s, MIME : String;

BEGIN
  Name:= GetFileExt (Name);

  MIME:= SeekMIMEType (Name, MIMECash);

  If Length(MIME)=0 Then
  BEGIN
    If SeekIniDivision (f, 'MIME-Types') Then
    BEGIN
      s:= '';
      While (IOResult=0) and (not EndofFile(f)) and (Length(MIME)=0) and (s[1]<>'[') Do
      BEGIN
        ReadIniLn (f, s);
        If s[1]<>'[' Then MIME:= SeekMIMEType (Name, s);
      END;
      CloseDev (f); InOutRes:= 0;
    END;

    If Length(MIME)=0 Then
    BEGIN
      MIME:= SeekMIMEType (Name, MIMETypHTML);
      If Length(MIME)<>0 Then MIMECash:=MIMETypHTML Else
      BEGIN
        MIME:= SeekMIMEType (Name, MIMETypPlain);
        If Length(MIME)<>0 Then MIMECash:=MIMETypPlain Else
        MIME:= 'application/octet-stream';
      END;
      MIMEType:=MIME;
    END Else MIMECash:= s;

  END;

  GetMIMEType:= MIME;
END;


{ ----------------------------- Server-Antwortseite ---------------------- }

PROCEDURE SendErrorFile (Name, OrigName : String);
VAR
  f : Device;
BEGIN
  AssignBuf (f, Name);
  OpenDev   (f, DevOutput);

  WriteString (f, '<TITLE>Error ');
  WriteString (f, StrVal(ServerError));
  WriteString (f, '</TITLE><BODY><PRE><FONT color="maroon">'#13#10'Error ');
  WriteString (f, StrVal(ServerError));
  WriteLine   (f, '</FONT>'#13#10);

  CASE ServerError Of
    404 : WriteString (f, 'Seite nicht gefunden');
    204 : WriteString (f, 'Dokument hat keinen Inhalt');
    100 : WriteString (f, 'Lesefehler in Datei');    { 100 inoffiziell, noch checken }
    Else  WriteString (f, 'keine Code-Beschreibung verfgbar');
  END;

  WriteLine (f, ' - '+LowStr(OrigName)+#13#10#13#10);
  WriteLine (f, '<A HREF="javascript:history.back()">zur&uuml;ck</A>');
(*WriteLine (f, '<A HREF="back:">zur&uuml;ck</A>');*)
  CloseDev  (f);
  InOutRes:= 0;
END;

{   200 : AccessCodeStr:= 'OK';
    201 : AccesscodeStr:= 'Erstellt';
    202 : AccesscodeStr:= 'Akzeptiert';
    206 : AccesscodeStr:= 'Datei teilweise geladen';
    300 : AccesscodeStr:= 'Mehrfach-Auswahl';
    301 : AccesscodeStr:= 'Verzogen';
    302 : AccessCodeStr:= 'Gefunden/Vorbergehend verzogen';
    304 : AccessCodeStr:= 'Nicht gendert';
    400 : AccessCodeStr:= 'Fehlerhafte Anfrage';
    401 : AccessCodeStr:= 'Nicht autorisiert';
    403 : AccessCodeStr:= 'Verboten';
    404 : AccessCodeStr:= 'Nicht gefunden';
    405 : AccessCodeStr:= 'Unerlaubte Zugriffs-Methode';
    500 : AccessCodeStr:= 'Interner Fehler';
    501 : AccessCodeStr:= 'Nicht implementiert';
    502 : AccessCodeStr:= 'Gateway-Zeitberschreitung';
    503 : AccessCodeStr:= 'Vorbergehend nicht verfgbar';
}


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
