UNIT Dir_IO;

INTERFACE
USES
  Strings, DOS, DeviceIO, Konvert, IO_Tools;


PROCEDURE AssignDir (VAR f : Device; Path : String; URL : String);


IMPLEMENTATION
VAR
  sr      : SearchRec;  { Vorsicht: Funktionen sind nicht reentrant! }
  OrigURL : String;


PROCEDURE PushInBuf (VAR f : Device; s : String);
VAR
  x : Byte;
BEGIN
  x:= 1;
  With f Do
  While (BufEnd<BufSize-1) and (x<=Length(s)) Do
  BEGIN
    BufPtr^[BufEnd]:= s[x];
    inc (BufEnd);
    inc (x);
  END;
END;


FUNCTION NameToHTML (Name : String) : String;
VAR
  x : Byte;
  s : String;
BEGIN
  s:= '';
  For x:= 1 To Length (Name) Do s:= s+Text2HTML (Name[x]);
  NameToHTML:= s;
END;

(* FUNCTION CreateLink (URL, Txt : String) : String;
BEGIN
  CreateLink:= '<A HREF="'+BuildLink(OrigUrl, LowStr(URL))+'">'+NameToHTML(Txt)+'</A>';
END;
So machts Netscape offline *)


FUNCTION CreateLink (URL, Txt : String) : String;
BEGIN
  CreateLink:= '<A HREF="'+LowStr(URL)+'">'+NameToHTML(Txt)+'</A>';
END;

FUNCTION DateStr (Time : LongInt) : String;
VAR
  dt : DateTime;
BEGIN
  UnPackTime (Time, dt);
  With dt Do
  DateStr:= lz(day)+'.'+lz(month)+'.'+StrVal(Year)+'      '+
            lz(hour)+':'+lz(min)+':'+lz(sec); 
END;


PROCEDURE PushDirEntry (VAR f : Device);
VAR
  s : String[20];
BEGIN
  With f Do
  BEGIN
    s:= FillString (14-Length(sr.name));
    If sr.attr and directory<>0 Then
    BEGIN
      PushInBuf (f,
      CreateLink (sr.name+'/', sr.name)+s+' &lt;DIR&gt;                   '+
      DateStr(sr.time)+#13#10);
    END
    Else
    BEGIN
      PushInBuf (f, CreateLink (sr.name, LowStr(sr.name))+s);
      s:= TausPkt (sr.size);
      PushInBuf (f, FillString (14-Length(s))+s+' Byte      '+DateStr(sr.time)+#13#10);
    END;
  END;
END;


{ ----------------------------- InOut-Funktionen ------------------------- }

{ Die Funktionsergebnisse tauchen in InOutRes bzw. IOResult wieder auf }

{ Die drei nchsten Funktionen installieren jeweils ihren Nachfolger
  als InOutFunc, sobald sie ihre Arbeit erledigt haben. OutHead wird
  von AssignDir installiert, OutHead installiert danach ReadFirstFile
  und dieses dann ReadNextFile. }


FUNCTION ReadNextFile (VAR f : Device) : Integer; far;
BEGIN
  With f Do
  BEGIN
    FindNext (sr);
    If DOSError=0 Then
    BEGIN PushDirEntry (f);   ReadNextFile:= 0; END Else
    BEGIN PushInBuf (f, #26); ReadNextFile:= 4; END;
  END;
END;


FUNCTION ReadFirstFile (VAR f : Device) : Integer; far;
BEGIN
  With f Do
  BEGIN
    InOutFunc:= @ReadNextFile;
    ReadFirstFile:= 0;
    FindFirst (BuildPath (ASCIIZToPascal(Name), '*.*'), anyfile and not (VolumeID or Hidden or SysFile), sr);
    If DOSError<>0 Then BEGIN ReadFirstFile:= 3; Exit; END;
    If sr.name='.' Then
    BEGIN
      FindNext (sr);
      If DOSError<>0 Then BEGIN ReadFirstFile:= 3; Exit; END;
    END;
    If sr.name='..' Then
    PushInBuf (f, CreateLink ('..', 'Verzeichnis hherer Stufe abrufen')+#13#10#13#10)
    Else
    PushDirEntry (f);
  END;
END;


FUNCTION OutHead (VAR f : Device) : Integer; far;
BEGIN
  With f Do
  BEGIN
    InOutFunc:= @ReadFirstFile;
    PushInBuf (f, '<TITLE>Verzeichnis '+NameToHTML(LowStr(OrigURL))+'</TITLE><BODY><PRE>'#13#10+
                  '<FONT color="teal">Verzeichnis-Liste von '+
                   NameToHTML(LowStr(OrigURL))+'</FONT><HR noshade color="silver">');
    OutHead:= 0;
  END;
END;


{ ------------------------ die anderen 3 Funktionen ---------------------- }

FUNCTION OpenFile (VAR f : Device) : Integer; far;
BEGIN
  With f Do
  BEGIN
    FileEnd:= -1;
    If Mode<>DevInput Then OpenFile:= 5 Else OpenFile:= 0;
  END;
END;


FUNCTION FlushInput (VAR f : Device) : Integer; far;
BEGIN
  FlushInput:= 0;
  { Dummy, wird eigentlich berhaupt nicht gebraucht, sollte aber
    erstmal drin bleiben, z.B. fr sptere Erweiterungen o.. }
END;


FUNCTION CloseFile (VAR f : Device) : Integer; far;
BEGIN
  CloseFile:= 0;
END;


{ -------------------------- Anstelle von Assign anwenden -------------- }

PROCEDURE AssignDir (VAR f : Device; Path : String; URL : String);
BEGIN
  With f Do
  BEGIN
    Mode      := DevClosed;
    BufSize   := SizeOf(Buffer);
    BufPtr    := @Buffer;

    OpenFunc  := @OpenFile;
    InOutFunc := @OutHead;
    FlushFunc := @FlushInput;
    CloseFunc := @CloseFile;

    PascalToASCIIZ (Path, Name, SizeOf (Name));

    If URL='' Then OrigURL:= Path Else
    BEGIN
      OrigURL:=URL;
      If pos ('file://', OrigURL) = 1 Then Delete (OrigURL, 1, 7);
    END;
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
