UNIT Fil_IO;

INTERFACE
USES
  Strings, DeviceIO;


PROCEDURE AssignFile  (VAR f : Device; Path : String);

FUNCTION  GetFileSize (VAR f : Device) : LongInt;
PROCEDURE SeekFile    (VAR f : Device;   NewPos : LongInt);
FUNCTION  GetFilePos  (VAR f : Device) : LongInt;

FUNCTION  GetFileAttr (VAR f : Device) : Word;
PROCEDURE SetFileAttr (VAR f : Device; Attr : Word);

PROCEDURE EraseFile   (VAR f : Device);
PROCEDURE RenameFile  (VAR f : Device; NewName : String);


IMPLEMENTATION


FUNCTION GetFileSize (VAR f : Device) : LongInt; assembler;
ASM
  xor  ax, ax
  xor  dx, dx
  cmp  word ptr InOutRes, 0
  jne  @ende

  les  di, f
  mov  bx, es:[di] { Datei-Handle }
  mov  ax, 4201h   { Dateizeiger um 0 Byte bewegen -> akt. Dateiposition }
  xor  cx, cx
  xor  dx, dx
  int  21h
  jc   @error
  push ax          { aktuelle Dateiposition merken }
  push dx

  xor  cx, cx
  xor  dx, dx
  mov  ax, 4202h   { Dateizeiger 0 Byte vor (also AN) das Dateiende setzen }
  int  21h
  mov  di, ax      { Dateigre (DX:AX) merken }
  mov  si, dx
  pop  cx          { alte Datei-Position in CX:DX laden }
  pop  dx
  jc   @error      { Fehler erst hier abfragen ! }

  mov  ax, 4200h   { alte Dateiposition wieder herstellen }
  int  21h
  jc   @error

  mov  ax, di
  mov  dx, si
  jmp  @ende

  @error:
  mov  InOutRes, ax
  @ende:
END;


PROCEDURE SeekFile (VAR f : Device; NewPos : LongInt); assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  mov  cx, word ptr [NewPos+2]
  mov  dx, word ptr [NewPos]
  les  di, f
  mov  bx, es:[di]  { Datei-Handle }
  mov  ax, 4200h    { al=00: Rel zum Dateianfang, 1: Akt.Pos, 2: Rel.zum Dateiende }
  int  21h
  jnc  @raus
  mov  InOutRes, ax
  @raus:
END;


FUNCTION GetFilePos (VAR f : Device) : LongInt; assembler;
ASM
  xor  ax, ax
  xor  dx, dx
  cmp  word ptr InOutRes, 0
  jne  @raus

  les  di, f
  mov  bx, es:[di]             { Datei-Handle }
  mov  ax, 4201h               { Relativ zur aktuellen Position }
  xor  cx, cx                  { um 0 Bytes bewegen }
  xor  dx, dx
  int  21h                     { Dateiposition in DX:AX }
  jnc  @raus
  mov  InOutRes, ax
  @raus:
END;


FUNCTION ReadFile (VAR f : Device) : Integer; far; assembler;
ASM
  push ds
  lds  si, f
  lodsw
  mov  bx, ax              { Datei-Handle }
  lodsw
  mov  cx, ax              { Zahl der zu lesenden Bytes = BufSize }
  push ds
  lds  dx, [si]            { Start-Adresse des Zielpuffers }
  mov  ah, 3Fh
  int  21h
  pop  es
  jc   @error
    mov di, si
    add di, 4
    stosw
    xor ax, ax
  @error:
  pop  ds
END;


FUNCTION WriteFile (VAR f : Device) : Integer; far; assembler;
ASM
  push ds
  lds  si, f
  lodsw
  mov  bx, ax         { Datei-Handle }
  add  si, 8
  lodsw
  mov  cx, ax         { Zahl der zu lesenden Bytes = BufPos }
  push cx             { = merken }
  lds  dx, [si-8]     { Start-Adresse des Zielpuffers }
  mov  ah, 40h
  int  21h
  pop  cx
  jc   @error
    mov bx, ax
    mov ax, 5         { Access denied, Platte voll }
    cmp bx, cx        { konnten alle Bytes geschrieben werden ? }
    jne @error
    xor ax, ax
  @error:
  pop  ds
END;


FUNCTION FlushInput (VAR f : Device) : Integer; far;
BEGIN
  FlushInput:= 0;
  { Dummy, wird eigentlich berhaupt nicht gebraucht, sollte aber
    erstmal drin bleiben, z.B. fr sptere Erweiterungen o.. }
END;


FUNCTION ResetFile (VAR Name; VAR Handle : Word; Mode : Byte) : Integer; assembler;
ASM
  push ds
  mov  al, Mode      { 0: nur lesen, 1: nur schreiben 2: beides }
  mov  ah, 3Dh
  lds  dx, Name
  int  21h
  jc   @error
    les di, Handle
    stosw
    xor ax, ax
  @error:
  pop  ds
  mov  InOutRes, ax
  { Damit bei einem Fehler GetFileSize bzw. SeekFile nicht ausgefhrt werden }
END;


FUNCTION RewriteFile (VAR Name; VAR Handle : Word) : Integer; assembler;
ASM
  push ds
  lds  dx, Name
  xor  cx, cx                     { Attribut Normal }
  mov  ah, 3Ch                    { ffnen zum "Lesen/Schreiben" }
  int  21h
  jc   @error
    les di, Handle
    stosw
    xor ax, ax
  @error:
  pop  ds
END;


FUNCTION OpenFile (VAR f : Device) : Integer; far;
BEGIN
  With f Do
  CASE Mode Of
    DevInput  : BEGIN
                  InOutFunc := @ReadFile;
                  FlushFunc := @FlushInput;
                  Openfile  := ResetFile (Name, Handle, DevMode);
                  FileEnd   := GetFileSize (f);
                END;
    DevOutput : BEGIN
                  InOutFunc := @WriteFile;
                  FlushFunc := @WriteFile;
                  OpenFile  := RewriteFile (Name, Handle);
                  FileEnd   := 0;
                END;
    DevAppend : BEGIN
                  InOutFunc := @WriteFile;
                  FlushFunc := @WriteFile;
                  OpenFile  := ResetFile (Name, Handle, 2);
                  FileEnd   := GetFileSize (f);
                  SeekFile (f, FileEnd);
                  Mode      := DevOutput;
                END;
    Else        OpenFile:= 2;
  END;
END;


FUNCTION CloseFile (VAR f : Device) : Integer; far; assembler;
ASM
  les di, f
  mov bx, es:[di]  { = Handle }
  mov ah, 3Eh
  int 21h
  jc  @error
  xor ax, ax
  @error:
END;


PROCEDURE AssignFile (VAR f : Device; Path : String);
BEGIN
  With f Do
  BEGIN
    Mode      := DevClosed;
    BufSize   := SizeOf(Buffer);
    BufPtr    := @Buffer;
    OpenFunc  := @OpenFile;
    CloseFunc := @CloseFile;
    PascalToASCIIZ (Path, Name, SizeOf (Name));
  END;
END;


FUNCTION GetFileAttr (VAR f : Device) : Word; assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  push ds
  lds  dx, f
  add  dx, Device.Name
  mov  ax, 4300h
  int  21h
  pop  ds
  jc   @error
  mov  ax, cx               { Attribute kommen in cx }
  jmp  @raus
  @error:
  mov  InOutRes, ax
  @raus:
END;


PROCEDURE SetFileAttr (VAR f : Device; Attr : Word); assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  push ds
  mov  cx, Attr
  lds  dx, f
  add  dx, Device.Name
  mov  ax, 4301h
  int  21h
  pop  ds
  jnc  @raus
  mov  InOutRes, ax
  @raus:
END;


PROCEDURE EraseFile (VAR f : Device); assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  push ds
  lds  dx, f
  add  dx, Device.Name
  mov  ah, 41h             { Datei lschen }
  int  21h
  pop  ds
  jnc  @raus
  mov  InOutRes, ax
  @raus:
END;


PROCEDURE RenameFile (VAR f : Device; NewName : String); assembler;
ASM
  cmp  word ptr InOutRes, 0
  jne  @raus
  push ds
  lds  dx, f
  add  dx, Device.Name
  les  di, NewName
  mov  al, es:[di]
  inc  di                   { erstes Zeichen nach Lngenbyte }
  push di
  xor  ah, ah
  add  di, ax
  xor  al, al
  stosb                     { Null-Byte schreiben }
  pop  di                   { Zeiger wieder auf erstes Zeichen "NewName" }

  mov  ah, 56h
  int  21h
  jc   @error
    lds  si, NewName
    les  di, f
    add  di, Device.Name
    lodsb
    xor  ah, ah
    mov  cx, ax
    jcxz @error
    rep  movsb
    xor  ax, ax
    stosb
  @error:
  pop  ds
  mov  InOutRes, ax
  @raus:
END;


END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
