UNIT IO_Tools;

INTERFACE
USES
  DOS, Strings, DeviceIO, Fil_IO;

VAR
  ServerError : Word;
  ProgDir     : PathStr;

PROCEDURE FindIndexFile (Path : String; VAR sr : SearchRec);

PROCEDURE ReadIniLn       (VAR f : Device; VAR s : String);
FUNCTION  SeekIniDivision (VAR f : Device; Division : String) : Boolean;

IMPLEMENTATION

CONST
  IndexFiles : String  = '';
  IniExist   : Boolean = true;


PROCEDURE FindIndexFile (Path : String; VAR sr : SearchRec);
VAR
  x, c : Byte;
  f    : Device;
  s    : String;

BEGIN
  DOSError:= 2;                             { = File not Found }

  If IndexFiles=#0 then Exit;

  If SeekIniDivision (f, 'IndexFiles') Then
  BEGIN
    s:= '';
    While (IOResult=0) and (not EndOfFile(f)) and (s[1]<>'[') and (Length(IndexFiles)<255) Do
    BEGIN
      ReadIniLn (f, s);
      s:= UpStr(s);
      If (s[1]<>'[') and (s<>'') Then IndexFiles:= IndexFiles+','+s;
    END;
    CloseDev (f); InOutRes:= 0;
  END;

  If Length (IndexFiles)=0 Then BEGIN IndexFiles:=#0; Exit; END;

  c:= CountFields (Indexfiles, ',');
  FindFirst (BuildPath (Path, '*.*'), anyfile and not (VolumeID or Hidden), sr);
  While DOSError=0 Do
  BEGIN
    For x:= 1 To c Do
    If Trim(nthField (IndexFiles, ',', x)) = sr.name Then Exit;
    FindNext (sr);
  END;
END;
{ Nach Aufruf DOSError auswerten ! }


PROCEDURE ReadIniLn (VAR f : Device; VAR s : String);
VAR
  Result : Word;
BEGIN
  REPEAT
    ReadLine (f, s);
    s:= Trim(s);
    Result:=IOResult;
  UNTIL (Result<>0) or
        ((Length (s)<>0) and (s[1]<>';') and (s[1]<>'#')) or
        (EndOfFile (f));
  If (Result<>0) or (EndOfFile(f)) Then s:= '';
  InOutRes:= Result;
END;


FUNCTION SeekIniDivision (VAR f : Device; Division : String) : Boolean;
VAR
  s : String;
  b : Boolean;
BEGIN
  SeekIniDivision:= false;
  If not IniExist then Exit;

  Division:= UpStr (Division);
  AssignFile (f, BuildPath (ProgDir, 'NSERVER.INI'));
  { AssignDev darf nicht, weil AssigDev SeekIniDivision dann rekursiv aufruft }

  OpenDev    (f, DevInput);
  If IOResult<>0 then BEGIN IniExist:=false; Exit; END;

  b:= False;
  REPEAT
    ReadIniLn (f, s);
    b:= UpStr(s)='['+Division+']';
  UNTIL (InOutRes<>0) or (EndOfFile(f)) or (b);
  If IOResult<>0 Then BEGIN CloseDev(f); InOutRes:= 0; Exit; END;

  SeekIniDivision:= b;
  { INI-Datei bleibt nur offen, wenn die Division gefunden wurde }
END;


BEGIN
  ProgDir:= ParamStr(0);
  While (Length(ProgDir)>0) and (ProgDir[Length(ProgDir)]<>'\') Do dec (ProgDir[0]);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
