PROGRAM Calculator;
{$N+} {$E+} {$M 5000, 0, 0}
USES
  Monitor, BiosCrt, Mouse, Strings, keycode, monit, time, dos,
  ClipBord;

CONST
  ee         : Byte    = 1;
  ErgLen     : Word    = 0;
  ErgPtr     : Word    = 0;
  MaxLines             = 1001;
  First      : Word    = 1;
  ToBig      = 'Berechnung nicht ausfhrbar. Weiter mit beliebiger Taste';
  MaxBut     = 255;

VAR
  a1, a2, a3 : Extended;
  Mem        : Extended;
  Err        : Boolean;
  c          : Integer;
  ErgList    : Array[1..MaxLines] of String[40];
  Ops        : Array[0..MaxLines] of Char;

  ButCount   : Byte;
  LastBut    : Byte;
  ActBut     : Byte;
  Buttons    : Array[1..MaxBut] Of RECORD x, y : Byte; END;
  Tmp        : String;
  cTmp       : Char;

PROCEDURE InsertPos (xx, yy : Byte);
BEGIN
  If LastBut<MaxBut Then
  BEGIN inc (LastBut); Buttons[LastBut].x:=xx; Buttons[LastBut].y:=yy; END;
END;


PROCEDURE SetCursor;
BEGIN
  Window (1, 1, 80, 25);
  With Buttons[ActBut] Do GotoXY (x, y);
END;


PROCEDURE MoveCursor;
BEGIN
  If t1=TAB Then
  BEGIN
    If ActBut<LastBut Then inc (ActBut) Else ActBut:= 1;
    t1:= #0;
  END Else
  If t2=Shift_TAB Then
  BEGIN
    If ActBut>1 Then dec (ActBut) Else ActBut:= LastBut;
    t2:= #0;
  END Else If t1<>#13 Then ActBut:= 1;
END;


PROCEDURE Standard_MT;
BEGIN
  t1:= #0; t2:= #0;
  MouseOn;
  REPEAT MouseGet; UNTIL (kn<>0) or (Keypressed);
  If KeyPressed Then BEGIN ScanKeys; t1:= UpCase (t1); END;
  MouseOff;
END;


PROCEDURE ErrorMsg (Txt1 : String);
BEGIN
  ClearWin (9, 3, 71, 8, 7);
  WriteXY (13, 5, Txt1, lightred, 0);
  GotoXY (4, 3);
  Standard_MT; MouseWait; t1:= #0; t2:= #0;
  Window (1, 1, 80, 25);
END;



PROCEDURE InsertErg (st : String);
BEGIN
  If ErgPtr<ErgLen Then ErgLen:= ErgPtr;
  If ErgLen<MaxLines-1 Then inc (ErgLen) Else
  BEGIN
    ErrorMsg ('Es knnen nicht mehr als 1000 Werte aufgenommen werden');
    Exit;
  END;
  ErgList[ErgLen]:= st;
  Ops[ErgLen]:= #0;
  ErgPtr:= ErgLen;
END;


PROCEDURE ScrollUp;
BEGIN If ErgPtr>1 Then dec (ErgPtr); END;


PROCEDURE ScrollDown;
BEGIN If ErgPtr<ErgLen Then inc (ErgPtr); END;


FUNCTION ErgStr (Nr : Word) : String;
BEGIN
  ErgStr:= FillString (60-Length(ErgList[Nr]))+ErgList[Nr]+'   ';
END;

PROCEDURE ViewErgList;
VAR
  x, y : Word;
BEGIN
  WriteXY (9,  8, ErgStr (ErgPtr), lightgreen, 0);
  CharXY  (70, 8, Ops[ErgPtr], 15, 0);
  y:= ErgPtr;
  For x:= 7 DownTo 3 Do If y>1 Then
  BEGIN
    dec (y);
    WriteXY (9,  x, ErgStr (y), lightmagenta, 0);
    CharXY  (70, x, Ops[y], 15, 0);
  END Else WriteXY (9, x, FillString (63), 0, 0);
END;



PROCEDURE Button (a, b : Byte; Hk1a, Hk1b : Char; Hotkey, st : String; keyCol, StrCol : Byte);
VAR
  l, yy : Byte;
PROCEDURE Taste (kc, sc, Modus : Byte);
VAR
  x : Byte;
BEGIN
  Rahmen (a, b, l, b+2, 7, Modus);
  WriteXY (succ (a), succ(b), St, sc, 7);
  yy:= Pos (Hotkey, St); If yy<>0 Then WriteXY (a+yy, succ(b), Hotkey, kc, 7);
END;
BEGIN  
  l:= succ (Length(st)+a);
  If ee=0 Then 
  BEGIN
    inc (ButCount);
    If ((kn<>0) and (MouseIn (a, b, l, b+2)))
    or ((t1=#13) and (ButCount=ActBut)) Then
    BEGIN
      t1 := Hk1a; t2:= Hk1b;
      Taste (8, 8, 1);
      If kn<>0 Then MouseWait Else xDelay (150);
      Taste (KeyCol, StrCol, 0);
    END;
  END Else
  BEGIN
    Taste (KeyCol, StrCol, 0);
    InsertPos (a+yy, b+1);
  END;
END;


PROCEDURE Tasten;
CONST
  Ok = 10;
  ar : Array[1..4] Of Char = ':*-+';
VAR
  x, y : Byte;
  c    : Char;
BEGIN
  If ee=1 Then
  BEGIN
    LastBut:=0; ActBut:= 1;
    InsertPos  (69, 8);
  END Else ButCount:= 1;

  Button (7,  OK+0,  'H', #0, 'H',    ' H x ', 9, 0);
  Button (7,  OK+3,  'Q', #0, 'Q',    ' Q x ', 9, 0);
  Button (7,  OK+6,  'B', #0, 'B',    ' B  ', 9, 0);
  Button (7,  OK+9,  'W', #0, 'W',    ' W  ', 9, 0);
  Button (7,  OK+12, ' ', #0, ' ',    ' Leer ', 9, 0);

  Button (17, OK+0,  'R', #0, 'R',    ' MR  ',  9, 0);
  Button (25, OK+0,  'M', #0, 'M',    ' MM- ',  9, 0);
  Button (33, OK+0,  'P', #0, 'P',    ' MP+ ',  9, 0);
  Button (41, OK+0,  'D', #0, 'D',    ' MD  ',  9, 0);

  Button (50, OK,    'S', #0, 'S',    ' Sin ',  9, 0);
  Button (58, OK,    'X', #0, 'x',    ' Exp ',  9, 0);
  Button (66, OK,    'N', #0, 'n',    'ArcTan', 9, 0);

  Button (50, OK+3,  'O', #0, 'o',    ' Cos ',  9, 0);
  Button (58, OK+3,  'L', #0, 'L',    ' Ln  ',  9, 0);
  Button (66, OK+3,  'T', #0, 'T',    ' Tang ', 9, 0);

  Button (50, OK+6,  'I', #0, 'i',    ' Pi  ',  9, 0);
  Button (58, OK+6,  'U', #0, 'U',    ' U  ',  9, 0);
  Button (66, OK+6,  'Z', #0, 'Z',    ' Z 1/x', 9, 0);

  Button (50, OK+9,  '', #0,  '',   ' ur ',  9, 0);
  Button (58, OK+9,  'C', #0,  'C',   ' C   ',  9, 0);
  Button (66, OK+9,  #0, Entf, 'Entf',' Entf ', 9, 0);

  Button (50, OK+12, #0,   Up, '',   '',      9, 0);
  Button (54, OK+12, #0, Down, '',   '',      9, 0);
  Button (58, OK+12, 'A',  #0, 'A',   ' AC  ',  9, 0);
  Button (66, OK+12, 'E',  #0, 'E',   ' Ende ', 9, 0);

  For y:= 1 To 4 Do
  Button (42, y*3+OK, ar[y], #0, ar[y], ' '+ar[y]+' ', 1, 0);

  Button (34, OK+12, '=', #0, '=',  ' = ',        1, 0);
  Button (26, OK+12, '.', #0, #249, ' '#249' ',   1, 0);
  Button (18, OK+12, '0', #0, '0',  ' 0 ',      red, 0);

  c:= '1';
  For y:= 3 DownTo 1 Do For x:= 1 To 3 Do
  BEGIN
    Button (x*8+10, y*3+OK, c, #0, c, ' '+c+' ',  red, 0);
    inc (c);
  END;
  Window (1, 1, 80, 25);
END;



FUNCTION GetStr (e : extended) : String;
VAR
  s : String;
  p : Byte;
BEGIN
  Str (e:0:30, s);
  p:= pos ('.', s);
  If (p<>0) and (pos('E', s)=0) Then
  While (Length(s)>=p) and ((s[Length(s)]='0') or (s[Length(s)]='.')) and (s[0]>#0) Do dec (s[0]);
  While (Length(s)> 0) and (s[1]=#32) Do delete (s, 1, 1);
  GetStr:= s;
END;



PROCEDURE AddKey;
VAR
  p : Byte;
BEGIN
  If t1=',' Then t1:='.';
  If ((t1='.') and (Pos ('.', ErgList[ErgPtr]) <> 0))
  or (Length(ErgList[ErgPtr])>=36) Then Exit;
  If (ErgList[ErgPtr]='0') and (t1<>'.') Then ErgList[ErgPtr]:= '';
  CharAdd (ErgList[ErgPtr], t1);
END;


FUNCTION XhochY (x, y : Extended) : Extended;
BEGIN
  XhochY:= exp(y * ln(x));
END;
{ berechnet Potenzen mit Realzahlen, wie z.B. 4^0.38 oder 5^2.31 }
{ x darf nicht <=0 sein !! }

PROCEDURE Potenz (Wurzel : Boolean);
VAR
  ax, ay : Extended;
  al     : LongInt;
  tmp    : String;
BEGIN
  If Wurzel Then
  BEGIN
    a1:= 1/a1;
    Str (a1:0:80, tmp);
  END Else
  tmp:=ErgList[ErgPtr];

  a3:= 0;
  If (a1>=2147483647) or (a1<=-2147483647) or ((a1=0) and (a2=0)) Then
  BEGIN Err:= TRUE; Exit; END;

  If pos ('.', tmp)<>0 Then
  BEGIN
    If a2<=0 then BEGIN Err:= TRUE; Exit; END;
    a2:= XhochY (a2, a1);
  END
  Else
  BEGIN
    ay:= a2; al:= abs (trunc(a1));
    If a1>0 Then
    BEGIN
      For al:= 2 To al Do
      If a2<= 1.0E+2460 Then a2:= a2*ay Else BEGIN Err:= TRUE; Exit; END
    END
    Else
    If ay>0 Then
    BEGIN For al:= 0 To al Do a2:= a2/ay END Else
    BEGIN Err:= TRUE; Exit; END;
  END;
  a3:= a2;
END;


PROCEDURE Umwandeln;
BEGIN
  Err:= FALSE;
  Val (ErgList[ErgPtr], a1, c); a3:= a1;
  CASE t1 Of
    'W' : If (a1>= 0) Then         a3:= sqrt(a1)   Else Err:= TRUE;
    'Q' : If (a1<= 1.0E+2460) Then a3:= sqr (a1)   Else Err:= TRUE;
    'S' : If (a1<= 1.0E+19)
          and(a1>=-1.0E+19)   Then a3:= sin (a1)   Else Err:= TRUE;
    'O' : If (a1<= 1.0E+19)
          and(a1>=-1.0E+19)   Then a3:= Cos (a1)   Else Err:= TRUE;
    'X' : If (a1<= 2830)
          and(a1>=-2830)      Then a3:= Exp (a1)   Else Err:= TRUE;
    'L' : If (a1>  0)         Then a3:= Ln  (a1)   Else Err:= TRUE;
    'Z' : If (a1<> 0)         Then a3:= 1/a1       Else Err:= TRUE;
    'T' : If (a1<= 1.0E+19)
          and(a1>=-1.0E+19)   Then a3:= Sin(a1)/Cos(a1) Else Err:= TRUE;
    'N' : a3:= ArcTan (a1);
  END;
  If Err Then BEGIN ErrorMsg(ToBig); Exit; END;
  ErgList[ErgPtr]:= GetStr(a3);
END;
                                                   

PROCEDURE Ergebnis;
VAR
  x : Word;
BEGIN
  Err:= FALSE; 
  First:= ErgPtr;
  While (First>1) and (Ops[First-1]<>'=') and (Ops[First-1]<>#0) Do dec (First);
  Val (ErgList[First], a2, c);

  For x:= First+1 To ErgPtr Do If Err= False Then
  BEGIN
    Val (ErgList[x], a1, c);
    CASE Ops[x-1] Of
    '+' : If (a1<= 1.0E+2460)
          and(a2<= 1.0E+2460) Then a3:= a2+a1      Else Err:= TRUE;
    '-' : If (a1<= 1.0E+2460)
          and(a2>=-1.0E+2460) Then a3:= a2-a1      Else Err:= TRUE;
    '*' : If (a1<= 1.0E+2460)
          and(a2<= 1.0E+2460) Then a3:= a2*a1      Else Err:= TRUE;
    ':' : If (a1<> 0) Then         a3:= a2/a1      Else Err:= TRUE;
    'H' : Potenz (false);
    'B' : Potenz (true);
    END;
    a2:= a3;
  END;
  If Err Then ErrorMsg (ToBig);
  InsertErg (GetStr (a3));
END;



BEGIN
  TextAttr:= 7; ClrScr; MouseInit;
  Rahmen   (4, 1, 76, 25, 7, 0);
  Rahmen   (7, 2, 73,  9, 7, 1);
  Window   (1, 1, 80, 25);
  Mem:= 0;
  ee:= 1; Tasten; ee:= 0;
  If ScrMode<>MonoMon Then ColCursor (magenta*16);
  InsertErg ('0');
  REPEAT
    ViewErgList;
    SetCursor;
    Standard_MT;
    MoveCursor;
    Tasten;
    If t1=#13 Then t1:= '=' Else
    If (t1=#0) and (t2=Entf) Then t1:=Back;
    If t1<>#0 Then
    CASE t1 Of
      'C'                : If ErgPtr>1 Then
                           BEGIN
                             ScrollUp;
                             ErgLen:= ErgPtr;
                             Ops[ErgLen]:= #0;
                           END Else ErgList[ErgPtr]:= '0';
      '0'..'9','.',','   : AddKey;
      Back               : BEGIN
                             dec (ErgList[ErgPtr][0]);
                             If  (ErgList[ErgPtr][0]=#0)
                             or ((ErgList[ErgPtr][0]=#1)
                             and (ErgList[ErgPtr][1]='-'))
                             Then ErgList[ErgPtr]:= '0';
                           END;
      ' '                : InsertErg ('0');
      '='                : If Ops[ErgPtr-1]<>#0 Then
                           BEGIN
                             Ops[ErgPtr]:= '=';
                             Ergebnis;
                           END;
      ':', '+', '-', '*',
      'H', 'B'           : BEGIN
                             cTmp:= Ops[ErgPtr];
                             Ops[ErgPtr]:= t1;
                             If (ErgPtr>=ErgLen)
                             or (cTmp='=') or (cTmp=#0) Then InsertErg ('0');
                           END;

      'W', 'Q', 'S', 'O',
      'X', 'L', 'T', 'N',
      'Z'                : BEGIN
                             Umwandeln;
                             Ops[ErgPtr]:= '=';
                           END;
      'A'                : BEGIN ErgList[1]:= '0'; ErgPtr:= 1; ErgLen:= 1; Ops[1]:= #0; END;
      'I'                : ErgList[ErgPtr]:= GetStr (Pi);
      'U'                : If ErgList[ErgPtr][1]='-' Then delete (ErgList[ErgPtr], 1, 1) Else
                           Insert ('-', ErgList[ErgPtr], 1);
      'D'                : Mem:= 0;
      'R'                : ErgList[ErgPtr]:= GetStr (Mem);
      'P'                : BEGIN
                             Val (ErgList[ErgPtr], a1, c);
                             If ((a1<= 1.0E+2460) and (Mem<= 1.0E+2460))
                             or ((Mem<=0)         and (a1>=0)) Then
                             Mem:= Mem+a1 Else ErrorMsg(ToBig);
                           END;
      'M'                : BEGIN
                             Val (ErgList[ErgPtr], a1, c);
                             If ((a1<= 1.0E+2460) and (Mem>=-1.0E+2460))
                             or (Mem=0) or (Mem>=a1-1) Then
                             Mem:= Mem-a1 Else ErrorMsg (ToBig);
                           END;
      ''                : ErgList[ErgPtr]:= '1.95586';
    END Else
    CASE t2 Of
      F3   : BEGIN
               RewriteClip;
               WriteClipLine (ErgList[ErgPtr]+' '+Ops[ErgPtr]);
               CloseClip;
             END;
      F4   : BEGIN
               RewriteClip;
               For c:= 1 To ErgPtr Do
               WriteClipLine (ErgList[c]+' '+Ops[c]);
               CloseClip;
             END;
      CF4  : BEGIN
               ResetClip;
               If (Ergptr=1) and (Ops[1]=#0) Then dec (ErgPtr);
               While not EofClip Do
               BEGIN
                 Tmp:= Trim (GetClipLine);
                 If Tmp<>'' Then
                 BEGIN
                   cTmp:= Tmp[Length(tmp)];
                   If (cTmp<'0') or (cTmp>'9') Then
                   tmp:= Trim (copy(tmp, 1, Length(tmp)-1)) Else
                   cTmp:= #0;
                   Val (tmp, a1, c);
                   If c=0 Then BEGIN InsertErg (Tmp); Ops[ErgPtr]:= cTmp; END;
                 END;
               END;
               CloseClip;
             END;
      Up   : ScrollUp; 
      Down : ScrollDown;
      Pos1 : ErgPtr:= 1;
      Endx : ErgPtr:= ErgLen;
    END;

  UNTIL (t1=#27) or (t1='E');

  MouseOff; ClearWin (1, 1, 80, 25, 7);
END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
