
PROGRAM CleanDisk;
{$M 10000, 0, 0}

USES
  BIOSCrt, Strings, DOS, keycode, DirOp, Masken, rechnen;

CONST
  MaxEnd = 11;

TYPE
  EndArr = Array[1..MaxEnd] Of String[4];

CONST
  R        = '$$$$';
  ProgName = 'CLEANDSK';
  Ask      = 'Diese Datei lschen?                           J-a     N-ein     A-lle     E-nde';

  EArr   : EndArr  = ('*.*', '.EXE', '.COM', '.SYS', '.BAT', '.PAS', '.ASM', '.LIB', '.INI', r, r);
  t      : Char    = 'J';
  Result : Word    = 0;
  Test   : Boolean = FALSE;
  Abbruch: Boolean = FALSE;
  ReadOn : Boolean = FALSE;
  All    : Boolean = FALSE;
  SubDirs: Boolean = TRUE;
  k1     : LongInt = 0;

VAR
  Pfad, Objekt : PathStr;
  TmpObject    : PathStr;
  ClustSize    : Word;
  i            : Byte;
  Param        : PathStr;
  temp         : String;

CONST
s1='bereinigt Datentrger oder Verzeichnisbume von unerwnschten Dateien.'#13#10#13#10+
   'CLEANDSK [zu durchsuchendes Verzeichnis] [gesuchte Datei(en)] [Parameter]'#13#10#13#10+
   '/a   lscht alle Dateien ohne vorherige Nachfrage'#13#10;
s2='/r   lscht auch schreibgeschtzte und versteckte Dateien'#13#10+
   '/t   Lschvorgang nur testen'#13#10+
   '/u   lscht keine Dateien in Unterverzeichnissen'#13#10#13#10;
s3='Jede Datei wird zum Lschen vorgelegt. CLEANDSK ohne Parameter zeigt eine'#13#10+
   'Eingabemaske. Mehrere Dateien knnen durch ein + verbunden angegeben'#13#10+
   'werden (z.B. cleandsk c:\ *.BAK+*.SIK+*.TMP)'#13#10;


PROCEDURE GetClusterSize (LW : Char); assembler;
ASM
  mov ah, $36
  mov dl, LW
  sub dl, 64
  int $21
  mul cx
  mov ClustSize, ax
END; {Sektoren Pro Cluster in ax, Anzahl Bytes pro Sektor in cx}



PROCEDURE Frage;
BEGIN
  REPEAT t:= UpReadKey; If (t='E') or (t=#27) Then EndeProc; UNTIL
  (t='J') or (t='N') or (t='A');
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Pfad, 'Verzeichnis oder Laufwerk, das CleanDisk nach Dateien durchsuchen soll:');
  Pfad:= UpCaseStr (Pfad);
  If Pfad = '' Then ErrorEnd ('Ungltige Verzeichnisangabe');

  a2:
  EditStr (6, Objekt, 'Name der zu lschenden Datei(en):');
  If t2=Up Then Goto a1;
  If Objekt = '' Then ErrorEnd ('Ungltiger Dateiname');

  a3:
  ParamField (12, ReadOn, 'auch schreibgeschtzte und versteckte Dateien lschen');
  If t2=Up Then Goto a2;

  a4:
  ParamField (13, All,    'alle Dateien ohne weitere Nachfrage lschen');
  If t2=Up Then Goto a3;

  a5:
  ParamField (14, Test,   'Lschvorgang nur testen');
  If t2=Up Then Goto a4;

  a6:
  ParamField (15, SubDirs,'auch Dateien in Unterverzeichnissen lschen');
  If t2=Up Then Goto a5;
END;



PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;



PROCEDURE OutName (Name : PathStr);
BEGIN
  DosLineFeed;
  DosStr ('- ');
  DosStr (DownCaseStr (Name));
  DosStr (FillString (20-Length (Name)));
END;



PROCEDURE List (S : PathStr);
VAR
  f : File;
  r : Searchrec;
  y : Byte;
BEGIN
  TmpObject:= Objekt; y:=0;
  While Objekt<>'' Do
  BEGIN
    Findfirst (Vollpfad (S, TeilStr (Objekt)), anyfile, r);
    While DOSError = 0 Do
    BEGIN
      If  (r.attr and (directory or VolumeID or sysfile) = 0)
      and ((ReadOn) or (r.attr and (readonly or hidden)  = 0)) Then
      BEGIN
        If y=0 Then BEGIN DosLineFeed; DosStr (S); y:=1; END;
        OutName (r.Name);
        If t<>'A' Then Frage;
        CASE t Of
          'J', 'A' : BEGIN
                       Assign (f, Vollpfad (S, r.name));
                       If not Test Then SetFAttr (f, 32); Result:= DOSerror;
                       If Result=0 Then
                       BEGIN
                         inc (k1, (r.Size DIV ClustSize + ord (r.Size MOD ClustSize<>0)) * ClustSize);
                         If not Test Then
                         BEGIN
                           Erase (f); Result:=IOResult;
                           If Result=0 Then DosStr ('Datei gelscht');
                         END Else DosStr ('Lschen nur getestet');
                       END;
                       If Result<>0 Then
                       BEGIN
                         DosStr ('Datei konnte nicht gelscht werden. DOS-Fehler : ');
                         DosNum (DosError);
                       END;
                     END;
          'N'      : DosStr ('Datei nicht gelscht');
        END;
      END;
      Findnext (r);
    END;
  END;
  Objekt:= TmpObject;
  If keypressed Then Frage;
END;



PROCEDURE Rekursiv (S : PathStr);
VAR
  tx : Searchrec;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), 63, tx);
  While DOSError=0 Do
  BEGIN
    If (tx.attr and 16<>0) and (tx.name[1]<>'.') Then
    BEGIN List (Vollpfad (S, tx.name)); Rekursiv (Vollpfad (S, tx.name)); END;
    Findnext (tx);
  END;
END;


{----------------------------- Hauptprogramm --------------------------------}
BEGIN
  StretchParam (temp);
  GDir (0, temp); 

  If ParamCount = 0 Then BEGIN Objekt:= '*.*'; Pfad:= temp; Maske END Else 
  BEGIN
    Objekt:= ''; Pfad:= '';
    For i:= 1 To ParamCount Do
    BEGIN
      Param:= UpcaseStr (ParamStr (i));
      If Param[1]='/' Then
      CASE Param[2] Of
        '?' : BEGIN
                StandardKopf (ProgName, CopyRight);
                DosStr (s1); DosStr (s2); DosStr (s3); Waitkey; Halt;
              END;
        'T' : Test   := TRUE;
        'R' : ReadOn := TRUE;
        'A' : All    := TRUE; 
        'U' : SubDirs:= FALSE;
      END
      Else
      CASE i Of
        1 : Pfad  := Param;
        2 : Objekt:= Param;
      END;
    END;
    If Objekt= '' Then
    If Pfad  = '' Then
    ErrorEnd ('Parameter fehlen') Else
    BEGIN Objekt:= Pfad; Pfad:= temp; END;
  END;

  StandardKopf (ProgName, '');

  For i:= 1 To MaxEnd Do
  If pos (EArr[i], UpCaseStr (Objekt)) <> 0 Then ErrorEnd ('CLEANDSK durch Lschsperre beendet');

  GetClusterSize (Pfad[1]);

  If All Then t:= 'A'; Fusszeile (Ask); GotoXY (1, 1);

  List (Pfad);
  If SubDirs Then Rekursiv (Pfad);

  Fusszeile ('Freigewordener Speicherplatz in kB:  '+LongStr(k1 shr 10));
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
