.include Param

jmp BEGIN 
DB                      1     ; VersionsNummer des Treibers 
DB                      9     ; Treiber-Nummer zur berprfung d. UnKeyb
DB                      1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB                      09h   ; Nummer eines der umgeleiteten Interrupts 
DB                      0     ; Zahl der erwarteten Start-Parameter
 
Flag                DB  0

OBJECT InDOS
  Ofs               DW  0         ; Segment und Offset des InDosBytes,
  Seg               DW  0         ; steht auf 1, wenn DOS-Int gerade aktiv
OBJECT END

VideoAddr           DW  $B000 

ScrPtr              DW  0
BufEnd              DW  0
ScreenSize          DW  2000      ; Gre des Bildschirmausschnittes
BufSize             DW  2060      ; incl. Zeilenumbrche, FormFeed o..
 
scrEmpty           EQU  0         ; Puffer leer
scrCharsExist      EQU  1         ; Puffer enthlt Zeichen
scrBusy            EQU  2         ; Timer sendet gerade oder soll senden

SendKeys            DB  scrEmpty  ; steht auf 0, wenn kein Zeichen vorhanden
                                   
Start               DW  0         ; Erstes Zeichen
CharNum             DW  2000      ; Zahl der zu bernehmenden Zeichen
F11Count            DB  0         ; Zhlt, wie oft F11 gedrckt
StartBX             DW  80
LiRand              DB  0         ; zum bergehen fhrender Leerzeichen
Printer             DW  0         ; BIOS-Drucker-Nummer
PrintScreen         DB  0         ; wenn<>0: ClipBoard zum Drucker senden 
NoTrim              DB  0         ; 1=Leerzeichen am Zeilenanfang nicht lschen

PROC GetScreen:
  push bx, cx, dx, si, di, es, cs / pop es
  lea  di, &ScreenBuf
  mov  cx, CharNum                ; Zahl der zu bernehmenden Zeichen
  inc  cx
  mov  si, Start
  add  si, si                     ; Zeiger auf erstes zu bernehmendes Zeichen 
  mov  bx, StartBX
  mov  ds, VideoAddr
  xor  dx, dx                     ; Zeichenzhler
  cld
  @nochmal:
    inc dx
    lodsw
    stosb
    dec bx
    jnz @jut
      push cx                     ; Leerzeichen am Zeilenende lschen
        std
        dec  di
        mov  cx, 80
        mov  al, 32
        repe scasb
        inc  di
        inc  di
        inc  dx
        mov  bx, 80
        sub  bx, cx
        sub  dx, bx
        cld
      pop cx
      mov al, 13 / stosb / inc dx      ; Zeilenumbruch senden 
      mov bx, 80               
    @jut:
  loop @nochmal
  push cs / pop ds
  mov  BufEnd, dx
  mov  al, scrCharsExist
  mov  SendKeys, al
  pop  es, di, si, dx, cx, bx
  RET
ENDP

PROC PrintCL
  push ax, dx, cx             ; CX hinten lassen!
  mov  cx, 16 ; WaitTimes
  @warte:                     ; Wartet auf "Drucker not busy"
    mov  ah, 2
    mov  dx, 0 ; Printer
    int  17h
    test ah, 00010000b        ; Online und Papier? = 00010000b
    jz   @noPrint             ; wenn nicht, raus
    and  ah, 10111000b        ; not Busy, Online, PaperOut
    cmp  ah, 10010000b
    je   @drucken             ; Bit 7 gesetzt, es kann also ohne
  loop @warte                 ; Verzgerung gedruckt werden
  jmp short @noPrint

  @drucken:
  pop  ax                     ; Inhalt von CX in AX
  push ax
  xor  ah, ah
  mov  dx, 0 ; Printer
  int  17h
  clc
  jmp short @raus

  @noPrint:
  stc
  @raus:
  pop cx, dx, ax
  ret
ENDP

PROC Print
  #PrintCL
  jc @ende
    cmp cl, 13
    jne @ende
      mov cl, 10
      #PrintCL
  @ende:
  ret
ENDP

PROC SetScreen:
  push ax, ds, cs / pop ds
  mov  ax, ScrPtr
  cmp  ax, BufEnd
  jae  @fertig
    push bx, cx, si
    mov  bx, ax
    lea  si, &ScreenBuf
    @Zeichen:
       mov cl, [si+bx]
       xor ch, ch
       cmp cl, 13             ; Bei Enter Tasten-Nummer 28
       jne @abb
       mov ch, 28             ; erforderlich
       mov Byte LiRand, 1
       jmp short @OutChar
       @abb:
       cmp Byte NoTrim, 1     ; fhrende Leerzeichen bergehen?
       je @NoTrim
       cmp cl, 32             ; fhrende Leerzeichen bergehen
       je @weiter
         @NoTrim:
         mov Byte LiRand, 0
         jmp short @OutChar
       @weiter:
       cmp Byte Lirand, 1
       je @Over

       @OutChar:              ; Zeichen senden
       mov al, PrintScreen
       or  al, al
       jz  @SendKey
         #Print
         jnc @Over            ; Weiterdrucken
         jmp short @xraus

       @SendKey:
         mov ah, 5
         int 16h
         or  al, al           ; 0=Okay, 1=Tastapuffer voll
         jnz @xraus

       @Over:
       inc bx
       cmp bx, BufEnd         ; Puffer-Ende erreicht?
       jb  @Zeichen           ; wenn ja, dann raus
         mov al, PrintScreen
         or  al, al
         jz  @xraus
         push dx
         mov dx, 0
         mov ax, 12
         int 17h
         pop dx
    @xraus:
    mov ScrPtr, bx
    pop si, cx, bx
    jmp short @weg
  @fertig:
  mov  al, scrCharsExist
  mov  SendKeys, al
  xor  ax, ax
  mov  ScrPtr, ax        ; Zeiger wieder auf erstes Zeichen
@weg:
  pop  ds, ax
  RET
ENDP


PROC WhereXY:
  push bx, dx
  mov  ah, 3
  mov  bh, 0
  int  10h
  mov  bx, dx
  mov  al, dh
  xor  ah, ah
  mov  dh, 80
  mul  dh
  xor  bh, bh
  add  ax, bx             ; Offset des Cursors auf Monitor errechnen

  mov  dl, F11Count
  @w0:
  inc  dl
  cmp  dl, 1 / je  @w1
  cmp  dl, 2 / je  @w2      / xor dl, dl      / jmp short @w0
  @w1:/mov Word StartBX, 80 / sub Startbx, bx
       mov Start, ax        / jmp short @w3 
  @w2:/cmp ax, Start        / jae @w4         / xchg ax, Start
       mov Word StartBX, 80 / sub Startbx, bx  
  @w4:/sub ax, Start        / mov CharNum, ax / #GetScreen
  @w3:
  mov  F11Count, dl
  pop  dx, bx
  RET
ENDP


; ---------------------- Tastatur-Prf-Routine -----------------------------

Keyboard:
  pushf                                     
  DB 9Ah                      ; Call Far Ptr = alte Tastaturroutine
  OBJECT Old09:
    Ofs DW '6.'               ; hier setzt der Loader die alte Adresse
    Seg DW '24'               ; der alten Tastatur-Routine ein.
  OBJECT END
  push ds, cs / pop ds

  cmp Byte Flag, 0
  jne @KeyEnde
 
  push ax
  in   al, 60h 

  cmp  al, 'W'                ; F11 gedrckt ?
  jne  @weiter
    mov  al, SendKeys
    cmp  al, scrBusy          ; Timer gerade beim Senden der Zeichen?
    je   @ganzraus            ; wenn ja, erst fertig werden lassen, also raus

    mov  ah, 02h              ; Tastatur-Status-Byte holen
    int  16h
    test al, 00000011b        ; Shift links oder rechts ?
    jnz  @Shift
      #WhereXY
      jmp short @ganzraus
    @Shift:
    xor ax, ax
    mov Start, ax
    mov F11Count, al
    mov ax, ScreenSize
    mov CharNum, ax
    mov ax, 80
    mov StartBX, ax
    #GetScreen                ; dann Bildschirm sichern
    jmp short @ganzraus
  @weiter:

  cmp  al, 'X'                ; F12 gedrckt ?
  jne @ganzraus
    mov al, SendKeys
    or  al, al                ; Sind berhaupt Zeichen im Puffer ?
    jz  @ganzraus

    cmp al, scrBusy
    jne @senden
      mov ax, BufEnd
      mov ScrPtr, ax
    @senden:

    mov ah, 02h               ; Tastatur-Status-Byte holen
    int 16h
    and al, 00000011b         ; nur "Shift links oder rechts"-Flag stehenlassen
    mov PrintScreen, al       ; PrintScreen<>0: Drucken, =0: an Tastatur senden

    mov al, scrBusy           ; dann Bildschirm in Tasta-Puffer
    mov SendKeys, al          ; Nachricht an Timer: Zeichen senden!

@GanzRaus: 
  pop ax

@KeyEnde:
  pop ds
IRET                                     

 
; -------------------------- Neuer Timer ----------------------------------

TSR:
  pushf
  DB 9Ah                     ; Call Far Ptr [alter Timer]
  OBJECT Old1C:
    Ofs DW   '6.'            ; hier setzt der Loader die alte Adresse
    Seg DW   '24'            ; der alten Int-Routine ein.
  OBJECT END
  push ax
  cs:
  mov  al, Flag
  shr  al, 1
  jc   @Unload
  jnz  @TSREnde

  cs:
  cmp  Byte SendKeys, scrBusy
  jne  @TSRende

  #SetScreen
  jmp short @TSRende

@Unload:                  
  push ds, dx, es, di, cs / pop ds

  les  di, InDOS           ; Error- und IndosFlag holen...  
  mov  ax, es:[di]
  or   ax, ax              ; ...und prfen, ob beide = 0
  jnz  @Wech

  lds  dx, Old09           ; Alte Adressen laden 
  mov  ax, 2509h           ; SetIntVec 09h
  int  21h                 ; Alte Tastaturroutine wieder einsetzen

  cs:
  lds  dx, Old1C           ; Alte Adressen laden 
  mov  ax, 251Ch           ; SetIntVec 1Ch
  int  21h                 ; Alte INT 1Ch-Routine wieder einsetzen

  push cs / pop es
  mov  ah, 49h             ; Speicher von CLIP.COM wieder freigeben
  int  21h                 ; ES=CS=Segment des freizugebenden Blocks 

@wech:
  pop  di, es, dx, ds

@TSRende:
  pop  ax
IRET


;------------------------------- Loader ------------------------------------
 
&ScreenBuf DB 'AO'

ProgSize EQU ($:16+2)         ; Programmgre in Paragraphen

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &Progname
  #Output

  #Paramcount
  mov  cx, ax
  jcxz @laden_1
  lea  si, &ParamBuf
  @NextParam:
    #ParamStr (cx, si)
    mov  al, [si+1]            ; Zeichen nach '/' laden
    and  al, 11011111b         ; UpCase
           cmp al, 'N' / jne @xp / mov Byte NoTrim, 1            / jmp short @loop
    @xp: / cmp al, 'L' / jne @xd / #GetPrinter/ jc @out          / jmp short @loop 
    @xd: / cmp al, 'D' / jne @xx 
           shl Word BufSize,    1
           shl Word ScreenSize, 1
           shl Word CharNum,    1/ jmp short @loop
    @xx: / cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
    @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
    @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
    @xh:                                      / lea dx, &Hilfe   / jmp short @out
    @loop:
  loop @NextParam

@laden_1:
jmp short @laden

@entladen:
  push dx, bx
  mov  ax, 3509h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  lea  dx, &Unload

@out:
 #OutPut
.HALT

@Laden:
  -EnvironMemFree
  -GetVideoAddr
 
  mov  ax, 3400h       ; steht das InDOS-Byte auf 0, ist DOS inaktiv,
  int  21h             ; der Int 21h kann also aufgerufen werden
  mov  InDos.Seg, es
  dec  bx              ; mit ErrorFlag
  mov  InDos.Ofs, bx
 
  push cs / pop es
  mov  bx, BufSize     ; Testen, ob gengend Speicher fr Puffer
  mov  cl, 4           ; in Paragraphen
  shr  bx, cl
  add  bx, ProgSize
  mov  ah, 4Ah
  int  21h
  jnc  @exec           ; alles klar, dann los!
    lea dx, &NoMem
    jmp short @out
  @exec:
 
  mov  ax, 3509h              ; GetIntVec 09h
  int  21h                                
  mov  Old09.Ofs, bx          ; Schreibe alten Vektor in den Call-Befehl
  mov  Old09.Seg, es
  mov  ax, 2509h              ; SetIntVec 09h
  lea  dx, Keyboard           ; mov dx, Offset Keyboard, DS bereits Segment
  int  21h

  mov  ax, 351Ch              ; GetIntVec 1Ch
  int  21h                                
  mov  Old1C.Ofs, bx          ; Schreibe alten Vektor in den Call-Befehl
  mov  Old1C.Seg, es     
  mov  ax, 251Ch              ; SetIntVec 1Ch
  lea  dx, TSR                ; mov dx, Offset TSR, DS bereits Segment
  int  21h

  lea  dx, &Load
  #OutPut              ; Gebe Text aus                  
  
  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
  add  dx, BufSize
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen


PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

PROC GetPrinter
  mov al, [si+2]             ; Ziffer '/L' laden
  cmp al, '1' / jb @error
  cmp al, '4' / ja @error
  sub al, 49
  xor ah, ah
  mov Printer, ax
  clc
  ret
  @error:
  lea dx, &NoPrinter
  stc
  ret
ENDP
 
.insert copyrigh

.ifopt deu 
  &ProgName  DB  'CLIP  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'anwendungsbergreifende Zwischenablage (ClipBoard)',13,10,13,10
  >              'Laden  : CLIP [/d /n /Lx]  (Parameter optional)',13,10
  >              'Steuern: CLIP [/x|/s|/r]',13,10,13,10
  >'/x  aus dem Speicher entfernen',13,10
  >'/s  stillegen',13,10
  >'/r  reaktivieren',13,10
  >'/d  doppelte Puffergre fr 50-Zeilen-Modus',13,10
  >'/n  unterdrckt das Lschen von Leerzeichen am Zeilenanfang',13,10
  >'/Lx Drucker fr PrintScreen: L1=LPT1, L2=LPT2 ... L4=LPT4 (k.A.=LPT1)', 13,10,13,10
  >'Steuertasten:',13,10
  >'SHIFT+F11  speichert gesamten Bildschirminhalt',13,10
  >'SHIFT+F12  sendet gespeicherten Inhalt an den Drucker',13,10
  >'F11        1. Mal: speichert Cursorposition',13,10
  >'           2. Mal: speichert Bildschirminhalt zwischen 1. und aktueller',13,10
  >'                   Cursorposition',13,10                     
  >'F12        1. Mal: fgt gespeicherten Inhalt in Zielanwendung ein',13,10
  >'           2. Mal: bricht Einfgen ab$'

  &NoMem     DB  'Nicht gengend Speicher$'
  &NoPrinter DB  'Ungltige Druckerangabe - mglich sind /L1 /L2 /L3 oder L4$'
.endopt 

.ifopt eng
  &Progname  DB  'CLIP  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Install a clipboard to exchange data between programs'
  >               13,10,13,10
  >              'Install: CLIP [/d]  (parameter optional)',13,10
  >              'Control: CLIP [/x|/s|/r]',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate',13,10 
  >              '/d  Double buffer size for 50-line-mode (EGA)',13,10,13,10
  >'Control keys:',13,10
  >'SHIFT+F11  Saves entire screen to clipboard', 13,10
  >'F11        1st time: Saves cursor position',13,10
  >'           2nd time: Copies screen between saved and current',13,10
  >'                     cursor position to clipboard',13,10                     
  >'F12        1st time: Insert contents of clipboard into current program',13,10
  >'           2nd time: Abort insertion$'

  &NoMem     DB  'Not enough memory$'
  &NoPrinter DB  'Invalid Printer - choose /L1 /L2 /L3 or L4$'
.endopt

&ParamBuf DB  'PARAMBUF'
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
