
jmp BEGIN 
DB                  1     ; VersionsNummer des Treibers 
DB                  4     ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0   ; interne Nummer (vom Programmierer frei whlbar) 
DB                  1Ch   ; Nummer eines der umgeleiteten Interrupts 
DB                  0     ; Zahl der erwarteten Start-Parameter
 
Flag            DB  0
VideoAddr       DW  $B000 
Counter         DB  18    ; Zhlt die Timerticks
Alarm           DB  0     ; 0= Kein Alarm 1=Alarm prfen 2=Alarm geben
Hour            DB  0     ; Alarmstunde
Min             DB  0     ; AlarmMinute
ShowTime        DB  1     ; Soll bei Alarm die Zeit angezeigt werden? (0=nein)


;----------------------- Unterfunktionen ---------------------------------
 
PROC Sound:           ; Frequenz in AX bergeben
  push bx,  dx
  mov  bx,  ax
  mov  ax,  34DDh
  mov  dx,  0012h
  cmp  dx,  bx
  jnb  @raus
  div  bx
  mov  bx,  ax
  in   al,  61h
  test al,  3
  jnz  @weiter
  or   AL,  3
  out  61h, AL
  mov  AL,  0B6h
  out  43h, AL
@weiter:
  mov  al,  bl
  out  42h, al
  mov  al,  bh
  out  42h, al
@raus:
  pop  dx,  bx
  RET
ENDP


PROC NoSound:
  push ax
  in   al,  61h
  and  al,  0FCh
  out  61h, al
  pop  ax
  RET
ENDP
 

PROC OutTime:
  mov ch, al             ; al sichern
  mov al, ah
  stosb  
  inc di
  mov al, ch
  shr al, 1              ; MSD von al
  shr al, 1
  shr al, 1
  shr al, 1
  add al, $30            ; in ASCII umwandeln
  stosb
  inc di                 ; Anzeigen
  mov al, ch             ; al zurckholen
  and al, $0F            ; nur LSD interessant 
  add al, $30            ; in ASCII umwandeln
  stosb
  inc di                 ; Anzeigen
  RET
ENDP


WriteTime:  
  pushf
  DB 9Ah                  ; CALL Far Ptr = alte Int-1Ch-Routine
  OBJECT Old1C:
    Ofs DW '6.'           ; hier setzt der Loader die alte Adresse
    Seg DW '24'           ; der alten Int-1Ch-Routine ein.
  OBJECT END
  push ax, ds, cs / pop ds

  mov  al, Flag
  shr  al, 1
  jc   @Unload
  jnz  @OnlyOld
 
  push dx, es, cx, di

  mov  ah, 2              ; Funktion 2 (Lies RTC-Zeit)
  int  1Ah                ; BIOS: "RTC services"

  mov  al, Alarm
  shr  al, 1
  jc   @CheckAlarm
  jz   @OutTime

  #nosound
  mov  al, Counter
  dec  al
  jnz  @w1
    mov ax, 1500
    #Sound
    mov al, 18
  @w1:
  mov Counter, al
  jmp short @OutTime

@CheckAlarm:
  cmp  ch, Hour
  jb   @OutTime
  cmp  cl, min
  jb   @OutTime
  mov  Byte Alarm, 2

@OutTime: 
  cmp  Byte ShowTime, 0   ; soll Zeit gezeigt werden?
  je   @wech
  mov  es, VideoAddr      ; Segment Video-RAM
  mov  di, 142            ; Offset im Videospeicher
  cld                     ; vorwrts schreiben
  mov  ah, 32             ; fhrendes Leerzeichen
  mov  al, ch             ; Stunden in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, cl             ; Minuten in al
  call OutTime            ; umwandeln und anzeigen
  mov  ah, ':'            ; Doppelpunkt dazwischen
  mov  al, dh             ; Sekunden in al
  call OutTime            ; umwandeln und anzeigen
  @wech:
  pop  di, cx
  jmp  short @GanzRaus
 
@Unload:
  #NoSound                ; sonst piept der Alarm evtl. ewig
  push dx, es
  lds  dx, Old1C          ; Alte Adressen laden 
  mov  ax, 251Ch          ; SetIntVec 1Ch
  int  21h                ; Alte INT 1Ch-Routine wieder einsetzen

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von CLOCK.COM wieder freigeben
  int  21h                ; ES=CS=Segment des freizugebenden Blocks 

@GanzRaus:
  pop  es, dx

@OnlyOld:
  pop  ds, ax
IRET


; ------------------------------ Loader --------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &Progname
  #OutPut

  cld
  mov  ax, 6200h              ; Adresse des PSP ermitteln
  int  21h                   
  mov  es, bx                 ; Segment des PSP in ES
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase

         cmp al, 'V' / jne @xa / mov Byte ShowTime, 0 / mov al, 'A'
  @xa: / cmp al, 'A' / jne @xx / #GetTime   / mov Byte Alarm,1 / jmp short @laden
  @xx: / cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 351Ch
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  int  1Ch                            ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree
  -GetVideoAddr

  lea  dx, &Load
  #output                    ; Gebe Text aus                  

  mov  ax, 351Ch       ; GetIntVec 1Ch
  int  21h                                
  mov  Old1C.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old1C.Seg, es 

  mov  ax, 251Ch       ; SetIntVec 1Ch
  lea  dx, WriteTime   ; = mov dx, Offset WriteTime, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen

PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP


PROC Konvert:
  sub  al, 48 / sub ah, 48
  mov  cl, 4
  shl  al, cl
  or   al, ah
  RET
ENDP


PROC GetTime:
  inc di
  mov ax, es:[di] / #konvert / mov hour, al
  add di, 3
  mov ax, es:[di] / #konvert / mov min,  al
  RET
ENDP

.insert copyrigh
 
.ifopt deu
  &ProgName  DB  'CLOCK  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'blendet eine laufende Uhr mit Alarmfunktion ein',13,10,13,10
  >              'Laden  : CLOCK [/a|/v]  (Parameter optional)',13,10
  >              'Steuern: CLOCK [/x|/s|/r]',13,10,13,10
  >'/a  Alarmzeit einstellen (z.B. /a12:30 fr 12.30 Uhr)',13,10
  >'/v  wie /a, es wird jedoch keine Uhrzeit angezeigt' ,13,10,13,10
  >'/x  aus dem Speicher entfernen',13,10
  >'/s  stillegen',13,10
  >'/r  reaktivieren$' 
.endopt
 
.ifOpt eng
  &Progname  DB  'CLOCK  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Displays an alarm clock'
  >               13,10,13,10
  >              'Install: CLOCK [/a|/v]  (Parameters optional)',13,10
  >              'Control: CLOCK [/x|/s|/r]',13,10,13,10
  >'/a  sets an alarm (e.g. /a12:30 for 12:30 o',"'",'clock)',13,10
  >'/v  like /a, but the clock will not be displayed',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
