UNIT cmd_auto;

INTERFACE
USES
  Dos, Monitor, Monitcmd, cmd_var, cmd_main, mouse,
  strings, schilder, dosX, viewer;


PROCEDURE Hilfe           (Datei : FStr);
PROCEDURE Check_Param     (SStr : EStr; Objekt : String);
PROCEDURE Check_Variables (b : Byte);
PROCEDURE Erwdatei        (de : EStr);



IMPLEMENTATION


PROCEDURE Hilfe (Datei : FStr);
BEGIN
  Insert ('.HTM', Datei, 255);
  If FileExist (VollPfad (Comdir, HelpDir+Datei)) Then
  BEGIN
    GetScreen50 (screen^);
    x25_Zeilen;
    DosShell (Vollpfad (ComDir, Browser) + ' ' +
              VollPfad (Comdir, HelpDir+Datei));
    Sign:= 7;
    x50_Zeilen; SetScreen50 (Screen^); GetBack:=0;
  END Else
  HinweisFenster (1009, Datei);
END;



PROCEDURE Check_Param (SStr : EStr; Objekt : String);
VAR
  PPos : Byte;
BEGIN
  Ppos:= pos (SStr, UpStr (RC.Befehl));
  While Ppos<>0 Do
  BEGIN
    delete (RC.Befehl, PPos, 3);
    insert (Objekt, RC.Befehl, Ppos);
    CASE SStr[2] Of
      'H' : BEGIN
              SetScreen50 (Screen^); GetBack:=0;
              Hilfe (RC.Befehl);
            END;
      'D' : BEGIN
              x25_Zeilen;
              DosShell (RC.Befehl);
              GetScreen25 (screen^[8001]);
              Sign:= 7;
              x50_Zeilen; SetScreen50 (Screen^); GetBack:=0;
            END;
      'V' : BEGIN
              SetScreen50 (Screen^); GetBack:=0;
              FileView (RC.Befehl);
            END;
    END;
    Ppos:= pos (SStr, UpStr (RC.Befehl));
  END;
END;


FUNCTION Slash (Pfad : PathStr) : Str1; assembler;
ASM
  push ds
  cld
  lds si, Pfad
  lodsb; or al, al; jz @schreibe;
  xor ah, ah; dec ax; add si, ax;
  lodsb; mov ah, '\'; cmp al, ah; jne @los; xor al, al; jmp @schreibe
@los:
  mov al, 1
@schreibe:
  les di, @Result
  stosW
  pop ds
END;
{ je nachdem, ob der Pfad ein Slash am Ende enthlt, wird entweder das
  Slash oder ein Leerstring zurckgegeben }


FUNCTION GetPrefix (ein : String) : String;
BEGIN
  If pos ('.', ein) <= 1 Then GetPrefix:= ein Else
  GetPrefix:= GetFilePrefix (ein);
END;


PROCEDURE Check_Variables (b : Byte);
BEGIN
  Check_Param ('[Q]', Listen[dd].Dateiname);
  Check_Param ('[P]', RC.FensterPfad[ax]+Slash(RC.FensterPfad[ax]));
  Check_Param ('[Z]', DelLastSlash (RC.FensterPfad[ax1]));
  Check_Param ('[C]', ComDir);
  Check_Param ('[E]', RC.Editor);
  Check_Param ('[X]', GetPrefix (Listen[dd].Dateiname));
  Check_Param ('[S]', GetFileExt(Listen[dd].Dateiname));
  If RC.Win95 Then Check_Param ('[W]', 'START') Else
  If RC.Win3x Then Check_Param ('[W]', 'WIN');
  If b=1 Then Exit;
  Check_Param ('[H]', '');
  Check_Param ('[D]', '');
  Check_Param ('[V]', '');
END;



PROCEDURE Erwdatei (de : EStr);
VAR
  s     : String;
  InBuf : Array[1..10000] Of Char;

BEGIN
  Sign:= 21;
  FileMode:=0;

  Assign (xf, 'AUTOSTAR.INI');
  Reset (xf);
  If IOResult <> 0 Then
  BEGIN
    Assign (xf, Vollpfad (Comdir, 'AUTOSTAR.INI'));
    Reset (xf);
    If IOResult <> 0 Then Exit;
  END;
  SetTextBuf (xf, InBuf, SizeOf (InBuf));

  If pos ('_', de)=3 Then de:='??_';

  While (not Eof (xf)) and (Sign=21) Do
  BEGIN
    ReadLn (xf, s);
    If (Length(s)<>0) and (UpStr(Trim(nthField (s, ':', 1)))=de) Then
    BEGIN
      RC.Befehl:= Trim (FromNthField (s, ':', 2));
      Check_Variables (1);
      Sign:=2;
    END;
  END;

  Close (xf);
  FileMode:=2;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
