UNIT cmd_back;

INTERFACE
USES
  DOS, bioscrt, cmd_var, strings, monitor, back_cop, time, PageDev;

CONST
  HG_Run : Byte = 0;


PROCEDURE Set_Copy_Params;
PROCEDURE Set_Print_Params;
PROCEDURE HG_Proc;


IMPLEMENTATION
USES
  Printex;  { wegen Circular Referenz mit CMD_Main }

TYPE
  PrintKillMode = (Okay, Error);

CONST
  HG_CFile_Open : Byte   = 0;
  HG_inc        : Word   = 1;

VAR
  HG_QFNameC, HG_ZFNameC : PathStr;
  HG_QAttr               : Word;
  HG_QCFile,  HG_ZCFile  : File;
  HG_QTime               : LongInt;
  Fileinc                : Word;


PROCEDURE Piep (s : Byte);
BEGIN
  Sound (1000 * s); xDelay (100); Nosound;
END;


PROCEDURE Alarm (s : Byte);
VAR
  x, z : Byte;
BEGIN
  z:=3;
  For x:= 1 To 8 Do
  BEGIN
    If s=2 Then z:=x;
    Sound (x * 50 * z);
    xDelay (70);
    NoSound;
    xDelay (70);
  END;
END;


PROCEDURE Set_Copy_Params;
BEGIN
  If (HG_run and 1 <> 0) Then
  BEGIN 
    WriteXY (22, 2,  StrVal(FileInc)+' von '+StrVal (FileNum), 4, 7);
    xDelay  (1000);
    WriteXY (22, 2, '                ', 7, 7);
    Exit;
  END;
  FatalCError:=0; FileInc:=0;
  inc (HG_Run, 1); HG_CFile_Open:=0; HG_inc:=1;
  TempFile_anlegen; FileMode:=0;
  Assign (TempF, VollPfad (TempPath, 'BACK_COP.TMP'));
  Reset  (TempF);
  If (IOResult<>0) or (RC.FensterPfad[ax]=RC.FensterPfad[ax1]) Then
  BEGIN FatalCError:=1; OutChar (#7); dec (HG_Run, 1); Exit; END;
  Piep(1); 
END;


PROCEDURE Set_Print_Params;
BEGIN
  If (HG_run and 2 <> 0) Then Exit;
  PrintFName:= VollPfad (RC.FensterPfad[ax], Listen[dd].Dateiname);
  InitPageDev;
  inc (HG_Run, 2);
END;


PROCEDURE KillPrintThread (Mode : PrintKillMode);
BEGIN
  If TextRec(PrintedFile).Mode<>fmClosed Then Close (PrintedFile);
  If TextRec(Printer).Mode<>fmClosed     Then
  BEGIN FlushPageBuf (Printer, PageKonfig); Close (Printer); END;
  dec (HG_Run, 2); FileMode:=2;
  If Mode=Okay Then Piep (2) Else Alarm (2);
END;


PROCEDURE HG_SetOn_CZero;
BEGIN
  If FileRec(HG_QCFile).Mode<>fmClosed Then Close (HG_QCFile);
  If FileRec(HG_ZCFile).Mode<>fmClosed Then Close (HG_ZCFile);
  If (Eof (TempF)) or (FatalCError<>0) Then
  BEGIN
    dec (HG_Run, 1);
    If TextRec(TempF).Mode<>fmClosed Then Close (TempF);
    SetFAttr (TempF, 32); Erase (TempF);
    If (FatalCError<>0) or (FileInc<>FileNum) Then Alarm(1) Else Piep(1);
  END;
  HG_CFile_Open:=0; FileMode:=2; HG_inc:=1;
END;


PROCEDURE HGprint; 
VAR
  c : Char;
BEGIN
  If TextRec(PrintedFile).Mode=fmClosed Then
  BEGIN
    Assign (PrintedFile, PrintFName);
    Reset  (PrintedFile);
    If IOResult<>0 Then KillPrintThread (Error) Else
    BEGIN
      Assign  (Printer, PrinterName);
      Rewrite (Printer);
      If IOResult<>0 Then KillPrintThread (Error) Else Piep (2);
    END;
  END
  Else
  If not Eof(PrintedFile) Then
  BEGIN
    Read (PrintedFile, c);
    If IOResult<>0 Then KillPrintThread (Error) Else
    BEGIN
      WriteIntoPage (Printer, c, PageKonfig);
      If IOResult<>0 Then KillPrintThread (Error);
      If IsLastPage (Printer, PageKonfig) Then KillPrintThread (Okay);
    END;
  END Else
  KillPrintThread (Okay);
END;


PROCEDURE HGCopy;
CONST
  Max   = 2048;
VAR
  Sr    : Searchrec;
  ges   : Word;
  Block : array[1..Max] Of Byte;

BEGIN
  If HG_CFile_Open=0 Then
  BEGIN
    ReadLn (TempF, HG_QFNameC);
    ReadLn (TempF, HG_ZFNameC);

    FindFirst (HG_QFNameC, anyFile, sr);
    If (DOSerror<>0) Then Exit Else
    BEGIN
      If (sr.attr and directory<>0) Then
      BEGIN
        MkDir (HG_ZFNameC);
        If IOResult<>0 Then ges:=1; inc (FileInc); Exit;
      END Else
      BEGIN HG_QAttr:= sr.attr; HG_QTime:=sr.time; END;
    END;

    Assign (HG_QCFile, HG_QFNameC); FileMode:=0;
    Reset (HG_QCFile, 1); 
    If IOResult<>0 Then BEGIN FatalCError:=1; HG_SetOn_CZero; Exit; END;

    Assign (HG_ZCFile, HG_ZFNameC);
    SetFAttr (HG_ZCFile, 32); Rewrite (HG_ZCFile, 1);
    If IOResult<>0 Then BEGIN FatalCError:=1; HG_SetOn_CZero; Exit; END;

    HG_CFile_Open:=1;
  END
  Else
  If HG_inc > 0 Then
  BEGIN
    Blockread (HG_QCFile, Block, Max, HG_inc);
    If IOResult<>0 Then BEGIN FatalCError:=1; HG_SetOn_CZero; Exit; END;
    If HG_inc=0 Then Exit;
    BlockWrite (HG_ZCFile, Block, HG_inc, ges);
    If IOResult<>0 Then BEGIN FatalCError:=1; HG_SetOn_CZero; Exit; END;
    HG_inc:=ges;
  END Else
  BEGIN
    inc (FileInc);
    SetFTime (HG_ZCFile, HG_QTime);
    HG_SetOn_CZero;
    SetFAttr (HG_ZCFile, HG_QAttr or archive);
  END;
END;


PROCEDURE HG_Proc;
BEGIN
  If HG_Run and 1 <> 0 Then
  BEGIN
    If SysTime<SysTimeCopy Then Exit;
    HGCopy;
    SysTimeCopy:= SysTime+7;
  END;
  If HG_Run and 2 <> 0 Then HGPrint;
END;

END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
