UNIT Dirliste;

INTERFACE

USES
  bioscrt, Dos, Cmd_var, disk, Strings;

TYPE
  Bloc = array  [1..65535] Of Char;


PROCEDURE Dateiliste;
PROCEDURE Read_PackFile_Header (VAR gel : Word; VAR Block : Bloc);
         {auch fr Packing !}


IMPLEMENTATION

TYPE
  Sortierung = FUNCTION (X, Y : Liste) : Boolean;
  NS         = String[78];
  Ls         = String[22];
  str2       = String[2];

VAR
  SortierArt : Sortierung;
  Block      : ^Bloc;
  PName      : ^NS;
  PSize      : ^LongInt;
  PTime      : ^LongInt;
  PAttr      : ^Byte;
  f          : File;
  Result     : Word;
  MaxMem     : Word;
  FPos       : LongInt;
  x, y       : Word;
  n          : Byte;
  gel        : Word;
  il, jl     : Integer;
  XL, YL     : Liste;



PROCEDURE Read_PackFile_Header (VAR gel : Word; VAR Block : Bloc);
VAR
  xx, x : Word;
BEGIN
  PacName[ax]:=ERR; xx:= gel-5; x:=0; 
  REPEAT
    inc (x);
    If (Block[x]=#30) and (Block[x+1]=#6)  and (Block[x+2]=#1)  and (Block[x+3]=#0)  Then
    PacName[ax]:=ARJ Else
    If (Block[x]='P') and (Block[x+1]='K') and (Block[x+2]=#3)  and (Block[x+3]=#4)  Then
    PacName[ax]:=ZIP Else
    If (Block[x]='-') and (Block[x+1]='l') and (Block[x+2]='h') and (Block[x+4]='-') Then
    PacName[ax]:=LHA Else
    If (Block[x]='R') and (Block[x+1]='a') and (Block[x+2]='r') and (Block[x+3]='!') Then
    PacName[ax]:=RAR;
  UNTIL (PacName[ax]<>ERR) or (x=xx);
END;



PROCEDURE List_proc_1;
BEGIN
  If ll>=MaxFiles Then Exit;
  inc (ll);
  With Listen[ll] Do
  BEGIN
    DateiName:=PName^; Attribut:=PAttr^; Zeit:=PTime^; Groesse:=PSize^;
    inc (GG, PSize^);
  END;
END;



PROCEDURE List_LHA;
BEGIN
  For x:= 1 To gel Do
  If  (Block^[x]  ='-') and (Block^[x+1]='l') and (Block^[x+2]='h')
  and (Block^[x+4]='-') Then
  BEGIN
    PSize := @Block^[x+9];
    PTime := @Block^[x+13];
    PName := @Block^[x+19];
    PAttr := @Block^[x+18];
    If PAttr^=1 Then  {---Normal-Archiv}
    BEGIN
      PAttr := @Block^[x+23+ord(PName^[0])];
      If PAttr^=0 Then PAttr^:= archive Else
      PAttr := @Block^[x+26+ord(PName^[0])];
    END Else PAttr := @Block^[x+17]; {---Selbstextraktor}
    List_proc_1;
  END;
END;



PROCEDURE List_RAR;
VAR
  p : Byte;
BEGIN
  For x:= 1 To gel Do
  If (Block^[x+2]= #$0F) and (Block^[x+3]= #$35) and (Block^[x+5]= #0) Then
  BEGIN
    PTime:= @Block^[x-2];
    PAttr:= @Block^[x+6];
    PSize:= @Block^[x-11];
    PName:= @Block^[x+9]; PName^[0]:=Block^[x+4];
    p:= LastPos ('\', PName^);
    If p<>0 Then PName^:= copy (PName^, p+1, 255);
    List_proc_1;
  END;
END;



PROCEDURE List_ZIP;
BEGIN
  For x:= 1 To gel Do
  If  (Block^[x]  ='P') and (Block^[x+1]='K') and (Block^[x+2]=#1)
  and (Block^[x+3]=#2)  and (Block^[x+4]=#20) and (Block^[x+5]=#0) Then
  BEGIN
    PName := @Block^[x+45]; PName^[0]:= Block^[x+28];
    PSize := @Block^[x+24];
    PTime := @Block^[x+12];
    PAttr := @Block^[x+38];
    List_proc_1;
  END;
END;



PROCEDURE List_ARJ;
BEGIN
  For x:= 1 To gel Do
  If  (Block^[x]  =#30) and (Block^[x+1]=#6)  and (Block^[x+2]= #1)
  and (Block^[x+3]=#0)  and (Block^[x+4]=#16) and (Block^[x+6]<>#2) Then
  BEGIN
    PAttr := @Block^[x+26];
    PSize := @Block^[x+16];
    PTime := @Block^[x+8];
    PName := @Block^[x+29];
    PName^[0]:= #78;
    PName^[0]:= chr (pos (#0, PName^));
    While pos ('/', PName^)<>0 Do delete (PName^, 1, pos ('/', PName^));
    While pos ('\', PName^)<>0 Do delete (PName^, 1, pos ('\', PName^));
    List_proc_1;
  END;
END;



PROCEDURE List_ARC;
VAR
  FSize : LongInt; r : Word;
LABEL
  Ende;
BEGIN
  MaxMem:= 65535;
  If MaxMem>MaxAvail Then MaxMem:=MaxAvail; GetMem (Block, MaxMem);
  Assign (f, ArcName[ax]); FileMode:=0; Reset (f, 1); Result:= IOResult;
  If Result<>0 Then BEGIN ViewMode[ax]:=0; Goto Ende; END; FSize:=FileSize(f);
  y:=0; n:=0;

  With Listen[1] Do
  BEGIN
    kk:=1; ll:=1;
    DateiName:='..'; Attribut:= directory;
    GetFTime (f, Zeit);
    Groesse:= FSize;
  END;

  REPEAT
    BlockRead (f, Block^, MaxMem, gel); Result:=IOResult;
    If Result<>0 Then BEGIN ViewMode[ax]:=0; Goto Ende; END;
    If gel>50 Then
    BEGIN
      If n=0 Then BEGIN Read_PackFile_Header (gel, Block^); n:=1; END;
      dec (gel, 20);
      CASE PacName[ax] Of
        ARJ : List_ARJ;
        ZIP : List_ZIP;
        LHA : List_LHA;
        RAR : List_RAR;
      END;
    END;
    FPos:=FilePos(f);
    If (FPos>=20) and (FSize>20) and (FSize-FPos>20) Then Seek (f, FPos-20);
  UNTIL (gel=0) or (PacName[ax]=ERR);

Ende:
  Close (f); R:=IOResult; FileMode:=2; 
  FreeMem (Block, MaxMem);
END;


FUNCTION Sort_Name_A (X, Y: Liste): Boolean; far;
BEGIN Sort_Name_A := X.DateiName < Y.DateiName; END;

FUNCTION Sort_Size_A (X, Y: Liste): Boolean; far;
BEGIN Sort_Size_A := X.Groesse < Y.Groesse; END;

FUNCTION Sort_Time_A (X, Y: Liste): Boolean; far;
BEGIN Sort_Time_A := X.Zeit > Y.Zeit; END;


FUNCTION Sort_End_A (X, Y: Liste): Boolean; far;
BEGIN
  Sort_End_A :=  (GetFileExt (X.DateiName) < GetFileExt (Y.DateiName))
             or ((GetFileExt (X.DateiName) = GetFileExt (Y.DateiName)) and (X.DateiName < Y.DateiName));
END;

FUNCTION Sort_Name_B (X, Y: Liste): Boolean; far;
BEGIN Sort_Name_B := X.DateiName > Y.DateiName; END;

FUNCTION Sort_Size_B (X, Y: Liste): Boolean; far;
BEGIN Sort_Size_B := X.Groesse > Y.Groesse; END;

FUNCTION Sort_Time_B (X, Y: Liste): Boolean; far;
BEGIN Sort_Time_B := X.Zeit < Y.Zeit; END;

FUNCTION Sort_End_B (X, Y: Liste): Boolean; far;
BEGIN
  Sort_End_B :=  (GetFileExt (X.DateiName) > GetFileExt (Y.DateiName))
             or ((GetFileExt (X.DateiName) = GetFileExt (Y.DateiName)) and (X.DateiName > Y.DateiName));
END;


PROCEDURE QuickSort (L, R: Integer);
BEGIN
  il := L;
  jl := R;
  XL  := Listen [ (L + R) div 2];
  REPEAT
    While SortierArt (Listen [il], XL) Do inc (il);
    While SortierArt (XL, Listen [jl]) Do dec (jl);
    If il <= jl then
    BEGIN
      YL:=Listen [il];
      Listen[il]:=Listen [jl];
      Listen [jl]:=YL;
      inc(il);
      dec(jl);
    END;
  UNTIL il > jl;
  If L  < jl Then QuickSort (L, jl);
  If il < R  Then QuickSort (il, R);
END;


PROCEDURE Dateiliste;
VAR
  lx       : Integer;
  subst    : Boolean;
  AttrMask : Byte;
  dl       : searchrec;

LABEL
  Nochmal;

BEGIN

Nochmal:
  GG:=0; kk:= 0; ll:= 0; 
  Subst:= (Drive (RC.Fensterpfad[ax][1]) and SubstDrive<>0)
      and (Length(RC.FensterPfad[ax])=3);

  If ViewMode[ax]=0 Then
  BEGIN
    If RC.Allfiles Then
    AttrMask:= anyfile and not  VolumeID Else
    AttrMask:= anyfile and not (VolumeID or Hidden or sysFile);

    Findfirst ('*.*', AttrMask, dl);
    If dl.name = '.' Then lx:=2 Else lx:=1;
    If Subst Then dec (lx);
    While (DOSError = 0) and (ll < MaxFiles)  Do
    BEGIN
      If   (dl.attr and directory<>0) and (dl.name<>'.')
      and ((not Subst) or (dl.Name<>'..')) Then
      BEGIN
        inc (ll);
        Move (dl.Attr, Listen [ll], SizeOf (Liste));
      END;
      Findnext (dl);
    END;

    kk:=ll;

    Findfirst (FileMask, AttrMask and not directory, dl);
    While (DOSError = 0) and (ll < MaxFiles) Do
    BEGIN
      inc (ll);
      Move (dl.Attr, Listen [ll], SizeOf (Liste));
      inc (GG, dl.Size);
      Findnext (dl);
    END;
  END
  Else BEGIN List_ARC; lx:=1; If Result<>0 Then Goto Nochmal; END;

  ii:=ll; 

  If RC.Sort<>0 Then
  BEGIN
    CASE RC.Sort + RC.SortRicht of
      1 : SortierArt := Sort_Name_A;
      2 : SortierArt := Sort_Time_A;
      3 : SortierArt := Sort_End_A;
      4 : SortierArt := Sort_Size_A;
      5 : SortierArt := Sort_Name_B;
      6 : SortierArt := Sort_Time_B;
      7 : SortierArt := Sort_End_B;
      8 : SortierArt := Sort_Size_B;
    END;
    If (kk > lx) and (ViewMode[ax]=0) Then QuickSort (lx,   kk);
    If ll-kk > 0                      Then QuickSort (kk+1, ll);
  END;

  dec (ll, kk);
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
