UNIT Edit_cmd;

INTERFACE

USES
  dos, bioscrt, buttons, cmd_var, cmd_main, Monitor, Monitcmd,
  cmd_back, strings, cmd_Str, Printex, keycode, time;



PROCEDURE TextEdit (FileName : PathStr; ViewOnly : Boolean);
PROCEDURE ReadStr (VAR s : String; Len : Byte);
PROCEDURE DOS_Prompt;


VAR
  EditResult : Word;
  et1        : Char;
  et2        : Char;


CONST
  MaxLines    = 8000;

  NotIndexMem = 1;
  NotLineMem  = 2;
  InsError    = 3;
  LineError   = 4;
  FileNotExist= 5;
  ReadError   = 6;
  LineToLong  = 7;
  FileToLong  = 8;
  WriteError  = 9;


TYPE
  EdRec = RECORD
            CurX        : Byte;
            CurY        : Byte;
            ViewLen     : Byte;
            ViewLines   : Byte;
            Start       : Byte;
            ActSign     : Byte;
            FirstLine   : Word;
            ActLine     : Word;
            LastLine    : Word;
            IsEdit      : Boolean;
            ins         : Boolean;
            OldWindMin  : Word;
            OldWindMax  : Word;
            OldX        : Byte;
            OldY        : Byte;
            OldTextAttr : Byte;
          END;


IMPLEMENTATION

TYPE
  TxArr = Array [1..MaxLines] Of ^String;
  Str5  = String[5];

VAR
  EditRec     : EdRec;
  TLine       : ^TxArr;
  AbsLastLine : Word;  {darf vom Programm nicht verndert werden !}
  MaxLen      : Word;
  IntMaxLen   : Word;  {darf vom Programm nicht verndert werden !}
  IndexSize   : Word;  {darf vom Programm nicht verndert werden !}
  Temp        : Word;
  UndoLine    : String;
  TextEd      : Boolean;
  GetLineNum  : Boolean;
  DOSPrompEdit: Boolean;
  ActHeap     : Pointer;


CONST
  RAMfree : Boolean = TRUE;

CONST
  Speichern=
  'Soll die Datei gespeichert werden? Besttigen Sie den alten Dateinamen mit'#13#10+
  'ENTER, geben Sie einen neuen Namen ein oder brechen Sie mit Esc ab.';
  Speicherfehler=
  'Die Datei konnte nicht gespeichert werden. Geben Sie einen anderen Dateinamen'#13#10+
  'oder ein anderes Laufwerk ein oder brechen Sie mit Esc ab.';



{---------------------------- Speicherverwaltung ---------------------------}

PROCEDURE GetRAM (Lines : Word; LineLen : Byte);
BEGIN
  Mark (ActHeap);
  If Lines   > MaxLines Then Lines:= MaxLines;
  If LineLen < 254 Then IntMaxLen:= LineLen Else IntMaxLen:= 254;
  If IntMaxLen < 60 Then IntMaxLen:= 60;
  MaxLen:= IntMaxLen - 1;
  If Lines = MaxLines Then Lines:= 400000 DIV IntMaxLen;
  IndexSize:= Lines * 4;                         {4 = SizeOf(Pointer)}
  RAMfree:= TRUE;
  If MaxAvail < IndexSize Then EditResult:= NotIndexMem Else
  BEGIN
    RAMFree:= FALSE;
    EditResult:= 0;
    GetMem (TLine, IndexSize);
    AbsLastLine:=0;
    While (MaxAvail > IntMaxLen) and (Lines > 0) do
    BEGIN
      inc (AbsLastLine);
      GetMem (TLine^[AbsLastLine], IntMaxLen);
      dec (Lines);
    END;
    If Lines > 0 Then EditResult:= NotLineMem;
  END;
END;
{Reserviert fr TLine^ <Lines> Zeilen mit einer Lnge von <LineLen> im RAM.}
{Da TLine selbst 32000 Bytes Speicher fr die Zeiger belegen wrde,}
{wird auch fr TLine nur soviel RAM reserviert, wie zur Indizierung der}
{angeforderten Zeilen bentigt wird. Wird <Lines> mit Maxlines belegt - also}
{der hchstmglichen Zeilenzahl - nimmt GetRAM eine Selbstoptimierung anhand}
{der Zeilenlnge vor. 400000 ist hierbei der angenommene freie Speicherplatz}
{und kann bei mehr freiem RAM auch erhht werden. Da GetRAM den Speicher fr}
{jede Zeile einzeln anfordert, wird auch ein stark fragmentierter RAM gut}
{ausgenutzt. GetRAM ist zwingend erforderlich}



PROCEDURE FreeRAM;
BEGIN
  If RAMFree Then Exit;
  AbsLastLine:=0;
  Release (ActHeap);
  RAMFree:= TRUE;
END;
{Gibt die mit GetRAM reservierten Speicherbereiche wieder frei. Mit RAMfree}
{wird verhindert, da Speicher versehentlich mehrmals freigegeben wird.}



{---------------------------- Editor-Initialisierung ------------------------}

PROCEDURE EditWindow (a, b, c, d, Attr : Byte);
BEGIN
  With EditRec Do
  BEGIN
    OldWindMin := WindMin;   {Speicherung des alten Windows}
    OldWindMax := WindMax;
    OldX       := WhereX;
    OldY       := WhereY;
    OldTextAttr:= TextAttr;

    CurX       := 1;         {Anfangsposition des Cursors}
    CurY       := 1;
    Start      := 0;         {erstes darzustellendes Zeichen + 1}
    ViewLen    := c-a+1;     {Zahl der darzustellenden Zeichen}
    ViewLines  := d-b+1;     {Zahl der darzustellenden Zeilen}
    FirstLine  := 0;         {Nummer der ersten angezeigten Zeile}
    ActLine    := 1;         {Nummer der aktuellen Zeile}
    ActSign    := 1;         {Nummer des Zeichens ber dem Cursor}
  END;
  ClearWin (a, b, c, d, Attr);
END;
{Setzt alle Koordinaten und internen Werte des sichtbaren Textfensters.}
{Whrend der Programmlaufzeit werden alle Werte stndig aktualisiert.}
{In einer Variablen des Typs EdRec kann daher der aktuelle Zustand des}
{Textfensters zwischengespeichert und spter wieder zurckgeschrieben werden.}



PROCEDURE RestoreWindow;
BEGIN
  With EditRec Do
  BEGIN
    WindMin  := OldWindMin;
    WindMax  := OldWindMax;
    TextAttr := OldTextAttr;
    GotoXY (OldX, OldY);
  END;
END;
{Stellt das durch EditWindow genderte Window wieder her und setzt den Cursor}
{an seine vorherige Position (Geht also auch ohne Window (a, b, c, d).}



{------------------------ Textdarstellung ----------------------------------}

PROCEDURE WriteString (s : String);
BEGIN
  CursorOff;
  With EditRec Do
  BEGIN
    WriteXY
    (Lo(WindMin)+1, CurY+Hi(WindMin), spaceStr(copy (s, Start+1, ViewLen-1), ViewLen), TextAttr and $0F, TextAttr shr 4);
    GotoXY (CurX, CurY);
  END;
  CursorOn;
END;
{Schreibt eine Zeile. Ist sie lnger als das Textfenster breit ist, wird nur}
{der Teil angezeigt, der in dieses Fenster pat. Es werden sowohl die ersten}
{als auch die letzten Zeichen abgeschnitten (seitliches Scrolling).}



PROCEDURE ShowText;
VAR
  CurYTemp : Byte;
BEGIN
  If not TextEd Then Exit;
  With EditRec Do
  BEGIN
    CurYTemp:= CurY; 
    For CurY:= 1 To ViewLines Do
    If CurY <> CurYTemp Then
    If (FirstLine+CurY) <= LastLine Then
    WriteString (TLine^[FirstLine+CurY]^) Else BEGIN GotoXY (1, CurY); ClrEOL; END;
    CurY:= CurYTemp;
  END;
END;
{Schreibt soviele Zeilen, wie in das angegebene Textfenster passen.}



PROCEDURE IncLine (Zahl : Word);
BEGIN
  With EditRec Do
  BEGIN
    Temp:= FirstLine;
    While (Zahl > 0) and (ActLine < LastLine) Do
    BEGIN
      dec (Zahl);
      If CurY < ViewLines Then inc (CurY) Else inc (FirstLine);
      ActLine:= FirstLine + CurY;
    END;
    If Temp <> FirstLine Then ShowText Else GotoXY (CurX, CurY);
  END;
END;
{Bewegt den Cursor um <Zahl> Zeichen nach unten. Steht dieser am unteren Rand}
{des Fensters, wird es via Showtext um eine Zeile nach oben gescrollt. Dazu}
{wird die Variable Firstline um 1 erhht (Showtext beginnt mit der}
{Darstellung immer mit der Zeile Nr. <FirstLine>). IncLine verhindert das}
{berscrollen der letzten Zeile.}



PROCEDURE DecLine (Zahl : Word);
BEGIN
  With EditRec Do
  BEGIN
    Temp:= FirstLine;
    While (Zahl > 0) and (ActLine > 1) Do
    BEGIN
      dec (Zahl);
      If CurY > 1 Then dec (CurY) Else If FirstLine > 0 Then dec (FirstLine);
      ActLine:= FirstLine + CurY;
    END;
    If Temp <> FirstLine Then ShowText Else GotoXY (CurX, CurY);
  END;
END;
{Funktioniert genau wie IncLine, nur das Cursor oder Text nach oben gefahren}
{werden. Decline verhindert das Unterscrollen der ersten Zeile.}



PROCEDURE IncSign (Zahl : Word);
BEGIN
  With EditRec Do
  BEGIN
    Temp:= Start;
    While (Zahl > 0) and (ActSign < MaxLen) Do
    BEGIN
      dec (Zahl);
      If CurX < ViewLen Then inc (CurX) Else inc (Start);
      ActSign:= Start + CurX;
    END;
    If Temp <> Start Then ShowText Else GotoXY (CurX, CurY);
  END;
END;
{Bewegt den Cursor nach rechts. Ist er am rechten Rand des Fensters angelangt,}
{wird das gesamte Textfenster um eine Spalte nach links gescrollt. Ein}
{berfahren der maximalen Zeilenlnge wird verhindert.}



PROCEDURE DecSign (Zahl : Word);
BEGIN
  With EditRec Do
  BEGIN
    Temp:= Start;
    While (Zahl > 0) and (ActSign > 1) Do
    BEGIN
      dec (Zahl);
      If CurX  > 1 Then dec (CurX) Else dec (Start);
      ActSign:= Start + CurX;
    END;
    If Temp <> Start Then ShowText Else GotoXY (CurX, CurY);
  END;
END;
{Funktioniert wie IncSign, nur das Cursor oder Text nach links gefahren}
{werden. Ein Unterfahren von Spalte eins wird verhindert.}



PROCEDURE MoveCursorTo (Nr : Byte);
BEGIN
  With EditRec Do
  If ActSign <= Nr Then IncSign (Nr-ActSign) Else DecSign (ActSign - Nr);
END;
{Bewegt den Cursor an Spalte <Nr>. Liegt <Nr> auerhalb des sichtbaren}
{Fensters, wird der Text seitlich gescrollt}


PROCEDURE Line_Sign_Nr;
BEGIN
  With EditRec Do
  WriteXY (72, 1, StretchStr(StrVal (ActLine)+':'+StrVal (ActSign), 8), 15, 1);
END;
{Schreibt Zeilen- und ZeichenNummer rechtsbndig}



PROCEDURE Taste_Abfragen;
VAR
  Oldt1, Oldt2 : Char;
BEGIN
  With EditRec Do
  BEGIN
    If HG_Run>0 Then REPEAT HG_Proc; UNTIL Keypressed;
    SysTimeCopy:= SysTime+15;
    Oldt1:= t1; Oldt2:= t2;
    ScanKeys;
    et1:= t1; et2:= t2;
    t1:= Oldt1; t2:= Oldt2;
  END;
END;
{Nimmt Tastatureingaben entgegen. Ist keine Eingabe vorhanden, luft die}
{Schleife mit den Hintergrundprozessen.}



PROCEDURE Fusszeile;
VAR
  Bottom : String[80];
  x      : Byte;
BEGIN
  Bottom:= ' F1Print F2Save F3CutLn F4PasteLn F5CopyLn F6Umbruch F9ClearLn F10RestoreLn     ';
  For x:= 1 To Length (Bottom) Do
  If (Bottom[x]='F') or (Bottom[x]<='9') Then
  CharXY (x, 25, Bottom[x], cyan, 1) Else CharXY (x, 25, Bottom[x], 15, 1);
  WriteXY (77, 25, 'ESC', cyan, blue);
END;
{Stellt die Fusszeile mit Bedienhinweisen dar.}



PROCEDURE ErrorMsg (EdResult : Byte);
VAR
  x : Byte;
  s : String[80];
BEGIN
  CASE EdResult Of
    0           : Exit;
    InsError    : s:= 'Kein Speicherplatz zum Einfgen';
    ReadError   : s:= 'Datei ist beschdigt';
    LineToLong  : s:= 'Zeile mit berlnge gefunden';
    FileToLong  : s:= 'Datei zum Laden zu gro';
    WriteError  : s:= 'Datei kann nicht gespeichert werden';
    LineError   : s:= 'Zielzeile zu lang';
  END;
  For x:= 1 To 80 Do CharXY (x, 25, #32, red, red);
  WriteXY (2, 25, s, yellow, red);
  WriteXY (64, 25, 'Weiter mit Taste', yellow, red);
  Piepton;
  Taste_Abfragen;
  With EditRec Do BEGIN et1:= #1; et2:= #2; END;
  Fusszeile;
END;
{Zeigt anstelle der Fusszeile eine Fehlermeldung an. Nach einem Tastendruck}
{wird die Fusszeile wieder hergestellt.}


{-------------------------- Zeilenmanipulationen ---------------------------}

PROCEDURE InsLines (StartLine : Word);
VAR
  x : Word;
BEGIN
  With EditRec Do
  BEGIN
    If (LastLine < AbsLastLine) and (StartLine > 0) Then
    BEGIN
      For x:= LastLine DownTo StartLine Do TLine^[x+1]^:= TLine^[x]^;
      inc (LastLine);
      IsEdit:=TRUE;
      EditResult:=0;
    END Else EditResult:= InsError;
  END;
END;
{Fgt eine Leerzeile in den Text ein. Dazu werden alle Zeilen ab der Zeile
{Nr <StartLine> um eine Zeile nach unten kopiert.}



PROCEDURE DelLines (StartLine : Word);
VAR
  x : Word;
BEGIN
  With EditRec Do
  BEGIN
    If StartLine > 0 Then
    BEGIN
      For x:= StartLine To LastLine Do TLine^[x]^:= TLine^[x+1]^;
      TLine^[LastLine]^:='';
      If LastLine > 1 Then dec (LastLine);
      If LastLine < ActLine Then DecLine(1);
      IsEdit:= TRUE;
    END;
  END;
END;
{Lscht eine Textzeile. Dazu werden alle Zeilen ab der Zeile Nr <StartLine>}
{um eine Zeile nach oben kopiert.}



PROCEDURE InsertLine;
BEGIN
  With EditRec Do
  BEGIN
    InsLines (ActLine);
    If EditResult = 0 Then
    BEGIN
      TLine^[ActLine+1]^ := copy (TLine^[ActLine]^, ActSign, MaxLen);
      TLine^[ActLine]^[0]:= chr (ActSign-1);
      DecSign (ActSign);
      incLine (1);
      ShowText;
    END;
  END;
END;
{Erzeugt einen Zeilenumbruch nach ENTER. Es wird eine Leerzeile eingefgt und}
{dort alle Zeichen hineinkopiert, die hinter dem Cursor folgten. Die alte}
{Zeile wird auf Corsorposition gekrzt.}



PROCEDURE BackDeleteLine;
BEGIN
  With EditRec Do
  BEGIN
    If (ActSign > 1) or (ActLine > LastLine) or (ActLine=1) Then Exit;
    If Length (TLine^[ActLine-1]^) + Length (TLine^[ActLine]^) + 1 < MaxLen Then
    BEGIN
      IncSign (Length (TLine^[ActLine-1]^));
      TLine^[ActLine-1]^:= TLine^[ActLine-1]^ + TLine^[ActLine]^;
      DelLines (ActLine);
      If ActLine<>LastLine Then DecLine(1);
      ShowText;
    END Else ErrorMsg (LineError);
  END;
END;
{Lscht eine Zeile nach Drcken der BACK-Taste, wenn der Cursor am Zeilen-}
{anfang stand. Diese Zeile wird an die neue Zeile angehngt. Ist die so}
{entstehende Zielzeile lnger als die erlaubte Zeilenlnge, wird eine}
{Fehlermeldung ausgegeben. Der Rest des Textes wird via DelLines nach oben}
{kopiert. Das neu enstehende Textbild wird angezeigt.} 



PROCEDURE EntFDeleteLine;
BEGIN
  With EditRec Do
  BEGIN
    If (ActLine<1) or (ActLine>=LastLine) Then Exit;
    If Length (TLine^[ActLine]^) + Length (TLine^[ActLine+1]^) + 1 < MaxLen Then
    BEGIN
      TLine^[ActLine]^:= TLine^[ActLine]^ + TLine^[ActLine+1]^;
      DelLines (Actline+1);
      ShowText;
    END Else ErrorMsg (LineError);
  END;
END;
{Funktioniert wie BackDeleteLine nach dem Drcken der ENTF-Taste, wenn sich}
{der Cursor am Ende der Zeile befand. In diesem Falle wird die nchste Zeile}
{(sowie der Rest der Datei) hochkopiert. Ist die Zielzeile zu lang, wird eine}
{Fehlermeldung ausgegeben.}



{----------------------------- Dateioperationen ----------------------------}

PROCEDURE ReadFile (FileName : PathStr);
VAR
  f     : Text;
  InBuf : Array[1..20000] Of Char;
BEGIN
  With EditRec Do
  BEGIN
    FileMode:=0; LastLine:=0; IsEdit:=FALSE; EditResult:= 0;
    Assign (f, FileName); SetTextBuf (f, InBuf, SizeOf (InBuf));
    Reset  (f);

    If IOResult=0 Then
    BEGIN
      While (not EOF (f)) and (LastLine < AbsLastLine) Do
      BEGIN
        inc (LastLine);
        ReadLn (f, UndoLine); If IOResult<>0 Then
        BEGIN EditResult:= ReadError; Close (f); Exit; END;
        If Length (UndoLine) <= MaxLen Then
        TLine^[LastLine]^:= UndoLine Else
        BEGIN EditResult:= LineToLong; Close (f); Exit; END;
      END;
      If not EOF (f) Then BEGIN EditResult:= FileToLong; END;
      Close (f);
    END Else EditResult:= FileNotExist;

    If LastLine=0 Then BEGIN LastLine:=1; TLine^[LastLine]^:= ''; END;
  END;
END;
{Liest die Datei <FileName> zeilenweise in den Textpuffer TLine^ ein.}
{Existiert die Datei nicht, wird angenommen, da eine neue Datei angelegt}
{werden soll. Jede Zeile wird zunchst geprft, ob sie die zulssige}
{Zeilenlnge berschreitet. Ebenso wird ermittelt, ob die Datei vollstndig}
{eingelesen werden konnte.}



PROCEDURE WriteFile (FileName : PathStr);
VAR
  f          : Text;
  x, OldAttr : Word;
  OutBuf     : Array[1..20000] Of Char;
BEGIN
  With EditRec Do
  BEGIN
    EditResult:=0;
    If not IsEdit Then Exit;

    Assign (f, FileName); SetTextBuf (f, OutBuf, SizeOf (OutBuf));
    GetFAttr (f, OldAttr);
    If DOSError=0 Then SetFAttr(f, 32) Else OldAttr:=32;

    ReWrite (f);

    If IOResult=0 Then
    BEGIN
      For x:= 1 To LastLine Do
      BEGIN
        WriteLn (f, TLine^[x]^);
        If IOResult<>0 Then BEGIN Close (f); EditResult:= WriteError; Exit; END;
      END;
      Close (f);
      SetFAttr (f, OldAttr or archive);
      IsEdit:= FALSE;
    END Else EditResult:= WriteError;
  END;
END;
{Speichert den editierten Text wieder in der Datei <FileName>. Anhand der}
{Variablen IsEdit wird geprft, ob die Datei berhaupt gendert wurde. Ist}
{dies nicht der Fall, wird das Abspeichern bergangen.}

{ReadFile und WriteFile kann auch verwendet werden, um Arbeitsspeicher auf}
{die Festplatte auszulagern, wenn mehrere Dateien zugleich bearbeitet werden.}
{Als Filename mu dann ein interner Name (z.B. FILE_1.TMP) angegeben werden.}
{Mit ReadFile kann diese Swap-Datei wieder eingelesen werden. Wurde vor dem}
{Wechseln der Datei das Record EditRec zwischengespeichert, kann es nun wieder}
{hergestellt werden. Showtext stellt dann genau den Zustand vor dem Verlassen}
{des Dateifensters wieder her.}



{------------------ Prozedur zum Editieren eines Strings--------------------}

PROCEDURE EditStr (VAR s : String);
VAR
  StrTemp : String;
BEGIN
  With EditRec Do
  BEGIN
    StrTemp:= s;
    REPEAT
      If GetLineNum Then Line_Sign_Nr;
      WriteString (s);
      Taste_abfragen;
      If (et1<>#0) and (et1<>#27) and (et1<>#13) Then
      BEGIN
        IsEdit:= TRUE;

        If et1=Back Then
        BEGIN
          If ActSign >1 Then
          BEGIN DecSign (1); delete (s, ActSign, 1); END Else If TextEd Then Exit;
        END
        Else

        If (et1= CTRJ) and (DosPrompEdit) Then
        BEGIN
          If Length(s)+Length(Listen[dd].Dateiname) <= MaxLen then
          BEGIN
            If (Length(s)<>0) and (s[Length(s)]<>' ') and (s[Length(s)]<>'\') Then s:= s+' ';
            If Length(s)+Length(Listen[dd].Dateiname) < MaxLen then
            s:= s+Listen[dd].Dateiname;
            MoveCursorTo (Length(s)+1);
          END;
        END Else

        BEGIN
          If ActSign-1 > Length(s) Then
          While Length (s) < ActSign-1 Do s:= s + ' ';

          If (ActSign-1 >= RC.EditUmbruch) and (TextEd) and (not DosPrompEdit) Then
          BEGIN
            If (et1=' ') or (et1='-') or (et1='.') or (et1=',')
            or (et1=';') or (et1=')') or (ActSign-1 >= MaxLen) Then
            BEGIN
              If et1=' ' Then BEGIN et1:= #13; Exit; END;
              et2:= #255;
            END;
          END;

          If not ins Then delete (s, ActSign, 1);
          If Length (s)+1 < MaxLen Then insert (et1, s, ActSign);
          If et2= #255 Then BEGIN et1:= #13; et2:=#0; END;
          IncSign (1);
        END
      END
      Else
      CASE et2 Of
        Left      : If (ActSign=1)      and (TextEd) Then Exit Else DecSign (1);
        Right     : If (ActSign=MaxLen) and (TextEd) Then Exit Else IncSign (1);
        Entf      : BEGIN
                      IsEdit:=TRUE;
                      If ActSign <= Length(s) Then delete (s, ActSign, 1) Else
                      If TextEd Then Exit;
                    END;
        Pos1      : MoveCursorTo (1);
        Endx      : MoveCursorTo (Length(s)+1);
        Einfg     : Ins:= not Ins;
        F9        : BEGIN s:= '';      MoveCursorTo (1);           IsEdit:= TRUE; END;
        F10       : BEGIN s:= StrTemp; MoveCursorTo (Length(s)+1); IsEdit:= TRUE; END;
        CTRL_Left : BEGIN DecSign(1); While (s[ActSign]<>' ') and (ActSign>1) Do DecSign (1); END;
        CTRL_Rght : BEGIN IncSign(1); While (s[ActSign]<>' ') and (ActSign<=Length(s)) Do IncSign (1); END;
        Else    If TextEd Then Exit;
      END;
    UNTIL (et1=#13) or (et1=#27);
  END;
END;
{Editiert einen Einzelstring oder die Zeile, in der sich (bei Texten) der}
{Cursor befindet.}



{===================== HauptProzedur EinzelString editieren =================}

PROCEDURE ReadStr (VAR s : String; Len : Byte);
BEGIN
  TextEd:= FALSE; GetLineNum:= FALSE; DOSPrompEdit:= TRUE;
  EditWindow (WhereX+lo(WindMin), WhereY+Hi(WindMin), lo(WindMax)+1, WhereY+Hi(WindMin), TextAttr);
  MaxLen:= Len;
  MoveCursorTo (Length(s)+1);
  CursorOn;
  EditStr (s);
  RestoreWindow;
END;


{========================== Hauptprozedur Editor ===========================}

PROCEDURE TextEdit (FileName : PathStr; ViewOnly : Boolean);
VAR
  OldMin, OldMax : Word;
LABEL
  Ende;

BEGIN
  With EditRec Do
  BEGIN
    GetScreen50 (Screen^); x25_Zeilen;
    TextEd:= TRUE; GetLineNum:= TRUE; DOSPrompEdit:= FALSE;
    ClearWin (1, 1, 80, 25, 16);
    ClearWin (1, 2, 80, 24, 112);
    EditWindow  (2, 2, 80, 24, 112);
    WriteXY  (2, 1, FileName, 11, 1);

    GetRAM  (MaxLines, RC.EditLineLen);
    ReadFile (FileName);
    If EditResult >= ReadError Then BEGIN ErrorMsg (EditResult); Goto Ende; END;

    UndoLine:='';
    Fusszeile;
    If ViewOnly Then WriteXY (10, 25, SpaceStr (' ', 66), 0, 1);

    ShowText;
    REPEAT
      If not ViewOnly Then EditStr (TLine^[ActLine]^) Else
      BEGIN WriteString (TLine^[ActLine]^); Taste_Abfragen; END;

      If et1<>#0 Then
      BEGIN
        If not ViewOnly Then
        CASE et1 Of
          #13  : BEGIN InsertLine; ErrorMsg (EditResult); END;
          Back : BackDeleteLine;
        END;
      END Else
      CASE et2 Of
        F1   : BEGIN
                 ij[ax]:=0;
                 OldMin:= WindMin; OldMax:= WindMax; CursorOff;
                 If HG_Run and 2=0 Then Print_Files;
                 WindMin:= OldMin; WindMax:=OldMax; CursorOn;
               END;
        F2   : If not ViewOnly Then
               BEGIN WriteFile(FileName); ErrorMsg (EditResult); END;
        F3   : If not ViewOnly Then BEGIN
                 UndoLine:= TLine^[ActLine]^;
                 DelLines (ActLine);
                 ShowText;
               END;
        F4   : If not ViewOnly Then BEGIN
                 InsLines (ActLine);
                 If EditResult=0 Then BEGIN TLine^[ActLine]^:= UndoLine; ShowText; END Else
                 ErrorMsg (EditResult);
               END;
        F5          : If not ViewOnly Then UndoLine:= TLine^[ActLine]^;
        F6          : If not ViewOnly Then RC.EditUmbruch:= ActSign;
        EntF        : If not ViewOnly Then EntFDeleteLine;
        Up          : DecLine (1);
        Left        : BEGIN DecLine (1); MoveCursorTo (Length(TLine^[ActLine]^)+1); END;
        Down        : IncLine (1);
        Right       : BEGIN IncLine (1); MoveCursorTo (1); END;
        PgUp        : DecLine (ViewLines-1);
        PgDn        : IncLine (ViewLines-1);
        CTRL_PgUp, CTRL_Pos1 : DecLine (ActLine);
        CTRL_PgDn, CTRL_Ende : IncLine (LastLine);
      END;
    UNTIL (et1=#27);

    If (IsEdit) and (not ViewOnly) Then
    BEGIN
      ClrScr;
      Window (2, 2, 79, 24);
      GotoXY (1, 2); WriteStr (Speichern);
      REPEAT
        TextAttr:= Cyan shl 4;
        GotoXY  (1, 5);
        ReadStr (FileName, SizeOf (FileName));
        If et1 = #13  Then
        BEGIN
          If FileName <>'' Then WriteFile (FileName) Else EditResult:= WriteError;
          If EditResult<>0 Then
          BEGIN ClearWin (2, 2, 80, 24, 112); GotoXY (1, 2); WriteStr (Speicherfehler); OutChar (#7); END;
        END;
      UNTIL (et1=#27) or ((et1=#13) and (EditResult=0));
    END;

Ende:
    FreeRAM;
    x50_Zeilen; SetScreen50 (Screen^);
  END;
END;


{========================= HauptProzedur DOS_PROMPT =====================}


PROCEDURE DOS_Prompt;
VAR
  VollBild  : Byte;

LABEL
  Ende;

BEGIN
  If (t1='Q') or (t1=CTRQ) Then VollBild:=0 Else VollBild:=1;
  If Vollbild=0 Then
  BEGIN
    ClearWin (1, 48, 80, 50, 15);
    GotoXY (Length(RC.FensterPfad[ax])+2, 2);
    WriteXY (1, 49, RC.FensterPfad[ax]+'>', 15, 0);
    GetLineNum:= FALSE;
  END Else
  BEGIN
    GetScreen50 (Screen^);
    Window (1, 1, 80, 26);  (*Trick*)
    x25_Zeilen; TextAttr:= 30;
    ClrEol; WriteXY (2, 1, RC.FensterPfad[ax]+'>', yellow, 1);
    TextAttr:=7;
    GetLineNum:= TRUE;
  END;
  EditWindow (WhereX, hi(WindMin)+2, 80, hi(WindMax), TextAttr);
  TextEd:= TRUE; DOSPrompEdit:= TRUE;

  With EditRec Do
  BEGIN
    GetRAM (254, SizeOf (RC.Befehl));
    ReadFile (VollPfad (ComDir, 'STAPEL.LOG'));
    If RC.HStapel>253 Then RC.HStapel:= 253;
    While LastLine > RC.HStapel Do DelLines (1);
    incLine (RC.HStapel);
    MoveCursorTo (Length(TLine^[ActLine]^)+1);
    InsertLine;

    REPEAT
      RC.Befehl:= TLine^[ActLine]^;
      MoveCursorTo (Length(RC.Befehl)+1);
      EditStr (RC.Befehl);
      If et1=#0 Then
      CASE et2 Of
        Up        : DecLine (1);
        Down      : IncLine (1);
        PgUp      : DecLine (ViewLines);
        PgDn      : IncLine (ViewLines);
        CTRL_PgUp : DecLine (ActLine);
        CTRL_PgDn : IncLine (LastLine);
      END;
    UNTIL (et1=#27) or (et1=#13);


    If (Length (RC.Befehl)=0) or (et1=#27) Then
    BEGIN
      RC.Befehl:='';
      If VollBild<>0 Then BEGIN x50_Zeilen; SetScreen50 (Screen^); END;
      Sign:= 25; Goto Ende;
    END;

    If (LastLine=1) or (RC.Befehl<>TLine^[LastLine-1]^) Then
    BEGIN
      TLine^[LastLine]^:= RC.Befehl;
      WriteFile (VollPfad (ComDir, 'STAPEL.LOG'));
    END;

    If (t1= CTRQ) or (t1=CTRW) or (pos ('/P', UpStr (RC.Befehl))<>0)
    or ((pos('|', RC.Befehl)<>0) and (pos('MORE', UpStr (RC.Befehl))<>0))
    Then RC.Pause:=True Else RC.Pause:= False;

    Sign:=2;
  Ende:
    FreeRAM;
    CursorOff;
  END;
END;

{------------------------- Initialisierung ---------------------------------}

BEGIN
  EditRec.ins:= TRUE;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
