UNIT Kopiere;


INTERFACE

USES
  cmd_var, cmd, bioscrt, dos, strings, Monitor,
  Schilder, Monitcmd, cmd_main, buttons, pac_tool, compare;


PROCEDURE Kopieren;


IMPLEMENTATION

VAR
  BSize           : Word;
  P               : Pointer;
  Gesamt, Kopiert : LongInt;



PROCEDURE GetFInfo (Suchpfad : PathStr; t1 : Searchrec);
VAR
  Baum   : PathStr;
  p1, p2 : Byte;
BEGIN
  tg:=t1; Quelle:=Suchpfad;
  Baum := Copy (Quelle, UrDirL+1, Length(Quelle)-UrDirL);
  If Baum[1]='\' Then delete (Baum, 1, 1);
  If XBefehl=3 Then
  BEGIN
    p1:= pos ('\', Baum); p2:= pos ('.', Baum);
    If p1+p2=0 Then Baum[Length(Baum)]:= '_' Else
    If (p1<>0) and ((p1<p2) or (p2=0)) Then Baum[p1-1]:='_' Else
    If (p2<>0) and ((p2<p1) or (p1=0)) Then Baum[p2-1]:='_';
    Ziel:= Vollpfad (RC.FensterPfad[ax], Baum);
  END Else
  If XBefehl =1 Then Ziel:= Vollpfad (Papierkorb, Baum)
  Else Ziel:= Vollpfad (RC.FensterPfad[ax1], Baum);
END; 



PROCEDURE Balken (Kopiert, Gesamt : LongInt);
VAR
  x : Byte;
  a : LongInt;
CONST
  MaxVal = MaxLongInt shr 7;
BEGIN
  If Kopiert > MaxVal then
  BEGIN Kopiert:= Kopiert shr 7; Gesamt:= Gesamt shr 7; END;
  If Gesamt<1 Then Gesamt:=1;

  a:= (Kopiert*40) DIV Gesamt;
  If a < 1  Then a:= 1;
  If a > 40 Then a:= 40;
  inc (a, 19);

  For x:= 20 To a Do
  BEGIN CharXY (x, 24, #219, red, 7); CharXY (x, 25, #219, red, 7); END;

  a:= (Kopiert*100) DIV Gesamt;
  If a < 1   Then a:= 1;
  If a > 100 Then a:= 100;
  WriteProz (a);
END;



PROCEDURE FileCopy;
VAR
  Fs         : LongInt;
  AZ, i1, i2 : Word;
  Q, Z       : File;


PROCEDURE FileCompare;
CONST
  PMax       = 20000;

VAR
  a1         : Array[1..PMax] Of Byte;
  a2         : Array[1..PMax] Of Byte;
  x          : Word;
  FEqual     : Boolean;
  gel, FSize : LongInt;

BEGIN
  gel:=0; FSize:= tg.Size+1; x:=0;
  Reset (Q, 1); Reset (Z, 1); FEqual:= (IOresult=0);
  If FEqual Then
  REPEAT
    BlockRead (Q, a1, PMax, i1); BlockRead (Z, a2, PMax, i2);
    FEqual:= (IOResult=0) and (i1=i2) and (CompareBuffers (a1, a2, i1) = 0);
    inc (gel, i1);
    x:= (gel*100) DIV Fsize; inc (x); If x > 100 Then x:= 100;
    WriteXY (53, 18, StretchStr(StrVal(x), 3)+' %', yellow, 2);
  UNTIL (i1=0) or (i2=0) or not (FEqual);
  Close(Q); Close (Z);
  If not FEqual Then Result:= 1016 Else WriteXY (53, 18, '100 %', yellow, 2);
END;



BEGIN
  Result:= 0; TimerSet;

  Assign (Q, Quelle);
  Assign (Z, Ziel); 

  Reset   (Q, 1); Result:=IOresult; If Result<>0 Then EXIT;
  Rewrite (Z, 1); Result:=IOresult;

  If Result<>0 Then
  BEGIN
    If (Result>=150) and (Result<=162) Then Exit;
    GetFAttr (Z, AZ); Result:=DOSerror; If Result<>0 Then Exit;
    If AZ and Directory <> 0 Then BEGIN Result:= 1006; EXIT END;
    SetFattr (Z, 32); Result:= DOSerror;
    If Result = 0 Then BEGIN Rewrite (Z, 1); Result:=IOresult; END;
    If Result<> 0 Then BEGIN Close (Q);    InOutRes:= 0; EXIT; END;
  END; 

  i1:= 0; i2:= 0;

  While (i1=i2) and (not Eof (Q)) Do
  BEGIN
    BLOCKREAD  (Q, P^, BSize, i1); Result:= IOresult;
    If Result<>0 Then
    BEGIN Close (Q); Close (Z); InOutRes:= 0; EXIT; END;
    Balken (Kopiert+i1 shr 1, Gesamt);

    BLOCKWRITE (Z, P^, i1, i2); Result:= IOresult;
    If Result<>0 Then
    BEGIN Close (Q); Close (Z); InOutRes:= 0; EXIT; END;
    inc (Kopiert, i1);
    Balken (Kopiert, Gesamt);
  END;

  SetFTime (Z, tg.time); Close(Q); Close(Z); 
  If i1<>i2 Then
  BEGIN Erase (Z); InOutRes:= 0; Result:= 1007; OkayMeld:=1; EXIT; END Else
  SetFAttr (Z, tg.attr or archive); InOutRes:= 0;

  If RC.Verify Then FileCompare;
END;



PROCEDURE DirCopy;
VAR
  at : Word;
  sc : Searchrec;
  Z  : File;
BEGIN
  Result:=0;
  MkDir (Ziel); Result:=IOresult;
  If Result=5 Then
  BEGIN
    FindFirst (Ziel, anyfile, sc);
    If DOSerror=0 Then
    If sc.attr and directory=0 Then BEGIN Result:=1005; OkayMeld:=1; END Else
    If sc.attr and 7 <> 0 Then
    BEGIN Result:= 1004; OkayMeld:=1; END Else Result:= 0;
  END;
  If Result=0 Then
  BEGIN
    Assign (Z, Quelle); GetFattr (Z, at);
    If DOSerror=0 Then
    BEGIN OkayMeld:=1; Assign (Z, Ziel); SetFAttr (Z, at-16); END;
  END;
END;



PROCEDURE Copy_Proc;
LABEL
  Nochmal;

BEGIN
  WriteName (tg.name);
Nochmal:
  If tg.attr and directory<>0 Then Dircopy Else Filecopy;
  If Result<>0 Then
  BEGIN
    Warnschild (Result); 
    CASE Result Of
      150, 152, 155, 157 : If ((t1='J') or (t1='A')) Then Goto Nochmal Else OkayMeld:=1;
      1005, 1006         : BEGIN t1:='N'; OkayMeld:=1; END;
      Else                 t1:='E';
    END;
  END;
  If keypressed Then
  BEGIN t1:= upReadKey; If t1=#27 Then t1:='E'; END;
END;



PROCEDURE Zieltest;
VAR
  sz : Searchrec;
BEGIN
  Findfirst (Ziel, anyfile and not VolumeID, sz);
  If DOSerror=0 Then
  BEGIN
    If tg.attr and directory <> 0 Then
    BEGIN
      If sz.attr and directory <>0 Then
      BEGIN
        If sz.attr and 7 <>0 Then
        BEGIN Warnschild (1004); t1:='N'; END Else Warnschild (1002);
      END
      Else BEGIN Warnschild (1005); t1:='N'; END;
    END
    Else
    BEGIN
      If sz.attr and directory <> 0 Then
      BEGIN Warnschild (1006); t1:='N'; END Else
      BEGIN
        Warnschild (1001);
        If (t1='J') and (sz.attr and 7 <> 0) Then Warnschild (1003);
      END;
    END;
  END;
END;



PROCEDURE Rekursiv (SuchPfad: PathStr);
VAR
  new_dir : PathStr;
  t       : Searchrec;
BEGIN
  Findfirst (Vollpfad (Suchpfad,'*.*'), anyfile and not VolumeID, t);
  While (DOSError = 0) Do
  BEGIN
    New_dir:= VollPfad (SuchPfad, t.name);
    If t.name[1]<>'.' Then
    BEGIN
      GetFinfo (New_Dir, t);
      Copy_Proc; If (Result<>0) or (t1='E') Then EXIT;
      If (t.attr and directory <> 0) Then
      Rekursiv (new_dir); If (Result<>0) or (t1='E') Then EXIT;
    END;
    Findnext (t);
  END;
END;



PROCEDURE AddRekurs (SuchPfad: PathStr);
VAR
  new_dir  : PathStr;
  t        : Searchrec;
BEGIN
  Findfirst (VollPfad (Suchpfad,'*.*'), anyfile and not VolumeID, t);
  While DOSError = 0 Do
  BEGIN
    If (t.attr and directory <> 0) and (t.name[1]<>'.') Then
    BEGIN
      new_dir:= VollPfad (SuchPfad, t.name);
      AddRekurs (new_dir);
    END Else
    inc (gesamt, t.size);
    Findnext (t);
  END;
END;



PROCEDURE Datei_Op (Name: Fstr);
VAR
  Suchpfad : PathStr;
BEGIN
  If (Name[1]='.') or ((Samepath (Name)) and (XBefehl<>1) and (XBefehl<>3)) Then
  BEGIN Warnschild (1008); OkayMeld:=1; If ij[ax]=0 Then Sign:=25; EXIT; END;

  UrDirL   := Length (RC.FensterPfad[ax]);
  Suchpfad := Vollpfad (RC.FensterPfad[ax], Name);

  FindFirst (Suchpfad, anyfile and not VolumeID, tg);
  If DOSerror=0 Then GetFInfo (Suchpfad, tg) Else BEGIN OkayMeld:=1; Exit; END;

  If t1='J' Then BEGIN Zieltest; If t1='N' Then BEGIN OkayMeld:=1; Exit; END; END;
  If t1='E' Then Exit;

  Gesamt:=0; Kopiert:=0;
  If tg.attr and directory <> 0 Then AddRekurs (tg.name) Else
  Gesamt:= tg.size;

  Copy_Proc;
  If tg.attr and directory <> 0 Then Rekursiv (Suchpfad);
END;



{------------------------------ HauptProzedur -------------------------------}

PROCEDURE Kopieren;
LABEL
  Ende, Weiter;
VAR
  ddx, xij  : Integer;
  CopyFile  : Boolean;
BEGIN
  FileMode:=0; 
  BSize:=65535; If BSize>MaxAvail Then BSize:= MaxAvail;
  GetMem (P, BSize);

  t1:='E'; t2:=#0; OkayMeld:= 0; Sign:=7;

  CASE XBefehl Of
    0 : YBefehl:= 'Datei wird kopiert.';
    1 : YBefehl:= 'Datei kommt in den Papierkorb.';
    2 : YBefehl:= 'Datei wird verschoben.';
    3 : YBefehl:= 'Datei wird geklont.';
  END;

  Fragefenster;

  CopyFile:= TRUE;
  If (ViewMode[ax1]=1)
  or (((ViewMode[ax]=1) or (ViewMode[ax1]=1))
  and (ii<>0) and (RC.FensterPfad[ax] = RC.FensterPfad[ax1])) Then
  CopyFile:= FALSE Else     {fr Entpacken ins gleiche Verzeichnis}

  If (ii=0) or ((RC.FensterPfad[ax] = RC.FensterPfad[ax1]) and (XBefehl<>1) and (XBefehl<>3)) Then
  BEGIN Warnschild (1008); OkayMeld:=1; If ij[ax]=0 Then Sign:=25; Goto Ende; END;

  If ViewMode[ax1]=1 Then Test_ArcName (ax1);

  If ij[ax]=0 Then
  BEGIN
    WriteName (Listen [dd].Dateiname);
    KopierStrip;
    KopierFrage;
    Tastenauswertung;
    CASE t1 Of 'E', 'N': BEGIN Sign:=25; Goto Ende; END; 'A': t1:='J'; END;

    If ViewMode[ax]=1 Then
    BEGIN
      Archiv_Befehl (Extract, Listen [dd].Dateiname, ax);
      If PacResult=2000 Then BEGIN OkayMeld:=1; Goto Ende; END;
    END;

    If CopyFile Then
    BEGIN
      Datei_Op (Listen [dd].Dateiname);
      If ViewMode[ax]=1 Then Del_TempFile (Listen [dd].Dateiname);
    END;

    If ViewMode[ax1]=1 Then
    BEGIN
      Archiv_Befehl (UpDate, Listen [dd].Dateiname, ax1);
      If PacResult=2000 Then BEGIN OkayMeld:=1; Goto Ende; END;
      If ViewMode[ax]=1 Then Del_TempFile (Listen [dd].Dateiname);
    END;

  END Else

  BEGIN
    xij:=ij[ax]; ddx:=0;
    REPEAT
      inc (ddx);
      With Listen[ddx] Do
      BEGIN
        If collect[ax, ddx]=#219 Then
        BEGIN
          dec (xij);
          If (ViewMode[ax]=1) and (t1<>'A') Then
          BEGIN SetScreen50 (Screen^); FrageFenster; END;
          WriteName (Dateiname);
          KopierStrip;
          If (t1<>'A') or (keypressed) Then
          BEGIN
            Kopierfrage;
            Tastenauswertung;
            CASE t1 Of
              'E': Goto Ende;
              'N': BEGIN OkayMeld:=1; Goto Weiter; END;
            END;
          END;

          If ViewMode[ax]=1 Then
          BEGIN
            Archiv_Befehl (Extract, Dateiname, ax);
            If PacResult=2000 Then BEGIN OkayMeld:=1; Goto Weiter; END;
          END;

          If CopyFile Then
          BEGIN
            Datei_Op (Dateiname);
            If (ViewMode[ax]=1) and (RC.FensterPfad[ax] <> RC.FensterPfad[ax1])
            Then Del_TempFile (Dateiname);
          END;

          If ViewMode[ax1]=1 Then
          BEGIN
            Archiv_Befehl (UpDate, Dateiname, ax1);
            If PacResult=2000 Then BEGIN OkayMeld:=1; Goto Ende; END;
            If ViewMode[ax]=1 Then Del_TempFile (Dateiname);
          END;
          Weiter:
        END;
      END;

    UNTIL (xij<= 0) or (ddx>=ii);
  END;

  If ViewMode[ax1]=1 Then Rename_Arc (ax1);

Ende:

  Freemem (P, BSize); FileMode:=2;
  If (XBefehl<>0) and (XBefehl<>3) Then
  BEGIN
    If (t1='N') or (t1='E') or (OkayMeld=1) Then
    BEGIN OkayMeld:=1; Warnschild (1013); END Else Exit;
  END Else Fenster_Zu;
END;


END.




{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
