UNIT Pac_tool;

INTERFACE

USES
  DOS, bioscrt, cmd_var, dosx, monitor, monitcmd, mouse,
  cmd_main, schilder, buttons, strings;

VAR
  PacResult : Word;
  Upac, Uent, Usfx, Ulst : PathStr;

CONST
  Extract = 1;
  UpDate  = 2;
  Delet   = 3;
  Waiting : Byte = 0;
  ArcExt  : array[ERR..LHARC] of String[3] = ('???', 'USE', 'ARJ', 'LZH', 'ZIP', 'RAR', 'LZH');


PROCEDURE User_ini_lesen;
PROCEDURE ClearWindow;
PROCEDURE Test_ArcName  (VAR ax : Byte);
PROCEDURE Rename_Arc    (VAR ax : Byte);
PROCEDURE Archiv_Befehl (b      : Byte; FName : FStr; Fenster : Byte);
PROCEDURE Del_TempFile  (FName  : PathStr);
PROCEDURE Kopfzeile     (as     : Byte);
PROCEDURE Pack_op       (Befehl : ComStr);
PROCEDURE UpDate_Edit_File;
PROCEDURE Dos_GateWay;


IMPLEMENTATION

VAR
  TempArc   : FStr;

CONST
  GateWay   : Boolean = False;
  Upackread : Boolean = False;


FUNCTION GetValue (s : ComStr) : ComStr;
BEGIN
  GetValue:= Trim (FromNthField (s, '=', 2));
END;


PROCEDURE User_ini_lesen;
VAR
  s : ComStr;
BEGIN
  If UPackread Then Exit;
  FileMode:=0;
  Assign (xf, VollPfad (Comdir, 'USERPACK.INI'));
  Reset  (xf);
  If IOResult=0 Then
  BEGIN
    While (IOResult=0) and (not EoF (xf)) Do
    BEGIN
      ReadLn (xf, s);
      CASE UpChar(s[1]) Of
       'E' : Upac:= GetValue (s);
       'A' : Uent:= GetValue (s);
       'S' : Usfx:= GetValue (s);
       'L' : Ulst:= GetValue (s);
       'F' : ArcExt[USER]:= GetValue (s);
      END;
    END;
    Close (xf);
    UPackread:=TRUE;
  END
  Else Upac:='frei';
  FileMode:=2;
END;


PROCEDURE Test_ArcName (VAR ax : Byte);
VAR
  f       : File;
  NewName : FStr;
  TempEnd : ExtStr;
BEGIN
  TempEnd:= GetFileExt (ArcName[ax]);
  If (TempEnd='EXE') or (TempEnd='COM') Then
  BEGIN
    NewName:= GetFilePrefix(ArcName[ax])+'.'+ArcExt[PacName[ax]];
    Assign (f, ArcName[ax]);
    Rename (f, NewName);
    If IOResult=0 Then
    BEGIN
      TempArc:= ArcName[ax];
      ArcName[ax]:= NewName;
    END Else TempArc:= '';
  END Else TempArc:= '';
END;


PROCEDURE Rename_Arc (VAR ax : Byte);
VAR
  f : File;
BEGIN
  If TempArc <> '' Then
  BEGIN
    Assign (f, ArcName[ax]);
    Rename (f, TempArc);
    InOutRes:= 0;
    ArcName[ax]:= TempArc;
  END;
END;



PROCEDURE ClearWindow;
BEGIN
  If not RC.Vollbild Then ClearWin (1, 10, 80, 47, 7) Else
  ClearWin (1, 3, 80, 24, 7);
END;



PROCEDURE Kopfzeile (as : Byte);
BEGIN
  If RC.Vollbild Then
  BEGIN If as=1 Then x25_Zeilen Else Window (1, 1, 80, 25); CursorOff; END
  Else Rahmen (1, 7, 80, 9, 7, 1);

  Case as Of
  1 : BEGIN
        Textattr:=113;
        If Gateway Then
        WriteStr (StretchStr('DOS-Gateway', 42)+StretchStr ('Ende=exit', 33)) Else
        WriteStr (' Bitte warten. Packprogramm arbeitet.'); ClrEol;
        If not RC.Vollbild Then ClearWin (1, 10, 80, 47, 7);
      END;
  2 : BEGIN
        If (DosError<>0) or (Waiting<>0) Then
        BEGIN
          Textattr:=116;
          If DOSError = 0 Then WriteStr (' Fertig.') Else
          BEGIN WriteStr (' Ausfhrungsfehler !');  Sign:=25; END;
          WriteStr (' Weiter mit Taste oder Maus.'); ClrEol;
          REPEAT MouseGet; UNTIL (kn<>0) or (Keypressed);
          If Keypressed Then WaitKey;
          MouseWait;
        END;
        If RC.Vollbild Then x50_Zeilen;
        CursorOff; MouseWindow (1, 7, 80, 50);
      END;
  END;
END;


PROCEDURE Pack_op (Befehl : ComStr);
BEGIN
  CASE RC.Vollbild Of
    FALSE : DosShellWin ( 1, 11, 80, 46, Befehl);
    TRUE  : DosShellWin ( 1,  3, 80, 24, Befehl);
  END;
END;


PROCEDURE Archiv_Befehl (b : Byte; FName : FStr; Fenster : Byte);
VAR
  Befehl : ComStr;
  arr    : Array[1..8000] Of Byte;

LABEL
  Ende;


PROCEDURE Delete_existing_File;
VAR
  f      : File;
  sr     : Searchrec;
  a1, a2 : Char;

BEGIN
  PacResult:=0;
  FindFirst (FName, anyfile and not VolumeID, sr); 
  If DOSerror<>0 Then Exit;
  a1:=t1; a2:=t2;
  If sr.attr and directory <> 0 Then PacResult:=1017 Else PacResult:=1018;
  Universal_Fenster; WriteName (FName); Warnschild1 (PacResult);
  If (PacResult=1017) or (t1='N') Then BEGIN PacResult:=2000; Exit; END;
  Assign (f, FName);
  If sr.attr and 7 <> 0 Then
  BEGIN
    WarnSchild1 (1003);
    If t1= 'N' Then BEGIN PacResult:=2000; Exit; END;
    SetFAttr (f, 32);
  END;
  Erase (f);
  t1:=a1; t2:=a2;
END;



BEGIN
  GetScreen50 (arr); Waiting:=0;
  If b=Extract Then
  BEGIN Delete_existing_File; If PacResult= 2000 Then Goto Ende; END;
  KopfZeile (1);
  Befehl:= ' '+VollPfad (RC.FensterPfad[Fenster], ArcName[Fenster])+' '+FName;
  CASE b Of
    Extract : CASE PacName[Fenster] Of
                ARJ : Befehl:= RC.arj+' x'+ Befehl;
                LHA : Befehl:= RC.lha+' x'+ Befehl;
                ZIP : Befehl:= RC.Pkunzip + Befehl;
              END;
    UpDate  : CASE PacName[Fenster] Of
                ARJ : Befehl:= RC.arj  +' u' + Befehl;
                LHA : Befehl:= RC.lha  +' u' + Befehl;
                ZIP : Befehl:= RC.Pkzip+' -u'+ Befehl;
              END;
    Delet   : CASE PacName[Fenster] Of
                ARJ : Befehl:= RC.arj  +' d' + Befehl;
                LHA : Befehl:= RC.lha  +' d' + Befehl;
                ZIP : Befehl:= RC.Pkzip+' -d'+ Befehl;
              END;
  END;
  pack_op (Befehl);
  Kopfzeile (2);
Ende:
  SetScreen50 (arr);
END;



PROCEDURE Del_TempFile (FName : PathStr);
VAR
  f : File;
BEGIN
  Assign   (f, FName);
  SetFAttr (f, 32); If DOSerror<>0 Then Exit;
  Erase    (f); InOutRes:= 0;
END;


PROCEDURE UpDate_Edit_File;
BEGIN
  ax:=RC.axx;
  ChDir (RC.FensterPfad [ax]);
  PacName[ax]:= RC.Pack;
  ArcName[ax]:= RC.Arc_Name;
  Archiv_Befehl (UpDate, RC.Arc_File, ax);
  Del_TempFile  (RC.Arc_File);
  RC.edit_arc:=0;
END;



PROCEDURE Dos_GateWay;
BEGIN
  Waiting:=0;
  GetScreen50 (Screen^);
  Gateway:=True;
  Kopfzeile(1);
  CursorOn;
  pack_op ('');
  Kopfzeile (2);
  SetScreen50 (Screen^);
  Gateway:=False;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
