UNIT printex;

INTERFACE

USES
  biosCrt, Monitor, Monitcmd, Buttons, Cmd_var, mouse, Strings,
  DOS, cmd_main, cmd_Str, time, PageDev;


VAR
  PageKonfig  : TPageKonfig;
  PrinterName : FStr;
  Printer     : Text;
  PrintFName  : PathStr;
  PrintedFile : Text;


PROCEDURE InitPageDev;
PROCEDURE Print_Files;


IMPLEMENTATION

CONST
  ClrLine = '                                            ';

VAR
  ExCode : Byte;

TYPE
  P = RECORD
        PortNr,
        Blocksatz,
        Seite_Ja,
        RandO,
        RandL,
        Zeichen,
        Zeilen,
        Fussrand,
        Seite,
        MaxSeiten : Byte;
      END;


PROCEDURE Tasten;
BEGIN
  Button  (36, 4, #13, #0, #13, #0, 'ENTER', ' ENTER Okay ', hCyan, 8);
  Button  (50, 4, #27, #0, #27, #0, 'Esc',   ' Esc Ende ',   hCyan, 8);
END;


PROCEDURE ClearLines;
BEGIN
  WriteXY (14, 17, ClrLine, 7, 7);
  WriteXY (14, 19, ClrLine, 7, 7);
END;


PROCEDURE Drucker_MT;
BEGIN
  MouseOn;
  REPEAT MouseGet; UNTIL (kn<>0) or (Keypressed);
  If keypressed Then UpScanKeys;
  MouseOff;
  Tasten;
END;


PROCEDURE OK_Meldung;
BEGIN
  WriteXY (14, 15, 'Datenflu OK                     ', nYellow, 7);
  ClearLines;
END;


PROCEDURE Fertigmeldung;
BEGIN
  WriteXY (14, 15, 'FERTIG !                         ', hlightblue, 7);
  ClearLines;
  xDelay (1000);
  WriteXY (14, 11, ClrLine, 7, 7);
END;


PROCEDURE FileError (x : Byte);
BEGIN
  PiepTon;
  If x=1 Then
  WriteXY (14, 15, 'Datei kann nicht gelesen werden. ', red,  7) Else
  WriteXY (14, 15, 'Druckziel nicht bereit.          ', red,  7);
  WriteXY (14, 17, 'ENTER: Diese Datei berspringen. ', blue, 7);
  WriteXY (14, 19, 'ESC  : Druck ganz abbrechen.     ', blue, 7);
  Drucker_MT;
  If t1=#27 Then ExCode:=1;
END;


PROCEDURE FehlerMeld;
BEGIN
  Piepton;
  WriteXY (14, 17, 'Beheben Sie den Fehler und drcken Sie', blue, 7);
  WriteXY (14, 19, 'ENTER oder brechen Sie mit ESC ab.',     blue, 7);
END;


PROCEDURE PStatus (IO : Byte);
BEGIN
  CASE IO of
  159 : BEGIN
          WriteXY (14, 15, 'Drucker hat kein Papier.         ', red,  7);
          FehlerMeld;
        END;
  160 : BEGIN
          WriteXY (14, 15, 'Drucker nicht bereit.            ', red,  7);
          FehlerMeld;
        END;
  END;
END;


PROCEDURE Printwindow;
BEGIN
  Rahmen  ( 9,  3, 62, 23, 7, 2); Schatten50 (9, 3, 62, 23);
  Rahmen  (10,  4, 35,  6, 7, 1); WriteXY (13,  5, 'DRUCKT: ', red, 7);
  Rahmen  (10,  7, 61, 22, 7, 1);
  WriteXY (14,  9, 'Datenflukontrolle', 1, 7);
  Rahmen  (12, 10, 59, 12, 7, 1); {Rahmen  fr Balken}
  Rahmen  (12, 13, 59, 21, 7, 1); {Rahmen  fr Meldungen}
  Window  (14, 11, 58, 11);       {Fenster fr Balken}
  Tasten;
END;


PROCEDURE Balken (Wert1, Wert2 : LongInt);
VAR
  x  : Byte;
  a  : Word;
BEGIN
  If Wert2=0 Then Wert2:= 1; a:= (Wert1*44) DIV Wert2; If a=0 Then a:=1;
  If a > 44 Then a:= 44; inc (a, 13);
  For x:= 14 To a Do CharXY (x, 11, #219, nYellow, 7);
  a:= (Wert1*100) DIV Wert2; inc (a); If a > 100 Then a:= 100;
  WriteXY (53, 9, StretchStr(StrVal(a), 3)+' %', nYellow, 7);
END;



PROCEDURE InitPageDev;
BEGIN
  With PageKonfig, p(RC.Format) Do
  BEGIN
    If PortNr <= 3 Then
    PrinterName:= 'LPT' + chr (PortNr+48) Else PrinterName:= 'C:\PRINT.$$';

    LineLen      := Zeichen;
    TopMargin    := RandO;
    LeftMargin   := RandL;
    BottomMargin := Fussrand;
    PageMode     := All;
    FirstPage    := 1;
    LastPage     := MaxSeiten;
    LinesPerPage := Zeilen;
    TabLen       := 2;

    If BlockSatz=1 Then TextAlign:= Justify Else TextAlign:= Left;

    PrintPageNr  := Seite_ja=1;
    FirstPageNr  := Seite;
    PageNrPrefix := 'Datei: '+PrintFName+'      Seite - ';
    PageNrSuffix := '';
    PageNrAlign  := Left;

    PrintFormFeed:= TRUE;
  END;
END;


PROCEDURE Printfile (FileName : PathStr; FSize : LongInt);
VAR
  fs         : LongInt;
  c          : Char;
  IO         : Word;
LABEL
  Ende, Endex;

BEGIN
  PrintFName:= FileName;
  InitPageDev;

  ExCode:=0;
  WriteXY (22, 5, '             ', 7, 7);
  WriteXY (22, 5, PrintFName,  hYellow, 7);

  Assign (PrintedFile, PrintFName); FileMode:= 0;
  Reset  (PrintedFile);
  If IOResult <> 0 Then BEGIN FileError(1); Goto Endex; END;

  fs:=0;

  Assign  (Printer, PrinterName); FileMode:= 2;
  Rewrite (Printer);
  If IOResult<>0 Then BEGIN FileError(2); Close (PrintedFile); Goto Endex; END;

  While (not Eof(PrintedFile)) and (ExCode=0) and (not IsLastPage (Printer, PageKonfig)) Do
  BEGIN
    Read    (PrintedFile, c);
    If IOResult<> 0 Then BEGIN FileError(1); Goto Ende; END;
    REPEAT
      WriteIntoPage (Printer, c, PageKonfig);
      IO:=IOResult;
      If IO <> 0 Then
      BEGIN
        PStatus(IO);
        Drucker_MT;
        If t1<>#27 Then OK_Meldung Else ExCode:=1;
      END;
    UNTIL (IO=0) or (t1=#27);
    inc (fs);
    If fs and 1024=0 Then Balken (fs, FSize);
  END;

  Balken (FSize, FSize);

Ende:
  Close (PrintedFile); InOutRes:= 0;

  FlushPageBuf (Printer, PageKonfig);
  Close (Printer); InOutRes:= 0;

Endex:

END;


{ ======================== Hauptprozedur ========================== }

PROCEDURE Print_Files;
VAR
  ddx : Integer;
  xij : Integer;
  ps  : Array [1..4000] of Byte;

LABEL
  Ende;

BEGIN
  Sign:=25;
  If ii<1 Then Exit;
  GetScreen25 (ps);
  MouseWindow (1, 1, 80, 50);

  ee:=1; PrintWindow; ee:=0;

  If ij[ax] = 0 Then
  BEGIN
    OK_Meldung;
    PrintFile (Listen[dd].Dateiname, Listen[dd].Groesse);
    If ExCode=0 Then Fertigmeldung; { Else Goto Ende; }
  END Else
  BEGIN
    ddx:=0; xij:= ij[ax];
    REPEAT
      inc (ddx);
      If collect[ax, ddx]=#219 Then
      BEGIN
        dec (xij); OK_Meldung;
        PrintFile (Listen[ddx].Dateiname, Listen[ddx].Groesse);
        If ExCode=0 Then Fertigmeldung Else Goto Ende;
      END;
    UNTIL (xij <= 0) or (ddx>=ii);
  END;

Ende:
  FileMode:= 2;
  SetScreen25 (ps);
  MouseWindow (1, 7, 80, 50);
  If RC.Format[1]>3 Then Sign:=7;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
