UNIT Schilder;

INTERFACE

USES
  cmd_var, mouse, dosx, bioscrt, dos, cmd_main, Monitor,
  monitcmd, cmd_str, Buttons, strings;

CONST
  LColor : Byte = lightcyan;

TYPE
  ErrStr= String[100];
  OrtStr= String[8];
  ChStr = String[35];

VAR
  YBefehl : String[40];
  LZahl   : Byte;
  ONr     : LongInt;
  KeyMode : Byte;



PROCEDURE Fragefenster;
PROCEDURE SuchFrage (Modus : Byte);
PROCEDURE Esc_Taste;
PROCEDURE New_Change_Tasten;
PROCEDURE KopierStrip;
PROCEDURE Kopierfrage;
PROCEDURE WriteName (s : PathStr);
PROCEDURE Warnung (Result : Word);
PROCEDURE Status;
PROCEDURE Warnschild (Result : Word);
PROCEDURE Fenster_zu;
PROCEDURE Warnschild1 (Result : Word);
PROCEDURE Tastenauswertung;
PROCEDURE WriteProz (p : Word);
PROCEDURE Kasten_Malen (x : Byte);

PROCEDURE Universal_Fenster;
PROCEDURE Dirfrage;
PROCEDURE Dateifrage;
PROCEDURE Hinweisfenster (Nr : Word; Name : PathStr);



IMPLEMENTATION
CONST
  GoOver  = 1;
  Weiter  = 2;
  Nochmal = 3;
  OverWrt = 4;
  TrDel   = 5;

  sGoOver  = #13'bergehen mit Taste oder Mausklick.';
  sWeiter  = #13'Weiter mit Taste oder Mausklick.';
  sNochmal = #13'Nochmal versuchen ?';
  sOverWrt = #13'berschreiben ?';
  sTrDel   = #13'Trotzdem lschen ?';



PROCEDURE CopyTasten;
BEGIN
  Button (20, 27, 'N', #0, 'N', #0, 'N', '  NEIN  ', red,        0);
  Button (30, 27, 'J', #0, #13, #0, 'J', '   JA   ', lightblue,  0);
  Button (40, 27, 'A', #0, 'A', #0, 'A', '  ALLE  ', lightgreen, 0);
  Button (50, 27, 'E', #0, #27, #0, 'E', '  ENDE  ', yellow,     0);
END;



PROCEDURE Esc_Taste;
BEGIN
  ee:=1;
  Button (19, 27, #27, #0, #27, #0, 'Esc', '   Operation mit Taste Esc abbrechen    ', red,0);
  ee:=0;
END;



PROCEDURE Weiter_Taste;
BEGIN
  ee:=1;
  Button (19, 23, #13, #0, #13, #0, '', '            Beliebige Taste             ', red,0);
  ee:=0;
END;



PROCEDURE New_Change_Tasten;
BEGIN
  Button (19, 23, 'N', #0, #27, #0, 'N', '       NEIN        ', red,      0);
  Button (40, 23, 'J', #0, 'J', #0, 'J', '        JA         ', lightblue,0);
END;



PROCEDURE Fragefenster;
BEGIN
  GetScreen50 (Screen^);
  Rahmen  (18, 10, 61, 30, 7, 2); Schatten50 (18, 10, 61, 30);
  Rahmen  (19, 11, 60, 15, 7, 1);
  Rahmen  (19, 16, 60, 22, 7, 1);
  Rahmen  (19, 23, 60, 26, 7, 1);
  ClearWin (20, 12, 59, 14, 16);
  KopierStrip;
  ee:=1; CopyTasten; ee:=0;
  MouseMoveXY (31, 28);
END;



PROCEDURE SuchFrage (Modus : Byte);
BEGIN
  ClearWin (20, 17, 59, 21, 32);
  CASE Modus Of
    1    : WriteXY (22, 18, 'Dateiname oder Wildcard + ENTER', nwhite, 2);
    2    : WriteXY (22, 18, 'Suchtext und/oder ENTER eingeben', nwhite, 2);
    3, 4 : WriteXY (22, 20, 'gefunden:', nwhite, 2);
  END;
  If Modus=3 Then WriteXY (22, 18, 'gelesen :', nwhite, 2);
END;



PROCEDURE KopierStrip;
VAR
  x : Byte;
BEGIN
  For x:=  20 To 59 Do
  BEGIN CharXY (x, 24, #219,  15, 5); CharXY (x, 25, #219,  15, 5); END;
END;



PROCEDURE Kopierfrage;
BEGIN
  ClearWin (20, 17, 59, 21, 32);
  If XBefehl=0 Then
  BEGIN
    If ax=1
    Then WriteXY (22, 19, 'Daten ins rechte Fenster kopieren?', nWhite, 2)
    Else WriteXY (22, 19, 'Daten ins linke Fenster kopieren?', nWhite, 2);
  END Else
  If XBefehl=1 Then WriteXY (22, 19, 'Daten in den Papierkorb werfen ?', nWhite, 2) Else
  If XBefehl=2 Then
  BEGIN
    If ax=1
    Then WriteXY (22, 19, 'Daten ins rechte Fenster verschieben?', nWhite, 2)
    Else WriteXY (22, 19, 'Daten ins linke Fenster verschieben?', nWhite, 2);
  END Else
  If XBefehl=3 Then
  WriteXY (22, 19, 'Datei/Verzeichnis klonen?', nWhite, 2);
END;



FUNCTION FehlerText (Result : Word) : ErrStr;
VAR
  f : ErrStr;
BEGIN
  CASE Result Of
    2   : BEGIN f:= 'Datei nicht gefunden.'                 ; KeyMode:= Weiter;  END;
    3   : BEGIN f:= 'Verzeichnispfad nicht gefunden.'       ; KeyMode:= Weiter;  END;
    5   : BEGIN f:= 'Dateizugriff verweigert.'              ; KeyMode:= Weiter;  END;
    6   : BEGIN f:= 'Dateihandler zerstrt.'                ; KeyMode:= Weiter;  END;
    150 : BEGIN f:= 'Laufwerk ist schreibgeschtzt.'        ; KeyMode:= Nochmal; END;
    151 : BEGIN f:= 'Unbekanntes Peripheriegert.'          ; KeyMode:= Weiter;  END;
    152 : BEGIN f:= 'Laufwerk/Verzeichnis nicht bereit.'    ; KeyMode:= Nochmal; END;
    154 : BEGIN f:= 'Prfsummenfehler beim Lesen der Datei' ; KeyMode:= Weiter;  END;
    155 : BEGIN f:= 'Parameterblock der Diskette defekt.'   ; KeyMode:= Nochmal; END;
    156 : BEGIN f:= 'Positionsfehler des Lesekopfes.'       ; KeyMode:= Weiter;  END;
    157 : BEGIN f:= 'Unbekanntes Datentrgerformat.'        ; KeyMode:= Nochmal; END;
    158 : BEGIN f:= 'Laufwerksektor nicht gefunden.'        ; KeyMode:= Weiter;  END;
    160 : BEGIN f:= 'Schreibfehler auf Peripheriegert.'    ; KeyMode:= Weiter;  END;
    161 : BEGIN f:= 'Lesefehler von Peripheriegert.'       ; KeyMode:= Weiter;  END;
    162 : BEGIN f:= 'Unbekannter Hardwarefehler.'           ; KeyMode:= Weiter;  END;
   1001 : BEGIN f:= 'Datei existiert bereits.'              ; KeyMode:= Overwrt; END;
   1002 : BEGIN f:= 'Verzeichnis existiert bereits.'        ; KeyMode:= Overwrt; END;
   1003 : BEGIN f:= 'Datei ist schreibgeschtzt.'           ; KeyMode:= OverWrt; END;
   1004 : BEGIN f:= 'Verzeichnis ist schreibgeschtzt.'     ; KeyMode:= GoOver;  END;
   1005 : BEGIN f:= 'Gleichnamige Datei gefunden.'          ; KeyMode:= Weiter;  END;
   1006 : BEGIN f:= 'Gleichnamiges Verzeichnis gefunden.'   ; KeyMode:= Weiter;  END;
   1007 : BEGIN f:= 'Datei pat nicht auf den Datentrger.' ; KeyMode:= Weiter;  END;
   1008 : BEGIN f:= 'Dieser Befehl ist nicht ausfhrbar.'   ; KeyMode:= Weiter;  END;
   1009 : BEGIN f:= 'Hilfedatei nicht gefunden.'            ; KeyMode:= Weiter;  END;
   1010 : BEGIN f:= 'Verzeichnis enthlt noch Dateien.'     ; KeyMode:= Weiter;  END;
   1011 : BEGIN f:= 'Lschgeschtzte Datei gefunden.'       ; KeyMode:= TrDel;   END;
   1012 : BEGIN f:= 'Lschgeschtztes Verzeichnis gefunden' ; KeyMode:= GoOver;  END;
   1013 : BEGIN f:= 'Quelldateien werden nicht gelscht.'   ; KeyMode:= Weiter;  END;
   1014 : BEGIN f:= 'Papierkorb kann nicht angelegt werden' ; KeyMode:= Weiter;  END;
   1015 : BEGIN f:= 'LOG-Datei kann nicht angelegt werden.' ; KeyMode:= Weiter;  END;
   1016 : BEGIN f:= 'Quell- und Zieldatei nicht identisch.' ; KeyMode:= Weiter;  END;
   1017 : BEGIN f:= 'Entpacken der Datei ist nicht mglich' ; KeyMode:= Weiter;  END;
   1018 : BEGIN f:= 'Temporrdatei existiert bereits !!!'   ; KeyMode:= OverWrt; END;
   1019 : BEGIN f:= 'Fehler bei Attributvergabe'            ; KeyMode:= Weiter;  END;
   1020 : BEGIN f:= 'Fehler in EXE-Datei'                   ; KeyMode:= Weiter;  END;
  END;

  CASE KeyMode Of
    GoOver  : Fehlertext:= f + sGoOver;
    Weiter  : Fehlertext:= f + sWeiter;
    Nochmal : Fehlertext:= f + sNochmal;
    OverWrt : Fehlertext:= f + sOverWrt;
    TrDel   : Fehlertext:= f + sTrDel;
  END;
END;



PROCEDURE Warnung (Result : Word);
VAR
  x, xx, y : Byte;
  s        : String;
BEGIN
  ClearWin (20, 17, 59, 21, 78);
  s:= Fehlertext (Result);
  xx:= 22; y:= 18;
  For x:= 1 To Length (s) Do
  If s[x]=#13 Then BEGIN xx:= 22; y:= 20; END Else
  BEGIN CharXY (xx, y, s[x], yellow, red); inc (xx); END;
  Piepton;
END;



PROCEDURE WriteName (s : PathStr);
BEGIN
  If Length(s)>36 Then BEGIN s[0]:= #33; s:= s+'...'; END;
  WriteXY (22, 13, SpaceStr (s, 36), lightcyan, blue);
END;



PROCEDURE WriteProz (p : Word);
BEGIN
  WriteXY (22, 20, StrVal(p)+' %  ', nWhite, 2);
END;



PROCEDURE Kasten_Malen (x : Byte);
BEGIN
  inc (LZahl);
  If LColor>15 Then LColor:=0; If LZahl>59 Then
  BEGIN
    LZahl:=20; inc (LColor);
    If LColor=7  Then inc (LColor);
    If LColor>15 Then LColor:=0;
  END;
  CharXY (LZahl, 24, #177, LColor, 7); CharXY (LZahl, 25, #177, LColor, 7);
  inc (ONr);
  WriteXY (x, 20, StrVal(ONr), nWhite, 2);
END;



PROCEDURE Status;
BEGIN
  ClearWin (20, 17, 59, 21, 47);
  WriteXY (22, 18, YBefehl, nWhite, 2);
END;



PROCEDURE Tastenauswertung;
BEGIN
  Standart_MT;
  CopyTasten;
  CASE t1 Of
    #13      : t1:='J';
    #27, #32 : t1:='E';
  END;
  TimerSet;
  Status;
END;



PROCEDURE Warnschild (Result : Word);
BEGIN
  Warnung (Result);
  Tastenauswertung;
END;



PROCEDURE Fenster_zu;
BEGIN
  SetScreen50 (Screen^);
END;


PROCEDURE Warnschild1 (Result : Word);
BEGIN
  Warnung (Result);
  ee:=1;   
  If (KeyMode=GoOver) or (Keymode=Weiter) Then Weiter_Taste Else New_Change_Tasten;
  ee:=0;
  Standart_MT;
  If (KeyMode=GoOver) or (Keymode=Weiter) Then Weiter_Taste Else New_Change_Tasten;
  CASE t1 Of
    #13, 'J' : t1:='J';
    Else       t1:='N';
  END;
  TimerSet;
END;



PROCEDURE Universal_Fenster;
BEGIN
  Rahmen (18, 10, 61, 26, 7, 2); Schatten50 (18, 10, 61, 26);
  Rahmen (19, 11, 60, 15, 7, 1);
  Rahmen (19, 16, 60, 22, 7, 1);
  ClearWin (20, 12, 59, 14, 16);
  ClearWin (20, 17, 59, 21, 63);
  GotoXY(3,4);
END;



PROCEDURE Dirfrage;
BEGIN
  Universal_Fenster;
  WriteXY (22, 18,'Wie soll das Verzeichnis heien?' , magenta, cyan);
END;



PROCEDURE Dateifrage;
BEGIN
  Universal_Fenster;
  WriteXY (22, 18,'Wie soll die Datei heien?' , magenta, cyan);
END;



PROCEDURE Hinweisfenster (Nr : Word; Name : PathStr);
BEGIN
  GetScreen50 (Screen^);
  Universal_Fenster;
  WriteName (Name);
  Warnschild1 (Nr);
  SetScreen50 (Screen^);
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
