UNIT Suche;


INTERFACE

USES
  cmd_var, bioscrt, dos, Monitor, Monitcmd, schilder, viewer, Strings,
  Edit_cmd, SeekBuf, spc;


PROCEDURE Daten_suchen;


IMPLEMENTATION

CONST
  Strich   = '------------------------------------------------------------------------------';
  BinExt   = ' EXE COM DLL OVL ';
  PMax     = 65024;

TYPE
  TBuffer    = Array[1..PMax] Of Char;

VAR
  ExeJa      : Boolean;
  ts         : Char;
  Datenmenge : LongInt;
  Buffer     : ^TBuffer;
  BufSize    : Word;
  Suchworte  : TSuchworte;



FUNCTION SearchFile (FileName : PathStr) : String;
VAR
  f        : File;
  Gelesen  : Word;
  FundOrt  : Word;
  c, lc    : Char;
  SeekPos  : LongInt;
  Result   : Word;
  Beispiel : PathStr;
  IsSpace  : Boolean;
  ToRead   : Word;
  RPos     : Word;
          
BEGIN
  SearchFile:= '';
  FileMode:=0;
  Assign (f, FileName);
  Reset  (f, 1);
  FileMode:=2;
  If InOutRes<>0 Then Exit;

  IsSpace:= GetFileExt(FileName)='SPC';
  If IsSpace Then
  BEGIN ToRead:= BufSize DIV 3; RPos:= BufSize-ToRead-3; END Else
  BEGIN ToRead:= BufSize;       RPos:= 1;                END;

  SeekPos:= 0;
  FundOrt:= 0;

  While (not Eof(f)) and (FundOrt=0) Do
  BEGIN
    If SeekPos>0 Then
    BEGIN
      dec  (SeekPos, Length(RC.Suchwort)-1);
      Seek (f, SeekPos);
    END;

    BlockRead (f, Buffer^[RPos], ToRead, gelesen);
    Result:= IOResult;
    If Result<>0 Then
    BEGIN
      Close (f);
      InOutRes:= Result;
      Exit;
    END;

    inc (SeekPos, Gelesen);
    If IsSpace Then UnPackText (Buffer^[RPos], Buffer^, Gelesen, Gelesen);
    If RC.WinKonvert Then KonvertBuf (Buffer^, Gelesen);

    If RC.IgGrKlein Then
    FundOrt:= NotCaseSensPos (SuchWorte,   Buffer^, gelesen) Else
    FundOrt:= CaseSensPos    (RC.SuchWort, Buffer^, gelesen);
  END;

  Close (f);
  InOutRes:= 0;

  If FundOrt<>0 Then
  BEGIN
    Beispiel:= '';
    c:= #0;
    While (FundOrt<=Gelesen) and (Length (Beispiel)<78) Do
    BEGIN
      lc:= c;
      c := Buffer^[FundOrt];
      If (c<=#13) Then c:=' ';
      If (c<>' ') or (lc<>' ') Then Insert (c, Beispiel, 255);
      inc (FundOrt);
    END;
    SearchFile:= Beispiel;
  END;
END;


PROCEDURE Objekt_listen (Suchpfad : PathStr);
VAR
  s        : Searchrec;
  d        : DateTime;
  atr      : PathStr;
  Beispiel : PathStr;
  FName    : PathStr;

BEGIN
  Findfirst (Vollpfad (Suchpfad, RC.SuchMask), anyfile and not VolumeID, s);
  While DOSError = 0 Do
  BEGIN
    If s.name[1]<>'.' Then
    BEGIN
      WriteName (s.name);
      FName:= VollPfad (Suchpfad, s.name);
      If Length(RC.SuchWort)=0 Then
      BEGIN
        Kasten_malen (32);
        atr:='Attrb: ';
        If (s.attr and directory<>0) Then atr:=atr+'Verzeichnis ' Else atr:=atr+'Datei ';
        If (s.attr and archive  <>0) Then atr:=atr+'/Archiv ';
        If (s.attr and ReadOnly <>0) Then atr:=atr+'/NurLesen ';
        If (s.attr and hidden   <>0) Then atr:=atr+'/Versteckt ';
        If (s.attr and sysfile  <>0) Then atr:=atr+'/Systemdatei';

        UnpackTime (s.time, d);
        WriteLn (xf, FName, #13#10);
        WriteLn (xf, 'Gre: ', s.size, ' Byte');
        With d Do
        BEGIN
          WriteLn (xf, 'Datum: ', day, '.', Month,'.',Year);
          WriteLn (xf, 'Zeit : ', hour, ':', LS(min), ' Uhr');
        END;
        WriteLn (xf, atr);
        WriteLn (xf, Strich);
      END
      Else
      {--- Textsuche ---}
      If   (s.attr and directory=0)
      and ((ExeJa) or (pos (' '+GetFileExt(s.name)+' ', BinExt)=0)) Then
      BEGIN

        Beispiel:= SearchFile (FName);

        inc (Datenmenge, s.size);
        WriteXY (32, 18, StrVal(Datenmenge shr 10)+' kB', 15, 2);
        If IOResult<>0 Then
        WriteLn (xf, 'Fehler in Datei '+FName) Else
        If Length(Beispiel)<>0 Then
        BEGIN
          WriteLn (xf, FName, #13#10#13#10, Beispiel);
          WriteLn (xf, Strich);
          Kasten_malen (32);
        END;
        If keypressed Then ts:= ReadKey;
      END;
    END;
    Findnext (s);
  END;
  If keypressed Then ts:=ReadKey;
END;



PROCEDURE Rekursiv (SuchPfad: PathStr);
VAR
  new_dir : PathStr;
  t       : Searchrec;
BEGIN
  Findfirst (Vollpfad(Suchpfad,'*.*'), anyfile and not VolumeID, t);
  While DOSError = 0 Do
  BEGIN
    If (t.attr and directory <> 0) and (t.name[1]<>'.') Then
    BEGIN
      New_dir:= VollPfad (suchpfad, t.name);
      Objekt_listen (New_dir); If ts=#27 Then Exit;
      Rekursiv (new_dir);      If ts=#27 Then Exit;
    END;
    Findnext (t);
  END;
END;


PROCEDURE Suche_Objekt;
BEGIN
  BufSize:= SizeOf (TBuffer);
  If BufSize>MaxAvail Then BufSize:= MaxAvail;
  GetMem (Buffer, BufSize);

  Datenmenge:= 0; ONr:=0; LZahl:=19; ts:=#0;
  Objekt_listen (RC.FensterPfad[ax]);
  Rekursiv (RC.FensterPfad[ax]);
  If RC.SuchWort='' Then
  BEGIN If ONr = 0 Then WriteLn (xf, RC.SuchMask, ' nicht gefunden!'); END Else
  BEGIN If ONr = 0 Then WriteLn (xf, RC.SuchWort, ' nicht gefunden!'); END;
  If ts = #27 Then WriteLn (xf, 'Suche vom Benutzer abgebrochen.'#13#10);

  FreeMem (Buffer, BufSize);
END;



PROCEDURE Sucheingabe (VAR ss : String; Nr : Byte);
BEGIN
  Suchfrage (Nr);
  GotoXY    (3, 4);
  CASE Nr Of
    1 : ReadStr (ss, SizeOf (FStr));
    2 : ReadStr (ss, SizeOf (PathStr));
  END;
  CursorOff;
END;
{Dateinamen und Suchwort einlesen}


{------------------- Zusammenfassung von Datei- und Textsuche --------------}


PROCEDURE Daten_Suchen;
CONST
  Uml    : array[1..7] of Char = 'ᄔ';
VAR
  u      : Byte;
  WinKon : Boolean;
LABEL
  Ende;

BEGIN
  FrageFenster; WriteName ('?'); Textcolor (0);

  Sucheingabe (RC.SuchMask, 1); If et1=#27 Then Goto Ende;
  Sucheingabe (RC.SuchWort, 2); If et1=#27 Then Goto Ende;

  Esc_Taste;
  If (RC.SuchMask='') and (RC.SuchWort= '') Then Goto Ende;
  If (RC.SuchMask='') and (RC.SuchWort<>'') Then RC.SuchMask:= '*.*';
  RC.SuchMask:= UpStr (RC.SuchMask);

  If RC.SuchWort<>'' Then
  BEGIN
    WinKon:=False;
    If RC.WinKonvert Then
    For u:= 1 To 7 Do If pos (Uml[u], RC.SuchWort)<>0 Then WinKon:=TRUE;

    If RC.IgGrKlein Then InitNotCaseSensSearch (RC.SuchWort, Suchworte);

    If RC.SearchExe Then ExeJa:= TRUE Else
    ExeJa:= pos (' '+GetFileExt (RC.SuchMask)+' ', BinExt)<>0;
  END;

  Assign   (xf, (Vollpfad (Comdir, 'SUCHE.LOG')));
  SetFAttr (xf, 32);
  Rewrite  (xf);
  If IOResult<>0 Then BEGIN Warnschild (1015); Goto Ende; END;
  If RC.SuchWort<>'' Then Suchfrage (3) Else SuchFrage (4);

  Suche_Objekt;

  Close (xf);
  InOutRes:= 0;

  SetScreen50 (Screen^);
  Fileview (Vollpfad (ComDir, 'SUCHE.LOG'));

Ende:
  Fenster_zu;
  Sign:= 25;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
