PROGRAM DelTree;
{$M 10000, 0, 0}
USES
  BiosCrt, Dos, strings, hexbin, masken, keycode, rechnen;


VAR
  sr       : Searchrec;
  i        : Byte;
  Para     : String;
  Objekt   : PathStr;
  TmpObjekt: PathStr;

CONST
  Ask      = 'Diese Datei lschen?                           J-a     N-ein     A-lle     E-nde';
  ProgName = 'DELTREE';
  Pfad     : PathStr = '';
  Files    : LongInt = 0;
  t        : Char    = #0;
  x        : Byte    = 0;
  DelDir   : Boolean = TRUE;
  Abfrage  : Boolean = TRUE;
  HidFiles : Boolean = TRUE;
  ROFiles  : Boolean = TRUE;
  SubDirs  : Boolean = TRUE;





PROCEDURE w (s : String);
BEGIN
  DosStr (s); DosStr (#13#10);
END;



PROCEDURE Hilfe;
CONST
s1='lscht Verzeichnisse mit allen Unterverzeichissen und Dateien'#13#10#13#10+
   'DELTREE [Verzeichnis/Datei(en)] [/y /r /h]'#13#10#13#10+
   '/y  lscht das Verzeichnis ohne vorherige Nachfrage'#13#10+
   '/r  lscht keine schreibgeschtzten Dateien';
s2='/h  lscht keine versteckten Dateien'#13#10#13#10+
   'System-Dateien werden generell nicht gelscht. ACHTUNG: Mit DELTREE gelschte'#13#10+
   'Daten sind nur sehr schwer oder gar nicht wiederherstellbar. DELTREE ohne'#13#10+
   'Parameter zeigt eine Eingabemaske.';
BEGIN
  StandardKopf (ProgName, CopyRight);
  w (s1); w (s2); Halt;
END;



PROCEDURE TastenAbfrage; assembler;
ASM
  @nochmal:
    call UpReadKey
    mov  t,  al
    cmp  al, 'J'; je @fertig
    cmp  al, 'N'; je @fertig
    cmp  al, 'A'; je @fertig
    cmp  al,  27; je @fertig
    cmp  al,  13; je @fertig
  jmp @nochmal
  @fertig:
END;



PROCEDURE ListDir (Pfad : PathStr);
VAR
  f : File;
BEGIN
  TmpObjekt:= Objekt;
  While Objekt<>'' Do
  BEGIN
    FindFirst (Vollpfad (Pfad, TeilStr(Objekt)), anyfile, sr);
    While (DosError = 0) and (t<>#27) Do
    BEGIN
      If  (sr.attr and (directory or VolumeID or SysFile) = 0)
      and ((HidFiles) or (sr.attr and hidden   = 0))
      and ((ROFiles)  or (sr.attr and ReadOnly = 0)) Then
      BEGIN
        t:= #0;
        If Abfrage Then
        BEGIN
          DosLineFeed;
          DosStr (sr.name + FillString(14-Length(sr.name)) + '('+Pfad+')');
          TastenAbfrage;
          If t='A' Then Abfrage:= FALSE;
        END;
        If (t=#27) or ((Keypressed) and (UpReadKey = #27)) Then
        EndeProc;

        If (t= 'J') or (t=#13) or (not Abfrage) Then
        BEGIN
          Assign (f, VollPfad (Pfad, sr.name));
          SetFAttr (f, 32);
          Erase (f);
          If IOResult<>0 Then w ('Dateizugriff verweigert')
          Else inc (Files);
        END;
      END;
      FindNext (sr);
    END;
  END;
  Objekt:= TmpObjekt;
END;



PROCEDURE Rek (S : PathStr);
VAR
  tx  : Searchrec;
BEGIN
  Findfirst (Vollpfad (S, '*.*'), anyfile, tx);
  While (DOSError=0) and (t<>#27) Do
  BEGIN
    If (tx.attr and 16<>0) and (tx.name[1]<>'.') Then
    BEGIN
      If Keypressed Then t:= ReadKey;
      ListDir (Vollpfad (S, tx.name));
      Rek (Vollpfad (S, tx.name));
      rmdir (Vollpfad (S, tx.name));
      If IOResult=0 Then inc (Files);
    END;
    Findnext (tx);
  END;
END;



PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Pfad, 'Verzeichnis, das gelscht werden soll:');
  Pfad:= UpCaseStr (Pfad);
  If Pfad = '' Then ErrorEnd ('Ungltige Verzeichnisangabe');

  a2:
  ParamField (6, Abfrage,    'fragt vor Beginn, ob das Verzeichnis gelscht werden soll');
  If t2=Up Then Goto a1;

  a3:
  ParamField (7, HidFiles,   'lscht auch versteckte Dateien');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, ROFiles,    'lscht auch schreibgeschtzte Dateien');
  If t2=Up Then Goto a3;
END;



PROCEDURE Maske;
BEGIN
  GetDir (0, Pfad);
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


LABEL
  PfadTeilen;

BEGIN
  StretchParam (Para);
  If ParamCount = 0 Then Maske Else

  For i:= 1 To ParamCount Do
  BEGIN
    Para:= UpCaseStr (ParamStr (i));
    If Para[1]='/' Then
    CASE Para[2] Of
      '?' : Hilfe;
      'Y' : Abfrage := FALSE;
      'H' : HidFiles:= FALSE;
      'R' : ROFiles := FALSE;
    END Else Pfad:= Para;
  END;

  If Pfad= '' Then Maske;

  If Abfrage Then
  BEGIN
    StandardKopf (ProgName, 'Verzeichnis lschen');
    Fusszeile (Ask); GotoOldPos;
  END;

  If (Pfad[2]=':') and (Length(Pfad)<=3) Then Pfad:= VollPfad (Pfad, '*.*');
  Objekt:= '*.*';

  If pos ('+', Pfad)=0 Then
  BEGIN
    FindFirst (Pfad, anyfile, sr);
    If DOSError<>0 Then ErrorEnd ('Verzeichnis oder Datei nicht gefunden');
    SubDirs:= sr.attr and directory <> 0;

    If (pos (sr.Name, Pfad) <> Length (Pfad) - Length (sr.Name) + 1)
    or (sr.name[1]='.') Then
    BEGIN
      Pfadteilen:
      Objekt:= GetFileName (Pfad);
      Pfad  := GetPathName (Pfad);
      If Pfad[Length(Pfad)] = '\' Then dec (Pfad[0]);
      DelDir:= FALSE;
    END;
  END Else BEGIN SubDirs:=FALSE; Goto PfadTeilen; END;

  If (Abfrage) and (DelDir) Then
  BEGIN
    W (Pfad);
    w ('Wollen Sie dieses Verzeichnis mit allen Dateien wirklich lschen?   J-a  N-ein');
    TastenAbfrage;
    If (t='N') or (t=#27) Then EndeProc;
  END;

  ListDir (Pfad);
  If SubDirs Then Rek (Pfad);

  If DelDir Then
  BEGIN RmDir (Pfad); If IOResult=0 Then inc (Files); END;

  Fusszeile (LongStr(Files)+' Dateien und Verzeichnisse gelscht');
  Halt (0);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
