PROGRAM DeviceManager;
{$M 64000, 0, 0}
USES
  NewCRT, DOS, hexbin, compare, mouse, strings, cButton, keycode;

CONST
  BGAttr    : Byte = DarkGray*16+15;
  WinAttr   = 112;
  FirstLine : Word = 0;
  Balken    : Word = 1;
  Scroll    : Boolean = TRUE;

  Stat : Array[0..2] Of String[35] =
  ('installiert und aktiv', 'nicht installiert', 'installiert und stillgelegt');


TYPE
  DriverHeadRec = RECORD
                    jmp        : array[0..2] Of Byte;
                    Generation : Byte;
                    Nummer     : Byte;
                    VerHigh    : Byte;
                    VerLow     : Byte;
                    IntNum     : Byte;
                    Params     : Byte;
                    Flag       : Byte;
                  END;

  Driver        = RECORD
                    Head    : DriverHeadRec;
                    Name    : String[12];
                  END;


VAR
  DriverList : Array[1..255] Of Driver;
  IntList    : Array[1..255] Of Byte;
  LastInt    : Byte;
  DriverNum  : Word;
  ProgPath   : PathStr;
  x          : Word;
  X1, Y1     : Driver;
  DriverOkay : Boolean;


VAR
  DriverHead : ^DriverHeadRec;



PROCEDURE QuickSort (L, R: Integer);
VAR
  i,  j  : Integer;
BEGIN
  i:= L; j:= R; X1:= DriverList[(L+R) DIV 2];
  REPEAT
    WHILE DriverList[i].name < X1.name Do inc (i);
    WHILE X1.name < DriverList[j].name Do dec (j);
    If i <= j then
    BEGIN
      Y1:= DriverList[i]; DriverList[i]:= DriverList[j]; DriverList[j]:= Y1;
      inc (i); dec (j);
    END;
  UNTIL i > j;
  If L < j Then QuickSort(L, j); If i < R Then QuickSort(i, R);
END;



PROCEDURE GetDriverList;
VAR
  sr : SearchRec;
  f  : File;
  g  : Word;
  b  : DriverHeadRec;

BEGIN
  ProgPath:= ParamStr (0);
  Fillchar (Driverlist, SizeOf (DriverList), 0);
  While (Length(ProgPath)>0) and (ProgPath[Length(ProgPath)]<>'\') Do
  dec (ProgPath[0]);
  DriverNum:= 0;
  FindFirst (ProgPath+'*.COM', anyfile, sr);
  While DOSError=0 Do
  BEGIN
    Assign (f, ProgPath+sr.name); FileMode:= 0; Reset (f, 1);
    BlockRead (f, b, SizeOf(b), g); Close (f);
    If  (IOResult=0) and (g=SizeOf(b))
    and (b.jmp[0]=233) and (b.Generation=1) and (b.Flag=0) Then
    BEGIN
      inc (DriverNum);
      With DriverList[DriverNum] Do
      BEGIN
        Head:= b;
        Name:= copy (sr.name, 1, pos ('.', sr.name)-1);
      END;
    END;
    FindNext (sr);
  END;
  If DriverNum>1 Then QuickSort (1, DriverNum);
END;



PROCEDURE DriverWin;
BEGIN
  TextAttr:= WinAttr; WriteStr ('  Device-Manager '); ClrEol;
  TextAttr:= BGAttr;
  GotoXY (5, 4); TextColor (14);
  WriteStr ('Treiber    Version    Nummer');
  Window (4, 5, 33, 19); TextAttr:= WinAttr; ClrScr;
END;



FUNCTION DriverAddress (IntNr : Byte) : Pointer; assembler;
ASM
  mov ah, 35h
  mov al, IntNr                   (* GetIntVec *)
  int 21h
  mov ax, 100h
  mov dx, es
END;



PROCEDURE DriverHeadMask;
BEGIN
  Window (38, 5, 80, 20); TextAttr:= BGAttr;
  If ScrMode=MonoMon Then TextColor(7) Else TextColor (cyan);
  WriteStrLn ('Name       : '#13#10);
  WriteStrLn ('Status     : '); 
  WriteStrLn ('Generation : ');
  WriteStrLn ('Nummer     : ');
  WriteStrLn ('Version    : ');
  WriteStrLn ('Segment    : ');
  WriteStrLn ('Interrupts : ');
END;



PROCEDURE GetAllInts;
VAR
  x : Byte;
  p : Pointer;
BEGIN
  LastInt:= 0;
  For x:= 0 To 255 Do
  BEGIN
    p:= DriverAddress (x);
    If seg(DriverHead^) = seg(p^) Then
    BEGIN
      inc (LastInt);
      IntList[LastInt]:=x;
    END;
  END;
END;



PROCEDURE OutDriverHead (Nr : Byte);
VAR
  Status : PathStr;
BEGIN
  Window (51, 5, 80, 14); TextAttr:= BGAttr; TextColor (15); ClrScr;
  DriverOkay:= False;
  With DriverList[Nr] Do
  BEGIN
    Swapvectors;
    DriverHead:= DriverAddress (Head.IntNum);
    SwapVectors;
    Head.Flag := DriverHead^.Flag;
    WriteStrLn (Name); LineFeed; 
    If CompareBuffers (Head, DriverHead^, SizeOf(DriverHeadRec))=0 Then
    With Head Do
    BEGIN
      If Flag<=2 Then Status:= Stat[Flag] Else Status:= 'unbekannt';
      WriteStrLn (Status);
      WriteNumLn (Generation); 
      WriteNumLn (Nummer); 
      WriteNum   (VerHigh); WriteStr ('.'); WriteNumLn (VerLow);
      WriteStr   (wordhex(seg(DriverHead^)));
      If seg(Driverhead^) >= $A000 Then WriteStr ('  (UMB)'); LineFeed;
      GetAllInts;
      For x:= 1 To LastInt Do If x<=9 Then WriteStr (ByteHex(IntList[x])+' ');
      DriverOkay:= TRUE;
    END Else WriteStr ('nicht geladen oder umgeleitet');
  END;
END;


PROCEDURE OutPrintHead;
TYPE
  StatusRec = RECORD
                BufSize     : Word;
                WritePtr    : Word;
                ReadPtr     : Word;
                CharCounter : Word;
              END;
VAR
  Status : ^StatusRec;

BEGIN
  Window (38, 14, 80, 20);
  If ScrMode=MonoMon Then TextColor(7) Else TextColor (cyan);
  WriteStrLn ('Puffergre: ');
  WriteStrLn ('Schreib-Pos: ');
  WriteStrLn ('Druck-Pos  : ');
  WriteStr   ('Zeichenzahl: ');
  Window (51, 14, 80, 20); TextColor (15);
  Status:= Ptr (seg(DriverHead^), ofs (DriverHead^)+10);
  With Status^ Do
  BEGIN
  WriteNumLn (BufSize);  
  WriteNumLn (WritePtr);
  WriteNumLn (ReadPtr);  
  WriteNum   (CharCounter);
  END;
END;



PROCEDURE Buttons;
VAR
  x : Byte;
BEGIN
  If (ee=1) and (ScrMode=MonoMon) Then
  BEGIN Window (1, 21, 80, 25); TextAttr:= WinAttr; ClrScr; END;
  Button ( 4, 22, 'L', #0,   'L', '    Laden    ');
  Button (21, 22, 'H', #0,   'H', '  Hochladen  ');
  Button (38, 22, 'E', #0,   'E', '  Entladen   ');
  Button ( 4, 24, 'S', #0,   'S', '  Stillegen  ');
  Button (21, 24, 'A', #0,   'A', '  Aktivieren ');
(*  Button (38, 24, 'I', #0,   'i', '    Hilfe    ');*)
  Button (65, 24, 'B', #0,   'B', '   Beenden   ');
  Button (34,  5,  #0, Up,   #24,  #24);
  Button (34, 19,  #0, Down, #25,  #25);
  If ee=1 Then
  For x:= 6 To 18 Do OutXY (34, x, #176, 7, 0);
END;


PROCEDURE ScrollDown (Zahl : Byte);
BEGIN
  While (Zahl>0) and (FirstLine+Balken<DriverNum) Do
  BEGIN
    dec (Zahl); Scroll:= TRUE;
    If Balken<15 Then inc (Balken) Else inc (FirstLine);
  END;
END;


PROCEDURE ScrollUp (Zahl : Byte);
BEGIN
  While (Zahl>0) and (FirstLine+Balken>1) Do
  BEGIN
    dec (Zahl); Scroll:= TRUE;
    If Balken>1 Then dec (Balken) Else dec (FirstLine);
  END;
END;


PROCEDURE RunProg (Befehl : String);
BEGIN
  CursorOn; GotoXY (1, 1);
  SwapVectors;
  Exec (Getenv ('COMSPEC'), ' /C '+Befehl);
  SwapVectors;
END;


PROCEDURE ExeCute (Befehl : String);
VAR
  Screen : Array[1..4000] Of Byte;
BEGIN
  GetScreen25 (Screen);
  RunProg (Befehl);
  VGAColorOn; CursorOff;
  SetScreen25 (Screen);
  If ScrMode=MonoMon Then BGAttr:= 7 Else ColCursor (magenta shl 4);
END;


PROCEDURE ReadStr (x, y, Len : Byte; VAR ein : String);
BEGIN
  REPEAT
    GotoXY (x, y); WriteStr (ein); ClrEol;
    ScanKeys;
    If t1=#8 Then BEGIN If Length (ein)>0 Then dec (ein[0]); END Else
    If (t1<>#13) and (t1<>#27) and (Length(ein)<Len) Then ein:= ein+t1;
  UNTIL (t1=#13) or (t1=#27);
END;


PROCEDURE LoadDevice (LoadModus, Param : String);
VAR
  Screen : Array[1..4000] Of Byte;
BEGIN
  If Param='' Then
  With DriverList[Balken+FirstLine].Head Do
  If Params<>0 Then
  BEGIN
    GetScreen25 (Screen);
    SaveWindow;
    Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
    RunProg (Progpath+DriverList[Balken+FirstLine].Name+'.COM /?');
    GotoXY (1, 24);
    WriteStr ('Geben Sie die erforderlichen Parameter ein: ');
    ReadStr (45, 24, 20, Param);
    RestoreWindow;
    VGAColorOn;
    SetScreen25 (Screen);
    If ScrMode=MonoMon Then BGAttr:= 7 Else ColCursor (magenta shl 4);
    CursorOff;
    If t1=#27 Then BEGIN t1:= #0; Exit; END;
    t1:= #0;
  END;
  Execute (LoadModus+ProgPath+DriverList[Balken+FirstLine].Name+'.COM'+Param);
END;


BEGIN
  If ParamStr (1)='/?' Then
  BEGIN
    WriteStr (#13#10+
    'DEVMAN  (c) Copyright 1998-2000 Andre Olejko - Freeware'#13#10+
    'Device-Manager zum Steuern von DDD'#13#10#13#10+
    'DEVMAN'#13#10#13#10+
    'Mehr DDD gibt es auch bei:'#13#10+
    'http://www.prignitz-online.de/newdos'#13#10+
    'http://home.t-online.de/home/Andre.Olejko'#13#10);
    Halt;
  END;

  VGAColorOn; CursorOff;
  MouseInit;
  If ScrMode=MonoMon Then BGAttr:= 7 Else ColCursor (magenta*16);
  TextAttr:= BGAttr;
  ClrScr;

  GetDriverList;
  DriverWin;
  DriverHeadMask;
  ee:= 1; Buttons; ee:= 0;

  REPEAT
    If Scroll Then
    BEGIN
      Scroll:= FALSE; 
      Window (4, 5, 33, 20);
      For x:= FirstLine+1 To FirstLine+15 Do
      If x<=DriverNum Then
      With DriverList[x] Do
      BEGIN
        If x=Balken+FirstLine Then
        TextAttr:= red*16+white Else TextAttr:= WinAttr;
        WriteStr (' ');
        WriteStr (Name); WriteStr(FillString(11-Length(Name)));
        WriteNum (Head.VerHigh); WriteStr ('.');
        WriteNum (Head.VerLow);
        WriteStr ('        ');  GotoXY (24, WhereY);
        WriteNum (Head.Nummer); ClrEol; LineFeed;
      END;

      OutDriverHead (Balken+Firstline);
      Window (38, 14, 80, 20); TextAttr:= BGAttr; ClrScr;
      If DriverOkay Then
      CASE DriverList[Balken+FirstLine].Head.Nummer Of
        3 : OutPrintHead;
      END;
    END;

    GetKey;
    If kn<>0 Then
    BEGIN
      If MouseIn (4, 5, 33, 19) Then
      BEGIN
        If ym-4+FirstLine<=DriverNum Then
        BEGIN Balken:= ym-4; Scroll:= TRUE; END;
      END Else Buttons;
    END;
    If t1=#0 Then
    CASE t2 Of
      Up   : ScrollUp   (1);
      Down : ScrollDown (1);
      Pos1 : ScrollUp   (DriverNum);
      Endx : ScrollDown (DriverNum);
      PgUp : ScrollUp   (14);
      PgDn : ScrollDown (14);
    END Else
    BEGIN
    CASE t1 Of
      'A'  : If     DriverOkay Then DriverHead^.Flag:= 0;
      'S'  : If     DriverOkay Then DriverHead^.Flag:= 2;
      'E'  : If     DriverOkay Then LoadDevice ('', ' /X');
      'L'  : If not DriverOkay Then LoadDevice ('','');
      'H'  : If not DriverOkay Then LoadDevice ('LH ','');
    (*  'I'  : Execute (ProgPath+'HELP.EXE DEVMAN');*)
    END;
    If t1<>'I' Then Scroll:= TRUE;
    END;
  UNTIL (t1=#27) or (t1='B');

  VGAColorOff;
  MouseOff; CursorOn;
  Window (1, 1, 80, 25); TextAttr:= 7; ClrScr;
END.
 


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
