PROGRAM Dircomp;
{$M 60000, 2048, 140000} { MinHeap (2048) darf nie 0 sein! }

USES
  DblFile, bioscrt, Dos, strings, masken, keycode, LogFile, filecopy,
  WildCard, ErrorStr;

VAR
  Files        : DoubleFileRec;
  sr1, sr2     : SearchRec;
  x            : Byte;
  Param        : String;
  PStat        : Byte;
  FileNr       : Char;

CONST
  ProgName     = 'DIRCOMP';
  Page         : Boolean = FALSE;
  NotExist     : Boolean = FALSE;
  OnlyIdent    : Boolean = FALSE;
  OnlyNotIdent : Boolean = FALSE;
  Klein        : Boolean = FALSE;
  SubDirs      : Boolean = FALSE;
  FilesFound   : Boolean = FALSE;
  z1           : LongInt = 0;
  z2           : LongInt = 0;
  Dir_1        : PathStr = '';
  Dir_2        : PathStr = '';
  FMask        : PathStr = '';
  Line         : Byte    = 0;


PROCEDURE Hilfe;
CONST
s1='vergleicht alle gleichnamigen Dateien zweier Verzeichnisse byteweise miteinander'#13#10+
   ProgName+' [Verzeichnis 1] [Verzeichnis 2] [ggf. Dateimaske/n] [/s /p /i /u /l /k]'#13#10#13#10+
   '/s  vergleicht auch Dateien in Unterverzeichnissen';
s2='/p  wartet nach jeder Bildschirmseite auf einen Tastendruck'#13#10+
   '/i  listet nur identische Dateien auf'#13#10+
   '/u  listet nur unterschiedliche Dateien auf'#13#10+
   '/l  listet auch die Namen nicht doppelt vorhandener Dateien auf'#13#10+
   '/k  verwendet Kleinschreibung';
BEGIN
  StandardKopf (ProgName, Copyright);
  DOSLnLF (s1); DOSLnLF (s2); Blindstop; Halt;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9;
BEGIN
  t2:= #0;
  a1:
  EditStr (1, Dir_1, 'Name des ersten Verzeichnisses:');

  a2:
  EditStr (5, Dir_2,  'Name des Verzeichnisses, das mit dem ersten verglichen werden soll:');
  If t2=Up Then Goto a1;

  a3:
  EditStr (9, FMask, 'Name der Dateien, die verglichen werden sollen:');
  If t2=Up Then Goto a2;

  a4:
  ParamField (14, SubDirs,  'vergleicht Dateien auch in Unterverzeichnissen');
  If t2=Up Then Goto a3;

  a5:
  ParamField (15, Page,     'wartet nach jeder Bildschirmseite auf einen Tastendruck');
  If t2=Up Then Goto a4;

  a6:
  ParamField (16, OnlyIdent, 'listet nur alle identischen Dateien auf');
  If t2=Up Then Goto a5;

  a7:
  ParamField (17, OnlyNotIdent, 'listet nur alle unterschiedlichen Dateien auf');
  If t2=Up Then Goto a6;

  a8:
  ParamField (18, NotExist, 'zeigt auch die Namen der nicht doppelt vorhandenen Dateien');
  If t2=Up Then Goto a7;

  a9:
  ParamField (19, Klein, 'verwendet Kleinschreibung');
  If t2=Up Then Goto a8;
END;


PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE W1 (s : String);
BEGIN
  DOSLnLF (s);
  If Page Then
  BEGIN
    inc (Line);
    If Line>=23 Then
    BEGIN
      Line:= 0;
      DosStr (#13#10'Weiter mit beliebiger Taste oder Abbruch mit ESC');
      ScanBKeys;
      If t1=#27 Then
      BEGIN ErrCode:= 3; DosLnLF (''); SimpleHaltLOG ('Abbruch durch Anwender'); END;
      DosStr (#13#10#13#10);
    END;
  END;
END;


PROCEDURE WriteName (Msg : String);
BEGIN
  If Klein Then DosStr (LowStr (sr1.name)) Else DosStr (sr1.Name);
  DosStr (FillString(18-Length(sr1.name)));
  w1 (Msg);
END;


PROCEDURE ScanDirs (Dir_1, Dir_2 : PathStr);
VAR
  IsFirstFile : Boolean;
  CompResult  : LongInt;
  IOError     : Integer;

BEGIN
  W1 ('1. '+Dir_1);
  W1 ('2. '+Dir_2);
  IsFirstFile:= TRUE;

  FindFirst (VollPfad (Dir_1, '*.*'), Normalfile, sr1);
  If DOSError>=150 Then
  BEGIN ErrCode:= 2; SimpleHaltLog (Dir_1+' - '+IOResultStr (DOSError)); END Else

  While DosError = 0 Do
  BEGIN
    If (sr1.attr and Directory = 0) and (FileMatch (sr1.Name, FMask)) Then
    BEGIN
      If IsFirstFile Then BEGIN W1 (''); IsFirstFile:= FALSE; END;
      FilesFound:= TRUE;
      inc (z1);

      AssignFiles (Files, VollPfad (Dir_1, sr1.name), VollPfad (Dir_2, sr1.name));

      CompResult:= CompareFiles (Files);
      IOError:= IOResult;

      If IOError = 0 Then
      BEGIN
        CASE CompResult Of
          0  : BEGIN
                 If (OnlyIdent) or (not OnlyNotIdent) Then
                 WriteName ('     Dateien sind identisch');
                 inc (z2);
               END;
          -1 : If (not OnlyIdent) or (OnlyNotIdent) Then
               WriteName ('!!!  Dateien sind unterschiedlich gro');
          Else If (OnlyNotIdent) or (not OnlyIdent) Then
               WriteName ('!!!  Dateien sind unterschiedlich');
        END;
      END
      Else
      BEGIN
        If IOError<0 Then FileNr:= '1' Else FileNr:= '2';
        CASE abs(IOError) Of
          2                : If (IOError<0) and (NotExist) Then
                             WriteName ('!!!  2. Datei nicht gefunden');
          3                : If (IOError<0) and (NotExist) Then
                             BEGIN w1 ('                  !!!  2. Verzeichnis nicht gefunden'#13#10); Exit; END;
          Else               WriteName ('!!! '+FileNr+'. Datei: '+IOResultStr (abs(IOError)));
        END;
      END;
    END;

    If (keyPressed) and (ReadBKey=#27) Then
    BEGIN Errcode:= 3; DosLnLF (''); SimpleHaltLog ('Abbruch durch Anwender'); END;
    FindNext (sr1);
  END;

  w1 ('');
END;


PROCEDURE Rekursiv (Dir_1, Dir_2 : PathStr);
VAR
  D1, D2 : PathStr;
  tg     : Searchrec;
BEGIN
  Findfirst (Vollpfad (Dir_1, '*.*'), Normalfile, tg);
  While DOSError = 0 Do
  BEGIN
    If (tg.attr and directory <> 0) and (tg.name[1]<>'.') Then
    BEGIN
      D1:= VollPfad (Dir_1, tg.name);
      D2:= VollPfad (Dir_2, tg.name);
      Scandirs (D1, D2);
      Rekursiv (D1, D2);
    END;
    Findnext (tg);
  END;
END;


BEGIN
  ClrScr;
  DOSLnLF ('');

FindFirst ('c:\tp\tp_unit\dircomp.exe', anyfile, sr1);
DosLnLF (StrVal(sr1.size));

  StretchParam (Param);
  If ParamCount=0 Then
  BEGIN FMask:= '*'; Dir_1:= FileExpand (''); Dir_2:= Dir_1; Maske; END Else
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'S' : SubDirs     := TRUE;
      'P' : Page        := TRUE;
      'L' : NotExist    := TRUE;
      'I' : OnlyIdent   := TRUE;
      'U' : OnlyNotIdent:= TRUE;
      'K' : Klein       := TRUE;
      'O' : LogStatus   := 0;
    END Else
    BEGIN
      If Dir_1 = '' Then Dir_1:= Param Else
      If Dir_2 = '' Then Dir_2:= Param Else
      If FMask = '' Then FMask:= Param;
    END;
  END;
  If LogStatus=0 Then Page:= FALSE;

  If (Page) or (ParamCount=0) Then BEGIN Window (1, 1, 80, 25); ClrScr; END;

  If Dir_1= '' Then
  BEGIN ErrCode:= 2; SimpleHaltLog ('Verzeichnisangaben fehlen'); END;

  Dir_1:= FileExpand (Dir_1);
  If DOSError=0 Then PStat:= PathStatus (Dir_1, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then BEGIN ErrCode:= 2; SimpleHaltLog (PathStatusStr (PStat)); END;

  Dir_2:= FileExpand (Dir_2);
  If DOSError=0 Then PStat:= PathStatus (Dir_2, CheckQuelle) Else PStat:= DOSError;
  If PStat<>0 Then BEGIN ErrCode:= 2; SimpleHaltLog (PathStatusStr (PStat)); END;

  If ObjektExist (Dir_1) and (Ver or Root) = 0 Then
  BEGIN ErrCode:= 2; SimpleHaltLog (Dir_1+' - Verzeichnis nicht gefunden'); END;

  If ObjektExist (Dir_2) and (Ver or Root) = 0 Then
  BEGIN ErrCode:= 2; SimpleHaltLog (Dir_2+' - Verzeichnis nicht gefunden'); END;

  If FMask= '' Then FMask:= '*';

  ScanDirs (Dir_1, Dir_2);
  If SubDirs Then Rekursiv (Dir_1, Dir_2);

  If ((z1=z2) and (z1<>0)) or (not FilesFound) Then
  BEGIN
    ErrCode:= 0;
    SimpleHaltLog ('Alle ausgewhlten und doppelt vorhandenen Dateien sind identisch');
  END Else
  BEGIN ErrCode:= 1; SimpleHaltLog ('Es wurden Unterschiede gefunden'); END;
END.



{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
