PROGRAM DiskComp;
{$M, 10000, 0, 0}

USES
  bioscrt, compare, masken, dos, keycode, strings, logfile, disk,
  laufbalk;

CONST
  ProgName  = 'DISKCOMP';
  Max       = 64;
  BSize     = 512*Max;
  ErstDisk  = 1;
  ZweitDisk = 2;

  QWait     : Boolean = TRUE;
  ZWait     : Boolean = TRUE;
  Nochmal   : Boolean = FALSE;
  SFormat   : Boolean = FALSE;
  MoreDisks : Boolean = FALSE;
  CheckBoot : Boolean = FALSE;
  wy        : Byte    = 1;
  SecError  : Byte    = 0;
  ErgStr    : String  = '';
  LW        : Array[1..2] Of Char = #0#0;

TYPE
  bloc  = array[1..Max] of array[1..512] Of char;

  BootR = RECORD
            Jump           : array[1..3] Of Byte;
            ID             : array[1..8] of Char;
            BytesProSec    : Word;
            SecProClust    : Byte;
            ReservSec      : Word;
            Fat_Kopien     : Byte;
            Max_HauptEinTr : Word;
            GesamtSec      : Word;
            MedienBeschr   : Byte;
            SecProFAT      : Word;
            SecProSpur     : Word;
            DiskSeiten     : Word;
            VerstecktSec   : Word;
            UniArray       : array[1..9] Of Byte;
            DiskNummer     : LongInt;
            DiskLabel      : Array[1..11] Of Char;
            FAT_Type       : array[1..8]  Of Char;
          END;


VAR
  Spur, Seite,
  Sektor           : Byte;
  xSpur, xSektor   : Word;
  Param            : String;
  LeseSektoren     : Byte;
  x                : Byte;
  Buf              : bloc;
  MaxSec           : Byte;
  MaxSides         : Word;
  Zylinder         : Word;
  Durchgang        : Byte;
  Prozent          : LongInt;
  Identisch        : Boolean;

  BootRec          : BootR absolute Buf;
  NBootRec         : BootR;

  ChkSums          : Array[0..1049, 0..1] Of Word;
  Versuche         : Byte;


PROCEDURE Hilfe;
CONST
Text1=
  'Vergleicht Disketten miteinander'#13#10#13#10+
  'DISKCOMP [Quelllaufwerk] [Ziellaufwerk] [/q /z /r /m /s /b /o]'#13#10;
Text2=
  '/q  unterdrckt die Aufforderung zum Einlegen der Erst-Diskette'#13#10+
  '/z  unterdrckt die Aufforderung zum Einlegen der Zweit-Diskette'#13#10+
  '/r  fragt, ob Sie noch zwei Disketten vergleichen wollen';
Text3=
  '/m  fragt, ob Sie noch eine Diskette mit der Erst-Diskette vergleichen wollen'#13#10+
  '/s  vergleicht Disketten mit Sonderformat oder leichten Fehlern'#13#10+
  '/b  vergleicht auch die beiden Boot-Sektoren'#13#10+
  '/o  Fehler und Unterschiede werden in der LOG-Datei protokolliert';
BEGIN
  Standardkopf (ProgName, copyright);
  DosLn (Text1); DosLn (text2); DosLn (text3);
  BlindStop; Halt;
END;



PROCEDURE ReadSektor (LW:Char; VAR buff; Spur:Word; Seite,Sektor,SecToRead:Byte); Assembler;
ASM
  mov Byte Ptr Versuche, 0
  @neuerversuch:
  mov ah, 2           {Befehl 2: lesen, 3: schreiben}
  mov al, SecToRead   {Lese Sektor-Anzahl}

  mov dl, LW          {Laufwerk: A=0, B=1 usw, C=$80, D=$81 (Bit 7 gesetzt)}
  and dl, 00011111b   {'A' und 'a' = 1 usw.}
  dec dl              {A=0 usw}

  mov bx, Spur
  mov cl, 6
  shl bh, cl

  mov ch, bl          {Spur   0 -  x, bei C Zylindernummer}
  mov cl, Sektor      {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  add cl, bh

  mov dh, Seite       {Seite  0/1, bei C Kopfnummer 0..x}
  les bx, Buff        {Pufferaddresse}
  int 13h
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah
END;


FUNCTION DisSize (LW : Char) : Word; assembler;
ASM
  mov ah, 36h
  mov dl, LW
  and dl, 00011111b   {#1, 'A' und 'a' = 1 usw.}
  int 21h
END;



PROCEDURE Read_BootRecord (LW : Char);
BEGIN
  If DisSize (LW) = 65535 Then ErrorHaltLog ('Laufwerk nicht bereit');
  ReadSektor (LW, Buf, 0, 0, 1, 1);
  If (BootRec.BytesProSec <> 512) or (SecError<>0) Then
  ErrorHaltLog ('Datentrger nicht ansprechbar');
  With BootRec Do
  BEGIN
    Zylinder := (GesamtSec+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
    MaxSec   := SecProSpur;
    MaxSides := DiskSeiten-1;
  END;
END;


PROCEDURE Write_Error;
BEGIN
  CASE SecError Of
    $02 : DosLn ('Adressmarkierung nicht gefunden');
    $04 : DosLn ('Sektor nicht gefunden');
    $10 : DosLn ('Prfsummenfehler');
    $20 : DosLn ('Controller-Fehler');
    Else  DosLn ('unbekannter Fehler');
  END;
END;


PROCEDURE LeseSpur (Spur : Word; Seite, SecToRead, Modus : Byte);
VAR
  Sektor : Byte;
BEGIN
  Sektor:= 1;
  REPEAT
    ReadSektor (LW[1], Buf[Sektor], Spur, Seite, Sektor, SecToRead);
    If SecError<>0 Then BEGIN GotoXY (1, wy); Write_Error; wy:= WhereY; END;
    inc (Sektor, SecToRead);
    If (Keypressed) and (UpReadBKey=#27) Then UserAbortLog;
  UNTIL Sektor>=MaxSec;

  If (Spur=0) and (Seite=0) and (not CheckBoot) Then Sektor:= 2 Else Sektor:= 1;

  If Modus = ErstDisk Then
  ChkSums[Spur, Seite]:= CheckSum (Buf[Sektor], 512 * (MaxSec-Sektor+1)) Else
  If
  ChkSums[Spur, Seite]<> CheckSum (Buf[Sektor], 512 * (MaxSec-Sektor+1)) Then
  BEGIN
    GotoXY (1, wy);
    DosStr ('Unterschied (Spur-Seite) : ');
    DosNum (Spur); DosStr ('-'); DosNum (Seite); 
    DosLineFeed;
    wy:= WhereY;
    Identisch := FALSE;
  END; 
END;


PROCEDURE Program_FirstInit;
VAR
  i : Byte;
BEGIN
  t1:= #0;
  Unterbalken (15, 'von Erstdiskette  gelesen');
  Unterbalken (18, 'von Zweitdiskette gelesen');
  If QWait Then
  BEGIN
    Tastenabfrage ('Erstdiskette einlegen und Enter drcken oder Abbruch mit Esc', #13, #27);
    If t1= #27 Then UserAbort;
  END;

  Read_Bootrecord (LW[1]);
  NBootRec:= BootRec;
  If SFormat Then LeseSektoren:= 1 Else LeseSektoren:= MaxSec;

  Fusszeile ('Lese Erstdiskette in Laufwerk '+LW[1]+':  (Abbrechen mit Esc)'); GotoOldPos;
  Identisch:= TRUE;
END;



PROCEDURE DiskEinlesen (Modus : Byte);
BEGIN
  xSpur:=0;
  REPEAT
    Seite:= 0;
    REPEAT
      LeseSpur (xSpur, Seite, LeseSektoren, Modus);
      inc (Seite);
    UNTIL Seite > MaxSides;
    inc (xSpur); Balken (15+((Modus-1)*3), xSpur, Zylinder);
  UNTIL xSpur >= Zylinder;
END;



PROCEDURE Program_SecondInit;
BEGIN
  ClrScr; wy:= 1;
  Unterbalken (18, 'von Zweitdiskette gelesen');
  Read_Bootrecord (LW[2]);
  
  With NBootRec Do If
  (Zylinder  <> (GesamtSec+VerstecktSec) DIV SecProSpur DIV DiskSeiten) or
  (MaxSec    <> SecProSpur) or
  (MaxSides  <> DiskSeiten-1) Then
  ErrorHaltLog ('Erst- und Zweitdiskette haben ein unterschiedliches Format');

  Fusszeile ('Lese Zweitdiskette in Laufwerk '+LW[2]+':  (Abbrechen mit Esc)'); GotoOldPos;
  Identisch:= TRUE;
END;



PROCEDURE ShowMaske;
VAR
  lw1, lw2 : PathStr;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8;
BEGIN
  t2:= #0;
  lw1:='A:'; Lw2:= 'A:';
  a1:
  EditStr (1, lw1, 'Laufwerk, das die erste Diskette enthlt:');
  If lw1 <>'' Then LW[1]:= UpCase (lw1[1]) Else LW[1]:= #0;

  a2:
  EditStr (5, lw2, 'Laufwerk, das die zweite Diskette enthlt:');
  If t2=Up Then Goto a1;
  If lw2 <>'' Then LW[2]:= UpCase (lw2[1]) Else LW[2]:= #0;

  a3:
  ParamField (10, QWait,    'fordert vor Beginn zum Einlegen der Erst- Diskette auf');
  If t2=Up Then Goto a2;

  a4:
  ParamField (11, ZWait,    'fordert vor Beginn zum Einlegen der Zweit-Diskette auf');
  If t2=Up Then Goto a3;

  a5:
  ParamField (12, Nochmal,  'fragt am Ende, ob zwei weitere Disketten verglichen werden sollen');
  If t2=Up Then Goto a4;

  a6:
  ParamField (13, MoreDisks,'fragt, ob eine weitere Disk mit der Erst-Diskette verglichen werden soll');
  If t2=Up Then Goto a5;

  a7:
  ParamField (14, SFormat,  'vergleicht auch Disketten mit Sonderformat oder leichten Fehlern');
  If t2=Up Then Goto a6;

  a8:
  ParamField (15, CheckBoot,'vergleicht auch die Bootsektoren beider Disketten');
  If t2=Up Then Goto a7;

  If (ee=0) and (lw1='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;


PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE CheckDrive (LW : Char);
BEGIN
  If (LW>'B') or (LW<'A') Then SimpleHaltLog ('Es werden nur die Laufwerke A und B untersttzt');
  x:= Drive (LW);
  If x and Phantomdrive<>0 Then SimpleHaltLog ('Phantomlaufwerk wird nicht untersttzt') Else
  If x and Substdrive  <>0 Then SimpleHaltLog ('SUBST-Laufwerk wird nicht untersttzt') Else
  If x and (NetDrive or InterLnkDrive) <> 0 Then SimpleHaltLog ('Netz-Laufwerk wird nicht untersttzt');
END;


{---------------------------- HauptProgramm -----------------------------}

BEGIN                                              
  StretchParam (Param);
  If ParamCount = 0 Then Maske Else

  For Durchgang:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (Durchgang));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'Q' : QWait    := FALSE;
      'Z' : ZWait    := FALSE;
      'R' : Nochmal  := TRUE;
      'S' : SFormat  := TRUE;
      'M' : MoreDisks:= TRUE;
      'B' : CheckBoot:= TRUE;
      'O' : LogStatus:= 0;
    END
    Else    BEGIN
              If LW[1]=#0 Then LW[1]:= Param[1] Else
              If LW[2]=#0 Then LW[2]:= Param[1];
            END;
  END;

  If LW[1] = #0 Then SimpleHaltLog ('Laufwerks-Bezeichner fehlt');
  If LW[2] = #0 Then LW[2]:= LW[1];
  CheckDrive (LW[1]);
  CheckDrive (LW[2]);

  If LogStatus=0 Then BEGIN QWait:= FALSE; ZWait:= FALSE; END;

  StandardKopf (ProgName, 'Disketten-Vergleich');
  Window (1, 3, 80, 14);

  REPEAT
    Program_FirstInit;
    DiskEinlesen (ErstDisk);

    REPEAT
      If ZWait Then
      BEGIN
        Tastenabfrage ('Zweit-Diskette einlegen und Enter drcken oder Abbruch mit Esc', #13, #27);
        If t1= #27 Then UserAbort;
      END;

      Program_SecondInit;

      DiskEinlesen (ZweitDisk);
      If Identisch Then ErgStr:= 'Disketten sind identisch. ' Else
                        Ergstr:= 'Disketten unterscheiden sich. ';
      If not Identisch Then AppendErr (ErgStr);

      If MoreDisks Then
      Tastenabfrage (ErgStr+'Weitere Disk mit Erstdiskette vergleichen? (j/n)', 'N', 'J');
    UNTIL (t1='N') or (not MoreDisks);

    If Nochmal Then
    BEGIN
      Tastenabfrage (ErgStr+'Noch zwei Disketten vergleichen? (j/n)', 'J', 'N');
      If t1 = 'N' Then t1:= #27;
    END;

  UNTIL (t1=#27) or (Nochmal=FALSE);

  ErrorHalt ('Vergleich beendet. '+ErgStr);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
