PROGRAM DiskCopy;
{$M, 10000, 0, 0}

USES
  bioscrt, Laufbalk, Dos, monitor, masken, keycode, strings, Logfile,
  disk, filecopy, rechnen;

CONST
  ProgName  = 'DISKCOPY';
  Max       = 64;
  BSize     = 512*Max;
  ENTER     = #13#10'Weiter mit Taste';
  Lesen     = 2;
  Schreiben = 3;
  ImageFile : PathStr = 'C:\DISKCOPY.IMG';
  Writing   : Boolean = TRUE;
  QWait     : Boolean = TRUE;
  ZWait     : Boolean = TRUE;
  Nochmal   : Boolean = FALSE;
  SFormat   : Boolean = FALSE;
  MoreDisks : Boolean = FALSE;
  SaveTemp  : Boolean = FALSE;
  TakeImage : Boolean = FALSE;
  QuickCopy : Boolean = FALSE;
  NewNumber : Boolean = TRUE;
  GetImg    : Boolean = FALSE;
  PutImg    : Boolean = FALSE;
  Unknown   : Boolean = FALSE;
  TestDisk  : Boolean = FALSE;
  SecError  : Byte    = 0;

  LW        : Array[1..2] Of Char = #0#0;

TYPE
  bloc  = array[1..Max] of array[1..512] Of char;

  BootR = RECORD
            Jump           : array[1..3] Of Byte;
            ID             : array[1..8] of Char;
            BytesProSec    : Word;
            SecProClust    : Byte;
            ReservSec      : Word;
            Fat_Kopien     : Byte;
            Max_HauptEinTr : Word;
            GesamtSec      : Word;
            MedienBeschr   : Byte;
            SecProFAT      : Word;
            SecProSpur     : Word;
            DiskSeiten     : Word;
            VerstecktSec   : Word;
            UniArray       : array[1..9] Of Byte;
            DiskNummer     : LongInt;
            DiskLabel      : Array[1..11] Of Char;
            FAT_Type       : array[1..8]  Of Char;
          END;


VAR
  ErrWrite         : Boolean;
  SecFile          : File;
  Param            : String;

  Sektoren_gelesen : LongInt;
  SectorNum        : LongInt;
  Fehler           : LongInt;
  LeseSektoren     : Byte;

  x         : Byte;
  Buf       : bloc;
  MaxSec    : Byte;
  MaxSides  : Word;
  Zylinder  : Word;
  Durchgang : Byte;
  Filler    : Char;

  BootRec             : BootR absolute Buf;
  NBootRec            : BootR;
  Spur, Seite, Sektor : Byte;
  xSpur, xSektor      : Word;
  Versuche            : Byte; { wird von Read/Write verwendet }
  ReadTrys            : Word;
  WriteTrys           : Word;
  PStat               : Byte;


PROCEDURE w  (s : String); BEGIN OutStr (s); OutStr (#13#10); END;
PROCEDURE dw (s : String); BEGIN DosStr (s); DosStr (#13#10); END;



PROCEDURE ErrorBreak (s : String);
BEGIN
  If FileRec(SecFile).Mode <> fmClosed Then
  BEGIN
    Close (SecFile);
    If not SaveTemp Then Erase (SecFile);
    If IOResult <> 0 Then;
  END;
  ErrCode:= SecError; If ErrCode=0 Then ErrCode:= 1;
  ErrorHaltLog (s);
END;


PROCEDURE Hilfe;
BEGIN
  StandardKopf (ProgName, Copyright);
  dw (
  'Dupliziert Disketten'#13#10#13#10+
  'DISKCOPY [Quelllaufwerk] [Ziellaufwerk] [Parameter]'#13#10);
  dw (
  '/q   unterdrckt die Aufforderung zum Einlegen der Quelldiskette'#13#10+
  '/z   unterdrckt die Aufforderung zum Einlegen der Ziel-Diskette'#13#10+
  '/r   fragt, ob Sie eine weitere Diskette kopieren wollen');
  dw (
  '/w   fragt, ob sie von der Quelldiskette weitere Kopien anlegen wollen'#13#10+
  '/s   kopiert Disketten mit Sonderformat oder leichten Fehlern'#13#10+
  '/g   erzwingt eine vorgegebene Datentrger-Geometrie. /g:9-80-2 bedeutet');
  dw (
  '     z.B., da die Diskette je 9 Sektoren in 80 Spuren auf 2 Seiten hat.'#13#10+
  '     Geben Sie /g:? ein, wenn Diskcopy diese Werte selbst ermitteln soll.'#13#10+
  '/t   unterdrckt das abschlieende Lschen der Imagedatei');
  dw (
  '/i   verwendet zum Kopieren die Imagedatei statt einer Quelldiskette'#13#10+
  '/x   beschleunigt das Kopieren nur teilweise gefllter Disketten'#13#10+
  '/n   Zieldiskette bekommt die gleiche Nummer wie die Quelldiskette');
  dw (
  '/o   Fehler werden in der LOG-Datei protokolliert'#13#10);
  DosStr (
  '/t:Dateiname   speichert Disk-Image als Datei mit beliebigem Namen'#13#10+
  '/i:Dateiname   kopiert die angegebene Image-Datei auf Diskette'#13#10#13#10+
  'z.B. DISKCOPY A: /t:C:\DISK0001.IMG oder DISKCOPY A: /i:C:\DISK0001.IMG');

  BlindStop; Halt;
END;



PROCEDURE ReadSektor (Modus:Byte; LW:Char; VAR buff; Spur:Word; Seite,Sektor,SecToRead:Byte); Assembler;
ASM
  mov Byte Ptr Versuche, 0
  @neuerversuch:
  mov ah, Modus       {Befehl 2: lesen, 3: schreiben}
  mov al, SecToRead   {Lese Sektor-Anzahl}

  mov dl, LW          {Laufwerk: A=0, B=1 usw, C=$80, D=$81 (Bit 7 gesetzt)}
  and dl, 00011111b   {'a' und 'a' = 1 usw.}
  dec dl              {A=0 usw}

  mov bx, Spur
  mov cl, 6
  shl bh, cl

  mov ch, bl          {Spur   0 -  x, bei C Zylindernummer}
  mov cl, Sektor      {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  add cl, bh

  mov dh, Seite       {Seite  0/1, bei C Kopfnummer 0..x}
  les bx, Buff        {Pufferaddresse}
  int 13h
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah
END;




FUNCTION DisSize (LW : Char) : Word; assembler;
ASM
  mov ah, 36h
  mov dl, LW
  and dl, 00011111b   {#1, 'A' und 'a' = 1 usw.}
  int 21h
END;



PROCEDURE GetFiller (LW : Char); assembler;
ASM
  mov ah, 08h
  mov dl, LW
  sub dl, 65
  int 13h
  mov al, es:[di+8]
  mov Filler, al
END;



PROCEDURE Check_Buffer (VAR buf; Size : Word); assembler;
ASM
  xor dx, dx
  mov cx, Size
  shr cx, 1
  mov al, Filler
  mov ah, al
  cld
  les di, buf
  repe scasW
  je @ende
  mov dx, 1
  @ende:
  mov Writing, dl
END;



PROCEDURE Read_BootRecord (LW : Char);
BEGIN
  If Unknown Then Exit;
  If DisSize (LW) = 65535 Then ErrorBreak ('Laufwerk nicht bereit');
  ReadSektor (Lesen, LW, Buf, 0, 0, 1, 1);
  If (BootRec.BytesProSec<>512) or (SecError<>0) Then
  ErrorBreak ('Datentrger nicht ansprechbar');
  With BootRec Do
  BEGIN
    Zylinder  := (GesamtSec+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
    SectorNum := (GesamtSec+VerstecktSec);
    MaxSec    := SecProSpur;
    MaxSides  := DiskSeiten-1;
  END;
END;



PROCEDURE Write_Anzeige (LWNr : Byte; Txt : String);
BEGIN
  Standardkopf ('DISKCOPY - '+txt+' Datentrger in Laufwerk '+LW[LWNr], '');
  OutStr ('Spur / Zylinder :                von : ');
  OutNum (Zylinder);  w ('');
  OutStr ('Sektor absolut  :                von : ');
  OutNum (SectorNum);
  W      (#13#10#10'Fehler          :'#13#10);
  If (GetImg) or (PutImg) Then 
  w      ('Image-Datei     : '+ImageFile);
  Unterbalken (15, 'Gelesen');
  Unterbalken (18, 'Geschrieben');
END;



PROCEDURE Write_LeseZeiger;
BEGIN
  GotoXY (19, 1); OutNum (xSpur);
  GotoXY (19, 2); OutNum (Sektoren_gelesen);
  GotoXY (19, 4); OutNum (Fehler);
  If SecError<>0 Then
  BEGIN
    CASE SecError Of
      $02 : OutStr ('  Adressmarkierung nicht gefunden');
      $03 : If Logstatus=2 Then
            BEGIN
              Tastenabfrage ('Diskette ist schreibgeschtzt. Wechseln/Entriegeln und wiederholen? (j/n)', 'J', 'N');
              If t1='N' Then UserAbortLog;
              Fusszeile ('Abbrechen mit Esc'); GotoOldPos; Exit;
            END Else ErrorBreak ('Ziel-Diskette ist schreibgeschtzt');
      $04 : OutStr ('  Sektor nicht gefunden');
      $10 : OutStr ('  Prfsummenfehler');
      $20 : OutStr ('  Controller-Fehler');
      Else  OutStr ('  sonstiger Fehler');
    END;
    If not ErrWrite Then BEGIN AppendErr ('Fehler beim Kopieren'); ErrWrite:= TRUE; END;
    ClrEol;
  END;
END;



PROCEDURE LeseSpur (Spur : Word; Seite, SecToRead : Byte);
VAR
  Sektor : Byte;
  ges    : Word;
BEGIN
  Sektor := 1;
  REPEAT
    ReadSektor (Lesen, LW[1], Buf[Sektor], Spur, Seite, Sektor, SecToRead);
    If SecError<>0 Then
    BEGIN inc (Fehler); Write_LeseZeiger; END Else
    If (Versuche<>0) and ((Spur>0) or (Seite<>0)) Then inc (ReadTrys);
    inc (Sektor, SecToRead);
  UNTIL ((Keypressed) and (ReadBKey=#27)) or (Sektor>= MaxSec);
  BlockWrite (SecFile, Buf, MaxSec shl 9, ges);
  If (IOResult<>0) or (ges <> MaxSec shl 9) Then
  ErrorBreak ('Schreibfehler in Image-Datei');
END;



PROCEDURE SchreibeSpur (Spur : Word; Seite, SecToRead : Byte);
VAR
  Sektor : Byte;
  gel    : Word;
  dt     : DateTime;
  l      : LongInt;
LABEL
  Nochmal;
BEGIN
  BlockRead (SecFile, Buf, MaxSec shl 9, gel);
  If (IOResult<>0) or (gel <> MaxSec shl 9) Then
  ErrorBreak ('Lesefehler in Image-Datei');
  If (NewNumber) and (Spur=0) and (Seite=0) and (not Unknown) Then
  BEGIN
    With dt Do GetDate (year, Month, day, gel);
    With dt Do GetTime (hour, min,   sec, gel);
    PackTime (dt, l);
    BootRec.DiskNummer:= l;
  END;
  Sektor:= 1;
  REPEAT
    If QuickCopy Then Check_Buffer (Buf[Sektor], SecToRead shl 9);
    If (not QuickCopy) or (Writing) Then
    BEGIN
      Nochmal:
      ReadSektor (Schreiben, LW[2], Buf[Sektor], Spur, Seite, Sektor, SecToRead);
      If SecError<>0 Then
      BEGIN Write_LeseZeiger; If SecError=3 Then Goto Nochmal; inc (Fehler); END Else
      If (Versuche<>0) and ((Spur>0) or (Seite<>0)) Then inc (WriteTrys);
    END;
    inc (Sektor, SecToRead);
  UNTIL ((Keypressed) and (ReadBKey=#27)) or (Sektor>=MaxSec);
END;



PROCEDURE Program_FirstInit;
VAR
  i : Byte;
BEGIN
  ReadTrys:= 0; ErrWrite:= False;
  t1:=#0;

  If QWait Then
  BEGIN
    TastenAbfrage ('Quelldiskette einlegen und Enter drcken (Abbruch mit Esc)', #13, #27);
    If t1= #27 Then UserAbort;
  END;

  Read_Bootrecord (LW[1]);
  NBootRec:= BootRec;
  If SFormat Then LeseSektoren:= 1 Else LeseSektoren:= MaxSec;

  Write_Anzeige (1, 'Lesen von');
  Sektoren_gelesen:=0;
  Fehler:=0;

  FileMode:= 2;

  If GetImg Then
  BEGIN
    Reset (SecFile, 1); Close (SecFile);
    If IOResult=0 Then
    BEGIN
      Tastenabfrage ('Image-Datei existiert bereits. berschreiben? (j/n)', 'J', 'N');
      If t1='N' Then UserAbort;
    END;
  END;

  Rewrite (SecFile, 1);
  If IOResult<>0 Then
  BEGIN
    SetFAttr (SecFile, 32); Rewrite (SecFile, 1);
    If IOResult <>0 Then
    ErrorBreak ('Image-Datei konnte nicht angelegt werden.');
  END;
  Fusszeile ('Abbrechen mit Esc');
END;



PROCEDURE DiskEinlesen;
BEGIN
  xSpur:=0;
  REPEAT
    Seite:= 0;
    REPEAT
      LeseSpur (xSpur, Seite, LeseSektoren);
      inc (Seite);
      inc (Sektoren_gelesen, MaxSec);
    UNTIL (t1=#27) or (Seite > MaxSides);
    inc (xSpur);
    Write_LeseZeiger; Balken (15, xSpur, Zylinder);
  UNTIL (t1=#27) or (xSpur >= Zylinder);
END;



PROCEDURE Program_SecondInit;
VAR
  DiskSiz : LongInt;
BEGIN
  t1:=#0; WriteTrys:= 0; ErrWrite:= FALSE;
  If not TakeImage Then Close (SecFile) Else LW[2]:= LW[1];

  FileMode:= 0;
  Reset (SecFile, 1);
  If IOResult <> 0 Then ErrorBreak ('Image-Datei nicht gefunden.');

  Read_Bootrecord (LW[2]);

  If TakeImage Then
  BEGIN
    If SFormat Then LeseSektoren:= 1 Else LeseSektoren:= MaxSec;
    Unterbalken (18, 'Geschrieben');
    With BootRec Do
    BEGIN
      If Unknown Then
      DiskSiz:= LongInt(MaxSec)     * LongInt(512) *
                LongInt(MaxSides+1) * LongInt(Zylinder) Else
      DiskSiz:= LongInt(SecProSpur) * LongInt(BytesProSec) *
                LongInt(Diskseiten) * LongInt(Zylinder);
      If FileSize (SecFile) <> DiskSiz Then
      ErrorBreak ('Zieldiskette und Image-Datei sind nicht kompatibel');
    END;
  END Else
  If not Unknown Then
  BEGIN
    With NBootRec Do If
    (Zylinder  <> (GesamtSec+VerstecktSec) DIV SecProSpur DIV DiskSeiten) or
    (MaxSec    <> SecProSpur) or
    (MaxSides  <> DiskSeiten-1) Then
    ErrorBreak ('Quell- und Zieldiskette haben ein unterschiedliches Format');
  END;

  Write_Anzeige (2, 'Schreiben auf');
  If not PutImg Then Balken (15, 100, 100);

  Sektoren_gelesen:= 0;
  Fehler:= 0;
  If QuickCopy Then GetFiller (LW[2]);
  Fusszeile ('Abbrechen mit Esc');
END;


PROCEDURE DiskSchreiben;
BEGIN
  xSpur:=0;
  REPEAT
    Seite:= 0;
    REPEAT
      SchreibeSpur (xSpur, Seite, LeseSektoren);
      inc (Seite);
      inc (Sektoren_gelesen, MaxSec);
    UNTIL (t1=#27) or (Seite > MaxSides);
    inc (xSpur);
    Write_LeseZeiger; Balken (18, xSpur, Zylinder);
  UNTIL (t1=#27) or (xSpur >= Zylinder);
END;


PROCEDURE TestDiskette;
BEGIN
  Standardkopf (ProgName, 'Datentrgeranalyse');
  Fusszeile ('Bitte warten. Mechanische Datentrger-Analyse...                 Abbruch mit Esc');
  GotoOldPos;
  MaxSides:= 0;
  Zylinder:= 0;
  MaxSec  := 0;

  OutStr ('Sektoren: '); SecError:= 0;
  REPEAT
    inc (MaxSec);
    ReadSektor (Lesen, LW[1], Buf, 0, 0, MaxSec, 1);
    GotoXY (11, 1); OutNum (MaxSec-1);
    If (Keypressed) and (UpReadBKey=#27) Then UserAbort;
  UNTIL SecError<>0;
  dec (MaxSec);

  OutStr (#13#10'Zylinder: '); SecError:=0;
  REPEAT
    ReadSektor (Lesen, LW[1], Buf, Zylinder, 0, MaxSec, 1);
    If SecError=0 Then inc (Zylinder);
    GotoXY (11, 2); OutNum (Zylinder);
    If (Keypressed) and (UpReadBKey=#27) Then UserAbort;
  UNTIL SecError<>0;

  OutStr (#13#10'Seiten  : '); SecError:=0;
  REPEAT
    ReadSektor (Lesen, LW[1], Buf, Zylinder, MaxSides, MaxSec, 1);
    inc (MaxSides);
    GotoXY (11, 3); OutNum (MaxSides+1);
    If (Keypressed) and (UpReadBKey=#27) Then UserAbort;
  UNTIL SecError<>0;

  If Logstatus=2 Then
  Tastenabfrage ('Soll DISKCOPY die ermittelten Werte anwenden? (j/n)', 'J', 'N');
  If t1='N' Then UserAbort;
  SectorNum:= LongInt(MaxSides+1)*LongInt(Zylinder)*LongInt (MaxSec);
  Unknown:= TRUE;
END;


PROCEDURE GetGeometrie (Param : PathStr);
VAR
  tmp     : Array[1..3] Of String;
  c, d, e : Integer;
BEGIN
  For c:= 1 To 3 Do tmp[c]:= '';
  c:= 1;
  For d:= 1 To Length (Param) Do
  If (Param[d]='-') and (c<3) Then inc (c) Else tmp[c]:= tmp[c]+Param[d];
  If tmp[1]='?' Then BEGIN TestDisk:= TRUE; Exit; END;
  Val (tmp[1], MaxSec,   c);
  Val (tmp[2], Zylinder, d);
  Val (tmp[3], Maxsides, e);
  If (c+d+e<>0) or (MaxSides=0) or (Zylinder=0)    or (MaxSec=0)
                or (Maxsides>2) or (Zylinder>1024) or (MaxSec>64) Then
  ErrorBreak ('Angabe der Laufwerksgeometrie hat ungltiges Format');
  SectorNum:= LongInt(MaxSides)*LongInt(Zylinder)*LongInt (MaxSec);
  dec (MaxSides);
  Unknown:= TRUE;
END;


PROCEDURE ShowMaske;
VAR
  lw1, lw2 : PathStr;
LABEL
  a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11;
BEGIN
  t2:= #0;
  lw1:='A:'; Lw2:= 'A:';

  a1:
  EditStr (1, lw1, 'Laufwerk, das die Quell-Diskette enthlt:');
  If lw1 <>'' Then LW[1]:= UpCase (lw1[1]) Else LW[1]:= #0;
 
  a2:
  EditStr (5, lw2, 'Laufwerk, das die Ziel-Diskette enthlt:');
  If t2=Up Then Goto a1;
  If lw2 <>'' Then LW[2]:= UpCase (lw2[1]) Else LW[2]:= #0;

  a3:
  ParamField (10, QWait,    'fordert vor Beginn zum Einlegen der Quell-Diskette auf');
  If t2=Up Then Goto a2;

  a4:
  ParamField (11, ZWait,    'fordert vor Beginn zum Einlegen der Ziel- Diskette auf');
  If t2=Up Then Goto a3;

  a5:
  ParamField (12, Nochmal,  'fragt am Ende, ob zwei weitere Disketten kopiert werden sollen');
  If t2=Up Then Goto a4;

  a6:
  ParamField (13, MoreDisks,'fragt, ob von der Quell-Diskette weitere Kopien angefertigt werden sollen');
  If t2=Up Then Goto a5;

  a7:
  ParamField (14, SFormat,  'kopiert auch Disketten mit Sonderformat oder leichten Fehlern');
  If t2=Up Then Goto a6;

  a8:
  ParamField (15, SaveTemp, 'Imagedatei wird nicht gelscht');
  If t2=Up Then Goto a7;

  a9:
  ParamField (16, QuickCopy, 'beschleunigtes Kopieren einer nur teilweise gefllten Quell-Diskette');
  If t2=Up Then Goto a8;

  a10:
  ParamField (17, NewNumber, 'Zieldiskette bekommt eine neue Datentrgernummer');
  If t2=Up Then Goto a9;

  a11:
  ParamField (18, TakeImage, 'verwendet zum Kopieren die Imagedatei statt einer Quell-Diskette');
  If t2=Up Then Goto a10;
  If TakeImage Then SaveTemp:= TRUE;

  If (ee=0) and (lw1='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;



PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE CheckDrive (LW : Char);
BEGIN
  If (LW>'B') or (LW<'A') Then ErrorBreak ('Es werden nur die Laufwerke A und B untersttzt');
  x:= Drive (LW);
  If x and Phantomdrive<>0 Then SimpleHaltLog ('Phantomlaufwerk wird nicht untersttzt') Else
  If x and Substdrive  <>0 Then SimpleHaltLog ('SUBST-Laufwerk wird nicht untersttzt') Else
  If x and (NetDrive or InterLnkDrive) <> 0 Then SimpleHaltLog ('Netz-Laufwerk wird nicht untersttzt');
END;


{---------------------------- HauptProgramm -----------------------------}

LABEL
  Ende;

BEGIN                                              
  StretchParam (Param);
  If ParamCount = 0 Then Maske Else
  For Durchgang:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (Durchgang));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' : Hilfe;
      'O' : LogStatus:= 0;
      'Q' : QWait    := FALSE;
      'Z' : ZWait    := FALSE;
      'R' : Nochmal  := TRUE;
      'G' : GetGeometrie (copy (Param, 4, 255));
      'S' : SFormat  := TRUE;
      'W' : MoreDisks:= TRUE;
      'X' : QuickCopy:= TRUE;
      'N' : NewNumber:= FALSE;
      'I' : BEGIN
              TakeImage:= TRUE; SaveTemp:= TRUE;
              If pos (':', Param)=3 Then
              BEGIN
                PutImg:= TRUE;
                ImageFile:= Copy (Param, 4, 255);
                If ImageFile='' Then ErrorEnd ('Name der Image-Datei fehlt');
                Nochmal:= FALSE;
                ImageFile:= FileExpand (ImageFile);
                If DOSError=0 Then PStat:= PathStatus (ImageFile, CheckQuelle) Else PStat:= DOSError;
                If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));
              END;
            END;
      'T' : BEGIN
              SaveTemp := TRUE;
              If pos (':', Param)=3 Then
              BEGIN
                GetImg:= TRUE;
                ImageFile:= Copy (Param, 4, 255);
                If ImageFile='' Then ErrorEnd ('Name der Image-Datei fehlt');
                Nochmal:= FALSE; MoreDisks:= FALSE;
                ImageFile:= FileExpand (ImageFile);
                If DOSError=0 Then PStat:= PathStatus (ImageFile, CheckZiel) Else PStat:= DOSError;
                If PStat<>0 Then SimpleHaltLog (PathStatusStr (PStat));
              END;
            END;
    END
    Else    BEGIN
              If LW[1]=#0 Then LW[1]:= Param[1] Else
              If LW[2]=#0 Then LW[2]:= Param[1];
            END;
  END;
  If LW[1] = #0 Then SimpleHaltLog ('Laufwerks-Bezeichner fehlt');
  If LW[2] = #0 Then LW[2]:= LW[1];
  CheckDrive (LW[1]);
  CheckDrive (LW[2]);

  If LogStatus=0 Then BEGIN QWait:= FALSE; ZWait:= FALSE; END;

  If (PutImg) and (GetImg) Then ErrorEnd ('Zweideutige Parameterangabe');

  Assign (SecFile, ImageFile);

  CursorOff;
  If TestDisk Then TestDiskette;

  If PutImg Then
  Standardkopf (ProgName+' - Schreiben auf Datentrger in Laufwerk '+LW[1], '') Else
  Standardkopf (ProgName+' - Lesen von Datentrger in Laufwerk '+LW[1], '');

  REPEAT
    If (not TakeImage) or (GetImg) Then
    BEGIN
      Program_FirstInit; If t1= #27 Then Goto Ende;
      DiskEinlesen;      If t1= #27 Then Goto Ende;
      If ReadTrys<>0 Then ErrorMsg ('Die Quelldiskette konnte gelesen werden, neigt aber zu Fehlern (Taste)');
    END;

    If not GetImg Then
    REPEAT
      If ZWait Then
      BEGIN
        TastenAbfrage ('Zieldiskette einlegen und Enter drcken (Abbruch mit Esc)', #13, #27);
        If t1= #27 Then Goto Ende;
      END;

      Program_SecondInit;
      DiskSchreiben;
      If WriteTrys<>0 Then ErrorMsg ('Die Zieldiskette konnte erstellt werden, neigt aber zu Fehlern (Taste)');
      If MoreDisks Then
      TastenAbfrage ('Weitere Diskette mit gleichem Inhalt erstellen? (j/n)', 'N', 'J');
    UNTIL (t1='N') or (not MoreDisks);
            
    If Nochmal Then
    BEGIN
      TastenAbfrage ('Noch eine Diskette kopieren? (j/n)', 'J', 'N');
      If t1= 'N' Then t1:= #27;
    END;

  UNTIL (t1=#27) or (Nochmal=FALSE);

Ende:
  If not SaveTemp Then Erase (SecFile);
  If t1=#27 Then UserAbort Else ErrorHalt ('Kopieren beendet');
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
