PROGRAM DiskDate;
{$M 10000, 0, 0}
uses
  bioscrt, bootsec, Dos, Strings, masken, disk;

VAR
  Sector      : Array[1..512] Of Byte;
  bs          : BootSector absolute Sector;
  SecError    : Byte;
  dt          : DateTime;
  x           : Byte;
  Param       : String;
  tmp         : Word;
  l           : LongInt;

CONST
  DriveLetter : Char = #0;
  writ        : Boolean = FALSE;


PROCEDURE Hilfe;
BEGIN
  DosLnLF (#13#10+
  'DISKDATE  '+Copyright+#13#10+
  'setzt oder ermittelt das Datum und die Uhrzeit einer Diskette'#13#10#13#10+
  'DISKDATE [Laufwerksbuchstabe (A oder B)] [/w]'#13#10);

  DosLnLF ('/w  DiskDate speichert das aktuelle Datum samt Uhrzeit auf der Diskette'#13#10#13#10+
  'Fehlt /w, werden Datum und Uhrzeit angezeigt, ohne da eine nderung erfolgt.'#13#10+
  'Es knnen nur Disketten korrekt angezeigt werden, deren Datum zuvor mit');

  DosLnLF ('DiskDate oder von Diskcopy gesetzt wurde.'#13#10#13#10+
  'Hinweis: DiskDate verschlsselt Datum und Uhrzeit in der Datentrgernummer,'#13#10+
  'diese wird dabei also gendert.');
  Blindstop;
  Halt;
END;



PROCEDURE ReadSektor (LW:Char; VAR buff; Mode : Byte); Assembler;
ASM
  mov ah, Mode        {Befehl 2: Sektor(en) lesen, 3: Schreiben}
  mov al, 1           {Lese Sektor-Anzahl}

  mov dl, LW          {Laufwerk: A=0, B=1 usw, C=$80, D=$81 (Bit 7 gesetzt)}
  and dl, 00011111b   {'a' und 'a' = 1 usw.}
  dec dl              {A=0 usw}
  cmp dl, 1           
  jbe @a              {<=B: ?}
  add dl, 126
  @a:

  mov cx, 1
  xor dh, dh
  les bx, Buff        {Pufferaddresse}
  int $13
  mov SecError, ah
END;


BEGIN
  If ParamCount=0 Then Hilfe;
  DosStr (#13#10);
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1]='/' Then
    CASE Param[2] Of
      '?' :  Hilfe;
      'W' :  BEGIN
               With dt Do GetDate (year, Month, day, tmp);
               With dt Do GetTime (hour, min,   sec, tmp);
               PackTime (dt, l);
               Writ:= TRUE;
             END;
    END Else BEGIN
               DriveLetter:= Param[1];
               If (DriveLetter<>'A') and (DriveLetter<>'B') Then
               SimpleHalt ('Es werden nur die Laufwerke A und B untersttzt.');
             END;
  END;
  If DriveLetter=#0 Then SimpleHalt ('Laufwerksangabe fehlt.');
  x:= Drive (Driveletter);
  If x and Phantomdrive<>0 Then SimpleHalt ('Phantomlaufwerk wird nicht untersttzt') Else
  If x and Substdrive  <>0 Then SimpleHalt ('SUBST-Laufwerk wird nicht untersttzt') Else
  If x and (NetDrive or InterLnkDrive) <> 0 Then Simplehalt ('Netz-Laufwerk wird nicht untersttzt');

  x:= 0;
  REPEAT
    ReadSektor (DriveLetter, bs, 2);
    inc (x);
  UNTIL (SecError=0) or (x>=3);
  If SecError<>0 Then SimpleHalt ('Fehler beim Lesen des Bootsektors.');

  If not Writ Then
  BEGIN
    UnpackTime (LongInt(bs.DiskNummer), dt);

    DOSStr ('Disketten-Datum :  ');
    DOSStr (lz (dt.day));   DOSChar ('.');
    DOSStr (lz (dt.month)); DOSChar ('.');
    DOSNum (dt.year);

    DOSStr ('  -  ');
    DOSStr (lz (dt.hour));  DOSChar (':');
    DOSStr (lz (dt.min));   DOSChar (':');
    DOSStr (lz (dt.sec));   DOSStr  (' Uhr'#13#10);
  END Else
  BEGIN
    move (l, bs.DiskNummer, 4);
    x:= 0;
    REPEAT
      ReadSektor (DriveLetter, bs, 3);
      inc (x);
    UNTIL (SecError=0) or (x>=3);
    If SecError<>0 Then SimpleHalt ('Fehler beim Schreiben des Bootsektors.');
    SimpleHalt ('Diskette erfolgreich mit aktuellem Datum versehen.');
  END;
END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
