PROGRAM DiskEdit;   {Sektoren editieren}
{$M 10000, 0, 0}


USES
  bioscrt, disk, monitor, keycode, strings, dos, sectors, hexbin,
  konvert, masken, BootSec, rechnen, Clipbord;


CONST
  ProgName              = 'DISKEDIT';
  SektorFound : Boolean = FALSE;
  UnKnownDisk : Boolean = FALSE;
  IfMetrics   : Boolean = FALSE;
  MacDisk     : Boolean = FALSE;
  WinDisk     : Boolean = FALSE;
  SpacePunkt  : Boolean = FALSE;
  fOpen       : Boolean = FALSE;
  DSize1      : LongInt = 0;
  DSize2      : LongInt = 0;
  Hcol        : Byte    = red;
  Vcol        : Byte    = yellow;
  LowCol      : Byte    = 8;
  HiCol       : Byte    = 7;
  LW          : Char    = #0;
  Suchwort    : String  = '';
  SuchW       : String  = '';
  IsSearch    : Boolean = FALSE;
  CaseSense   : Boolean = FALSE;
  FoundPos    : Word    = 0;
  SearchAgain : Boolean = FALSE;

  SectorFile  = 'SEKTOR.SAV';
  BSize       = 512;

  ch          = 0;    {Zifferncode NICHT ndern!}
  hx          = 1;
  dc          = 2;
  Suchhilfe   = 'Suche starten mit Enter - Abbrechen mit Pfeil '#24' oder '#25;

TYPE
  Dir    = RECORD
             FileName     : Array[1..8] Of Char;
             FileExt      : Array[1..3] Of Char;
             FileAttr     : Byte;
             intern       : Array[1..10] Of Byte;
             FileTime     : LongInt;
             StartCluster : Word;
             FSize        : LongInt;
           END;

  LFNRec = RECORD         { Struktur eines DirEntry fr lange Dateinamen }
             Sequence     : Byte;                  { s.u. }
             Name1        : Array[1..5] Of Word;   { Unicode der ersten 5 Zeichen }
             FileAttr     : Byte;                  { immer $0F = RHSI }
             Indicator    : Byte;                  { Zeichen-Indikator, i.d.R. 0, manchmal 32 }
             CheckSum     : Byte;                  { Addition bestimmter Felder des 8.3-Namens MOD 256 }
             Name2        : Array[1..6] Of Word;   { Unicode der nchsten 6 Zeichen }
             StartCluster : Word;                  { bei langen Namen immer 0 }
             Name3        : Array[1..2] Of Word;   { Unicode der nchsten 2 Zeichen }
           END;

  DirRec = Array[1..16] Of Dir;
  LFNArr = Array[1..16] Of LFNRec;

  B      = Array[1..BSize] Of char;

  FB    = RECORD
            bLW        : Char;
            bDiskNr    : LongInt;
            bSpur      : Byte;
            bSeite     : Byte;
            bSektor    : Byte;
            SaveSektor : B;
          END;


VAR
  LWk       : String;
  i         : Word;
  x, y      : Byte;
  buf       : B;
  SecError  : Byte;
  SecSize   : Integer;
  MaxSec    : Byte;
  MaxSides  : Word;
  Zylinder  : LongInt;
  Versuche  : Byte;

  iDiskType,
  iMaxCylinder, 
  iMaxSec, 
  iMaxSides, 
  iDriveNums          : Byte;
  iMaxCyl             : Word;

  BootRec             : BootSector;
  FirstSide           : Byte;
  Spur, Seite, Sektor : Byte;
  xSpur, xSektor      : Word;
  xes, xdi            : Word;
  f                   : File of FB;
  SaveSek, SaveSek2   : FB;
  ProgPath            : String;
  Result              : Word;
  ScreenBuffer        : Array[1..4000] Of Char;
  FatBuffer           : TrackBuffer;
  SektorenGesamt      : LongInt;
  FirstDataSec        : LongInt;



PROCEDURE ClearWin (a, b, c, d, col : Byte);
BEGIN
  Window (a, b, c, d); TextAttr:= Col; ClrScr;
END;


PROCEDURE Line (Spalte : Byte);
VAR
  x : Byte;
BEGIN
  For x:= 1 To 80 Do CharXY (x, Spalte, #196, 7, 0);
END;


PROCEDURE ErrorMsg (ErrNum : Byte; Nr : Word); ForWard;


PROCEDURE OpenSektorFile;
BEGIN
  If FOpen Then Exit;
  FileMode:= 2;
  Assign (f, ProgPath+SectorFile);
  Reset (f);
  If IOResult<>0 Then
  BEGIN
    SetFAttr (f, 32); Reset (f); Result:= IOResult;
    While Result<>0 Do
    BEGIN
      Rewrite (f); Result:= IOResult;
      If Result<>0 Then
      BEGIN ErrorMsg (4, 0); If t1='N' Then Exit; END;
    END;
  END;
  FOpen:= TRUE;
END;



PROCEDURE SeekSektor;
VAR
  dNr : LongInt;
BEGIN
  SektorFound:= FALSE;
  OpenSektorFile;
  If not FOpen Then Exit;
  move (BootRec.DiskNummer, dNr, 4);
  Seek (f, 0);
  With SaveSek2 Do
  REPEAT
    If not Eof(f) Then Read (f, SaveSek2);
    SektorFound:=
    ((bLW=LW) and (bDiskNr=dNr) and (bSpur=Spur) and (bSeite=Seite) and (bSektor=Sektor));
  UNTIL (Eof(f)) or (SektorFound);
  If SektorFound Then Seek (f, FilePos(f)-1);
END;



PROCEDURE WriteInFile (Buffer : B);
BEGIN
  OpenSektorFile;
  If not FOpen Then Exit;

  With SaveSek Do
  BEGIN
    SaveSektor:= Buffer;
    Move (BootRec.DiskNummer, bDiskNr, 4);
    bLW    := LW;
    bSpur  := Spur;
    bSektor:= Sektor;
    bSeite := Seite;
  END;

  SeekSektor;
  REPEAT
    Write (f, SaveSek); Result:= IOResult;
    If Result<>0 Then ErrorMsg (4, 0);
  UNTIL (Result=0) or (t1='N');
END;



PROCEDURE Hilfe;
CONST
Text0=
   'Anzeige von Daten physikalischer Laufwerke/Anzeige und Editierung von Sektoren'#13#10#13#10+
   'DISKEDIT [Laufwerk] [/u /i /m /l /g]'#13#10#13#10+
   '/u  bergeht Bootsektortest bei unbekannten oder defekten Disketten';
Text1 =
   '/i  konvertiert Windows-Zeichensatz in der TextAnzeige in DOS-Zeichensatz'#13#10+
   '/m  konvertiert Macintosh-Zeichensatz in der TextAnzeige in DOS-Zeichensatz'#13#10+
   '/l  zeigt Leerzeichen in der Textanzeige als Punkt';
Text2=
   '/g  erzwingt eine vorgegebene Datentrger-Geometrie. /g:9-80-2 bedeutet'#13#10+
   '    z.B., da die Diskette je 9 Sektoren in 80 Spuren auf 2 Seiten hat.';
BEGIN
  StandardKopf (ProgName, Copyright);
  DosLnLF (Text0);
  DosLnLF (Text1);
  DosLnLF (Text2);
  BlindStop; Halt;
END;



PROCEDURE Read_Sektor (LW : char; VAR buf; Sec, Spr, Side : Byte); Assembler;
ASM
  les di, Buf; xor ax, ax; mov cx, BSize; shr cx, 1
  rep stosW          {Puffer mit Nullbytes fllen}
  mov Byte Ptr Versuche, 0
  @neuerversuch:
  mov ah, 2          {2= Sektor(en) lesen, 3= Schreiben}
  mov al, 1          {Lese Sektor-Anzahl}
  mov dl, LW         {Laufwerk: A=0, B=1 usw, C = $80, D = $81 (bit 7 gesetzt)}
  and dl, 00011111b  {'a' und 'A' = 1 usw.}
  dec dl             {A=0 usw}
  cmp dl, 1
  jbe @a             {<=B: ?}
  add dl, 126
  @a:

  mov dh, Side       {Seite  0/1, bei C Kopfnummer 0..x}
  mov ch, Spr        {Spur   0 - 79, bei C Zylindernummer}
  mov cl, Sec        {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  les bx, Buf        {Pufferaddresse}
  int $13
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah
END;



PROCEDURE Write_Sektor (LW : char; VAR buf; Sec, Spr, Side : Byte); Assembler;
ASM
  mov Byte Ptr Versuche, 0
  @neuerversuch:
  mov ah, 3         {Befehl 2: Sektor(en) lesen, 3= Schreiben}
  mov al, 1         {Lese Sektor-Anzahl}
  mov dl, LW        {Laufwerk: A=0, B=1 usw, C = $80, D = $81 (bit 7 gesetzt)}
  and dl, 00011111b {'a' und 'A' = 1 usw.}
  dec dl            {A=0 usw}
  cmp dl, 1
  jbe @a            {<=B: ?}
  add dl, 126
  @a:

  mov dh, Side      {Seite  0/1, bei C Kopfnummer 0..x}
  mov ch, Spr       {Spur   0 - 79, bei C Zylindernummer}
  mov cl, Sec       {Sektor 1 - 63, bei Platte bit 7-8 = Highbits CylinderNr}
  les bx, Buf       {Pufferaddresse}
  int $13
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah;
END;




PROCEDURE Taste;
BEGIN
  GotoXY (1, 25); DosStr ('Weiter = ENTER        Beenden = Esc');
  ScanBKeys;
  If t1=#27 Then BEGIN CursorOn; Halt; END;
  ClearWin (1, 1, 80, 25, 7);
END;



PROCEDURE Show_BootRecord;
CONST
  Boot : array[boolean] Of String[4] = ('nein', 'ja');
VAR
  x       : Byte;
  s       : String[12];
  BootStr : ^Word;
  hBuf    :  B;
BEGIN
  DosLnLF ('Bootsektor von Datentrger in Laufwerk '+ LW);
  For x:= 1 To 80 Do CharXY (x, 2, #196, 7, 0); GotoXY (1, 3);
  DSize1:= DskSize (ord (LW) and 31); {Initialisiert gleichzeitig Laufwerk neu}
  DSize2:= DSize1 and 1023;
  DSize1:= DSize1 shr 10;
  If DSize1<0 Then BEGIN DosLnLF ('Laufwerk nicht bereit'); CursorOn; Halt; END;

  Read_Sektor (LW, Buf, 1, 0, FirstSide);
  Move (buf, BootRec, SizeOf(BootRec));
  If BootRec.BytesProSec <> BSize Then
  BEGIN DosLnLF ('Laufwerk kann nicht geprft werden.'); CursorOn; Halt; END;
  BootStr:= @Buf[pred(SizeOf(Buf))];

  With BootRec Do
  BEGIN
    DosStr  ('Sprungbefehl                : ');
    For x:= 1 To 3 Do DosStr (Bytehex(Jump[x])+' '); DosLnLF ('hex');
    DosLnLF ('OEM-Name                    : '+ OEMName);
    DosLnLF ('Bytes pro Sektor            : '+ LongStr(BytesProSec));
    DosLnLF ('Sektoren je Cluster         : '+ LongStr(SecProClust));
    DosLnLF ('Reservierte Sektoren        : '+ LongStr(ReservSec));
    DosLnLF ('Anzahl FATs                 : '+ LongStr(FAT_Kopien));
    DosLnLF ('Max. Eintrge im Hauptverz. : '+ LongStr(Max_HauptEinTr));
    DosStr  ('Gesamtzahl der Sektoren     : ');

    If GesamtSec1=0 Then
    BEGIN
      DosLnLF (LongStr(GesamtSec2+VerstecktSec)); s:= '(Festplatte)';
      Zylinder:= (GesamtSec2+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
    END Else
    BEGIN
      DosLnLF (LongStr (GesamtSec1+VerstecktSec));
      Zylinder:= (GesamtSec1+VerstecktSec) DIV SecProSpur DIV DiskSeiten;
      If Medienbeschr=$F0 Then s:= '(>= 1.44 MB)' Else s:= '(< 1.44 MB)';
    END; 

    DosLnLF       ('Medien-Beschrifter          : '+ Bytehex(MedienBeschr) + 'h   '+ s);
    DosLnLF       ('Sektoren pro FAT            : '+ LongStr(SecProFAT));
    DosLnLF       ('Sektoren pro Spur           : '+ LongStr(SecProSpur));
    DosLnLF       ('Disketten-Seiten            : '+ LongStr(DiskSeiten));
    DosLnLF       ('Versteckte Sektoren         : '+ LongStr(VerstecktSec));
    DosLnLF       ('Zylinder                    : '+ LongStr(Zylinder));

    If BootSignatur=$29 Then
    BEGIN
      DosStr  ('Datentrger-Nummer          : ');
      For x:= 4 DownTo 1 Do
      BEGIN DosStr (Bytehex(DiskNummer[x])); If x=3 Then DosStr ('-'); END;
      DosLnLF ('');
      DosLnLF ('Disketten-Label             : '+ DiskLabel);
      DosLnLF ('FAT-Typ                     : '+ Fat_Type);
      DosLnLF ('Reserviertes Byte           : '+ ByteHex (Reserved)+'h');
      DosLnLF ('Erste Festplatte            : '+ boot [DriveNumber=$80]);
    END;

    DosLnLF ('Erw. BIOS-Parameter-Block   : '+ boot [BootSignatur=$29]);
    DosLnLF ('bootfhiger Datentrger     : '+ boot [BootStr^= 43605]+
        '  (Boot-Signatur = '+ Bytehex(lo(BootStr^))+' '+ Bytehex(hi(BootStr^))+ ' hex)');

    MaxSec  := SecProSpur;
    SecSize := BytesProSec;
    MaxSides:= DiskSeiten-1;
  END;
  Taste;
END;



PROCEDURE Diskette_Type (LW : Char); assembler;
ASM
  mov Byte Ptr Versuche, 0
  @neuerversuch:

  mov ah, 8
  mov dl, LW        {Laufwerk: A=0, B=1 usw, C = $80, D = $81 (bit 7 gesetzt)}
  and dl, 00011111b {'a' und 'A' = 1 usw.}
  dec dl            {A=0 usw}
  cmp dl, 1
  jbe @a            {<=B: ?}
  add dl, 126
  @a:

  int 13h
  or  ah, ah
  jz  @okay
    inc Byte Ptr Versuche
    cmp Byte Ptr Versuche, 3
    jbe @neuerversuch
  @okay:
  mov SecError, ah
  mov iDiskType, bl
  mov iMaxCylinder, ch
  mov iMaxSec, cl
  mov iMaxSides, dh
  mov iDriveNums, dl
  mov xes, es
  mov xdi, di
END;


FUNCTION EStr (l : LongInt) : String;
BEGIN
  EStr:= StretchStr (LongStr (l), 3);
END;


PROCEDURE Write_DiskParameters; {nur fr a oder b ???}
TYPE
  pb = array[0..10] Of Byte;
CONST
  Zoll5 = '5 1/4 Zoll  ';
  Zoll3 = '3 1/2 Zoll  ';
  Form  = ' formatiert auf ';
VAR
  ParOfs, ParSeg : Integer;
  ParamBlock     : pb;
  x              : Byte;
  SecSize_1      : Word;
  g              : String[3];
  PBlock         : ^pb;
  Dummy          : LongInt;

BEGIN
  If UnknownDisk Then Dummy:= DskSize (ord (LW) and 31); {Initialisierung}
  Diskette_Type (LW);

  DosStr ('Datentrger- und Laufwerks-Parameter von Laufwerk '+ LW); GotoXY (1, 3);
  For x:= 1 To 80 Do CharXY (x, 2, #196, 7, 0);

  If LW<='B'Then
  BEGIN
    pBlock:= @Mem[xes:xdi];     (* das gleiche wie pBlock:= Ptr (xes, xdi);*)
    ParamBlock:=PBlock^;
    SecSize_1:=ParamBlock[3]*256; If SecSize_1=0 Then SecSize_1:=128;
    DosLnLF      ('Disk-Drive-Parameter-Tabelle von Laufwerk '+ LW);
    DosLnLF      ('-------------------------------------------');
    DosLnLF      ('Steprate & Kopf-Unload-Zeit     : '+EStr(ParamBlock[0])+' ms');
    DosLnLF      ('Lese/Schreibkopf-Ladezeit       : '+EStr(ParamBlock[1])+' ms');
    DosLnLF      ('Sektorgre                     : '+EStr(SecSize_1)+    ' Byte');
    DosLnLF      ('Sektoren pro Spur               : '+EStr(ParamBlock[4]));
    DosLnLF      ('GAP3 Lnge beim Lesen/Schreiben : '+EStr(ParamBlock[5]));
    DosLnLF      ('DTL (Datenlnge)                : '+EStr(ParamBlock[6]));
    DosLnLF      ('GAP3 Lnge beim Formatieren     : '+EStr(ParamBlock[7]));
    DosLnLF      ('Fllbyte beim Formatieren       : '+EStr(ParamBlock[8])+' = ');
    DosLnLF      ('Kopfruhepause nach Spurwechsel  : '+EStr(ParamBlock[9])+' ms');
    DosLnLF      ('Anlaufzeit Diskettenmotor       : '+EStr(ParamBlock[10])+' ms');
    DosLnLF      ('Nachlaufzeit Diskettenmotor     : '+EStr(ParamBlock[2])+' ms'#10);
    CharXY  (41, 12, chr (ParamBlock[8]), 7, 0);
  END;
  If DSize1>1024 Then
  BEGIN DSize2:= DSize1 and 1023; DSize1:= DSize1 shr 10; g:=' MB'; END Else g:=' kB';
  DosStr ('Diskettentyp                    : ');
  CASE iDiskType Of
    1 :  DosLnLF (Zoll5+ '360 kB');
    2 :  DosLnLF (Zoll5+ '1.2 MB');
    3 :  DosLnLF (Zoll3+ '720 kB');
    4 :  DosLnLF (Zoll3+ '1.44 MB');
    5 :  DosLnLF (Zoll3+ '?');
    6 :  DosLnLF (Zoll3+ '2.88 MB');
    Else DosLnLF ('Festplatte');
  END;
  If LW>='C' Then
  BEGIN
    iMaxCyl:= iMaxCylinder+(256*(iMaxSec shr 6));
    iMaxSec:= iMaxSec xor 192;
  END Else iMaxCyl:= iMaxCylinder;
  DosLnLF      ('formatiert auf                  : '+LongStr(DSize1)+'.'+LongStr(DSize2)+g);
  DosLnLF      ('Max. Nr. des letzten Zylinders  : '+LongStr(iMaxCyl));
  DosLnLF      ('Max. Nr. des letzten Sektors    : '+LongStr(iMaxSec));
  DosLnLF      ('Max. Nr. des letzten Kopfes     : '+LongStr(iMaxSides));
  DosLnLF      ('Zahl der Laufwerke dieses Typs  : '+LongStr(iDriveNums));

  If (UnKnownDisk) and (not IfMetrics) Then
  BEGIN
    MaxSec  := iMaxSec;
    Zylinder:= iMaxCyl+1;
    MaxSides:= iMaxSides;
  END;

  Taste;
END;


PROCEDURE ShowSuchmaske;
LABEL
  a1, a2;
VAR
  x   : Byte;
  tmp : String;
BEGIN
  t2:= #0; IsSearch:= FALSE;
  tmp:= Suchwort;
  a1:
  EditStr (1, Suchwort, 'Wort oder Textpassage, die gesucht werden soll');
  If t2=Up Then Exit;
  a2:
  ParamField (6, CaseSense,  'Gro- und Kleinschreibung beachten');
  If t2=Up Then Goto a1;

  If ee=1 Then
  OutStr (#13#10#13#10#13#10#13#10'Ein laufender Suchvorgang kann mit Esc abgebrochen werden.');

  If (ee=0) and (Suchwort='') and (t1=#13) Then
  BEGIN
    Tastenabfrage ('Suchwort fehlt. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (SuchHilfe); Goto a1 END Else IsSearch:= FALSE;
  END;
  If (t1=#13) and (ee=0) Then
  BEGIN
    SearchAgain:= tmp=Suchwort;
    IsSearch:= TRUE;
    SuchW:= Suchwort;
    If not CaseSense Then SuchW:= UpStr (Suchwort);
  END;
END;


PROCEDURE SuchMaske;
VAR
  ScreenBuf : Array[1..4000] Of Byte;
  OldX, OldY, OldWindMin, OldWindMax : Word;
BEGIN
  GetScreen25 (Screenbuf);
  OldX:= WhereX; OldY:= WhereY; OldWindMin:= WindMin; OldWindMax:= WindMax;
  StandardKopf (ProgName, 'Suchen');
  Fusszeile (Suchhilfe);
  ee:= 1; ShowSuchMaske; ee:= 0; ShowSuchMaske;
  SetScreen25 (ScreenBuf);
  WindMin:= OldWindMin; WindMax:= OldWindMax; GotoXY (OldX, OldY);
  If IsSearch Then t1:= 'S' Else t1:= #1;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3, a4;
VAR
  lwk : PathStr;
BEGIN
  t2:= #0;
  LWk:='A:';

  a1:
  EditStr (1, LWk, 'Laufwerk, das editiert bzw. angezeigt werden soll:');
  LW:= UpCase (LWk[1]); 

  a2:
  ParamField (6, MacDisk,  'konvertiert Macintosh-Zeichen bei der Textanzeige in DOS-Zeichen');
  If t2=Up Then Goto a1;
  If MacDisk Then UnKnownDisk:=TRUE Else

  a3:
  ParamField (7, UnKnownDisk, 'bergeht den Bootsektor-Test bei unbekannten oder defekten Disketten');
  If t2=Up Then Goto a2;

  a4:
  ParamField (8, WinDisk,  'konvertiert Windows-Zeichen bei der Textanzeige in DOS-Zeichen');
  If t2=Up Then Goto a3;

  ParamField (9, SpacePunkt,  'zeigt Leerzeichen bei der Textanzeige als Punkte');
  If t2=Up Then Goto a4;

  If (ee=0) and (lwk='') Then
  BEGIN
    Tastenabfrage ('Ungltiger Laufwerks-Bezeichner. Neue Eingabe? (j/n)', 'J', 'N');
    If t1='J' Then 
    BEGIN Fusszeile (EingabeHilfe); Goto a1 END Else UserAbort;
  END;
END;



PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;


PROCEDURE GetGeometrie (Param : PathStr);
VAR
  tmp     : Array[1..3] Of String;
  c, d, e : Integer;
BEGIN
  For c:= 1 To 3 Do tmp[c]:= '';
  c:= 1;
  For d:= 1 To Length (Param) Do
  If (Param[d]='-') and (c<3) Then inc (c) Else tmp[c]:= tmp[c]+Param[d];
  Val (tmp[1], MaxSec,   c);
  Val (tmp[2], Zylinder, d);
  Val (tmp[3], Maxsides, e);
  If (c+d+e<>0) or (MaxSides=0) or (Zylinder=0)    or (MaxSec=0)
                or (Maxsides>2) or (Zylinder>1024) or (MaxSec>64) Then
  SimpleHalt ('Angabe der Laufwerksgeometrie hat ungltiges Format');
  dec (MaxSides);
  UnknownDisk:= TRUE; IfMetrics:= TRUE;
END;

PROCEDURE Program_Init;
BEGIN
  If ParamCount=0 Then Maske Else
  For x:= 1 To ParamCount Do
  BEGIN
    LWk:= UpStr (ParamStr(x));
    If Lwk[1]='/' Then
    CASE Lwk[2] Of
      '?' : Hilfe;
      'I' : Windisk      := TRUE;
      'M' : BEGIN MacDisk:= TRUE; UnKnownDisk:=TRUE; END;
      'U' : UnKnownDisk  := TRUE;
      'L' : Spacepunkt   := TRUE;
      'G' : GetGeometrie (copy (LWk, 4, 255));
    END
    Else If LW=#0 Then LW:=Lwk[1];
  END;

  If (LW>'Z') or (LW<'A') Then SimpleHalt ('Ungltiger oder fehlender Laufwerksbezeichner');
  x:= Drive (LW);
  If x and Phantomdrive<>0 Then SimpleHalt ('Phantomlaufwerk wird nicht untersttzt') Else
  If x and Substdrive  <>0 Then SimpleHalt ('SUBST-Laufwerk wird nicht untersttzt') Else
  If x and CDDrive     <>0 Then SimpleHalt ('CD-ROM werden nicht untersttzt') Else
  If x and (NetDrive or InterLnkDrive) <> 0 Then SimpleHalt ('Netz-Laufwerk wird nicht untersttzt');

  FirstSide:= ord (LW>'B');
  ClearWin (1, 1, 80, 25, 7);
  CursorOff;
END;



PROCEDURE Bedienung (Modus : Byte);
BEGIN
  If Modus=1 Then
  BEGIN
    GotoXY (55, 1); DosStr ('<S>     Suchen          ');
    GotoXY (55, 2); DosStr ('<F1>    Hilfe           ');
    GotoXY (55, 3); DosStr ('<M>     Men     ');
    GotoXY (55, 4); DosStr ('<Esc>   Diskedit beenden  ');
  END Else
  BEGIN
    GotoXY (55, 1); DosStr ('<ALT+S> Sektor schreiben');
    GotoXY (55, 2); DosStr ('<ALT+L> Lade Sektorkopie');
    GotoXY (55, 3); DosStr ('<Esc>   Abbrechen');
    GotoXY (55, 4); DosStr ('        ASCII/Offset:     ');
  END;
END;



PROCEDURE Write_ProgramHeader;
VAR
  s : String[21];
BEGIN
  If IsSearch Then
  BEGIN
    NumXY (27, 2, 10, xSpur,   7, 0);
    NumXY (27, 3, 10, Seite,   7, 0);
    NumXY (27, 4, 10, xSektor, 7, 0); WriteXY (37, 4, '            ', 7, 0);
    Exit;
  END;

  s:='                     ';
  TextAttr:=7;
  Bedienung (1);
  GotoXY (1, 1);
  DosLnLF      ('Datentrger in Laufwerk : '+ LW);
  DosLnLF      ('Spur/Zylinder           : '+LongStr(xSpur)+ s);
  DosLnLF      ('Seite/Kopf              : '+LongStr(Seite)+ s);
  If (Spur=0) and (Sektor=1) Then
  BEGIN
    If ((Seite=0) and (LW<'C')) or ((Seite=1) and (LW>='C')) Then
    s:= ' (Boot-Sektor)         ' Else
    If (Seite=0) and (LW>='C') Then s:= ' (Master-Boot-Record)';
  END;
  DosLnLF      ('Sektor-Nr.              : '+LongStr(xSektor)+s+#13#10);
END;



PROCEDURE Write_Buffer (Nr : Word);
VAR
  TAttr, back, ZCol : Byte;
  ch : Char;
BEGIN
  x:= 1; y:=6;
  For i:= 1 To BSize Do
  BEGIN
    If i=Nr Then
    BEGIN back:= hCol; ZCol:= vCol; TAttr:= vCol; END Else
    BEGIN Back:= 0;    ZCol:= 7;    If not odd (i) Then TAttr:=LowCol Else TAttr:=HiCol; END;
    ch:= buf[i];

    If FoundPos<>0 Then
    BEGIN
      If (i>= FoundPos) and (i<FoundPos+Length (SuchW)) Then
      BEGIN back:= red; ZCol:= yellow; inc (TAttr, 7); END;
    END;

    WriteXY (x, y, Bytehex(ord(ch)), TAttr, back);

    If (ch=' ') and (SpacePunkt) Then ch:= #250 Else
    If WinDisk Then ch:= WinToDOS  (ch) Else
    If MacDisk Then ch:= MacToAscii(ch);
    CharXY  (x shr 1 + 55, y, ch, ZCol, back);

    inc (x, 2); If x>52 Then BEGIN inc(y); x:=1; END;
  END;
END;




PROCEDURE EditSektor (Modus : Byte);
VAR
  Nr          : Word;
  dezi, EdStr : String[3];
  ps          : Byte;
  Code, c     : Integer;
  t3          : Char;
  TempSec     : B;
  tbuf        : B;
  Reading     : Word;
BEGIN
  CursorOn;
  Nr:= 1; ps:=0; TempSec:= Buf;
  Bedienung (2);
  REPEAT
    Write_Buffer (Nr);
    dezi:= LongStr (ord(Buf[Nr])); While Length (dezi)<3 Do dezi:= '0'+dezi;
    If Modus=hx Then EdStr:= Bytehex (ord (Buf[Nr])) Else EdStr:= dezi;
    WriteXY (55, 4, dezi, vCol, hCol);
    NumXY (77, 4, 3, Nr, 7, 0);
    CASE Modus Of
      hx : GotoXY ((Nr-1) MOD 26*2+1+ps, 6 + (Nr-1) DIV 26);
      dc : GotoXY (55+ps, 4);
      ch : GotoXY ((Nr-1) MOD 26+55, 6 + (Nr-1) DIV 26);
    END;

    ScanBKeys;
    t3:= t1;
    t1:= upcase (t3);
    If t1=#0 Then
    BEGIN
      CASE t2 Of
        Right     : If Nr < BSize Then inc (Nr);
        Left      : If Nr>1 Then dec (Nr);
        Pos1      : Nr:= 1;
        Endx      : Nr:= BSize;
        Down      : If Nr+26<=BSize Then inc (Nr, 26);
        Up        : If Nr>26 Then dec (Nr, 26);
        ALTS      : BEGIN
                      ErrorMsg (1, Nr); Result:=0;
                      If t1='J' Then WriteInFile (TempSec);
                      If (t1='N') or (Result=0) Then
                      REPEAT
                        Write_Sektor (LW, buf, Sektor, Spur, Seite);
                        If SecError<>0 Then ErrorMsg (2, Nr);
                      UNTIL (SecError=0) or (t1='N');
                    END;
        ALTL      : BEGIN
                      SeekSektor;
                      If SektorFound Then Buf:= SaveSek2.SaveSektor Else
                      ErrorMsg (3, Nr);
                    END;
        F4        : WriteBinClip (Buf, BSize);
        CF4       : BEGIN
                      Reading:=BSize;
                      ReadBinClip (tBuf, Reading);
                      If Reading=BSize Then buf:= TBuf;
                    END;
      END;
      ps:=0;
    END Else
    BEGIN
      CASE t1 Of
        Back : If ps>0 Then dec (ps) Else ps:=Modus;
        Else
        If (Modus<>ch) and (((t1>='0') and (t1<='9')) or ((t1>='A') and (t1<='F'))) Then
        BEGIN
          If (modus=hx) or (t1<='9') Then
          BEGIN
            EdStr[ps+1]:= t1;
            If Modus=hx Then
            VAL ('$'+EdStr, c, code) Else VAL (EdStr, c, code);
            buf[Nr]:= chr (byte(c));
            If ps<Modus Then inc (ps) Else
            BEGIN If Nr<BSize Then inc (Nr); ps:=0; END;
          END;
        END Else
        If (Modus=ch) and (t1<>#27) Then
        BEGIN Buf[Nr]:= t3; If Nr<BSize Then inc (Nr); END;
      END;
    END;
  UNTIL (t1=#27);
  t1:=#0; t2:=#0;
  CursorOff;
  Bedienung (1);
END;




PROCEDURE GetKey;
BEGIN
  REPEAT
    ScanBKeys; t1:= UpCase (t1);
    If t1=#27 Then t1:= 'N' Else If t1=#13 Then t1:= 'J';
  UNTIL (t1='J') or (t1='N');
END;



PROCEDURE ErrorMsg (ErrNum : Byte; Nr : Word); 
VAR
  x, y, z : Byte;
BEGIN
  if ErrNum<5 Then z:= 13 Else z:= 21;
  For y:= 8 To z Do For x:= 3 To 50 Do CharXY (x, y, #32, 0, 7);
  CASE ErrNum Of
    1 : BEGIN
          WriteXY ( 5,  9, 'Soll von diesem Sektor eine Sicherheitskopie', 0, 7);
          WriteXY (17, 10,            'angelegt werden ?', 0, 7);
          WriteXY ( 6, 12, 'Drcken Sie Taste J fr Ja oder N fr Nein', 0, 7);
          GetKey;
        END;
    2 : BEGIN
          WriteXY (11,  9, 'Fehler beim Schreiben des Sektors', 0, 7);
          WriteXY (17, 10,         'Nochmal versuchen ?', 0, 7);
          WriteXY ( 6, 12, 'Drcken Sie Taste J fr Ja oder N fr Nein', 0, 7);
          GetKey;
        END;
    3 : BEGIN
          WriteXY ( 6,  9, 'Von diesem Sektor konnte keine Sicherheits-', 0, 7);
          WriteXY (16, 10,           'kopie gefunden werden', 0, 7);
          WriteXY (13, 12,      'Weiter mit beliebiger Taste', 0, 7);
          WaitKey;
        END;
    4 : BEGIN
          WriteXY ( 5,  9, 'Sicherheitskopie konnte nicht angelegt werden', 0, 7);
          WriteXY (17, 10,             'Nochmal versuchen ?', 0, 7);
          WriteXY ( 6, 12, 'Drcken Sie Taste J fr Ja oder N fr Nein', 0, 7);
          GetKey;
        END;
    5 : BEGIN
          WriteXY ( 7,  9, '<H>       Sektor HEX-editieren',            0, 7);
          WriteXY ( 7, 10, '<T>       Sektor als Text editieren',       0, 7);
          WriteXY ( 7, 11, '<D>       Sektor dezimal editieren',        0, 7);
          WriteXY ( 7, 13, '<V>       Verzeichnissektor anzeigen',      0, 7);
          WriteXY ( 7, 14, '<F>       FAT12 anzeigen (Blttern=Enter)', 0, 7);
          WriteXY ( 7, 16, '<S>       Sektor in Datenbank speichern',   0, 7);
          WriteXY ( 7, 18, '<M>       Men schlieen',                  0, 7);
          WriteXY ( 7, 19, '<Esc>     Diskedit beenden',                0, 7);
          UpScanBKeys;
        END;
    6 : BEGIN
          WriteXY ( 7,  9, '<PgUp>    Spur zurck',                    0, 7);
          WriteXY ( 7, 10, '<PgDn>    Spur weiter',                    0, 7);
          WriteXY ( 7, 11, '<Up>      Sektor zurck',                  0, 7);
          WriteXY ( 7, 12, '<Down>    Sektor weiter',                  0, 7);
          WriteXY ( 7, 13, '<Left>    Seite zurck' ,                  0, 7);
          WriteXY ( 7, 14, '<Right>   Seite weiter' ,                  0, 7);
          WriteXY ( 7, 15, '<Pos1>    Diskettenanfang',                0, 7);
          WriteXY ( 7, 16, '<End>     Diskettenende'  ,                0, 7);
          WriteXY ( 7, 17, '<ENTER>   kontinuierlich vorblttern',     0, 7);
          WriteXY ( 7, 18, '<Back>    kontinuierlich zurckblttern',  0, 7);
          WriteXY ( 7, 19, '<F4>      Sektor ins Clipboard kopieren',  0, 7);
          WriteXY ( 7, 20, '<Esc>     Hilfe beenden',                  0, 7);
          WaitBKey;
        END;
  END;
  Write_Buffer (Nr);
END;



FUNCTION LZ (Wert:Word) : Str2;
BEGIN
  If Wert<10 Then LZ:= '0'+LongStr (Wert) Else LZ:= LongStr (Wert);
END;



PROCEDURE ShowDirectory;
VAR
  DRec : DirRec;
  LFNs : LFNArr absolute DRec;
  x    : Byte;
  dt   : DateTime;
  y    : Byte;
  i    : Byte;

CONST
  Attrs : Array [Boolean, 1..6] Of Char = ('------', 'RHSIDA');

FUNCTION GetLFNChar (DirRec : LFNRec; Index : Word) : Char; assembler;
ASM
  les di, DirRec
  add di, 1                { Sequence berspringen }
  mov ax, Index
  add ax, ax               { in Byte-Position umrechnen ... }
  cmp ax, 8
  jbe @los
  add ax, 3
  cmp ax, 23
  jbe @los
  add ax, 2
  @los:
  add di, ax
  mov al, es:[di]
END;
{ Gibt eines der 13 Zeichen eines langen Dateinamens aus einem DirEntry
  zurck. Die Indizierung via "Index" erfolgt linear zwischen 0 und 12 }

BEGIN
  ClearWin (1, 6, 80, 25, 7);
  DosLnLF ('Name             Datum         Uhrzeit     Gre        Attribut    StartCluster');
  Line (7);
  Move (Buf, DRec, SizeOf (DRec));
  For x:= 1 To 16 Do
  With DRec[x] Do
  If (FileName=#0#0#0#0#0#0#0#0) and (FileExt=#0#0#0) and (FileTime=0) Then DosLnLF ('') Else
  If FileAttr<>15 Then  { langer Win-Dateiname }
  BEGIN
    DosStr (FileName+' '+FileExt+'     ');
    UnpackTime (FileTime, DT);
    With DT Do DosStr (LZ(Day )+ '.'+ LZ(Month)+ '.'+LongStr(Year)+'    ');
    With DT Do DosStr (LZ(Hour)+ ':'+ LZ(Min  )+ ':'+ LZ(Sec)+ '    ');
    DosStr (LongStr(FSize));
    GotoXY (57, x+2);
    For y:= 1 To 6 Do DosStr (Attrs[FileAttr and (1 shl (y-1)) <> 0, y]);
    DosLnLF ('      '+LongStr(StartCluster));
  END Else
  BEGIN
    TextAttr:= 8; ClrEol; TextAttr:=7;
    For i:= 0 To 12 Do DosChar (GetLFNChar (LFNs[x], i));
    DosStr ('   [Windows-LFN - Teilstck:  ');
    If LFNs[x].Sequence<> ord('') Then
    DosStr (LongStr(LFNs[x].Sequence and 31)) Else DosStr ('gelscht');
    DosChar (']');
    GotoXY (57, x+2);
    For y:= 1 To 6 Do DosStr (Attrs[FileAttr and (1 shl (y-1)) <> 0, y]);
    DosLnLF ('');
  END;
  Line (24);
  WriteXY (1, 25, 'Verzeichniseintrge                                  Weiter mit beliebiger Taste', 7, 0);
  WaitBKey;
  ClrScr;
  Window (1, 1, 80, 25);
END;



FUNCTION FatEntry (Nr : Word; VAR Buf) : Word; assembler;
ASM
  mov ax, Nr
  mov cx, ax
  mov bx, 12
  mul bx
  mov bx, 8
  div bx

  test cx, 1
  jne @ungerade
  dec ax
  @ungerade:

  les di, Buf
  add di, ax
  dec di
  mov ax, es:[di]

  test cx, 1
  je @gerade

  and ah, 00001111b
  jmp @ende

  @gerade:
  and al, 11110000b
  mov cl, 4
  shr ax, cl

  @ende:
END;




FUNCTION DatenSektorZahl : LongInt; assembler;
ASM
  mov dl, LW
  and dl, 00011111b   {#1, 'A' und 'a' = 1 usw.}
  mov ah, 36h
  int 21h
  mul dx
END;



FUNCTION ClusterNum (Spur, Seite, Sektor : Word) : Word;
VAR
  Cluster  : LongInt;
  DSeiten  : LongInt;
BEGIN
  With BootRec Do
  BEGIN
    dSeiten:= longInt (DiskSeiten);
    dseiten:= dSeiten * LongInt (SecProSpur);
    dSeiten:= dSeiten * LongInt (Spur);
    Cluster:= dSeiten;
    dSeiten:= LongInt(Seite);
    dSeiten:= dSeiten* LongInt(SecProSpur);
    inc (DSeiten, Sektor);
    Cluster:= Cluster+dSeiten;
    If LW<='B' Then inc (Cluster, SecProClust) Else inc (Cluster, SecProClust*2);
    If Cluster<=FirstDataSec Then Cluster:=0 Else dec (Cluster, FirstDataSec);
    Cluster:= Cluster DIV LongInt(SecProClust);
  END;
  ClusterNum:= Word (Cluster);
END;


PROCEDURE ShowFat12;
VAR
  x, y  : Word;
  t     : Char;
  a, b  : Word;
  col   : Byte;
  FatEn : Word;
BEGIN
  GetScreen25 (Screenbuffer);
  ClrScr;
  OutStr ('FAT12-Sektor:          (4095=letzter Cluster einer Datei  4087=defekter Cluster)'#13#10);
  Line (2);
  Line (25);
  AssignDrive (LW, FatBuffer, SizeOf (FatBuffer));
  SecToRead:= BootRec.SecProFAT;
  ReadSector (2, 0, 0);
  Col:= HiCol;
  For y:= 1 To SecToRead Do
  BEGIN
    NumXY (15, 1, 3, y, 7, 0);
    a:= 1; b:= 3;
    For x:= 1 To 341 Do
    BEGIN
      FatEn:= FatEntry (x+((y-1)*341), FatBuffer);
      NumXY ((a-1)*5+1, b, 5, FatEn, Col, 0);
      If FatEn= 4095 Then If col=LowCol Then col:= Hicol Else Col:=LowCol;
      inc (a); If a>16 Then BEGIN a:= 1; inc (b); END;
    END;
    t:=ReadBKey;
    GotoXY (1, 3);
    If (t=#27) or (y=SecToRead) Then
    BEGIN SetScreen25 (ScreenBuffer); Exit; END;
  END;
END;


PROCEDURE CheckSector;
VAR
  tBuf : B;
  x    : Word;
  s    : String;
BEGIN
  tBuf:= Buf;
  If     WinDisk   Then For x:= 1 To BSize Do tBuf[x]:= WinToDos   (tBuf[x]) Else
  If     MacDisk   Then For x:= 1 To BSize Do tBuf[x]:= MacToASCII (tBuf[x]);
  If not CaseSense Then For x:= 1 To BSize Do tBuf[x]:= UpChar     (tBuf[x]);
  s[0]:= chr (Length(SuchW));
  For x:= 1 To BSize+1-Length(SuchW) Do
  If tBuf[x]=SuchW[1] Then
  BEGIN
    Move (tBuf[x], s[1], Length (SuchW));
    If s = SuchW Then BEGIN IsSearch:= FALSE; FoundPos:= x; Exit; END;
  END;
END;


{---------------------------- HauptProgramm -----------------------------}

LABEL
  NextSec;

BEGIN                                              
  StretchParam (Lwk);
  If ScrMode=MonoMon Then BEGIN HCol:=7; VCol:= 0; LowCol:=7; HiCol:= 15; END;
  ProgPath:= ParamStr(0); ProgPath[0]:= chr (LastPos ('\', ProgPath));
  Program_Init;
  If Not UnKnownDisk Then Show_Bootrecord;
  Write_DiskParameters;
  For x:= 1 To 80 Do CharXY (x, 5, #196, 7, 0);
  xSpur:=0;
  Seite:= 0;
  xSektor:=1;

  REPEAT
    If LW>='C' Then
    Sektor:= Lo (xSektor) + Hi(xSpur) shl 6 Else Sektor:= Lo (XSektor);
    Spur:= Lo (XSpur);
    Write_ProgramHeader;
    Read_Sektor (LW, buf, Sektor, Spur, Seite);
    If SecError<>0 Then
    WriteXY (31, 1, ' fehlerhafter Sektor ', vcol, hcol) Else
    WriteXY (31, 1, '                     ',  0,  0);
    If not IsSearch Then
    BEGIN
      Write_Buffer (0);
      ScanBKeys;
      FoundPos:= 0;
    END;
    If t1=#0 Then
    BEGIN
      CASE t2 Of
        F1   : ErrorMsg (6, 0);
        PgDn : If xSpur < Zylinder-1 Then inc (xSpur);
        PgUp : If xSpur > 0          Then dec (xSpur);
        Down : If xSektor < MaxSec   Then inc (xSektor);
        Up   : If xSektor > 1        Then dec (xSektor);
        Pos1 : BEGIN xSektor:=1; xSpur:=0; Seite:=0; END;
        Endx : BEGIN xSektor:=MaxSec; xSpur:= Zylinder-1; Seite:= MaxSides; END;
        Right: If Seite < MaxSides   Then inc (Seite);
        Left : If Seite > 0          Then dec (Seite);
        F4   : WriteBinClip (Buf, BSize);
      END;
    END Else
    BEGIN
      CASE UpCase(t1) Of
        'S'  : BEGIN
                 If (Keypressed) and (ReadBKey=#27) Then
                 BEGIN IsSearch:= FALSE; SearchAgain:= FALSE; t1:= #1; END Else
                 BEGIN
                   If not IsSearch Then
                   BEGIN Suchmaske; If SearchAgain Then Goto NextSec; END;
                   If IsSearch Then
                   BEGIN
                     CheckSector;
                     If IsSearch Then Goto NextSec;
                   END;
                 END;
               END;
        'M'  : BEGIN
                 ErrorMsg (5, 0);
                 CASE t1 Of
                   'V'  : ShowDirectory;
                   'F'  : If LW<='B' Then ShowFat12;
                   'H'  : EditSektor (hx);
                   'D'  : EditSektor (dc);
                   'T'  : EditSektor (ch);
                   'S'  : WriteInFile (buf);
                 END;
               END;
        #13  : BEGIN
                 NextSec: 
                 inc (xSektor);
                 If xSektor>MaxSec Then
                 BEGIN
                   xSektor:=1; inc (Seite);
                   If Seite>MaxSides Then
                   BEGIN
                     Seite:=0; xSektor:=1; inc (xSpur);
                     If xSpur>Zylinder-1 Then
                     BEGIN xSektor:=1; Seite:=0; xSpur:=0; IsSearch:= FALSE; END;
                   END;
                 END;
                 If SearchAgain Then BEGIN t1:= 'S'; SearchAgain:= FALSE; END;
               END;
        Back : BEGIN
                 dec (xSektor);
                 If xSektor<1 Then
                 BEGIN
                   xSektor:=MaxSec;
                   If Seite>0 Then dec (Seite) Else
                   BEGIN
                     Seite:=MaxSides; xSektor:=MaxSec;
                     If xSpur>0 Then dec (xSpur) Else
                     BEGIN xSektor:=MaxSec; Seite:=MaxSides; xSpur:=Zylinder-1; END;
                   END;
                 END;
               END;
 
      END;
    END;
  UNTIL (t1=#27);
  ClearWin (1, 1, 80, 25, 7);
  CursorOn;
  If FOpen Then Close (f);
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
