PROGRAM Minesweeper;
{$M 5000, 0, 0}

USES
  dos, crt, Monitor, Monitcmd, mouse, dosmin_a, ExeWrite, Compare,
  dm_old, dm_var{$IFDEF SHARE}, Sperre {$ENDIF};


LABEL
  Start, Start1, Ende, EndX;


PROCEDURE Timer;
VAR
  ho, mi, se, hu : Word;
BEGIN
  If IfEnd>0 Then Exit;
  GetTime (ho, mi, se, hu);
  If se<>sec Then
  BEGIN
    inc (xTime); Str (xTime, StTime);
    WriteXY (43, 2, 'Zeit: '+stTime+'    ', 10, 1); sec:=se;
  END;
END;



PROCEDURE VGAColorOn; assembler;
ASM;
  MOV AH,10H; MOV AL, 3H; MOV BL, 0H; INT 10H
END;


PROCEDURE VGAColorOff; assembler;
ASM;
  MOV AH,10H; MOV AL, 3H; MOV BL, 1H; INT 10H
END;



PROCEDURE Kasten (x, y, Mode : Byte);
VAR
  xx, yy, Col, Col1, col2 : Byte;
BEGIN
  xx:= x*4; yy:= y*3+2; Feld[x,y].Open:= Mode=1;

  If Mode=0 Then
  BEGIN Col1:=7; Col2:=15; END Else BEGIN Col1:=1; Col2:= 1; END;

  With Feld[x,y] Do
  If Open Then
  WriteXY (xx,yy+1, #32+chr(Zeichen)+#32, vc, hc) Else

  If Sign='?' Then
  WriteXY (xx,yy+1, #32+Sign+#32, SCol, 7) Else
  WriteXY (xx,yy+1, #32+Sign+#32, 4,    7);

  If x=1 Then Col:=1 Else Col:=8;
  CharXY (xx-1, yy,   #222, col2, Col);
  CharXY (xx-1, yy+1, #222, col2, Col);
  CharXY (xx-1, yy+2, #222, col2, Col);

  If kn<>2 Then
  BEGIN
    If ((x=19) or (Mode=1)) and (Feld[x+1,y].Open) Then
    Col:=1 Else Col:=15;
  END Else
  BEGIN
    If (Feld[x+1,y].Open) Then
    Col:=1 Else Col:=15;
  END;

  CharXY (xx+3, yy,   #221,  8, col);
  CharXY (xx+3, yy+1, #221,  8, col);
  CharXY (xx+3, yy+2, #221,  8, col);

  WriteXY (xx, yy,    #223#223#223, col2, col1);
  WriteXY (xx, yy+2,  #220#220#220,    8, col1);
END;



PROCEDURE BombsInit;
VAR
  x, y, z, a, b : Byte;

BEGIN
  Fillchar (Feld, SizeOf (Feld), 32);
  Bomben:=0; Fahnen:=0; xTime:=0; IfEnd:=0; RFahne:=0; aufgedeckt:=0;
  Randomize;
  Bomben:=0;
  REPEAT
    x:= Random (19)+1;
    y:= Random (15)+1;
    With Feld[x, y] Do
    If Zeichen= 32 Then BEGIN Zeichen:= 15; inc (Bomben); END;
  UNTIL Bomben = Konfig.Bombenzahl;

  For x:=1 To 19 Do For y:= 1 To 15 Do
  With Feld[x, y] Do
  BEGIN
    If Zeichen = 15 Then
    BEGIN hc:= 4; vc:= 15; END Else BEGIN hc:= 1; vc:= 1; Zeichen:= 0; END;
    Open:=False;
  END;

  For x:=1 To 19 Do For y:= 1 To 15 Do
  BEGIN
    If Feld[x, y].Zeichen <> 15 Then
    BEGIN
      z:=0;
      For a:= x-1 To x+1 Do For b:= y-1 To y+1 Do
      If Feld[a, b].Zeichen= 15 Then inc(z);
      If z > 0 Then Feld [x, y].Zeichen:= z+48;
      CASE z Of
        1 : Feld [x, y].vc:=yellow;
        2 : Feld [x, y].vc:=Lightgreen;
        3 : Feld [x, y].vc:=Lightred;
        4 : Feld [x, y].vc:=lightmagenta;
        5 : Feld [x, y].vc:=magenta;
        6 : Feld [x, y].vc:=brown;
        7 : Feld [x, y].vc:=lightcyan;
      END;
    END;
  END;
END;


PROCEDURE DrawField;
VAR
  x, y, z : Word;
BEGIN
  WriteXY (4, 2, 'DOS-Minesweeper', 13, 1);
  WriteXY (59, 2, 'ESC Ende   ENTER neu', 14, 1);
  For x:=1 To 19 Do For y:= 1 To 15 Do
  If Feld[x, y].open Then Kasten (x, y, 1) Else Kasten (x, y, 0); 
END;


PROCEDURE BombField (x, y, c : Byte);
VAR
  Col      : Byte;
  xx, yy   : Word;
  WaitTime : Word;
BEGIN
  WaitTime:= (100-Konfig.Bombenzahl) * Konfig.vTime;

  If Konfig.SoundOn Then
  BEGIN Sound (5000); Delay (WaitTime DIV 5); Nosound; Delay (WaitTime); END;

  xx:= x*4; yy:= y*3+2;
  If x=1 Then col:=1 Else Col:=8;

  CharXY  (xx-1, yy,   #222, c, col);
  CharXY  (xx-1, yy+1, #222, c, col);
  CharXY  (xx-1, yy+2, #222, c, col);
  WriteXY (xx,   yy,   #32#32#32, 14, c);
  WriteXY (xx,   yy+1, #32#15#32, 14, c);
  WriteXY (xx,   yy+2, #32#32#32, 14, c);
END;



PROCEDURE ShowBombs;
VAR
  x, y : Byte;
BEGIN
  For x:=1 To 19 Do For y:= 1 To 15 Do
  BEGIN
   (* MouseGet;*)
    If (not keypressed) (*and (kn<>2)*) Then If Feld[x,y].Zeichen=15 Then BombField (x, y, 4);
  END;
  BombField (xmm, ymm, 0);
  If Konfig.SoundOn Then BEGIN Sound (1000); Delay (60*Konfig.vTime); Nosound;END;
END;



PROCEDURE RekProc1 (x, y : Integer);
VAR
  a, b : Integer;
BEGIN
  For a:= x-1 To x+1 Do For b:= y-1 To y+1 Do
  If (a>0) and (b>0) and (a<20) and (b<16) and (Feld[a, b].Zeichen<>15) Then
  BEGIN
    If (not Feld[a, b].Open) Then
    BEGIN
      If (Feld[a, b].Sign=#16) Then dec (Fahnen); inc(aufgedeckt);
      If Konfig.SoundOn Then BEGIN Sound(400*(a+b)); Delay (Konfig.vTime); Nosound; Delay (20*Konfig.vTime); END;
    END;
    Kasten (a, b, 1);
  END;
END;


PROCEDURE RekProc2 (x, y : Integer);
VAR
  a, b : Integer;
BEGIN
  a:=x; b:=y;
  WHILE (y>0) and(Feld[x,y].Zeichen=0) Do BEGIN RekProc1(x,y);dec(y);END;y:=b;
  WHILE (y<16)and(Feld[x,y].Zeichen=0) Do BEGIN RekProc1(x,y);inc(y);END;y:=b;
  WHILE (x>0) and(Feld[x,y].Zeichen=0) Do BEGIN RekProc1(x,y);dec(x);END;x:=a;
  WHILE (x<20)and(Feld[x,y].Zeichen=0) Do BEGIN RekProc1(x,y);inc(x);END;
END;

PROCEDURE RekProc (x, y : Integer);
VAR
  a, b : Integer;
BEGIN
  a:=x; b:=y;
  WHILE (y>0) and(Feld[x,y].Zeichen=0) Do BEGIN RekProc2(x,y);dec(y);END;y:=b;
  WHILE (y<16)and(Feld[x,y].Zeichen=0) Do BEGIN RekProc2(x,y);inc(y);END;y:=b;
  WHILE (x>0) and(Feld[x,y].Zeichen=0) Do BEGIN RekProc2(x,y);dec(x);END;x:=a;
  WHILE (x<20)and(Feld[x,y].Zeichen=0) Do BEGIN RekProc2(x,y);inc(x);END;
END;


PROCEDURE Freudentanz;
VAR
  x, y, z, d, c, e : Byte;
BEGIN
  Delay (300*Konfig.vTime);
  MouseOff; ClearWin (19, 14, 62, 34, 240); e:=0;
  WriteXY (38, 18, 'Hurra !', 0, 15);
  WriteXY (38, 22, 'Du hast gewonnen!', 0, 15);
  While (not Keypressed) and (e<6) Do
  BEGIN
    inc (e);
    c:=Random (4);
    For x:=34 Downto 17 Do
    BEGIN
      CharXY (23+c, x, #219, green, 15);
      d:=34-x; If d>5 Then d:=5;
      For z:=1 To d Do CharXY (23+c, x+z, #196, 1, 15);
      If x<29 Then CharXY (23+c, x+6, #32, 0, 15);
      If (x>28) and (Konfig.SoundOn) Then Sound (x*75);
      Delay ((36-x)*Konfig.vTime);
      Nosound;
    END;
    For x:=17 to 34 Do
    BEGIN
      CharXY (23+c, x, #219, green, 15);
      If x>17 Then CharXY (23+c, x-1, #32, 14, 15);
      Delay ((36-x)*Konfig.vTime);
    END; 
    If e<6 Then CharXY (23+c, 34, #32, 0, 15);
  END;
  If Konfig.SoundOn Then BEGIN Sound(5000); Delay (Konfig.vTime); Nosound; END;
  WriteXY (28, 27, 'Weiter mit Maus oder Taste...', 1, 15);
  MouseOn;
END;


PROCEDURE Trauer;
VAR
  x, y, z, d, e : Byte;
BEGIN
  If (keypressed) Then Exit;
  Delay (300*Konfig.vTime);
  MouseOff; ClearWin (19, 14, 62, 34, 7); e:=0;
  WriteXY (38, 18, 'Trst...', 15, 0);
  WriteXY (38, 22, 'Du hast verloren...', 15, 0);
  While (not Keypressed) and (e<7) Do
  BEGIN
    inc (e);
    For x:=25 Downto 19 Do
    BEGIN
      CharXY (x,   34, #219, green, 0);
      CharXY (x+1, 34, #219, 0, 0);
      Delay ((36-x)*Konfig.vTime);
    END;
    If Konfig.SoundOn Then BEGIN Sound(5000); Delay (Konfig.vTime); Nosound; END;
    If e<7 Then
    For x:=19 to 25 Do
    BEGIN
      CharXY (x+1, 34, #219, green, 0);
      CharXY (x,   34, #219, 0, 0);
      Delay ((36-x)*Konfig.vTime);
    END; 
  END;
  WriteXY (28, 27, 'Weiter mit Maus oder Taste...', 15, 0);
  MouseOn;
END;



{------------------------------ Hauptprogramm ----------------------------}

BEGIN
  OldCheckSum:= CheckSum (Konfig, SizeOf (Konfig));

  MouseInit; MouseMoveXY (70, 2); MouseSpeed (4, 8); CyanCursor;


  StartMenue(t); If t=#27 Then Goto Ende;
  Start1:  
  x50_Zeilen; VGAColorOn; MouseWindow (1, 1, 80, 50);
  Textattr:=16; ClrScr; 
  t:=#0;
Start:
  If t='O' Then Read_OldGame Else BombsInit;
  DrawField; t:=#0; MouseOn;

  REPEAT
    Str (Bomben-Fahnen, Bombs);
    WriteXY (27, 2, 'Bomben: '+Bombs+'   ', 11, 1);

    CASE IfEnd Of
      1 : Trauer;
      2 : Freudentanz;
    END; 

    REPEAT MouseGet; Timer; UNTIL (kn<>0) or (Keypressed);
    If keypressed Then t:=ReadKey Else

    If ym<3 Then
    BEGIN
      If xm>57 Then t:=#27; If (xm>67) Then t:=#13;
      If (xm>79) Then BEGIN If SCol=0 Then SCol:=15 Else SCol:=0; t:=#9; END;
    END;

    If (xm>3) and (ym>4) and (xm<79) and (ym<50) Then
    BEGIN
      MouseOff;
      xmm:= xm DIV 4; ymm:=(ym-2) DIV 3;

      If kn=1 Then
      BEGIN
        If not (Feld[xmm, ymm].Open) and (Feld[xmm, ymm].Sign<>#16) and
        (Feld[xmm, ymm].Zeichen=0) Then RekProc (xmm, ymm);

        If (Feld[xmm, ymm].Zeichen=15) and (Feld[xmm, ymm].Sign<>#16) Then
        BEGIN If IfEnd=0 Then IfEnd:=1; ShowBombs; END Else
        BEGIN
          If not (Feld[xmm, ymm].Open) and (Feld[xmm, ymm].Sign<>#16) Then
          BEGIN inc (aufgedeckt); Kasten (xmm, ymm, 1); END;
        END;
      END
      Else
      If not Feld[xmm, ymm].Open Then
      BEGIN
        CASE Feld[xmm, ymm].Sign Of
         #32 : BEGIN
                 Feld[xmm, ymm].Sign:=#16; inc (Fahnen);
                 If Feld[xmm, ymm].Zeichen=15 Then inc (RFahne);
               END;
         #16 : BEGIN
                 Feld[xmm, ymm].Sign:='?'; dec (Fahnen);
                 If Feld[xmm, ymm].Zeichen=15 Then dec (RFahne);
               END;
         '?' : Feld[xmm, ymm].Sign:=#32;
        END;
        Kasten (xmm, ymm, 0);
        Delay (100);
      END;
      MouseOn;
    END;
    If (RFahne=Bomben) and (Bomben=Fahnen) and (aufgedeckt+Fahnen=285) Then IfEnd:=2;
    While kn<>0 Do MouseGet;
Endx:
  UNTIL (t=#13) or (t=#27) or (t='E') or (t='O');
  MouseOff;
  If t='E' Then Write_OldGame;


  If t<>#27 Then Goto Start;
  
  x25_Zeilen;

  StartMenue(t);
  If t<>#27 Then Goto Start1;

  VGAColorOff;

Ende:
  ClearWin (1,1,80,25, 7); CursorOn;

(*If ParamStr(1)<>'AO' Then BEGIN W (ShareHinweis); ReadLn; END;*)

  If OldCheckSum <> CheckSum (Konfig, SizeOf (Konfig)) Then
  BEGIN
    W (#13#10'Speichere Konfiguration...');
    WriteIntoExeFile (Konfig, SizeOf (Konfig));
    If IOResult<>0 Then
    BEGIN
      w (#13#10'Konfiguration konnte nicht gespeichert werden.'#13#10'Weiter mit ENTER.');
      ReadLn;
    END;
  END;
(*  ExeSize;*)
  Halt;
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
