PROGRAM double;
{$M 60000, 0, 655360}

USES
  DOS, bioscrt, strings, LaufBalk, compare, masken, keycode,
  monitor, filecopy, LogFile, WildCard;


CONST
  ProgName   = 'DOUBLE';
  Bufsize    = 100;
  OneBufSize = 16382;
  IndexZahl  = 10;
  IndexEnd   : LongInt = 0;
  LastIndex  : LongInt = 0;
  IndexPtr   : LongInt = 0;

TYPE
  TStr       = String[9];
  xTRec      = RECORD ho, mi, se, hu : Word END;
  IndexBuf   = Array [0..OneBufSize] of LongInt;
  FiList     = Array [1..10000] Of ^PathStr;

VAR
  FList            : ^FiList;
  LastFile         : Word;
  TmpSuchPfad      : PathStr;

  tLong            : LongInt;
  f                : File;
  Idx              : Array[0..IndexZahl] Of ^IndexBuf;
  Buf              : Array[1..Bufsize]   Of PathStr;
  tx               : Text;
  g                : Word;
  new_dir          : PathStr;
  IndexY           : LongInt;
  ProgPath         : PathStr;
  TempPath         : PathStr;
  OldHeap          : Pointer;
  Zeiger           : Word;
  FirstLine        : Word;
  PStat            : Byte;
  cf               : Byte;

CONST
  SuchPfad   : PathStr  = '';
  Objekt     : PathStr  = '';
  Teiler     : Byte     = 0;
  BufPos     : Word     = 0;
  BufNum     : Word     = 0;
  BufPtr     : Word     = 0;

  Result     : Word     = 0;
  Files      : LongInt  = 0;


PROCEDURE WriteFile (s : String);
BEGIN
  WriteLn (tx, s);
END;


PROCEDURE ExProc;
VAR
  s : PathStr;
BEGIN
  If (t1=#27) or (Result<>0) Then
  BEGIN
    GotoXY (1, 12);
    If t1=#27 Then
    BEGIN
      Result:=253;
      s:= 'Abbruch durch Anwender';
    END Else
    BEGIN
      If Result<>1 Then s:= CopyResultStr (Result) Else
      s:= 'Zu wenig Arbeitsspeicher. Lesen Sie die Hilfe (Befehl: HELP Double)';
    END;
    If FileRec(f).Mode <> fmClosed Then
    BEGIN Close (f); Erase (f); END;
    If TextRec(tx).Mode <> fmClosed Then
    BEGIN Close (tx); If IOResult<>0 Then; END;
    ErrorHaltLog (s);
  END;
END;


PROCEDURE Hilfetext;
BEGIN
  StandardKopf (ProgName, CopyRight);

  DosLnLF (
  'sucht doppelte Dateien und zeigt eine Liste aller Doubletten'#13#10#13#10+
  'DOUBLE [zu durchsuchende/s Verzeichnis/se] [zu prfende Datei(en)] [/o]'#13#10#13#10+
  '/o   es erfolgt keine Benutzerabfrage, Fehler werden in der LOG-Datei'#13#10+
  '     gespeichert'#13#10);
  DosLnLF (
  'Mehrere zu durchsuchende Verzeichnisse sowie mehrere zu prfende Dateien'#13#10+
  'knnen durch das Zeichen + getrennt nacheinander aufgefhrt werden. berlappende'+
  'Verzeichnispfade werden beim Vergleich erkannt.'#13#10);
  DosLnLF (
  'Die Liste aller doppelten Dateien wird am Ende angezeigt und befindet sich'#13#10+
  'auch nach Beendigung von DOUBLE in der Datei DOUBLETT.DOC im selben Verzeichnis'#13#10+
  'wie DOUBLE.EXE.');

  BlindStop; Halt (255);
END;


PROCEDURE PushFileName (Name : PathStr; Size : LongInt);
BEGIN
  If BufPos >= BufSize Then
  BEGIN
    BlockWrite (f, Buf, SizeOf (Buf), g);
    Result:= IOResult; Exproc;
    Bufpos:= 0;
  END;
  inc (Bufpos);
  Buf[BufPos]:= Name;

  Idx[BufNum]^[BufPtr]:= Size;
  If BufPtr < OneBufSize Then inc (BufPtr) Else
  BEGIN BufPtr:= 0; inc (BufNum); END;
END;


PROCEDURE PushLastBuf;
BEGIN
  BlockWrite (f, Buf, BufPos*SizeOf(PathStr), g);
  Result:= IOResult; Exproc;
END;


PROCEDURE Rekursiv (SuchPfad: PathStr);
VAR
  tr : Searchrec;
BEGIN
  Findfirst (Vollpfad (Suchpfad,'*.*'), Normalfile, tr);
  If DOSError>=150 Then BEGIN Result:= DOSError; ExProc; END;
  WriteXY (1, 20, Suchpfad+FillString(80-Length(Suchpfad)), 7, 0);
  While DOSError = 0 Do
  BEGIN
    If tr.attr and directory <> 0 Then
    BEGIN
      If tr.name[1]<>'.' Then Rekursiv (VollPfad (SuchPfad, tr.name));
    END Else
    If FileMatch (tr.name, Objekt) Then
    BEGIN
      If IndexEnd<LastIndex Then
      BEGIN
        inc (IndexEnd);
        WriteXY (23, 3, StrVal(IndexEnd), 7, 0);
        PushFileName (Vollpfad (suchpfad, tr.name), tr.size);
      END Else
      BEGIN
        GotoXY (1, 8);
        OutStr ('Nicht gengend Arbeitsspeicher.'#13#10+
                'Geben Sie den DOS-Befehl "help double" fr mehr Informationen.'#13#10);
        Result:= 1; ExProc;
      END;
    END;
    Findnext (tr);
    If keyPressed Then ScanBKeys; ExProc;
  END;
END;


PROCEDURE ShowMaske;
LABEL
  a1, a2, a3;
BEGIN
  t2:= #0;
  GetDir (0, SuchPfad); Objekt:= '*.*';

  a1:
  EditStr (1, SuchPfad, 'Verzeichnis(se), das nach doppelten Dateien durchsucht werden soll:');
  SuchPfad:= UpStr (SuchPfad);

  a2:
  EditStr (6, Objekt,  'Dateien, von denen dabei Doubletten gesucht werden sollen:');
  Objekt:= UpStr (Objekt);
  If t2=Up Then Goto a1;
END;



PROCEDURE Maske;
BEGIN
  StandardKopf (ProgName, 'Eingabemaske');
  Fusszeile (EingabeHilfe);
  ee:= 1; ShowMaske; ee:= 0; ShowMaske;
END;



PROCEDURE Parameter;
VAR
  x     : Byte;
  Param : String;
BEGIN
  StretchParam (Param);
  If ParamCount=0 Then Maske Else
  For x:= 1 To ParamCount Do
  BEGIN
    Param:= UpStr (ParamStr (x));
    If Param[1] = '/' Then
    CASE Param[2] Of
      '?' : Hilfetext;
      'O' : LogStatus:= 0;
    END Else
    BEGIN
      If SuchPfad='' Then Suchpfad:=Param Else
      If Objekt  ='' Then Objekt  :=Param;
    END;
  END;
  If Objekt='' Then Objekt:= '*';
END;



FUNCTION CheckSumme (AnCheck : Boolean; Name : PathStr) : Word;
VAR
  f1     : File;
  Buf    : Array[1..50000] Of Byte;
  w, gel : Word;

BEGIN
  w:= 0;
  Assign (f1, Name); FileMode:= 0;
  Reset (f1, 1); Result:= IOResult; ExProc;

  If Ancheck Then
  BEGIN
    BlockRead (f1, Buf, 20480, gel);
    Result:= IOResult;
    w:= CheckSum (Buf, gel);
  END Else
  While (Result=0) and (not Eof (f1))  Do
  BEGIN
    BlockRead (f1, Buf, SizeOf (Buf), gel);
    Result:= IOResult;
    inc (w, CheckSum (Buf, gel));
  END;
  Close (f1); Result:= IOResult; ExProc;
  CheckSumme:= w;
END;


PROCEDURE Suche_Doubletten;
VAR
  x, y         : LongInt;
  Found        : Boolean;
  First        : Boolean;
  OrigChkSum   : Word;
  OrigAnCheck  : Word;
  NewAnCheck   : Word;
  OrigSize     : LongInt;
  BNum, BPos   : Word;
  OrigName     : PathStr;
  NewName      : PathStr;

BEGIN
  BufNum:= 0;
  BufPos:= 0;
  WriteFile ('Folgende Dateien sind identisch'#13#10'-------------------------------'#13#10);
  Result:= IOResult; ExProc;
  Unterbalken (18, 'Untersucht');

  For x:= 0 To IndexEnd-1 Do
  BEGIN
    If KeyPressed Then ScanBKeys; ExProc;
    WriteXY (23, 5, StrVal (x), 7, 0);
    Balken (18, x+2, IndexEnd);

    OrigSize:= Idx[BufNum]^[BufPos];

    If Bufpos < OneBufSize Then inc (BufPos) Else
    BEGIN BufPos:= 0; inc (BufNum); END;

    If OrigSize > -1 Then
    BEGIN
      Found:= FALSE;
      First:= FALSE;
      BPos := BufPos;
      BNum := BufNum;

      For y:= x+1 To IndexEnd-1 Do    { war vorher 2, versagte aber bei nur 2 Dateien }
      BEGIN
        If OrigSize=Idx[BNum]^[BPos] Then
        BEGIN
          If not First Then
          BEGIN
            Seek (f, x*LongInt(SizeOf(PathStr)));
            BlockRead (f, OrigName, SizeOf (PathStr), g);
            OrigAnCheck:= CheckSumme (TRUE, OrigName);
            First:= True;
          END;

          Seek (f, y*LongInt(SizeOf(PathStr)));
          BlockRead (f, NewName, SizeOf (PathStr), g);

          If NewName<>OrigName Then
          BEGIN
            NewAnCheck:= CheckSumme (TRUE, NewName);

            If NewAnCheck = OrigAncheck Then
            BEGIN
              If not Found Then
              BEGIN
                If OrigSize<=20480 Then
                OrigChkSum:= OrigAncheck Else
                OrigChkSum:= CheckSumme (FALSE, OrigName);
              END;

              If OrigSize>20480 Then NewAnCheck:= CheckSumme (FALSE, NewName);

              If NewAnCheck = OrigChkSum Then
              BEGIN
                inc (Files);
                If not Found Then
                BEGIN
                  WriteFile (OrigName);
                  Result:= IOResult; ExProc;
                  Found:= TRUE;
                  WriteXY (23, 6, StrVal (Files), 7, 0);
                END;
                WriteFile (NewName);
                Result:= IOResult; ExProc;
                Idx[BNum]^[BPos]:= -1;
              END;
            END;
          END;
        END;
        If Bpos < OneBufSize Then inc (BPos) Else
        BEGIN BPos:= 0; inc (BNum); END;
      END;

      If Found Then
      WriteFile ('Gre : '+StrVal (OrigSize)+ ' Byte'#13#10);
      Result:= IOResult; ExProc;
    END;
  END;

  Close (tx);
  If Files=0 Then Erase (tx);
  Result:= IOResult;
END;


PROCEDURE ReadFile;
VAR
  tmp  : String;
  TBuf : Array[1..10000] Of Byte;
BEGIN
  Fusszeile ('Lade Ergebnisdatei...');
  Release (OldHeap);
  Mark (OldHeap);
  If MaxAvail>SizeOf (FiList) Then GetMem (FList, SizeOf (FiList)) Else
  ErrorHalt ('Zu wenig Speicher zum Anzeigen der gefundenen Dateien');
  LastFile:= 0;
  Assign (tx, VollPfad (ProgPath, 'DOUBLETT.DOC')); FileMode:= 0;
  SetTextBuf (tx, TBuf, SizeOf (TBuf));
  Reset (tx); Result:= IOResult; Exproc;
  While (not Eof (tx)) and (MaxAvail>SizeOf (PathStr)) Do
  BEGIN
    ReadLn (tx, tmp); Result:= IOResult; ExProc;
    If Length (tmp)>(SizeOf (PathStr)-1) Then tmp[0]:= chr(SizeOf (PathStr)-1);
    If ((Length(Tmp)>2) and (tmp[2]=':'))
    or ((Tmp='')        and (LastFile<>0)) Then 
    BEGIN
      inc (LastFile);
      GetMem (FList^[LastFile], SizeOf (PathStr));
      FList^[LastFile]^:= Tmp;
    END;
  END;
  Close (tx); Result:= IOResult; ExProc;
  While (FList^[LastFile]^='') and (LastFile>0) Do dec (LastFile);
END;


PROCEDURE ViewScreen;
VAR
  y,  y2 : Word;
  hc, vc : byte;
BEGIN
  y2:= 2;
  For y:= FirstLine To FirstLine+18 Do
  BEGIN
    inc (y2);
    If y2-3=Zeiger Then
    BEGIN hc:= 7; vc:=  0; GotoXY (1, Zeiger+1); END Else
    BEGIN hc:= 0; vc:=  7; END;
    If y<=LastFile Then
    WriteXY (1, y2, SpaceStr (FList^[y]^, 80), vc, hc) Else
    WriteXY (1, y2, SpaceStr (' ', 80) ,       7, 0);
  END;
END;


PROCEDURE IncLine (Zahl : Word);
BEGIN
  For Zahl:= 1 To Zahl Do If FirstLine+Zeiger<LastFile Then
  If Zeiger<18 Then inc (Zeiger) Else inc (FirstLine);
  If (FirstLine+Zeiger<LastFile) and (FList^[FirstLine+Zeiger]^='') Then
  If Zeiger<18 Then inc (Zeiger) Else inc (FirstLine);
END;


PROCEDURE DecLine (Zahl : Word);
BEGIN
  For Zahl:= 1 To Zahl Do 
  If Zeiger>0 Then dec (Zeiger) Else If FirstLine>1 Then dec (FirstLine);
  If FList^[FirstLine+Zeiger]^='' Then
  If Zeiger>0 Then dec (Zeiger) Else If FirstLine>1 Then dec (FirstLine);
END;


PROCEDURE ViewerHelp;
BEGIN
  Fusszeile ('Kurzanzeige der Datei: F3   Datei lschen: F8   Scrollen: Pfeil   Abbruch: Esc');
  t1:= #0; t2:= #0;
END;


PROCEDURE DeleteFile;
VAR
  x, x1 : Word;
  f     : File;
BEGIN
  x1:= FirstLine+Zeiger;
  If  (LastFile<2)
  or  ((x1=1)        and (FList^[x1+1]^=''))
  or  ((x1=LastFile) and (FList^[x1-1]^=''))
  or (((x1>1)        and (FList^[x1-1]^=''))
  and ((x1<LastFile) and (FList^[x1+1]^=''))) Then
  BEGIN
    ErrorMsg ('Die jeweils briggebliebene Datei kann nicht gelscht werden. Weiter mit Taste.');
    ViewerHelp;
    Exit;
  END;
  EraseFile (FList^[x1]^);
  Result:= IOResult;
  If Result<>0 Then
  BEGIN
    ErrorMsg ('Lschen fehlgeschlagen: '+CopyresultStr (Result));
    ViewerHelp;
    Exit;
  END;
  dec (LastFile);
  For x:= x1 To LastFile Do FList^[x]^:= FList^[x+1]^;
  If (FList^[x1]^= '') or (x1 > LastFile) Then DecLine (1);
END;


PROCEDURE QuickView;
VAR
  tx : Text;
  s  : String;
  x  : Byte;
LABEL
  Err;
BEGIN
  Assign (tx, FList^[FirstLine+Zeiger]^); FileMode:= 0;
  Reset (tx);
  If IOResult<> 0 Then
  BEGIN
    Err:
    ErrorMsg ('Datei kann nicht angezeigt werden. Weiter mit Taste.');
    ViewerHelp;
    Exit;
  END;
  x:= 0; ClrScr;
  While (not Eof (tx)) and (x<19) Do
  BEGIN
    ReadLn (tx, s);
    If IOResult<>0 Then BEGIN Close (tx); Result:= IOResult; Goto Err; END;
    inc (x);
    OutLnLF (copy (s, 1, 79));
  END;
  Close (tx); Result:= IOResult; 
  Fusszeile ('Dateiansicht beenden mit beliebiger Taste');
  WaitBKey;
  ViewerHelp;
END;


PROCEDURE Viewer;
BEGIN
  FirstLine:= 1; Zeiger:= 0;
  ViewerHelp;
  REPEAT
    ViewScreen;
    ScanBKeys;
    If t1=#0 Then
    CASE t2 Of
      Down : IncLine (1);
      Up   : DecLine (1);
      Endx : IncLine (LastFile);
      Pos1 : DecLine (FirstLine+Zeiger);
      PgUp : DecLine (18);
      PgDn : IncLine (18);
      F3   : QuickView;
      F8   : DeleteFile;
    END;
  UNTIL t1=#27;
  Release (OldHeap);
END;


{----------------------------- HauptProgramm ------------------------------}

BEGIN
  t1:= #1;
  Mark (OldHeap);
  For g:= 0 To IndexZahl Do
  BEGIN
    tLong:= MaxAvail;
    If tLong>0 Then
    BEGIN
      If tLong>SizeOf (IndexBuf) Then tLong:= SizeOf (IndexBuf);
      tLong:= tLong shr 2;
      inc (LastIndex, tLong);
      tLong:= tLong shl 2;
      GetMem (Idx[g], tLong);
    END;
  END;

  ClrScr;
  Parameter; 
  StandardKopf (ProgName, '');

  FileMode:= 2;

  ProgPath:= ParamStr (0);
  While (Length(ProgPath)<>0) and (ProgPath[Length(ProgPath)]<>'\') Do dec (ProgPath[0]);

  TempPath:= Trim (GetEnv ('TEMP'));
  If  TempPath='' Then TempPath:= Trim (GetEnv ('TMP'));
  If (TempPath='') or (ObjektExist (TempPath) <> Ver) Then
  TempPath:= ProgPath;

  Assign (f,  VollPfad (TempPath, 'DOUBLETT.TMP')); 
  Assign (tx, VollPfad (ProgPath, 'DOUBLETT.DOC'));

  Rewrite (f, 1);
  If IOResult<>0 Then
  BEGIN SetFAttr (f, 32); Rewrite (f, 1); Result:= IOResult; Exproc; END;
  
  Rewrite (tx);
  If IOResult <> 0 Then
  BEGIN SetFAttr (tx, 32); Rewrite (tx); Result:= IOResult; Exproc; END;

  For cf:= 1 To CountFields (SuchPfad, '+') Do
  BEGIN
    TmpSuchpfad:= FileExPand (nthField (SuchPfad, '+', cf));
    If DOSError=0 Then PStat:= PathStatus (TmpSuchPfad, CheckQuelle) Else PStat:= DOSError;
    If PStat<>0 Then ErrorMsgLog (PathStatusStr (PStat)) Else
    BEGIN
      GotoXY (1, 1);
      OutLnLF ('Gefundene Dateien.. : 0');
      Fusszeile ('Double legt Dateiliste an...  (Abbrechen mit Esc)');
      Rekursiv (TmpSuchpfad);
    END;
  END;

  PushLastBuf;

  IndexY:= IndexEnd;
  While IndexY>200000 Do BEGIN inc (Teiler); IndexY:= IndexY shr 1; END;
  IndexY:= IndexY * ((IndexY+1) shr 1);  { Gesamtzahl der Listenzugriffe }

  GotoOldPos;
  OutLnLF (#13#10+
          'Suche Doublette von : 0'#13#10+
          'Gefundene Doubletten: 0');
  Fusszeile ('Double sucht nach doppelten Dateien...  (Abbrechen mit Esc)');

  Suche_Doubletten;

  Close (f);
  Erase (f);
  Result:= IOResult;

  If Files=0 Then ErrorHaltLog ('Keine doppelten Dateien gefunden.');

  If LogStatus=2 Then BEGIN ReadFile; Viewer; END;

  ErrCode:=Result;
  ErrorHalt ('Fertig');
END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
