
jmp BEGIN 
DB                  1   ; VersionsNummer des Treibers 
DB                  5   ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0 ; interne Nummer (vom Programmierer frei whlbar) 
DB                  21h ; Nummer eines der umgeleiteten Interrupts 
DB                  0   ; Zahl der erwarteten Start-Parameter

Flag            DB  0
 

;----------------------- Unterfunktionen ---------------------------------
 
Protection:
  cs:
  cmp Byte Flag, 2
  je  @Old
  cs:
  cmp Byte Flag, 1        ; Flag wird vom Unloader auf 1 gesetzt, 
  je  @Unload             ; wenn DPROTECT aus dem Speicher entfernt
                          ; werden soll. Sonst Flag = 0
  cmp ah, 41h             ; delete file ?
  je  @Sperre
  cmp ah, 13h             ; delete file FCB ?
  je  @Sperre
  cmp ah, 3Ah             ; remove directory ?
  jne @Old

@Sperre:
  mov ax, 5
  stc
  retf 2

@Old:
  DB 0EAh                 ; JMP Far Ptr = alte Int-21h-Routine
  OBJECT Old21:
    Ofs DW '6.'           ; hier setzt der Loader die alte Adresse
    Seg DW '24'           ; der alten Int-21h-Routine ein.
  OBJECT END

@Unload:
  push ax, di
  cli
  cld
  xor  ax, ax
  mov  es, ax
  mov  di, 21h
  shl  di, 2
  cs:
  mov  ax, Old21.Ofs
  stosw
  cs:
  mov  ax, Old21.Seg
  stosw
  sti
  pop  di, ax

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von DPROTECT.COM wieder freigeben
  jmp  short @Old

; ------------------------------ Loader --------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt
  lea  dx, &ProgName
  #OutPut

  cld
  push cs                     ; Adresse des PSP ermitteln
  pop  es                     ; Segment des PSP in ES 
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
  

         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3521h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  mov  ah, 30h / int  21h              ; Unload anschubsen
  lea  dx, &Unload

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree
 
  lea  dx, &Load
  #OutPut

  mov  ax, 3521h       ; GetIntVec 21h
  int  21h                                
  mov  Old21.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old21.Seg, es 
  mov  ax, 2521h       ; SetIntVec 21h
  lea  dx, Protection  ; = mov dx, Offset Protection, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen


PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh

.ifopt deu
  &ProgName  DB  'DPROTECT  ', Copyright, '$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'Lschschutz fr Dateien/Verzeichnisse',13,10,13,10  
  >              'Laden  : DPROTECT',13,10
  >              'Steuern: DPROTECT [/x|/s|/r]',13,10,13,10
  >              '/x  aus Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren$'
.endopt

.ifOpt eng
  &Progname  DB  'DPROTECT  ', Copyright, '$' 
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Delete-protection for files and directories'
  >               13,10,13,10
  >              'Install: DPROTECT',13,10
  >              'Control: DPROTECT [/x|/s|/r]',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
