
jmp BEGIN 
DB                  1   ; VersionsNummer des Treibers 
DB                  10  ; Treiber-Nummer zur berprfung d. UnLoader
DB                  1,0 ; interne Nummer (vom Programmierer frei whlbar) 
DB                  13h ; Nummer eines der umgeleiteten Interrupts 
DB                  0   ; Zahl der erwarteten Start-Parameter

Flag            DB  0
 

;----------------------- Unterfunktionen ---------------------------------
 


Protection:
  cmp dl, 1               ; Kein Floppy-Laufwerk ?
  ja  @Old                ; dann Old

  cs:
  cmp Byte Flag, 2
  je  @Old
  cs:
  cmp Byte Flag, 1        ; Flag wird vom Unloader auf 1 gesetzt, 
  je  @Unload             ; wenn DPROTECT aus dem Speicher entfernt
                          ; werden soll. Sonst Flag = 0

  cmp ah, 3               ; write ?
  je  @Sperre
  cmp ah, 5               ; format ?
  jne @Old

@Sperre:
  mov ah, 3               ; Error: Disk write-protected
  stc
  retf 2

@Old:
  DB 0EAh                 ; JMP Far Ptr = alte Int-13h-Routine
  OBJECT Old13:
    Ofs DW '6.'           ; hier setzt der Loader die alte Adresse
    Seg DW '24'           ; der alten Int-13h-Routine ein.
  OBJECT END

@Unload:
  push ds, dx, es, ax
  cs:
  mov  dx, Old13.Ofs      ; Alte Adressen laden
  cs:
  mov  ds, Old13.Seg
  mov  ax, 2513h          ; SetIntVec 13h
  int  21h                ; Alte INT 13h-Routine wieder einsetzen

  push cs 
  pop  es
  mov  ah, 49h            ; Speicher von DRVLOCK.COM wieder freigeben
  int  21h                ; ES=CS=Segment des freizugebenden Blocks 
  pop  ax, es, dx, ds
RETF 2

; ------------------------------ Loader --------------------------------------

BEGIN:
 .IfOpt share / .include sperre / #sperre / .endopt  
  lea  dx, &ProgName
  #OutPut

  cld
  push cs                     ; Adresse des PSP ermitteln
  pop  es                     ; Segment des PSP in ES 
  mov  di, 81h                ; Anfang Kommandozeile in SI
  xor  cx, cx
  mov  cl, es:[80h]           ; Lade LngenByte der Kommandozeile in CL
  mov  al, ' '
  repe scasb                  ; Leerzeichen berspringen
  je   @laden                 ; nur Leerzeichen? dann raus
  mov  al, es:[di]            ; Zeichen nach '/' laden
  and  al, 11011111b          ; UpCase
  
         cmp al, 'X' / jne @xs / mov bl, 1                     / jmp short @entladen
  @xs: / cmp al, 'S' / jne @xr / mov bl, 2  / lea dx, &Deactiv / jmp short @entladen
  @xr: / cmp al, 'R' / jne @xh / xor bl, bl / lea dx, &Activ   / jmp short @entladen 
  @xh:                                      / lea dx, &Hilfe   / jmp short @out 
 
@entladen:
  push dx, bx
  mov  ax, 3513h
  int  21h
  pop  bx, dx
  mov  di, 100h                       ; es:di = Driver-Header
  mov  si, di                         ; ds:si = COM-Header
  mov  cx, 9                          ; Lnge Header
  repe cmpsb                          ; Header vergleichen
  jcxz @ausfhren
    lea dx, &NotFound
    jmp short @out
  @ausfhren:
  es:
  mov  Flag, bl
  cmp  bl, 1
  jne  @out

  xor  ah, ah / xor dl, dl / int 13h     ; Unload anschubsen
  lea  dx, &Unload                       ; (Init LW A:)

@out:
 #OutPut
.HALT


@Laden:
  -EnvironMemFree

  lea  dx, &Load
  #OutPut

  mov  ax, 3513h       ; GetIntVec 13h
  int  21h                                
  mov  Old13.Ofs, bx   ; Schreibe alten Vektor in den Call-Befehl
  mov  Old13.Seg, es 

  mov  ax, 2513h       ; SetIntVec 13h
  lea  dx, Protection  ; = mov dx, Offset Protection, DS bereits Segment-Addr.
  int  21h

  lea  dx, BEGIN       ; = Zahl der resident zu haltenden 
                       ; Bytes - CS-Register = Segment des PSP
  int  27h             ; Rest des Programmes resident machen


PROC OutPut:
  mov ah, 9
  int 21h
  lea dx, &LineFeed
  mov ah, 9
  int 21h
  RET
ENDP

.insert copyrigh
.ifopt deu
  &ProgName  DB  'DRVLOCK  ', Copyright,'$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'geladen$'
  &Deactiv   DB  'stillgelegt$'
  &Activ     DB  'reaktiviert$'
  &Unload    DB  'entfernt$'
  &NotFound  DB  'nicht gefunden$'
  &Hilfe     DB  'Schreibschutz fr Diskettenlaufwerke',13,10,13,10  
  >              'Laden  : DRVLOCK',13,10
  >              'Steuern: DRVLOCK [/x|/s|/r]',13,10,13,10
  >              '/x  aus dem Speicher entfernen',13,10
  >              '/s  stillegen',13,10
  >              '/r  reaktivieren$'
.endopt

.ifOpt eng
  &Progname  DB  'DRVLOCK  Copyright (c) 1998 Andr Olejko$'
  &LineFeed  DB   13,10,'$'
  &Load      DB  'installed$'
  &Deactiv   DB  'deactivated$'
  &Activ     DB  'reactivated$'
  &Unload    DB  'removed$'
  &NotFound  DB  'not found$'
  &Hilfe     DB  'Write-protection for floppy drives'
  >               13,10,13,10
  >              'Install: DRVLOCK',13,10
  >              'Control: DRVLOCK [/x|/s|/r]',13,10,13,10
  >              '/x  Remove from memory',13,10
  >              '/s  Deactivate',13,10
  >              '/r  Reactivate$' 
.endopt
 


; Copyright (C) 1994-2002 Andre Olejko - olejko.de
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; version 2, as published by the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
