UNIT ed_File;

INTERFACE

USES
  DOS, ed_var, Strings, spc;


PROCEDURE ResetFile   (Name : PathStr);
PROCEDURE ReadSPCLn (VAR Aus: String);
FUNCTION  EofInFile         : Boolean;
PROCEDURE CloseInFile; 


IMPLEMENTATION

CONST
  BufSize  = SizeOf (Dirliste);

TYPE
  Buf      = Array[1..Bufsize] Of Char;

VAR
  InFile   : File;
  InLen    : LongInt;
  InPtr    : LongInt;
  InBufPtr : Word;
  InBufEnd : Word;
  Buffer   : ^Buf;



PROCEDURE ResetFile (Name : PathStr);
BEGIN
  FileMode:= 0;
  Assign (InFile, Name);
  Reset  (InFile, 1);
  InBufPtr := 0;
  InBufEnd := 0;
  InPtr    := 0;
  InLen    := FileSize (InFile);
  Buffer   := addr (Dirlist^);
END;



PROCEDURE ReadSPCLn (VAR Aus : String);
LABEL
  Ende;
VAR
  tAus   : String;
  NewLen : Word;
BEGIN
  tAus:= '';
  REPEAT
    If InBufPtr >= InBufEnd Then
    BEGIN
      InPtr:= FilePos (InFile); 
      BlockRead (InFile, Buffer^, BufSize, InBufEnd);
      InBufPtr:= 0; If InBufEnd=0 Then Goto Ende;
    END;
    inc (InBufPtr);
    CharAdd (tAus, Buffer^[InBufPtr]);
  UNTIL (Buffer^[InBufPtr]= #1);
  Ende:
  UnPackText (tAus[1], Aus[1], Length (tAus), NewLen);
  Aus[0]:= chr (lo(NewLen));
END;



FUNCTION EofInFile : Boolean; assembler;
ASM
  xor cx, cx
  mov dx, Word Ptr InPtr[2]
  mov ax, Word Ptr InPtr[0]
  add ax, InBufPtr
  adc dx, cx
  cmp dx, Word Ptr InLen[2]
  jb @ende
  ja @weiter
  cmp ax, Word Ptr InLen[0]
  jb @ende
  @weiter:
  mov cx, TRUE
  @ende:
  mov ax, cx
END;
{ EofInFile:= InPtr + InBufPtr >= InLen }



PROCEDURE CloseInFile;
BEGIN
  Close (InFile);
END;



END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
