UNIT Ed_Form;


INTERFACE

USES
  Monitor, menue, BIOScrt, ed_unit, ed_var, ed_suche, strings;


PROCEDURE InsertLine (Modus : Byte);
FUNCTION  GetCutPos (s : String; Umbr : Byte) : Byte;
PROCEDURE ZeilenUmbruch (Modus : Byte);
PROCEDURE BackDeleteLine;
PROCEDURE EntFDeleteLine (Modus : Byte);

PROCEDURE MakeNewFormat;
PROCEDURE RechtsBund;
PROCEDURE LinksBund (Modus : Byte);
PROCEDURE Zentrieren;
PROCEDURE Einruecken;
PROCEDURE Ausruecken;
PROCEDURE MakeBlockSatz;
PROCEDURE FlatterSatz    (Modus : Byte);
PROCEDURE UpLowCaseBlock (IsUpp : Boolean);


IMPLEMENTATION

VAR
  LineSize   : Byte;



FUNCTION SignLen (s : String) : Byte; assembler;
ASM
  les di, s
  xor cx, cx
  mov cl, es:[di]
  add di, cx
  inc cx
  std
  mov al, 32
  repe scasB
  mov ax, cx
END;



PROCEDURE InsertLine (Modus : Byte);
BEGIN
  With FPos[FileNr] Do
  BEGIN
    IfEdit:= TRUE;
    While WhereX+Start>Length (TLine^[ActLine]^)+2 Do GotoXY (WhereX-1, Line+(WinOk-1));
    InsLines (ActLine, 1);
    If RAMError= 0 Then
    BEGIN
      StrCopy (copy (TLine^[ActLine]^, Start+WhereX-1, MaxLen), TLine^[ActLine+1]^);
      TLine^[ActLine]^[0]:= chr (Start+WhereX-2);
      If (t1=#10) and (FPos[FileNr].Bin) and (Length(TLine^[ActLine]^)<MaxLen-3) Then
      StrAdd (TLine^[ActLine]^, #13#10);
      IncMode:= TRUE; incLine; NewCurX:=2; Start:= 0;
      If Modus=1 Then ShowText;
    END Else ErrorMsg ('Nicht gengend Speicherplatz zum Einfgen der Zeile', Okay);
  END;
END;



FUNCTION GetCutPos (s : String; Umbr : Byte) : Byte; assembler;
ASM
  mov bx, ds; xor dx, dx; xor ax, ax; mov dl, Umbr
  lds si, s; cld; LodsB; mov cx, ax; jcxz @ende
  std; cmp cx, dx; jbe @weiter
  mov cx, dx
  @weiter:
  jcxz @ende

  add si, cx; dec si
  @start:
    LodsB
    cmp al,  32; je @ende
    cmp al, '-'; je @ende
    cmp al, '.'; je @ende
    cmp al, ','; je @ende
    cmp al, ';'; je @ende
    cmp al, ']'; je @ende
    cmp al, ')'; je @ende
  loop @start
  @ende:
  mov ax, cx; mov ds, bx
END;



PROCEDURE Zeilenumbruch (Modus : Byte);
VAR
  GesLen, Umbr : Byte;
  tmp          : String;
  LstLine      : Boolean;
  ActLineLen   : Byte;

BEGIN
  With FPos[FileNr] Do
  BEGIN
    If (ActLine<LastLine) and (Length (TLine^[ActLine+1]^)=0) Then
    BEGIN InsLines (Actline+1, 1); TLine^[ActLine+1]^:=''; END;
    ActLineLen:= Length (TLine^[ActLine]^);
    Umbr:= GetCutPos (TLine^[ActLine]^, Konfig.Umbruch-1);
    If (Umbr=0) Then BEGIN InsertLine (Modus); Exit; END;
    IfEdit:= TRUE;
    
    StrCopy (copy (TLine^[ActLine]^, Umbr+1, MaxLen), tmp);
    GesLen:= succ (Length (tmp));
    If ActLine<LastLine Then inc (GesLen, Length (TLine^[ActLine+1]^));

    LstLine:= Actline=LastLine;
    If (GesLen>=Konfig.Umbruch) or (LstLine) Then
    InsLines (ActLine, 1) Else RAMError:=0;

    If RAMError= 0 Then
    BEGIN
      If (GesLen>=Konfig.Umbruch) or (LstLine) or (Length (TLine^[ActLine+1]^)=0) Then
      StrCopy (tmp, TLine^[ActLine+1]^) Else
      insert  (tmp, TLine^[ActLine+1]^, 1);
      TLine^[ActLine]^[0]:= chr (Umbr);

      If (Start+WhereX>=Length (TLine^[ActLine]^)+2) Then
      BEGIN
        incLine;
        NewCurX:= Length (tmp)-(ActLineLen-(Start+WhereX));
        Start:= 0;
      END;

      If Modus=1 Then ShowText;
    END Else ErrorMsg ('Nicht gengend Speicherplatz zum Einfgen der Zeile', Okay);
  END;
END;



PROCEDURE BackDeleteLine;
VAR
  x  : Byte;
BEGIN
  If (ActLine<=1) or (ActLine > LastLine) or (Konfig.Umbruch<Length (TLine^[ActLine-1]^)) Then Exit;

  With FPos[FileNr] Do
  BEGIN
    NewCurX:= Length (TLine^[ActLine-1]^)+WinL;
    If NewCurX > WinR-1 Then BEGIN Start:= NewCurX-(WinR-10); NewCurX:= WinR-10 ; END;

    If Length (TLine^[ActLine]^) + Length (TLine^[ActLine-1]^) < Konfig.Umbruch Then
    BEGIN
      StrAdd (TLine^[ActLine-1]^, TLine^[ActLine]^);
      DelLines (ActLine+1, 1);
    END Else
    BEGIN
      x:= GetCutPos (TLine^[ActLine]^, Konfig.Umbruch-Length (TLine^[ActLine-1]^));
      StrAdd (TLine^[ActLine-1]^, Copy (TLine^[ActLine]^, 1, x));
      Delete (TLine^[ActLine]^, 1, x);
    END;
    IfEdit:= TRUE;
  END;
  DecLine;
  ShowText;
END;




PROCEDURE EntFDeleteLine (Modus : Byte);
VAR
  x      : Byte;
  CutLen : Byte;
BEGIN
  If (ActLine<1) or (ActLine>=LastLine) or (Konfig.Umbruch<Length (TLine^[ActLine]^)) Then Exit;
  If (Length (TLine^[ActLine]^) + Length (TLine^[ActLine+1]^) < Konfig.Umbruch) Then
  BEGIN
    StrAdd (TLine^[ActLine]^, TLine^[ActLine+1]^);
    DelLines (Actline+2, 1);
  END
  Else
  BEGIN
    CutLen:= Konfig.Umbruch-Length (TLine^[ActLine]^);
    If CutLen>1 Then dec (CutLen);
    x:= GetCutPos (TLine^[ActLine+1]^, CutLen);
    StrAdd (TLine^[ActLine]^, Copy (TLine^[ActLine+1]^, 1, x));
    Delete (TLine^[ActLine+1]^, 1, x);
  END;
  FPos[FileNr].IfEdit:= TRUE;
  If Modus=1 Then ShowText;
END; 




FUNCTION BlockSatz (ein : String) : String;
VAR
  x, y : Byte;
BEGIN
  If SignLen (ein) + LineSize DIV 4 > LineSize Then
  BEGIN
    y:= 1;
    While (SignLen (ein) < LineSize) and (y<>0) Do
    BEGIN
      x:= 1;
      y:= 0;
      While (x < SignLen (ein)) and (x<LineSize) Do
      BEGIN
        inc (x);
        If (SignLen (ein) < LineSize) and (ein[x]=#32) Then
        BEGIN Insert (' ', ein, x); inc (y); inc (x); END;
      END;
    END;
  END;
  BlockSatz:= Ein;
END;



PROCEDURE MakeNewFormat;
VAR
  OldActLine  : Word;
  ZielLine    : Word;
  OldLastLine : Word;

BEGIN
  LinksBund (0);
  FlatterSatz (0);
  ClearLin;
  OldActLine:= ActLine;
  CursorOff;

  If LineAn * LineEn=0 Then
  BEGIN ActLine:= 0;      ZielLine:= LastLine; END Else
  BEGIN ActLine:= LineAn; ZielLine:= LineEn;   END;

  RAMError:=0;
  While (ActLine<ZielLine) and (RAMError=0) and (ActLine<LastLine) Do
  BEGIN
    OldLastLine:= LastLine;
    inc (ActLine);
    FormatAnzeige (ActLine);

    If  (Length (TLine^[ActLine]^) > 0)
    and (GetCutPos (TLine^[ActLine]^, Konfig.Umbruch)>0) Then
    BEGIN
      If (SignLen (TLine^[ActLine]^) < Konfig.Umbruch) Then
      BEGIN
        If (Length (TLine^[ActLine+1]^) > 0) Then
        EntFDeleteLine (0);
      END
      Else
      BEGIN
        GotoXY (2, WhereY);
        ZeilenUmbruch (0);
      END;
    END;

    If OldLastLine < LastLine Then inc (ZielLine, LastLine-OldLastLine) Else
    If OldLastLine > LastLine Then inc (ZielLine, OldLastLine-LastLine);

  END;

  ActLine:= OldActLine;
  While ActLine>LastLine Do DecLine;
  GotoXY (2, FPos[FileNr].Line + (WinOk-1)); FPos[FileNr].NewCurX:= 2;
  SetTextScreen;
  CursorOn;
END;



PROCEDURE RechtsBund;
VAR
  x, a, e : Word;
  InStr   : String;
BEGIN
  ClearLin;
  FillChar (InStr, SizeOf (Instr), #32);
  If LineEn * LineAn=0 Then
  BEGIN a:=1; e:= LastLine; END Else BEGIN a:= LineAn; e:= LineEn; END;
  For x:= a to e Do
  BEGIN
    If (Length (TLine^[x]^) > 0) and (SignLen (TLine^[x]^)<Konfig.Umbruch-1) Then
    BEGIN
      InStr[0]:= chr (Konfig.Umbruch-1-SignLen (TLine^[x]^));
      insert (InStr, TLine^[x]^, 1);
    END;
    FormatAnzeige (x);
  END;
  SetTextScreen;
  FPos[FileNr].IfEdit:= TRUE;
END;



PROCEDURE LinksBund (Modus : Byte);
VAR
  x, a, e : Word;
  y       : Byte;
BEGIN
  ClearLin;
  If LineEn * LineAn=0 Then
  BEGIN a:=1; e:= LastLine; END Else BEGIN a:= LineAn; e:= LineEn; END;
  For x:= a to e Do
  BEGIN
    y:=1;
    While (y<Length (TLine^[x]^)) and (TLine^[x]^[y]=#32) Do inc (y);
    dec (y);
    delete (TLine^[x]^, 1, y);
    FormatAnzeige (x);
  END;
  If Modus = 1 Then SetTextScreen;
  FPos[FileNr].IfEdit:= TRUE;
END;



PROCEDURE Zentrieren;
VAR
  x, a, e : Word;
  InStr   : String;
BEGIN
  Linksbund (0);
  ClearLin;
  FillChar (InStr, SizeOf (Instr), #32);
  If LineEn * LineAn=0 Then
  BEGIN a:=1; e:= LastLine; END Else BEGIN a:= LineAn; e:= LineEn; END;
  For x:= a to e Do
  BEGIN
    If (Length (TLine^[x]^) > 0) and (SignLen (TLine^[x]^)<Konfig.Umbruch-1) Then
    BEGIN
      InStr[0]:= chr ((Konfig.Umbruch-1-SignLen (TLine^[x]^)) DIV 2);
      insert (Instr, TLine^[x]^, 1);
    END;
    FormatAnzeige (x);
  END;
  SetTextScreen;
  FPos[FileNr].IfEdit:= TRUE;
END;



PROCEDURE Einruecken;
VAR
  x, a, e : Word;
  s       : String;
BEGIN
  ClearLin;
  FillChar (s, SizeOf(s), #32);
  s[0]:= Char (Konfig.TabLen);
  If LineEn * LineAn=0 Then
  BEGIN a:=1; e:= LastLine; END Else BEGIN a:= LineAn; e:= LineEn; END;
  For x:= a to e Do
  BEGIN
    If  (Length (TLine^[x]^) <> 0)
    and (Length (TLine^[x]^)+Konfig.TabLen<= Konfig.Umbruch) Then
    insert (s, TLine^[x]^, 1);
    FormatAnzeige (x);
  END;
  SetTextScreen;
  FPos[FileNr].IfEdit:= TRUE;
END;



PROCEDURE Ausruecken;
VAR
  x, a, e : Word;
  s       : String;
BEGIN
  ClearLin;
  FillChar (s, SizeOf(s), #32);
  s[0]:= Char (Konfig.TabLen);
  If LineEn * LineAn=0 Then
  BEGIN a:=1; e:= LastLine; END Else BEGIN a:= LineAn; e:= LineEn; END;
  For x:= a to e Do
  BEGIN
    If (Length (TLine^[x]^)>0) and (pos (s, TLine^[x]^)<>0)  Then
    delete (TLine^[x]^, 1, Length (s));
    FormatAnzeige (x);
  END;
  SetTextScreen;
  FPos[FileNr].IfEdit:= TRUE;
END;


PROCEDURE MakeBlockSatz;
VAR
  x    : Word;
BEGIN
  ClearLin;
  LineSize:= Konfig.Umbruch-1;
  If LineAn * LineEn = 0 Then
  BEGIN
    For x:= 1 To LastLine Do
    BEGIN
      TLine^[x]^:= Blocksatz (TLine^[x]^);
      FormatAnzeige (x);
    END;
  END Else
  BEGIN
    For x:= LineAn To LineEn Do
    BEGIN
      TLine^[x]^:= Blocksatz (TLine^[x]^);
      FormatAnzeige (x);
    END;
  END;
  FPos[FileNr].IfEdit:= TRUE;
  SetTextScreen;
END;



PROCEDURE FlatterSatz (Modus : Byte);
VAR
  x : Word;
BEGIN
  ClearLin;
  If LineAn * LineEn = 0 Then
  BEGIN
    For x:= 1 To LastLine Do
    BEGIN
      While pos (#32#32, TLine^[x]^) <> 0 Do
      delete (TLine^[x]^, pos (#32#32, TLine^[x]^), 1);
      FormatAnzeige (x);
    END;
  END Else
  BEGIN
    For x:= LineAn To LineEn Do
    BEGIN
      While pos (#32#32, TLine^[x]^) <> 0 Do
      delete (TLine^[x]^, pos (#32#32, TLine^[x]^), 1);
      FormatAnzeige (x);
    END;
  END;
  FPos[FileNr].IfEdit:= TRUE;
  SetTextScreen;
END;

FUNCTION UpLowChar (InChar : Char; IsUpp : Boolean) : Char;
BEGIN
  If IsUpp Then
  UpLowChar:= UpChar (InChar) Else UpLowChar:= LowChar (InChar);
END;


PROCEDURE UpLowCaseBlock (IsUpp : Boolean);
VAR
  x, y : Word;
BEGIN
  If LineAn*LineEn=0 Then Exit;
  If LineAn=LineEn Then
  For x:= SignAn To SignEn Do
  TLine^[LineAn]^[x]:= UpLowChar (TLine^[LineAn]^[x], IsUpp) Else
  For x:= LineAn To LineEn Do
  BEGIN
    If x=LineAn Then For y:= SignAn To Length (TLine^[x]^) Do
    TLine^[x]^[y]:= UpLowChar (TLine^[x]^[y], IsUpp) Else
    If x=LineEn Then For y:= 1 To SignEn Do
    TLine^[x]^[y]:= UpLowChar (TLine^[x]^[y], IsUpp) Else
    For y:= 1 To Length (TLine^[x]^) Do
    TLine^[x]^[y]:= UpLowChar (TLine^[x]^[y], IsUpp);
  END;
  FPos[FileNr].IfEdit:= TRUE;
  ShowText;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
