UNIT Ed_Help;

INTERFACE

USES
  bioscrt, ed_unit, Monitor, ed_var, keycode, strings,
  mouse, menue, ed_File;



PROCEDURE Interne_Hilfe (HelpFile : String; Link : String);
PROCEDURE Syntax_Hilfe (HelpFile : String);
PROCEDURE Hilfe;



IMPLEMENTATION



PROCEDURE Interne_Hilfe (HelpFile : String; Link : String);
CONST
  MaxLink = 20;
  MaxHist = 100;
  vor     = 1;
  bac     = 2;

VAR
  FLine       : String;
  HelpError   : Byte;
  LinkPtr     : Byte;
  LastLink    : Byte;
  LinkList    : Array[1..MaxLink] Of RECORD xa, xe, yy : Byte; END;
  LineNr      : Word;

  HistList    : array[1..MaxHist] Of Word;
  HistPtr     : Byte;
  SeekLineNum : Word;

LABEL
  Ende;




FUNCTION GetHeadLine (ein : String) : String;
BEGIN
  delete (ein, 1, pos (#4, ein));
  GetHeadLine:= copy (ein, 1, pos (#4, ein)-1);
END;



PROCEDURE WriteHelpLine (Line : String; y : Byte);
VAR
  Link : Boolean;
  i, x : Byte;
BEGIN
  CharXY (1, y, #32, 7, 7);
  Link:=FALSE; i:= WinL-1;
  For x:= 1 To Length (Line) Do
  If Line[x]=#4 Then
  BEGIN
    If LastLink<MaxLink Then
    If not Link Then
    BEGIN
      If Konfig.Blind Then BEGIN inc (i); CharXY (i, y, '[', 0, 7); END;
      inc (LastLink); LinkList[LastLink].xa:= i+1; LinkList[LastLink].yy:=y;
    END Else
    BEGIN
      LinkList[LastLink].xe:= i+1;
      If Konfig.Blind Then BEGIN inc (i); CharXY (i, y, ']', 0, 7); END;
    END;
    Link:= not Link;
  END
  Else
  BEGIN
    inc (i);
    If Link Then
    CharXY (i, y, Line[x], yellow, cyan) Else CharXY (i, y, Line[x], 0, 7);
  END;
  For x:= i+1 To WinR Do CharXY (x, y, #32, 0, 7);
END;



PROCEDURE GotoLinkField (Modus : Byte);
BEGIN
  If LastLink=0 Then Exit;
  With LinkList[LinkPtr] Do
  ChangeBackColor (xa, yy, xe-xa, cyan);
  CASE Modus Of
    vor : If LinkPtr<LastLink Then inc (LinkPtr) Else LinkPtr:= 1;
    bac : If LinkPtr>1 Then dec (LinkPtr) Else LinkPtr:= LastLink;
  END;
  With LinkList[LinkPtr] Do
  BEGIN
    ChangeBackColor (xa, yy, xe-xa, magenta);
    GotoXY (xa, yy);
  END;
END;



FUNCTION DelDoubleSpace (ein : String) : String;
BEGIN
  ein:= Trim (ein);
  While pos ('  ', ein) <> 0 Do delete (ein, pos ('  ', ein), 1);
  If pos ('...', ein)=Length (ein)-2 Then dec (ein[0], 3);
  DelDoubleSpace:= ein;
END;


PROCEDURE ShowHelp (LinkStr : String; LineNum : Word);
VAR
  x, i : Byte;
  LNr  : Word;

LABEL
  Ende;

BEGIN
  LinkStr:= #6#4+UpStr (deldoublespace(LinkStr))+#4;

  ResetFile (ProgPath+HelpFile);
  If IOResult<>0 Then
  BEGIN ErrorMsg ('Hilfedatei '+HelpFile+' nicht gefunden', Okay); HelpError:= 1; Exit; END;
  LNr:= 0;
  REPEAT
    ReadSPCLn (FLine);
    If IOResult<>0 Then
    BEGIN ErrorMsg ('Lesefehler in Hilfedatei', Okay); Close (f); If IOResult<>0 Then; HelpError:= 1; Goto Ende; END;
    If (FLine[0]<>#0) and (FLine[1]=#6) Then inc (LNr);
  UNTIL
     (EOfInFile) or
    ((LineNum =0) and (pos (LinkStr, UpStr (FLine))=1)) or
    ((LineNum<>0) and (LNr>= LineNum));

  If LNr<>0 Then LineNr:= LNr;

  If EofInFile Then
  BEGIN ErrorMsg ('Hilfetext nicht gefunden', Okay); HelpError:= 2; Goto Ende; END;

  WriteHelpLine ('', WinOK); 
  WriteHelpLine (GetHeadLine (FLine), WinOK+1); i:=0; LastLink:=0;

  For x:= WinOK+2 To WinUK Do
  BEGIN
    If not EofInFile Then ReadSPCLn (FLine) Else i:= 1;
    dec (FLine[0], 2);
    If IOResult<>0 Then
    BEGIN ErrorMsg ('Lesefehler in Hilfedatei', Okay); HelpError:= 1; Goto Ende; END;
    If (Fline[0]<>#0) and (FLine[1]=#6) Then i:= 1;
    If i = 0 Then
    WriteHelpLine (FLine, x) Else WriteHelpLine ('', x);
  END;

  HelpError:= 0;
Ende:
  CloseInFile; If IOResult<>0 Then;
END;


LABEL
  Tabu;
{---------------------------- HauptProzedur -------------------------------}

BEGIN
  ClearLine (WinOk-1, MenCol.WinB);
  WriteXY (2, WinOk-1, 'HILFE', yellow, MenCol.WinB);
  ClearLine (25, MenCol.WinB);
  WriteXY
  (2, 25, 'Blttern=BILD-'#24#25'  Blinden-Cursor='#24#25'  Verweis whlen=TAB/'#26'/'#27+
  ' + ENTER   Ende=Esc', MenCol.KeyT, MenCol.WinB);

  If Link = '' Then SeekLineNum:= 1 Else SeekLineNum:=0;
  HistPtr:=0; t1:=#1;

  REPEAT
    ShowHelp (Link, SeekLineNum); If HelpError<>0 Then Goto Ende;
    If (t1<>Back) and (HistPtr<MaxHist) Then BEGIN inc (HistPtr); HistList[HistPtr]:= LineNr; END;
    LinkPtr:=1; SeekLineNum:= 0;
    GotoLinkField (0);
    If Konfig.Blind Then GotoXY (1, 4);
    REPEAT
      Scankeys;
      If t1<>#0 Then
      CASE t1 Of
        #13  : With LinkList[LinkPtr] Do Link:= GetScreenLine (xa, xe, yy);
        Back : If HistPtr>1 Then
               BEGIN dec (HistPtr); SeekLineNum:= HistList[HistPtr]; END Else
               SeekLineNum:=1;
        TAB  : Goto Tabu;
      END Else
      CASE t2 Of
        Right      : Tabu: GotoLinkField (vor);
        Left       : GotoLinkField (bac);
        Down       : If WhereY<24 Then GotoXY (1, WhereY+1);
        Up         : If WhereY>4  Then GotoXY (1, WhereY-1);
        Ctrl_PgUp  : GotoXY (1, 4);
        PgDn       : BEGIN inc (LineNr); SeekLineNum:= LineNr; END;
        PgUp       : BEGIN If LineNr>1 Then dec (LineNr); SeekLineNum:= LineNr; END;
        Pos1       : BEGIN LineNr:=1; SeekLineNum:=1; END;
      END;
    UNTIL (t1=#27) or (t1=#13) or (t1=Back) or (t2=PgUp) or (t2=PgDn) or (t2=Pos1);
  UNTIL (t1=#27);

Ende:
  t1:= #0; t2:=#0;
  HeadLine;
  ViewMode:= ShowMen;
  MouseBottomLine;
  ShowText;
END;



FUNCTION CutSignFound (c : Char) : Boolean; assembler;
ASM
  mov al, 1
  mov bl, c
  cmp bl, 32;  je @ende;
(*cmp bl, '@'; je @ende;
  cmp bl, '!'; je @ende;
  cmp bl, '#'; je @ende;
  cmp bl, '%'; je @ende; *)

  cmp bl, ')'; je @ende;
  cmp bl, '('; je @ende;
  cmp bl, '['; je @ende;
  cmp bl, ']'; je @ende;
  cmp bl, ';'; je @ende;
  cmp bl, ','; je @ende;

  cmp bl, '+'; je @ende;
  cmp bl, '-'; je @ende;
  cmp bl, '*'; je @ende;
  cmp bl, '/'; je @ende;

  cmp bl, '='; je @ende;
  cmp bl, ':'; je @ende;
  cmp bl, '<'; je @ende;
  cmp bl, '>'; je @ende;
  cmp bl, '.'; je @ende;
  cmp bl, TAB; je @ende;

  xor al, al
  @ende:
END;


PROCEDURE Syntax_Hilfe (HelpFile : String);
VAR
  x : Byte;
BEGIN
  StrCopy (TLine^[Actline]^, DOSHelpLine);
  x:= WhereX+FPos[FileNr].Start-1;
  While (x>0) and (not CutSignFound (DOSHelpLine[x])) do dec (x);
  delete (DOSHelpLine, 1, x);
  x:= 1;
  While (x<Length (DOSHelpLine)) and (not CutSignFound (DOSHelpLine[x])) do inc (x);
  If x<Length (DOSHelpLine) Then dec (x);
  DOSHelpLine[0]:= chr (x);
  If HelpFile<>'' Then Interne_Hilfe (HelpFile, DOSHelpLine);
END;




PROCEDURE Hilfe;
BEGIN
  DosStr (#13#10+
  'ED 2.0  '+Copyright+#13#10+
  'ASCII-Text-, Binr- und HTML-Editor'#13#10#13#10+
  'ED [Dateiname(n)] [/B /H /L:xxx]'#13#10#13#10+
  '/B      ffnet eine Datei binr'#13#10+
  '/L:xxx  xxx = Zeilenlnge (20-250)'#13#10+
  '/H      startet ED als HTML-Editor'#13#10);
  Halt;
END;



END.


{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
