UNIT Ed_HTML;


INTERFACE
USES
  Menue, dialogs, ed_Var, bioscrt, keyCode, Monitor, 
  strings, time, dos, ed_unit, ed_form, ed_Suche;


PROCEDURE StyleMen;
PROCEDURE ParagraphMen;
PROCEDURE ElementMen;
PROCEDURE ListenMenue;
PROCEDURE FormMen;
PROCEDURE TableMen;
PROCEDURE SonderMen;

PROCEDURE InsertTags;


IMPLEMENTATION

VAR
  Instr1, InStr2 : String;


FUNCTION GetRelPath (s1, s2 : String) : String;
VAR
  s3   : String;
  x, y : Byte;
BEGIN
  x:= LastPos ('\', s1);
  If copy (s1, 1, x) = copy (s2, 1, x) Then
  BEGIN
    s3:= copy (s2, x+1, 255);
  END Else
  BEGIN
    x:= LastPos ('\', s2);
    If copy (s2, 1, x) = copy (s1, 1, x) Then
    BEGIN
      s3:= '';
      For y:= x+1 To Length (s1) Do If s1[y]='\' Then StrAdd (s3, '../');
      StrAdd (s3, copy (s2, x+1, 255));
    END Else
    If copy (s1, 1, Pos ('\', s1)) <> copy (s2, 1, Pos ('\', s2)) Then s3:=s2 Else
    BEGIN
      x:= 1; y:=1;
      While (x<Length(s1)) and (x<Length(s2)) and (s1[x]=s2[x]) Do
      BEGIN inc (x); If (s1[x]='\') and (s2[x]='\') Then y:= x; END;
      x:= y+1;
      s3:= '';
      For y:= x To Length (s1) Do If s1[y]='\' Then StrAdd (s3, '../');
      StrAdd (s3, copy (s2, x, 255));
    END;
  END;
  For x:= 1 To Length (s3) Do If s3[x]='\' Then s3[x]:='/';
  GetRelPath:= s3;
END;
(*s1=Pfad des aktuellen Dokumentes - s2=Pfad des Verweises (Link, Image*)


PROCEDURE StyleMen;
BEGIN
  MenWin  (3, 5, 25, 23, 'Textstil');
  MenLine ('~F~ett',                   '',  #254,  #14);
  MenLine ('~K~ursiv',                 '',  #254,  #15);
  MenLine ('~U~nterstrichen',          '',  #254,  #16);
  MenLine ('~D~urchgestrichen',        '',  #254,  #17); EmptyMenline;
  MenLine ('~G~rer',                 '',  #254,  #18);
  MenLine ('K~l~einer',                '',  #254,  #19);
  MenLine ('~T~iefgestellt',           '',  #254,  #20);
  MenLine ('~H~ochgestellt',           '',  #254,  #21); EmptyMenline;
  MenLine ('T~e~letyper',              '',  #254,  #22);
  MenLine ('~B~linkend',               '',  #254,  #23); EmptyMenline;
  MenLine ('Schrift-~G~re',          '',  #254,  #24);
  MenLine ('Schrift-F~a~rbe',          '',  #254,  #25);
  MenLine ('Schrift-A~r~t',            '',  #254,  #30);

  Helplines^  [1]:= 'Fettschrift  <B>';
  Helplines^  [2]:= 'Kursivschrift  <I>';
  Helplines^  [3]:= 'Unterstrichene Schrift  <U>';
  Helplines^  [4]:= 'Durchgestrichener Text  <STRIKE>';
  Helplines^  [6]:= 'Text wird vergrert  <BIG>';
  Helplines^  [7]:= 'Text wird verkleinert  <SMALL>';
  Helplines^  [8]:= 'Text wird tiefgestellt  <SUB>';
  Helplines^  [9]:= 'Text wird hochgestellt  <SUP>';
  Helplines^ [11]:= 'Teletyper-Schrift (dicktengleiche Schrift)  <TT>';
  Helplines^ [12]:= 'Blinkende Schrift  <BLINK>';
  Helplines^ [14]:= 'Erzeugt ein Feld zur Angabe der Schriftgre  <FONT SIZE= >';
  Helplines^ [15]:= 'Erzeugt ein Feld zur Angabe der Schriftfarbe  <FONT COLOR= >';
  Helplines^ [16]:= 'Erzeugt ein Feld zur Angabe der Schriftart  <FONT FACE= >';
END;



PROCEDURE ParagraphMen;
VAR
  x : Byte;
BEGIN
  MenWin  (3, 4, 23, 22, 'Paragraphen');
  MenLine ('~Z~itat',                  '',  #254,  #0);
  MenLine ('~P~re-Formatiert',         '',  #254,  #1);
  MenLine ('~A~dresse',                '',  #254,  #2);
  MenLine ('~N~euer Absatz',           '',  #254,  #3); EmptyMenline;
  MenLine ('~L~inksbndig',            '',  #254,  #4);
  MenLine ('Z~e~ntriert',              '',  #254,  #5);
  MenLine ('~R~echtsbndig',           '',  #254,  #6);
  MenLine ('~F~lush',                  '',  #254,  #7); EmptyMenline;
  MenLine ('Head ~1~',                 '',  #254,  #8);
  MenLine ('Head ~2~',                 '',  #254,  #9);
  MenLine ('Head ~3~',                 '',  #254,  #10);
  MenLine ('Head ~4~',                 '',  #254,  #11);
  MenLine ('Head ~5~',                 '',  #254,  #12);
  MenLine ('Head ~6~',                 '',  #254,  #13);

  Helplines^ [1]:= 'Kennzeichnet ein Zitat (i.d.R. eingerckt und kursiv)  <BLOCKQUOTE>';
  Helplines^ [2]:= 'Schreibmaschinenschrift (Teletyper)  <PRE>';
  Helplines^ [3]:= 'Kennzeichnet eine Adresse (i.d.R. eingerckt und kursiv)  <ADDRESS>';
  Helplines^ [4]:= 'Text wird als Absatz geklammert  <P>';

  Helplines^ [6]:= 'Richtet Element linksbndig aus  ALIGN=Left';
  Helplines^ [7]:= 'Richtet Element in der Bildmitte aus  ALIGN=Center';
  Helplines^ [8]:= 'Richtet Element rechtsbndig aus  ALIGN=Right';
  Helplines^ [9]:= 'Blocksatz';

  For x:= 11 To 16 Do
  Helplines^ [x]:= 'Schriftgre  <H1> gro ... <H6> klein';
END;



PROCEDURE ElementMen;
TYPE
  taw = Array[1..5000] Of Word;
  tac = Array[1..10000] Of Char;
VAR
  tt1    : Char;
  aw     : ^taw;
  ac     : ^tac;
  g, x   : Word;
  i      : File;
  he, wi : String[6];

LABEL
  Ready;
BEGIN
  MenWin  (18, 5, 38, 20, 'Elemente');
  MenLine ('HT~M~L-Tag',               '',  #254,  #26);
  MenLine ('~H~eader',                 '',  #254,  #27);
  MenLine ('~T~itel',                  '',  #254,  #28); 
  MenLine ('~B~ody',                   '',  #254,  #29); EmptyMenline;
  MenLine ('T~r~ennlinie',             '',  #254,  #31);
  MenLine ('~Z~eilenumbruch',          '',  #254,  #32); EmptyMenline;
  MenLine ('~L~ink...',                '',  #254,  #33); 
  MenLine ('~A~nker...',               '',  #254,  #34); EmptyMenline;
  MenLine ('~I~mage...',               '',  #254,  #35); 
  MenLine ('~e~Mail...',               '',  #254,  #36);

  Helplines^  [1]:= 'HTML-Klammer  <HTML>';
  Helplines^  [2]:= 'Head-Klammer  <HEAD>';
  Helplines^  [3]:= 'Titel-Klammer  <TITLE>';
  Helplines^  [4]:= 'Body-Klammer  <BODY>';
  Helplines^  [6]:= 'Waagerechte Trennlinie  <HR>';
  Helplines^  [7]:= 'Harter Zeilenumbruch  <BR>';
  Helplines^  [9]:= 'Link (Verweis) zu einer anderen Datei (#Anker optional) <A HREF="...">';
  Helplines^ [10]:= 'Anker setzen <A>';
  Helplines^ [12]:= 'Grafik einbinden <IMG SRC="...">';
  Helplines^ [13]:= 'eMail-Adresse einbinden  <A HREF="Mailto:...">';

  InStr1:= '';
  If (ViewMode= GetEv) and (t1=#254) Then
  BEGIN
  tt1:= t2;
  CASE t2 Of
    #33 : BEGIN
            ReadLine (InStr1, 'Link zu Datei...#Anker...', 9, 2);
            If t1<>#27 Then
            BEGIN
              InStr1:= GetRelPath (FexPand (FPos[FileNr].FName), FexPand (UpStr (InStr1)));
              Instr1:= '<A HREF="'+LowStr(Instr1)+'">'
            END Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #34 : BEGIN
            ReadLine (InStr1, 'Setze Anker...', 0, 0);
            If t1<>#27 Then Instr1:= '<A NAME="'+LowStr(Instr1)+'">' Else
            BEGIN InStr1:= '';  ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #35 : BEGIN
            ReadLine (InStr1, 'Einbinden von Grafikdatei...', 10, 2);
            If t1<>#27 Then
            BEGIN
              InStr1:= GetRelPath (FexPand (FPos[FileNr].FName), FexPand (UpStr (InStr1)));
              If MaxAvail>SizeOf (taw) Then
              GetMem (aw, SizeOf (taw)) Else aw:= NIL;
              ac:=addr(aw^);
              Assign (i, Instr1); FileMode:= 0;
              Reset (i, 1);
              BlockRead (i, aw^, SizeOf (taw), g);
              Close (i); wi:='';
              If IOResult<>0 Then
              ErrorMsg ('Grafik-Datei nicht gefunden.', Okay) Else
              BEGIN
                If UpStr (copy (InStr1, Length(Instr1)-3, 4)) = '.GIF' Then
                BEGIN Str (aw^[4], wi); Str (aw^[5], he); END
                Else
                If UpStr (copy (InStr1, Length(Instr1)-3, 4)) = '.JPG' Then
                BEGIN
                  For x:= 1 To g Do
                  If (ac^[x]='a') and (ac^[x+1]='c') and (ac^[x+2]='s') and (ac^[x+3]='p') Then
                  BEGIN
                    For x:= x To g-1 Do
                    If (ac^[x]=#255) and (ac^[x+1]=#192) Then
                    BEGIN
                      Str (ord (ac^[x+5]) * 256 + ord (ac^[x+6]), he);
                      Str (ord (ac^[x+7]) * 256 + ord (ac^[x+8]), wi);
                      Goto Ready;
                    END;
                  END;
                  Ready:
                END
                Else ErrorMsg ('Es sind nur GIF- oder JPG-Grafiken erlaubt.', Okay);
              END;
              Instr1:= '<IMG SRC="'+LowStr(Instr1)+'" ALT="" BORDER="0"';
              If wi<>'' Then
              StrAdd (Instr1, ' WIDTH="'+wi+'" HEIGHT="'+he+'">') Else
              CharAdd (Instr1, '>');
              Freemem (aw, SizeOf (taw));
            END Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #36 : BEGIN
            ReadLine (InStr1, 'Link zu eMail...', 9, 0);
            If t1<>#27 Then Instr1:= '<A HREF="mailto:'+Instr1+'">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
  END;
  t2:= tt1;
  t1:= #254;
  For g:= 1 To Length (Instr1) Do If Instr1[g]='\' Then Instr1[g]:= '/';
  END;
END;



PROCEDURE ListenMenue;
BEGIN
  MenWin  (23, 5, 55, 17, 'Liste...');
  MenLine ('nummeriert  ~A~, B, C...',     '',  #254,  #37);
  MenLine ('nummeriert  a, ~b~, c...',     '',  #254,  #38);
  MenLine ('nummeriert  ~I~, II, III...',  '',  #254,  #39);
  MenLine ('nummeriert  ~1~, 2, 3...',     '',  #254,  #40); EmptyMenline;

  MenLine ('~R~undes Vorzeichen',          '',  #254,  #41);
  MenLine ('~E~ckiges Vorzeichen',         '',  #254,  #42);
  MenLine ('~D~ateisymbol-Vorzeichen',     '',  #254,  #43); EmptyMenline;

  MenLine ('~L~istenelement',              '',  #254,  #44);

  Helplines^ [1]:= 'Listen-Klammer: Nummerierung von A-Z  <OL TYPE="A">';
  Helplines^ [2]:= 'Listen-Klammer: Nummerierung von a-z  <OL TYPE="a">';
  Helplines^ [3]:= 'Listen-Klammer: Nummerierung mit rmischen Zahlen  <OL TYPE="I">';
  Helplines^ [4]:= 'Listen-Klammer: Nummerierung mit normalen Zahlen  <OL START=1>';

  Helplines^ [6]:= 'Bullet-Liste mit rundem Vorzeichen  <UL TYPE=circle>';
  Helplines^ [7]:= 'Bullet-Liste mit eckigem Vorzeichen  <UL TYPE=square>';
  Helplines^ [8]:= 'Bullet-Liste mit Dateisymbol als Vorzeichen  <UL TYPE=disk>';
  Helplines^[10]:= 'Listen-Element (markierte Zeile) klammern  <LI>';
END;



PROCEDURE FormMen;
VAR
  tt1 : Char;
BEGIN
  MenWin  (30, 4, 52, 22, 'Formular');
  MenLine ('~N~eues Formular',         '',  #254,  #45); Emptymenline;
  MenLine ('~R~adio-Button',           '',  #254,  #46);
  MenLine ('~C~heck-Box',              '',  #254,  #47);
  MenLine ('~A~bbruch-Button',         '',  #254,  #48);
  MenLine ('~S~enden-Button',          '',  #254,  #49);
  MenLine ('~F~reier Button',          '',  #254,  #50); Emptymenline;
  MenLine ('~E~ingabezeile',           '',  #254,  #51);
  MenLine ('~T~extfeld',               '',  #254,  #52); EmptyMenline;
  MenLine ('neue Options~l~iste',      '',  #254,  #53);
  MenLine ('~O~ption',                 '',  #254,  #54); EmptyMenline;
  MenLine ('~P~awortabfrage',         '',  #254,  #55);
  MenLine ('~U~nsichtbares Feld',      '',  #254,  #56);

  Helplines^ [1]:= 'Erstellt eine neue Formular-Klammer  <FORM>';
  Helplines^ [3]:= 'runder Radio-Button  <INPUT TYPE=radio...>';
  Helplines^ [4]:= 'eckige Checkbox  <INPUT TYPE=checkbox...>';
  Helplines^ [5]:= 'Abbruch-Button (Reset)  <INPUT TYPE=reset...>';
  Helplines^ [6]:= 'Absenden-Button (Submit)  <INPUT TYPE=submit...>';
  Helplines^ [7]:= 'frei definierbarer Button  <INPUT TYPE=button...>';
  Helplines^ [9]:= 'einzeiligen Text-Eingabefeld  <INPUT TYPE=text...>';
  Helplines^ [10]:= 'mehrzeiliges Texteingabe-Fenster  <TEXTAREA>';
  Helplines^ [12]:= 'Erstellt eine Klammer fr ein Optionsfenster  <SELECT>';
  Helplines^ [13]:= 'Kennzeichnet eine Option im Optionsfenster <OPTION>';
  Helplines^ [15]:= 'Einzeiliges Text-Feld fr verdeckte Eingaben <INPUT TYPE=passwort...>';
  Helplines^ [16]:= 'Unsichtbares Feld fr Infos, die mitgesendet werden sollen.';

  InStr1:= '';
  If (ViewMode= GetEv) and (t1=#254) Then
  BEGIN
  tt1:= t2;
  CASE t2 Of
    #45 : BEGIN
            ReadLine (InStr1, 'Auszufhrende Aktion (mailto: ect.)', 0, 0);
            If t1<>#27 Then Instr1:= '<FORM ACTION="'+Instr1+'" METHOD=post ENCTYPE="text/plain">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #46 : BEGIN
            ReadLine (InStr1, 'Abzusendender Wert des Buttons', 0, 0);
            If t1<>#27 Then Instr1:= '<INPUT TYPE="radio" NAME="radio" VALUE="'+InStr1+'">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #47 : BEGIN
            ReadLine (InStr1, 'Abzusendender Wert der Checkbox', 0, 0);
            If t1<>#27 Then Instr1:= '<INPUT TYPE="checkbox" NAME="checkbox" VALUE="'+InStr1+'">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #50 : BEGIN
            ReadLine (InStr1, 'Button-Beschriftung', 0, 0);
            If t1<>#27 Then Instr1:= '<INPUT TYPE="button" VALUE="'+Instr1+'" ONCLICK="">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #51 : BEGIN
            ReadLine (InStr1, 'Name der Eingabezeile', 0, 0);
            If t1<>#27 Then Instr1:= '<INPUT TYPE="text" NAME="'+Instr1+'" VALUE="" SIZE=40 MAXLENGTH=60>' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #52 : BEGIN
            ReadLine (InStr1, 'Name des Textfeldes', 0, 0);
            If t1<>#27 Then Instr1:= '<TEXTAREA NAME="'+Instr1+'" ROWS=10 COLS=50 WRAP=virtual>' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #53 : BEGIN
            ReadLine (InStr1, 'Name der Optionsliste', 0, 0);
            If t1<>#27 Then Instr1:= '<SELECT NAME="'+Instr1+'" SIZE=5>' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
    #56 : BEGIN
            ReadLine (InStr1, 'Name des unsichtbaren Feldes', 0, 0);
            If t1<>#27 Then Instr1:= '<INPUT TYPE="hidden" NAME="'+Instr1+'" VALUE="">' Else
            BEGIN InStr1:= ''; ViewMode:= OpenNew; EventOK:= FALSE; END;
          END;
  END;
  t2:= tt1;
  t1:= #254;
  END;
END;


PROCEDURE TableMen;
BEGIN
  MenWin  (30, 5, 52, 13, 'Tabelle');
  MenLine ('~N~eue Tabelle',           '',  #254,  #57); Emptymenline;
  MenLine ('Neue ~Z~eile',             '',  #254,  #58); Emptymenline;
  MenLine ('~K~opfzelle',              '',  #254,  #59);
  MenLine ('normale Ze~l~le',          '',  #254,  #60); Emptymenline;

  Helplines^ [1]:= 'Erstellt eine neue Tabellen-Klammer  <TABLE>';
  Helplines^ [3]:= 'Erstellt eine neue Zeilen-Klammer in der Tabelle  <TR>';
  Helplines^ [5]:= 'Erstellt eine neue Kopfzellen-Klammer in der Zeile  <TH>';
  Helplines^ [6]:= 'Erstellt eine neue Zellen-Klammer in der Zeile  <TH>';
END;


PROCEDURE SonderMen;
BEGIN
  MenWin  (30, 5, 55, 12, 'Sonderzeichen');
  MenLine ('~L~eerzeichen',                  '',  #254,  #61); 
  MenLine ('~G~rerzeichen      >',         '',  #254,  #62);
  MenLine ('~K~leinerzeichen     <',         '',  #254,  #63);
  MenLine ('~A~nfhrungsstriche  "',         '',  #254,  #64); 
  MenLine ('~U~nd-Zeichen        &',         '',  #254,  #65); 

  Helplines^ [1]:= 'Erzeugt den HTML-Code fr ein "hartes" Leerzeichen';
  Helplines^ [2]:= 'Erzeugt den HTML-Code fr ein Grerzeichen';
  Helplines^ [3]:= 'Erzeugt den HTML-Code fr ein Kleinerzeichen';
  Helplines^ [4]:= 'Erzeugt den HTML-Code fr Anfhrungsstriche';
  Helplines^ [5]:= 'Erzeugt den HTML-Code fr das &-Zeichen';
END;


PROCEDURE GetPair;
VAR
  c : Char;
BEGIN
  Pair1:= ''; Pair2:= '';
  If t1<>#254 Then Exit;
  CASE t2 Of
    #0  : BEGIN Pair1:= '<BLOCKQUOTE>'; Pair2:= '</BLOCKQUOTE>'; END;
    #1  : BEGIN Pair1:= '<PRE>';        Pair2:= '</PRE>';        END;
    #2  : BEGIN Pair1:= '<ADDRESS>';    Pair2:= '</ADDRESS>';    END;
    #3  : BEGIN Pair1:= '<P>';          Pair2:= '</P>';          END;
    #4  :       Pair1:= ' ALIGN=Left';
    #5  :       Pair1:= ' ALIGN=Center';
    #6  :       Pair1:= ' ALIGN=Right';
    #7  :       Pair1:= ' ALIGN=Justify';
    #8..#13 :   BEGIN c:= t2; inc (c, 41); pair1:= '<H'+c+'>'; pair2:= '</H'+c+'>'; END;
    #14 : BEGIN Pair1:= '<B>';               Pair2:= '</B>';           END;
    #15 : BEGIN Pair1:= '<I>';               Pair2:= '</I>';           END;
    #16 : BEGIN Pair1:= '<U>';               Pair2:= '</U>';           END;
    #17 : BEGIN Pair1:= '<STRIKE>';          Pair2:= '</STRIKE>';      END;
    #18 : BEGIN Pair1:= '<BIG>';             Pair2:= '</BIG>';         END;
    #19 : BEGIN Pair1:= '<SMALL>';           Pair2:= '</SMALL>';       END;
    #20 : BEGIN Pair1:= '<SUB>';             Pair2:= '</SUB>';         END;
    #21 : BEGIN Pair1:= '<SUP>';             Pair2:= '</SUP';          END;
    #22 : BEGIN Pair1:= '<TT>';              Pair2:= '</TT>';          END;
    #23 : BEGIN Pair1:= '<BLINK>';           Pair2:= '</BLINK>';       END;
    #24 : BEGIN Pair1:= '<FONT SIZE="">';    Pair2:= '</FONT>';        END;
    #25 : BEGIN Pair1:= '<FONT COLOR="">';   Pair2:= '</FONT>';        END;
    #26 : BEGIN Pair1:= '<HTML><! Created by ED 2.0 (c) A.Olejko>';
                                             Pair2:= '</HTML>';        END;
    #27 : BEGIN Pair1:= '<HEAD>';            Pair2:= '</HEAD>';        END;
    #28 : BEGIN Pair1:= '<TITLE>';           Pair2:= '</TITLE>';       END;
    #29 : BEGIN Pair1:= '<BODY BGCOLOR="white" TEXT="black" BACKGROUND="" LINK="blue" VLINK="purple">';
                                             Pair2:= '</BODY>';        END;
    #30 : BEGIN Pair1:= '<FONT FACE="">';    Pair2:= '</FONT>';        END;
    #31 :       Pair1:= '<HR>';
    #32 :       Pair1:= '<BR>';
    #33..#36 : BEGIN Pair1:= InStr1; If (t2<>#34) and (t2<>#35) Then Pair2:= '</A>';  END;
    #37 : BEGIN Pair1:= '<OL TYPE="A">';         Pair2:= '</OL>';      END;
    #38 : BEGIN Pair1:= '<OL TYPE="a">';         Pair2:= '</OL>';      END;
    #39 : BEGIN Pair1:= '<OL TYPE="I">';         Pair2:= '</OL>';      END;
    #40 : BEGIN Pair1:= '<OL START=1>';          Pair2:= '</OL>';      END;
    #41 : BEGIN Pair1:= '<UL TYPE=circle>';      Pair2:= '</UL>';      END;
    #42 : BEGIN Pair1:= '<UL TYPE=square>';      Pair2:= '</UL>';      END;
    #43 : BEGIN Pair1:= '<UL TYPE=disk>';        Pair2:= '</UL>';      END;
    #44 : BEGIN Pair1:= '<LI>';                  Pair2:= '</LI>';      END;
    #45 : BEGIN Pair1:= Instr1; If Instr1<>'' Then Pair2:= '</FORM>';    END;
    #46, #47, #50, #51, #56 : Pair1:= InStr1;
    #48 : Pair1:= '<INPUT TYPE=reset VALUE="Abbrechen">';
    #49 : Pair1:= '<INPUT TYPE=submit VALUE="Absenden.">';
    #52 : BEGIN Pair1:= Instr1; If Instr1<>'' Then Pair2:= '</TEXTAREA>'; END;
    #53 : BEGIN Pair1:= Instr1; If Instr1<>'' Then Pair2:= '</SELECT>';   END;
    #54 : Pair1:= '<OPTION>';
    #55 : Pair1:= '<INPUT TYPE=passwort NAME="passwort" VALUE="" SIZE=10 MAXLENGTH=10>';
    #57 : BEGIN Pair1:= '<TABLE BORDER="0" CELLSPACING="0" CELLPADDING="0">';
                                                    Pair2:= '</TABLE>';   END;
    #58 : BEGIN Pair1:= '<TR>';                     Pair2:= '</TR>';      END;
    #59 : BEGIN Pair1:= '<TH>';                     Pair2:= '</TH>';      END;
    #60 : BEGIN Pair1:= '<TD>';                     Pair2:= '</TD>';      END;

    #61 : Pair1:= '&nbsp;';
    #62 : Pair1:= '&gt;';
    #63 : Pair1:= '&lt;';
    #64 : Pair1:= '&quot;';
    #65 : Pair1:= '&amp;';
  END;
END;



PROCEDURE InsertStr (x, y : Word; Stri : String);
BEGIN
  If Length (TLine^[y]^) + Length (Stri) < MaxLen-20 Then
  Insert (Stri, TLine^[y]^, x) Else
  BEGIN
    InsertLine(1);
    If RAMError=0 Then Stradd (TLine^[y]^, Stri);
  END;
END;



PROCEDURE InsertTags;
BEGIN
  GetPair;
  If Pair1='' Then Exit;
  With FPos[FileNr] Do
  BEGIN
    While (Length(TLine^[ActLine]^) < Start+WhereX-1) and (Length(TLine^[ActLine]^)<MaxLen-1) Do
    CharAdd (TLine^[ActLine]^, ' ');
    If Pair2='' Then
    InsertStr (Start+WhereX-1, Actline, Pair1) Else
    If LineEn * LineAn=0 Then
    InsertStr (Start+WhereX-1, Actline, Pair1+Pair2) Else
    BEGIN
      If Pair2<>'' Then
      InsertStr (SignEn+1, LineEn, Pair2);
      InsertStr (SignAn, LineAn, Pair1);
      LineAn:= 0; LineEn:= 0;
    END;
    IfEdit:= TRUE;
  END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
