UNIT Ed_manag;

INTERFACE

USES
  bioscrt, dos, strings, keyCode, Menue, ed_var, ListWin,
  mouse, Monitor, ed_unit, editors, Time, ed_Help, disk;



PROCEDURE FileManager (VAR OutName : String; Title : String);


IMPLEMENTATION

VAR
  sr       : SearchRec;
  j        : Word;
  i        : Word;
  LWNum    : Byte;
  ActDir   : DirStr;
  OldDir   : DirStr;

  ActivObj : Byte;
  oym      : Byte;


CONST
  a = 3; b= 6; c= 46; d= 22; WinLen= d-b-3;


  MaxObj  = 2;

  FileWin = 1;
  DirWin  = 2;



FUNCTION FileNameOK (s : PathStr) : Boolean;
BEGIN
  CASE Konfig.Dateifilter Of
    1 :  FileNameOK:=  TRUE;
    2 :  FileNameOK:= (pos ('.EXE', s) = 0) and (pos ('.COM', s)= 0) and (pos ('.DLL', s) = 0) and (pos ('.OVL', s) = 0);
    3 :  FileNameOK:=  pos ('.RUN', s) <> 0;
    4 :  FileNameOK:=  pos ('.BAT', s) <> 0;
    5 :  FileNameOK:=  pos ('.ASM', s) <> 0;
    6 :  FileNameOK:=  pos ('.PAS', s) <> 0;
    7 :  FileNameOK:= (pos ('.C', s) <> 0) or (pos ('.CPP', s) <> 0) or (pos ('.H', s) <> 0);
    8 :  FileNameOK:=  pos ('.DEB', s) <> 0;
    9 :  FileNameOK:= (pos ('.TXT', s) <> 0) or (pos ('.DOC', s) <> 0);
    Else FileNameOK:=  TRUE;
  END;
END;



PROCEDURE Laufwerke;
VAR
  LW : Char;
BEGIN
  LWNum:= 0;
  For LW:= 'A' To 'Z' Do
  If (DriveList[ord(LW)-64] <> nodrive) and (i<MaxDirList) Then
  BEGIN
    inc (i); inc (LWNum);
    InsertInList (LW+':\', i)
  END;
END;



PROCEDURE ReadFiles (Dirs : Boolean);
VAR
  Subst : Boolean;
BEGIN
  Subst:= (DriveList[DosDriveNum(ActDir[1])] and SubstDrv<>0) and
          (Length (ActDir)=3);

  FindFirst ('*.*', anyFile, sr);
  While (DosError= 0) and (i<MaxDirList) Do
  BEGIN
    If  ((sr.attr and Directory <> 0) = Dirs) and (sr.name<>'.') and (sr.attr and VolumeID=0)
    and ((not Subst) or (sr.name<>'..'))Then
    If  (Dirs) or (FileNameOK (sr.Name)) Then
    BEGIN
      inc (i);
      If Dirs Then
      InsertInList (sr.name, i) Else InsertInList (LowStr (sr.name), i);
    END;
    FindNext (sr);
  END;
  If Dirs Then LaufWerke;
END;



PROCEDURE FileListWin;
BEGIN
  UniWin (a, b, a+20, d, ' Dateiauswahl');
  Window (a, b, a+20, d);
  ListWinInit;
  SetStartEndLine (j, i);
  SortList;
  CursorOff;
  ShowList;
END;



PROCEDURE DirListWin;
BEGIN
  UniWin (a+25, b, a+45, d, '  Verzeichniswechsel');
  Window (a+25, b, a+45, d);
  ListWinInit;
  SetStartEndLine (1, pred(j)-LWNum);
  SortList;
  SetStartEndLine (1, pred(j));
  CursorOff; 
  ShowList;
END;



PROCEDURE WriteLine (x, y : Byte; s : String; vc, hc, Len : Byte);
BEGIN
  CharXY (x, y, #32,  vc, hc); inc (x);
  WriteClrStr (x, y, s, Len-x, vc, hc);
END;



PROCEDURE Buttons;
VAR
  OldCol   : Byte;
BEGIN
  OldCol:=MenCol.WinB;
  MenCol.WinB:=7;
  Button (53,  9, '   ~D~ateinamen eingeben  ',       'D',  #0);
  Button (53, 11, '   ~V~erzeichnis whlen   ',       'V',  #0);
  Button (53, 18, '   ~Enter~ ffnen         ',       #13,  #0);
  Button (53, 20, '   ~Esc~   Abbrechen      ',       #27,  #0);
  Button (53, 22, '   ~F1~    Hilfe          ',       #0 ,  F1);
  MenCol.WinB:=OldCol;
END;



PROCEDURE CheckMouse;
BEGIN
  If ((ActivObj=FileWin) and (succ(i)-j=0))
  or ((ActivObj=DirWin)  and (j=0)) Then Exit;
  If (ym-7=BalkenY) and (Balkeny=oym) Then t1:= #13 Else
  If ym<= 7 Then t2:= Up   Else
  If ym>=22 Then t2:= Down Else
  While ym-7<>BalkenY Do
  If ym-7<BalkenY Then ScrollUp (1) Else
  BEGIN
    If ((ActivObj= DirWin) and (BalkenY<pred(j)))
    or ((ActivObj=FileWin) and (BalkenY<succ(i)-j)) Then ScrollDown (1)
    Else Exit;
  END;
END;


FUNCTION FChar : Char;
VAR
  s : String[1];
BEGIN
  s:= copy (GetListLine (ListIndex), 1, 1);
  FChar:= upchar(s[1]);
END;


PROCEDURE ScrollTo;
VAR
  ix : Word;
BEGIN
  If ActivObj=DirWin Then ix:= j Else ix:= i;
  If upchar(t1) > FChar Then
  While (ListIndex<ix) and (upchar(t1) > FChar) Do ScrollDown(1) Else
  If upchar(t1) < FChar Then
  While (ListIndex>0)  and (upchar(t1) < FChar) Do ScrollUp(1);
END;


PROCEDURE FileManager (VAR OutName : String; Title : String);
VAR
  FileName : PathStr;
LABEL
  Wechsel, Start;
BEGIN
  GetDir (0, OldDir); oym:= 255;
  Start:
  EditMouse:= TRUE;
  If HTMMode Then Window (1, 4, 80, 24) Else Window (1, 3, 80, 24);
  TextAttr:= 112; ClrScr; Window (1, 3, 80, 24);
  AssignList (DirList^, SizeOf (DirList^[1]), MaxDirList);
  ActivObj:= 1;
  ViewMode:= ShowMen;
  Buttons; 
  BottomLine ('Die Bedienung der Listenfenster erfolgt wie beim Norton-Commander');

  REPEAT
    GetDir (0, ActDir);
    WriteLine (3, 4, ActDir, 0, cyan, 77);

    i:= 0;
    ReadFiles (TRUE); 
    j:= succ (i);
    ReadFiles (FALSE); 

    CASE ActivObj Of
      DirWin  : BEGIN FileListWin; DelBalken; DirListWin;  END;
      FileWin : BEGIN DirListWin;  DelBalken; FileListWin; END;
    END;
    If ActivObj=FileWin Then WriteLine (54, 7, GetListLine (ListIndex), 0, cyan, 77);

    REPEAT
      MouseOn;
      REPEAT MouseGet UNTIL (keypressed) or (kn<>0);
      MouseOff;
      t1:=#0; t2:=#0;
      If KeyPressed Then ScanKeys Else
      BEGIN
        ViewMode:= GetEv;
        Buttons;
        If (ym>=6) and (ym<=23) and (t1=#0) and (t2=#0) Then
        BEGIN
          If (xm<26) Then
          BEGIN If ActivObj=DirWin  Then Goto Wechsel; CheckMouse; END Else
          If (xm<52) Then
          BEGIN If ActivObj=FileWin Then Goto Wechsel; CheckMouse; END;
        END;
        ViewMode:= ShowMen;
      END;
      If (xm>52) and (kn<>0) or ((t2<>Up) and (t2<>Down)) Then
      While kn<>0 Do MouseGet Else If kn=1 Then xDelay (70);

      If t1<>#0 Then
      BEGIN
      If (Keystatus and (LShift or RShift) <> 0) and (t1>#32) Then
      ScrollTo Else
      CASE UpCase(t1) Of
        #13 : BEGIN
                If ActivObj=DirWin Then
                BEGIN
                  ChDir (GetListLine (ListIndex));
                  If IOResult<>0 Then
                  BEGIN ErrorMsg ('Laufwerk nicht bereit', Okay); CursorOff; ChDir (ActDir); END;
                  GetDir (0, ActDir);
                END Else
                BEGIN
                  t1:=#1; StrCopy (GetListLine (ListIndex), FileName);
                END;
              END;
        TAB : BEGIN
                Wechsel: oym:= 254;
                If ActivObj<MaxObj Then inc (ActivObj) Else ActivObj:= 1;
                CASE ActivObj Of
                  FileWin : BEGIN DelBalken; FileListWin; END;
                  DirWin  : BEGIN DelBalken; DirListWin;  END;
                END;
              END;
         'D': If ActivObj=FileWin Then
              BEGIN
                CursorOn;
                Window (1, 1, 80, 25); 
                StrCopy (GetListLine (ListIndex), FileName);
                LineEditor (54, 7, FileName, 13, 12, 0, cyan, 0);
                If t1=#13 Then t1:=#1 Else
                BEGIN
                  ActivObj:= FileWin; FileListWin; t1:=#0;
                  CursorOff;
                END;
              END;
        'V' : StrCopy (ActDir, OutName);
      END;
      END Else
      CASE t2 Of
        F1    : BEGIN Interne_Hilfe (EdHelpFile, 'Datei-Manager'); Goto Start; END;
        PgUp  : ScrollUp   (WinLen);
        PgDn  : ScrollDown (WinLen);
        Up    : ScrollUp   (1);
        Down  : ScrollDown (1);
        Pos1  : ScrollUp   (i);
        EndX  : ScrollDown (i);
        Left, Right  : Goto Wechsel;
      END;
      If ActivObj=FileWin Then
      WriteLine (54, 7, GetListLine (ListIndex), 0, cyan, 77) Else
      WriteLine (54, 7, ' ', 0, cyan, 77);
      If oym=254 Then oym:= 255 Else oym:= BalkenY;
    UNTIL (t1=#13) or (t1=#27) or (t1=#1) or (t1='V');
    oym:= 255;
  UNTIL (t1=#27) or (t1=#1) or (t1='V');

  If t1=#1 Then StrCopy (Vollpfad (ActDir, FileName), OutName);

  ChDir (OldDir);
  Window (1, 1, 80, 25);
  ViewMode:= ShowMen;
  MouseBottomLine;
  ShowText;
  CursorOn;

END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
