UNIT ed_maxe;

INTERFACE
USES
  Menue, Strings;

PROCEDURE ReadIniFile (IniFile : String);

IMPLEMENTATION


FUNCTION GetContent (ein : String) : String;
VAR
  x : Byte;
BEGIN
  x:= pos ('=', ein);
  If x=0 Then
  GetContent:= '' Else
  GetContent:= Trim(copy (ein, x+1, 255));
END;


FUNCTION GetColCode (ColName : String) : Byte;
BEGIN
  If Colname= 'black'        Then GetColCode:= 0 Else
  If Colname= 'blue'         Then GetColCode:= 1 Else
  If Colname= 'green'        Then GetColCode:= 2 Else
  If Colname= 'cyan'         Then GetColCode:= 3 Else
  If Colname= 'red'          Then GetColCode:= 4 Else
  If Colname= 'magenta'      Then GetColCode:= 5 Else
  If Colname= 'brown'        Then GetColCode:= 6 Else
  If Colname= 'lightgray'    Then GetColCode:= 7 Else
  If Colname= 'darkgray'     Then GetColCode:= 8 Else
  If Colname= 'lightblue'    Then GetColCode:= 9 Else
  If Colname= 'lightgreen'   Then GetColCode:= 10 Else
  If Colname= 'lightcyan'    Then GetColCode:= 11 Else
  If Colname= 'lightred'     Then GetColCode:= 12 Else
  If Colname= 'lightmagenta' Then GetColCode:= 13 Else
  If Colname= 'yellow'       Then GetColCode:= 14 Else
  If Colname= 'white'        Then GetColCode:= 15 Else GetColCode:= 255;
END;


PROCEDURE SetColor (VAR ColField : Byte; ColStr : String);
VAR
  tmp : Byte;
BEGIN
  tmp:= GetColCode (GetContent (ColStr));
  If tmp<>255 Then ColField:= tmp;
END;


PROCEDURE ReadIniFile (IniFile : String);
VAR
  f : Text;
  s : String;
BEGIN
  Assign (f, IniFile); FileMode:= 0;
  Reset (f);
  If IOResult<>0 Then Exit;
  While not Eof(f) Do
  BEGIN
    ReadLn (f, s);
    If IOResult<>0 Then
    BEGIN Close (f); InOutRes:= 0; Exit; END;
    s:= LowStr(Trim(s));
    If pos (';', s)<>1 Then  (* Kommentare bergehen *)
    With MenCol Do
    BEGIN
      If pos ('winheadbackground',s)=1 Then SetColor (HeadB,  s) Else
      If pos ('windowname',       s)=1 Then SetColor (HeadT,  s) Else
      If pos ('windowbackground', s)=1 Then SetColor (WinB,   s) Else
      If pos ('windowtext',       s)=1 Then SetColor (WinT,   s) Else
      If pos ('hotkeys',          s)=1 Then SetColor (KeyT,   s) Else
      If pos ('shortkeys',        s)=1 Then SetColor (InfoT,  s) Else
      If pos ('selectionbar',     s)=1 Then SetColor (Balken, s) Else
      If pos ('helpbackground',   s)=1 Then SetColor (HelpB,  s) Else
      If pos ('helptext',         s)=1 Then SetColor (HelpT,  s) Else
      If pos ('buttonbackground', s)=1 Then SetColor (ButtB,  s);
    END;
  END;
  Close (f); InOutRes:= 0;
END;

(*
winheadbackground = black
windowname        = yellow
windowbackground  = darkgray
windowtext        = white
hotkeys           = cyan
shortkeys         = lightgray
selectionbar      = black
helpbackground    = darkgray
helptext          = cyan
buttonbackground  = blue
*)

END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
