UNIT Ed_Menue;

INTERFACE

USES
  mouse, Menue, dialogs, ed_Var, bioscrt, keyCode, Monitor, ed_suche,
  ed_unit, ed_maus, strings, time, ed_help, dos, ed_Html;




PROCEDURE MakeMenue;
PROCEDURE ListMenue;



IMPLEMENTATION




PROCEDURE ReadNumber (VAR Ein : Byte; Wort : Str80);
VAR
  s    : MenStr;
  code : Integer;
  tmp  : Byte;
LABEL
  Nochmal;
BEGIN
  Nochmal:
  NotHistoryList;
  Str (Ein, s);
  LineEditbox (14, 6, 64, s, 3, Wort, 1);
  If t2=F1 Then
  BEGIN Interne_Hilfe (EdHelpFile, Wort); Goto Nochmal; END;
  If t1 = #27 Then Exit;
  Val (s, tmp, code);
  If Code=0 Then Ein:= Tmp;
  t1:=#0; t2:=#0;
END;




PROCEDURE ListMen (HistListNr : Byte; VAR OpenName : PathStr);
VAR
  x, y : Byte;
  s    : String;
BEGIN
  ListWahl:= FALSE;
  StrCopy ('NONAME', OpenName);
  If (HistListNr=0) or (HistListNr>MaxHLists) Then
  BEGIN NotHistoryList; Exit; END Else AssignHistoryList (HistList^[HistListNr]);
  y:= 0;
  For x:= 1 To HistList^[HistListNr].HistPtr Do
  If  Length  (HistList^[HistListNr].Line[x]) > y Then
  y:= Length  (HistList^[HistListNr].Line[x]);
  If y>55 Then y:=55;

  MenWin (4, 4, 20+y, 6+HistList^[HistListNr].HistPtr, 'ffnen');
  For x:= 1 To HistList^[HistListNr].HistPtr Do
  BEGIN
    StrCopy (CutFName(HistList^[HistListNr].Line[x], 50), s);
    Insert (FillString (y+6-Length(s)), s, succ(Lastpos ('\', s)));
    MenLine ('~'+ chr(x+48)+'~   ' + s, '', chr (x), #0);
    Helplines^[x]:= 'ffnet Datei '+ CutFName(HistList^[HistListNr].Line[x], 64)
  END;
  If ViewMode=GetEv Then
  BEGIN
    If (ord(t1)<= HistList^[HistListNr].HistPtr) and (t1<>#0) Then
    BEGIN
      StrCopy (HistList^[HistListNr].Line[ord(t1)], OpenName);
      ListWahl:= TRUE;
      t1:= #0; t2:= #0;
    END Else
    If F1Pressed Then HelpTitle:= 'Dateiwechsel';
  END;
END;



PROCEDURE ListMenue;
VAR
  Men : Char;
  x   : Byte;
LABEL
  Ende;

BEGIN
  If HistList^[8].HistPtr = 0 Then BEGIN Dateiwahl:= 0; Exit; END;
  CursorOff;
  t1:=#0; t2:=#0;
  ViewMode:= ShowMen; EventOK:= False;
  HelpLines:= addr (DirList^);

  IfHelpContext:= TRUE;
  REPEAT
    ListMen (8, OpenName);
    AssignShortHelp (Helplines^);
    MenuBalken;
    If not EventOK Then MouseKey;
  UNTIL EventOK;
  IfHelpContext:= False;

Ende:
  If t1=#1 Then t1:= #27 Else If (t1=#27) or ((t1=#0) and (t2=#0)) Then t1:= #1;

  RestoreScreen;
  SetTextScreen; CursorOn;
  Dateiwahl:= 0;
  If F1Pressed Then
  BEGIN Interne_Hilfe (EdHelpFile, HelpTitle); F1Pressed:= FALSE; END Else
  If ListWahl Then
  For x:= 1 To FileNum Do
  If OpenName=FPos[x].FName Then BEGIN Dateiwahl:= x; Exit; END;
END;



PROCEDURE DateiMen;
VAR
  ApfelW, ApfelS, ApfelQ : String[7];
BEGIN
  If Konfig.MacWin Then
  BEGIN
    ApfelW:= 'Alt+W'; ApfelS:= 'Alt+S'; ApfelQ:= 'Alt+Q';
  END Else
  BEGIN
    ApfelW:= 'CTRL+F5'; ApfelS:= 'F2'; ApfelQ:= 'Esc';
  END;
  MenWin  (3, 4, 45, 19, 'Datei');
  MenLine ('~N~eu',                  'CTRL+F4', #2, CF4);
  MenLine ('~f~fnen...',            'CTRL+F4', #0, CF4); 
  MenLine ('L~i~ste...',             '',        #0,#247); EmptyMenLine;
  MenLine ('~S~peichern',             ApfelS,   #0,  F2);
  MenLine ('Speichern ~u~nter...',   'CTRL+F3', #0, CF3);
  MenLine ('Speichern als ~H~TML-Text','',      #0,#246);
  MenLine ('~A~lle speichern',       'CTRL+F2', #0, CF2); EmptyMenLine;
  MenLine ('Sch~l~ieen',             ApfelW,   #0, CF5);
  MenLine ('S~p~eichern & schlieen','CTRL+F6', #0, CF6); EmptyMenLine;
  MenLine ('~B~eenden',               ApfelQ,   #1,  #0);

  Helplines^ [1]:= 'Erstellt und ffnet eine neue Datei';
  Helplines^ [2]:= 'ffnet eine bestehende Datei';
  Helplines^ [3]:= 'Zeigt eine Liste der zuletzt geffneten Dateien';
  Helplines^ [5]:= 'Speichert die momentan editierte Datei';
  Helplines^ [6]:= 'Fragt, unter welchem Namen die Datei gespeichert werden soll';
  Helplines^ [7]:= 'Speichert die Datei zweimal: 1. als Original-Text  2. mit HTML-Codierung (.HTM)';
  Helplines^ [8]:= 'Speichert alle geladenen Dateien';
  Helplines^[10]:= 'Schliet die momentan editierte Datei, ohne die nderungen zu speichern';
  Helplines^[11]:= 'Speichert und schliet die momentan editierte Datei';
  Helplines^[13]:= 'Beendet den Editor';

  If (ViewMode=GetEv) and (t1=#2) Then BEGIN t1:= #0; OpenMode:= 1; END;
END;



PROCEDURE BearbeitenMen;
VAR
  ApfelA, ApfelX, ApfelY, ApfelC, ApfelV : String[7];
BEGIN
  If Konfig.MacWin Then
  BEGIN
    ApfelA:= 'Alt+A'; ApfelX:= 'Alt+X'; ApfelV:= 'Alt+V'; ApfelC:= 'Alt+C'; ApfelY:= 'Alt+Y';
  END Else
  BEGIN
    ApfelA:= ''; ApfelX:= 'F3/Entf'; ApfelV:= 'F4'; ApfelC:= 'F5'; ApfelY:= '';
  END;
  MenWin  (3, 4, 46, 18, 'Bearbeiten');
  MenLine ('~A~usschneiden',           ApfelX,     #0,  F3);
  MenLine ('~E~infgen',               ApfelV,     #0,  F4);
  MenLine ('K~o~pieren',               ApfelC,     #0,  F5);
  MenLine ('L~s~chen',                ApfelY,     #0, #244); EmptyMenLine;
  MenLine ('~B~lockanfang markieren',  'F7',       #0,  F7);
  MenLine ('Bloc~k~ende   markieren',  'F8',       #0,  F8);
  MenLine ('Blockmarkierung ~l~schen','F6',       #0,  F6); EmptyMenLine;
  MenLine ('~Z~eile markieren',        'Alt+F8',   #0, AF8);
  MenLine ('~W~ort markieren',         'Alt+F9',   #0, AF9); 
  MenLine ('Alles ~m~arkieren',         ApfelA,    #0, #245);

  Helplines^ [1]:= 'Lscht markierten Textblock und kopiert ihn in die Zwischenablage';
  Helplines^ [2]:= 'Fgt Inhalt der Zwischenablage an der Cursorposition in den Text ein';
  Helplines^ [3]:= 'Kopiert markierten Textblock in die Zwischenablage';
  Helplines^ [4]:= 'Lscht den markierten Textblock, Inhalt der Zwischenablage bleibt erhalten';

  Helplines^ [6]:= 'Markiert den Beginn eines Textblockes';
  Helplines^ [7]:= 'Markiert das Ende eines Textblockes';
  Helplines^ [8]:= 'Entfernt die farbige Textblock-Markierung';

  Helplines^[10]:= 'Markiert die aktuelle Zeile als Textblock';
  Helplines^[11]:= 'Markiert das Wort ber dem Cursor als Textblock';
  Helplines^[12]:= 'Markiert den gesamten Text der Datei als Block';
END;



PROCEDURE SuchenMen;
BEGIN
  MenWin  (10, 4, 51, 11, 'Suchen');
  MenLine ('~S~uchen (alles)',   'ALT+F4', #0, AF4);
  MenLine ('S~u~chen (genau)',   'ALT+F5', #0, AF5); EmptyMenLine;
  MenLine ('~E~rsetzen (alles)', 'ALT+F6', #0, AF6);
  MenLine ('E~r~setzen (genau)', 'ALT+F7', #0, AF7);

  Helplines^ [1]:= 'Sucht alle Worte, egal ob gro- oder kleingeschrieben';
  Helplines^ [2]:= 'Sucht nur Worte, die exakt mit dem Suchwort bereinstimmen';
  Helplines^ [4]:= 'Sucht und ersetzt alle Worte, egal ob gro- oder kleingeschrieben';
  Helplines^ [5]:= 'Sucht und ersetzt nur Worte, die exakt mit dem Suchwort bereinstimmen';
END;



PROCEDURE AusfMen;
BEGIN
  MenWin  (18, 4, 61, 20, 'Ausfhren');
  MenLine ('~R~UN-Datei starten',              'CTRL+F9',  #0,      CF9); EmptyMenLine;

  MenLine ('~B~atch-Datei starten',            'SHIFT+F7', #0, SHIFT_F7);
  MenLine ('~D~atei bersetzen',               'SHIFT+F8', #0, SHIFT_F8);
  MenLine ('bersetzen & ~s~tarten',           'SHIFT+F9', #0, SHIFT_F9); EmptyMenLine;
  MenLine ('D~O~S-Fenster',                    'CTRL+F10', #0,     CF10); EmptyMenLine;

  MenLine ('~P~arameter...',                   'CTRL+F8',  #0,      CF8);
  MenLine ('~H~auptdatei...',                  'CTRL+F7',  #0,      CF7);
  MenLine ('~C~ompiler/Assembler...',          'SHIFT+F5', #0, SHIFT_F5);
  MenLine ('Pro~g~rammstartbefehl...',         'SHIFT+F6', #0, SHIFT_F6); EmptyMenLine;
  Kreuz:= TRUE;
  Vergleichswert:= ord (Konfig.Wait)+9;
  MenLine ('~W~arte nach Programmende',        '',         #1, #0);

  Helplines^ [1]:= 'Startet die momentan editierte bzw. als Hauptprogramm festgelegte RUN-Datei';
  Helplines^ [3]:= 'Startet die momentan editierte bzw. als Hauptprogramm festgelegte BAT-Datei';
  Helplines^ [4]:= 'Compiliert bzw. assembliert die festgelegte bzw. momentan editierte Datei';
  Helplines^ [5]:= 'bersetzt und startet die festgelegte bzw. momentan editierte Datei';
  Helplines^ [7]:= 'ffnet ein Fenster zu DOS. Schlieen Sie es wieder mit EXIT + Entertaste';
  Helplines^ [9]:= 'Fragt, welche Parameter an das zu startende Programm bergeben werden sollen';
  Helplines^[10]:= 'Fragt, welches Programm anstatt des momentan editierten gestartet werden soll';
  HelpLines^[11]:= 'Fragt, mit welchem Compiler oder Assembler eine Datei bersetzt werden soll';
  HelpLines^[12]:= 'Fragt nach dem Befehl, mit dem eine bersetzte Datei gestartet werden soll';
  HelpLines^[14]:= 'Editor wartet nach Ausfhrung einer gestarteten Datei auf einen Tastendruck';

  If ViewMode=GetEv Then
  BEGIN
    If t1=#1 Then
    BEGIN Konfig.Wait:=not Konfig.Wait; t1:=#0; END Else
    If t1=#0 Then
    CASE t2 Of
      CF7      : BEGIN ReadCmdLine (Konfig.PrimeFile, 'Hauptdatei',          4, 3); ViewMode:= OpenNew; EventOK:= FALSE; END;
      CF8      : BEGIN ReadCmdLine (Konfig.CmdLine,   'Parameter',           5, 1); ViewMode:= OpenNew; EventOK:= FALSE; END;
      SHIFT_F5 : BEGIN ReadCmdLine (Konfig.Compiler,  'Compiler/Assembler',  6, 3); ViewMode:= OpenNew; EventOK:= FALSE; END;
      SHIFT_F6 : BEGIN ReadCmdLine (Konfig.ProgStart, 'Programmstartbefehl', 7, 3); ViewMode:= OpenNew; EventOK:= FALSE; END;
    END;
  END;
END;


PROCEDURE FormatMen;
BEGIN
  MenWin  (24, 4, 68, 19, 'Format');
  MenLine ('~T~ext neu formatieren',   'SHIFT+F2',  #0, SHIFT_F2);
  MenLine ('Text e~i~nrcken',         'SHIFT+TAB', #0, SHIFT_TAB);
  MenLine ('Text a~u~srcken',         ''         , #0, #253); EmptyMenLine;
  MenLine ('~B~locksatz',              'ALT+F10',   #0, AF10);
  MenLine ('~F~lattersatz',            '',          #0, #252);
  MenLine ('~R~echtsbndig',           '',          #0, #255);
  MenLine ('~L~inksbndig',            '',          #0, #254);
  MenLine ('~Z~entriert',              '',          #0, #251); EmptyMenLine;

  MenLine ('Markiertes ~g~roschreiben',         '',#0, #242);
  MenLine ('Markiertes ~k~leinschreiben',        '',#0, #241);
  MenLine ('L~e~erzeichen am Zeilenende lschen','',#0, #243);

  Helplines^ [1]:= 'Neuformatierung des Textes (z.B. nach nderung der Zeilenumbruchmarke)';
  Helplines^ [2]:= 'Schiebt alle oder die markierten Zeilen um eine TAB-Lnge nach rechts';
  Helplines^ [3]:= 'Schiebt alle oder die markierten Zeilen um eine TAB-Lnge nach links';
  Helplines^ [5]:= 'Formatiert den Text im Blocksatz (Streckung der Zeilen bis zur Umbruchmarke)';
  Helplines^ [6]:= 'Formatiert den Text im Flattersatz (Blocksatz wird wieder rckgngig gemacht)';
  Helplines^ [7]:= 'Richtet alle Zeilen am rechten Rand (=Umbruchmarke) aus';
  Helplines^ [8]:= 'Richtet alle Zeilen am linken Rand aus';
  Helplines^ [9]:= 'Richtet alle Zeilen an der Blattmitte aus';
  Helplines^[11]:= 'Verwandelt alle Zeichen im markierten Block in Grobuchstaben';
  Helplines^[12]:= 'Verwandelt alle Zeichen im markierten Block in Kleinbuchstaben';
  Helplines^[13]:= 'Lscht alle Leerzeichen am Ende von Textzeilen';
END;


PROCEDURE OptionsMen;
BEGIN
  MenWin  (29, 4, 72, 23, 'Optionen');
  MenLine ('~T~AB-Stop setzen/lschen',     'ALT+F2',    #0, AF2);
  MenLine ('~Z~eilenumbruchmarke setzen',   'ALT+F3',    #0, AF3); 
  MenLine ('~M~aximale Zeilenlnge...',     '',          'M', #0);
  MenLine ('~L~nge TAB-Sprung...',         '',          'L', #0);   EmptyMenLine;

  Kreuz:= TRUE;
  Vergleichswert:= ord (ins)+4;
  MenLine ('~E~infge-Modus',                    'Einfg',   #0, Einfg);
  Vergleichswert:= ord (Konfig.EndWarning)+5;
  MenLine ('~B~eenden-Hinweis',                  '',        'B', #0);
  Vergleichswert:= ord (Konfig.BakFiles)+6;
  MenLine ('~S~icherheitskopien',                '',        'S', #0); 
  Vergleichswert:= ord (Konfig.Umbruch<>MaxLen-2)+7;
  MenLine ('~A~utom. ZeilenUmbruch',             '',        'A', #0);
  Vergleichswert:= ord (Konfig.UmbruchEin)+8;
  MenLine ('~U~mbruchrand zeigen',               '',        'U', #0);
  Vergleichswert:= ord (Konfig.Seitwechsel)+9;
  MenLine ('Seiten~w~echsel zeigen',             '',        'W', #0);
  Vergleichswert:= ord (Konfig.AutoSave)+10;
  MenLine ('Date~i~ automatisch sichern',        '',        'I', #0);
  Vergleichswert:= ord (Konfig.Ersetzen)+11;
  MenLine ('Ma~r~kiertes ersetzen',              '',        'R', #0);
  Vergleichswert:= ord (Konfig.MacWin)+12;
  MenLine ('Mac-Windows-Short~k~eys',            '',        'K', #0);
  Vergleichswert:= ord (Konfig.Allchars)+13;
  MenLine ('Alle Zeichen ei~n~blenden',          '',        'N', #0);
  Vergleichswert:= ord (Konfig.Blind)+14;
  MenLine ('Blin~d~-Support',                    '',        'D', #0);
  Vergleichswert:= ord (Konfig.SoundOn)+15;
  MenLine ('Akustis~c~he Hinweise',              '',        'C', #0);

  Helplines^ [1]:= 'Setzt einen neuen oder lscht einen bestehenden TAB-Stop an der Cursorposition';
  Helplines^ [2]:= 'Setzt die Markierung fr den automatischen Zeilenumbruch an die Cursorposition';
  Helplines^ [3]:= 'Fragt nach der max. Zeilenlnge, mit der eine Leerdatei erstellt werden soll';
  Helplines^ [4]:= 'Fragt nach der Anzahl der Zeichen, die der Tabulator berspringen soll';

  Helplines^ [6]:= 'Wechselt zwischen berschreib- und Einfge-Modus hin und her';
  Helplines^ [7]:= 'Zeigt beim Beenden von ED mit der Taste ESC einen Hinweis';
  Helplines^ [8]:= 'Legt von jeder genderten Datei eine Sicherheitskopie mit der Endung .BAK an';
  Helplines^ [9]:= 'Versetzt die Zeilenumbruchmarke an den uersten rechten Schreibrand';
  Helplines^[10]:= 'Blendet den Rand im Editor ein, an dem der automatische Zeilenumbruch erfolgt';
  Helplines^[11]:= 'Kennzeichnet die erste Zeile jeder Druckseite mit einem farbigen Pfeil';
  Helplines^[12]:= 'Speichert die gerade editierte Datei alle 15 Minuten automatisch ab';
  HelpLines^[13]:= 'Markierter Text wird bei Einfgen eines Zeichens oder Blockes gelscht';
  HelpLines^[14]:= 'Verwendet Tastenkombinationen von Macintosh/Windows (Alt+C, Alt+V usw.)';
  HelpLines^[15]:= 'Zeigt Leerzeichen und Zeilenumbrche als Symbole ( '#250' und '#20' )';
  HelpLines^[16]:= 'Zustzliche Orientierungshilfen fr Blinde (BIOS-Cursor-Fhrung u.a.)';
  HelpLines^[17]:= 'Gibt bei Hinweisen oder Fehlern unterschiedliche Ton-Sequenzen aus';

  If (ViewMode= GetEv) Then
  CASE t1 Of
    #0  :  If t2=Einfg Then ins:= not ins;
    'B' :  Konfig.EndWarning := not Konfig.EndWarning;
    'S' :  Konfig.BakFiles   := not Konfig.BakFiles;
    'M' :  BEGIN ReadNumber (Konfig.StartMaxLen, 'Maximale Zeilenlnge'); ViewMode:= OpenNew; EventOK:= FALSE; END;
    'L' :  BEGIN ReadNumber (Konfig.TABLen, 'Lnge TAB-Sprung'); ViewMode:= OpenNew; EventOK:= FALSE; END;
    'A' :  Konfig.Umbruch:= MaxLen-2;
    'U' :  BEGIN
             Konfig.UmbruchEin:= not Konfig.UmbruchEin;
             If Konfig.PFormat Then LinesPerSide:= Konfig.PLines Else LinesPerSide:= 63;
           END;
    'W' :  Konfig.Seitwechsel:= not Konfig.Seitwechsel;
    'I' :  Konfig.AutoSave   := not Konfig.AutoSave;
    'R' :  Konfig.Ersetzen   := not Konfig.Ersetzen;
    'K' :  Konfig.MacWin     := not Konfig.MacWin;
    'N' :  Konfig.AllChars   := not Konfig.AllChars;
    'D' :  BEGIN Konfig.Blind:= not Konfig.Blind; Blinds:= Konfig.Blind; END;
    'C' :  Konfig.SoundOn    := not Konfig.SoundOn;
  END;
END;



PROCEDURE PrintMen;
VAR
  lpt   : Char;
  Blatt : Word;
  Lines : Word;
  Oldt1 : Char;
BEGIN
  MenWin  (33, 4, 76, 22, 'Drucken');
  MenLine ('~D~rucken',        'SHIFT+F3', #0, SHIFT_F3);
  MenLine ('Seiten~a~nsicht',  'SHIFT+F4', #0, SHIFT_F4);
  EmptyMenLine;
  Kreuz:= TRUE;
  Vergleichswert:= ord (Konfig.Printer)-46;
  For LPT:= '1' To '3' Do
  BEGIN
    MenLine ('Druckeranschlu LPT ~'+LPT+'~',  '', LPT, #0);
    HelpLines^[ord (LPT)-45]:= 'Legt LPT '+LPT+' als Druckeranschlu fest';
  END;
  MenLine ('Drucke in Datei LPT ~4~',         '', '4', #0);
  EmptyMenLine;
  Vergleichswert:= ord (Konfig.PFormat)+6;
  MenLine ('~F~ormatierter Ausdruck',         '', 'F', #0);
  Kreuz:= FALSE;
  MenLine ('      ~S~eitenzahl...',                 '', 'S', #0);
  MenLine ('      ~L~inker  Rand...',               '', 'L', #0);
  MenLine ('      ~O~berer  Rand...',               '', 'O', #0);
  MenLine ('      ~Z~eilen  pro Druckseite...',     '', 'Z', #0);
  MenLine ('      ~U~nterer Rand...',               '', 'U', #0);

  Helplines^ [1]:= 'Druckt entweder das gesamte Dokument oder den gerade markierten Textblock';
  Helplines^ [2]:= 'Zeigt am Bildschirm, wie die auszudruckenden Seiten aussehen werden';
  Helplines^ [7]:= 'Druckt in eine Datei namens LPT4 im akt. Verzeichnis (z.B. fr Seitenvorschau)';
  Helplines^ [9]:= 'Druckt eine Datei mit der im folgenden eingestellten Formatierung';
  Helplines^[10]:= 'Fragt, wieviele Seiten des Dokuments gedruckt werden sollen (0 = alle)';
  Helplines^[11]:= 'Fragt, wieviele Leerzeichen der linke Rand breit sein soll';
  Helplines^[12]:= 'Fragt, wieviele Leerzeilen der obere Rand breit sein soll';
  Helplines^[13]:= 'Fragt, wieviele Textzeilen auf jedes Blatt gedruckt werden sollen';
  Helplines^[14]:= 'Fragt, nach wieviel Leerzeilen die Seitennummer folgen soll (0=keine Seiten-Nr)';

  If (ViewMode=GetEv) and (t2=#0) Then
  BEGIN
    Oldt1:= t1;
    CASE t1 Of
      '1'..'4' : BEGIN Konfig.Printer:=t1; ViewMode:= MustRefresh; END;
      'F'      : BEGIN
                   Konfig.PFormat:= not Konfig.PFormat;
                   If Konfig.PFormat Then
                   LinesPerSide:= Konfig.PLines Else LinesPerSide:= 63;
                 END;
      'S'      : ReadNumber (Konfig.PMaxSides,  'Seitenzahl');
      'O'      : ReadNumber (Konfig.PRandOben,  'Oberer Rand');
      'L'      : ReadNumber (Konfig.PRand,      'Linker Rand');
      'U'      : ReadNumber (Konfig.PFusszeile, 'Unterer Rand');
      'Z'      : BEGIN
                   ReadNumber (Konfig.PLines,     'Zeilen pro Druckseite');
                   If Konfig.PFormat Then LinesPerSide:= Konfig.PLines Else LinesPerSide:= 63;
                 END;
    END;
    If Oldt1 >='A' Then
    BEGIN ViewMode:= OpenNew; EventOK:= FALSE; END;
    t1:=#0;
  END Else
  With Konfig Do
  BEGIN
    If LineAn * LineEn=0 Then Lines:= LastLine Else Lines:= LineEn-LineAn;
    If not PFormat Then Blatt:= Lines DIV 63 Else
    BEGIN
      If PLines=0 Then Blatt:=0 Else
      BEGIN
        If PMaxSides=0 Then Blatt:= Lines DIV PLines Else Blatt:= PMaxSides-1;
      END;
    END;
    inc (Blatt);
    WriteXY (42, 21, 'Bentigte Blatt Papier : '+sstr (Blatt), MenCol.InfoT, MenCol.WinB);
  END;
END;



PROCEDURE FensterMen;
VAR
  x, y : Byte;
  s    : PathStr;
BEGIN
  y:= 0;
  For x:= 1 To FileNum Do If Length (FPos[x].FName) > y Then y:= Length (FPos[x].FName);
  If y>46 Then y:=46;
  MenWin (50-y, 4, 75, 6+FileNum, 'Wechseln zu');
  For x:= 1 To FileNum Do
  BEGIN
    StrCopy (CutFName(FPos[x].FName, 50), s);
    Insert (FillString (y+15-Length(s)), s, succ(Lastpos ('\', s)));
    MenLine ('~'+ chr(x+48)+'~   '+s, '', chr (x), #0);
    Helplines^[x]:= 'Wechselt zur Datei '+ CutFName(FPos[x].FName, 55)
  END;
  If ViewMode=GetEv Then
  BEGIN
    If (ord(t1)<=FileNum) and (t1<>#0) Then
    BEGIN Dateiwahl:= ord (t1); t1:= #0; t2:= #0; END Else
    If F1Pressed Then HelpTitle:= 'Dateiwechsel';
  END;
END;



PROCEDURE ZeigeMen;
CONST
  en : Array [4..10] Of String[12] = ('RUN', 'BAT', 'ASM', 'PAS', 'C, CPP und H', 'DEB', 'TXT und DOC');
VAR
  x   : Byte;
BEGIN
  MenWin  (38, 4, 76, 16, 'Zeigen');
  Kreuz:= TRUE;
  Vergleichswert:= Konfig.DateiFilter;
  MenLine ('A~l~le Dateien',               '', #1, #0);
  MenLine ('Alle a~u~er Programmdateien', '', #2, #0);
  EmptyMenLine;
  MenLine ('Nur ~R~UN-Dateien',            '', #3, #0);
  MenLine ('Nur ~B~atch-Dateien',          '', #4, #0);
  MenLine ('Nur ~A~ssembler-Dateien',      '', #5, #0);
  MenLine ('Nur ~P~ascal-Dateien',         '', #6, #0);
  MenLine ('Nur ~C~-Dateien',              '', #7, #0);
  MenLine ('Nur ~D~ebug-Dateien',          '', #8 ,#0);
  MenLine ('Nur ~T~XT und DOC-Dateien',    '', #9, #0);

  Helplines^ [1]:= 'Alle Dateien werden im Datei-Auswahlfenster angezeigt';
  HelpLines^ [2]:= 'Alle Dateien (auer EXE, COM, DLL, OVL usw.) werden angezeigt';
  For x:= 4 To 10 Do
  HelpLines^[x]:= 'Nur Dateien mit der Endung '+en[x]+' werden im Auswahlfenster angezeigt';

  If (ViewMode= GetEv) and (t2=#0) and (t1>=#0) and (t1<=#9) Then
  BEGIN
    Konfig.DateiFilter:= ord (t1); t1:=#0;
    ViewMode:= MustRefresh;
  END;
END;



PROCEDURE HelpMen;
BEGIN
  MenWin  (32, 4, 76, 18, 'Hilfe');
  MenLine ('Hilfe zum ~E~ditor',        'F1',      #0, F1);
  MenLine ('Hilfe zu  ~R~UN',           '',        #0, #248);
  MenLine ('Hilfe zu  ~D~OS',           '',        #0, #249); EmptyMenLine;
  MenLine ('Syntax-Hilfe ~A~SM/Pascal', 'CTRL +F1',#0, CF1); 
  MenLine ('Syntax-Hilfe ~B~ATCH',      'SHIFT+F1',#0, SHIFT_F1); 
  MenLine ('Eigene Syntax~h~ilfe',      'ALT  +F1',#0, AF1); EmptyMenLine;

  MenLine ('~I~nfo',                    '',        #0, #250);

  Helplines^ [1]:= 'Startet die Hilfe zum Editor';
  Helplines^ [2]:= 'Startet die Hilfe zur RUN-Programmierung';
  Helplines^ [3]:= 'Startet die DOS-Hilfe (Index)';
  Helplines^ [5]:= 'Zeigt eine Hilfe zu dem Pascal/Assembler-Befehl ber dem Cursor';
  Helplines^ [6]:= 'Zeigt eine Hilfe zu dem Batch-Befehl ber dem Cursor';
  Helplines^ [7]:= 'Zeigt eine selbsterstellte Hilfe zu dem Befehl ber dem Cursor';
  Helplines^ [9]:= 'Information zum Editor ED';
  WriteXY (35, 16, 'Uhrzeit     '+ActTimeStr(8), MenCol.InfoT, MenCol.WinB);
  WriteXY (35, 17, 'Datum       '+ActDateStr(8), MenCol.InfoT, MenCol.WinB);
END;



PROCEDURE MakeMenue;
VAR
  Men : Char;
  x   : Byte;
  OldWinMin,
  OldWinMax,
  OldX,
  OldY      : Word;
LABEL
  Ende, Start;

BEGIN
  Men:= t2;
  OldWinMin:= WindMin; OldWinMax:= WindMax; OldX:= WhereX; OldY:= WhereY;
  Start:
  Dateiwahl:= 0;
  CursorOff;
  t1:=#0; t2:=#0;
  ViewMode:= ShowMen; EventOK:= False;
  HelpLines:= addr (DirList^);

  If Blinds Then
  BEGIN Window (1, WinOK, 80, WinUK); ClrScr; Window (1, 1, 80, 25); END;

  IfHelpContext:= TRUE;

  REPEAT
    CASE Men Of
      ALTD : DateiMen;
      ALTB : BearbeitenMen;
      ALTS : SuchenMen;
      ALTA : AusFMen;
      ALTF : FormatMen;
      ALTO : OptionsMen;
      ALTP : PrintMen;
      ALTW : FensterMen;
      ALTZ : ZeigeMen;
      ALTH : HelpMen;
      ALTR : Paragraphmen;
      ALTT : StyleMen;
      ALTE : ElementMen;
      ALTI : ListenMenue;
      ALTM : FormMen;
      ALTL : TableMen;
      ALTC : SonderMen;
    END;
    If ViewMode=OpenNew Then
    BEGIN RestoreScreen; SetTextScreen; Goto Start; END;
    AssignShortHelp (Helplines^);
    MenuBalken;
    If ViewMode=MustRefresh Then ViewMode:= Refresh Else
    If not EventOK Then MouseKey;
  UNTIL EventOK;
  IfHelpContext:= False;

Ende:
  If t1=#1 Then t1:= #27 Else If (t1=#27) or ((t1=#0) and (t2=#0)) Then t1:= #1;

  RestoreScreen;
  WindMin:= OldWinMin; WindMax:= OldWinMax; GotoXY (OldX, OldY);
  SetTextScreen; CursorOn;
  If F1Pressed Then
  BEGIN Interne_Hilfe (EdHelpFile, HelpTitle); F1Pressed:= FALSE; END;
END;


END.

{
Copyright (C) 1994-2002 Andre Olejko - olejko.de

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2, as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
}
